/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.as;

import java.util.HashMap;
import java.util.Map;

public class ActionScriptScribe {
    private StringBuffer buffer = new StringBuffer(500);
    private int currentLineNumber = 1;
    private final int INDENT_LEVEL_MAX = 20;
    private int indentLevel = 0;
    private int effectiveIndentLevel = 0;
    private LineTracker lineTracker = new LineTracker();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    int currentMappedLineNumber = 1;
    String javaFileName;

    public ActionScriptScribe(String string) {
        this.javaFileName = string;
    }

    public ActionScriptScribe append(boolean bl) {
        this.buffer.append(bl);
        return this;
    }

    public ActionScriptScribe append(char c) {
        this.buffer.append(c);
        return this;
    }

    public ActionScriptScribe append(char[] cArray) {
        this.buffer.append(cArray);
        return this;
    }

    public ActionScriptScribe append(double d) {
        this.buffer.append(d);
        return this;
    }

    public ActionScriptScribe append(float f) {
        this.buffer.append(f);
        return this;
    }

    public ActionScriptScribe append(int n) {
        this.buffer.append(n);
        return this;
    }

    public ActionScriptScribe append(long l) {
        this.buffer.append(l);
        return this;
    }

    public ActionScriptScribe append(Object object) {
        this.buffer.append(object);
        return this;
    }

    public ActionScriptScribe append(String string) {
        this.buffer.append(string);
        return this;
    }

    public ActionScriptScribe appendNewLine() {
        this.lineTracker.record(this.currentLineNumber, this.currentMappedLineNumber);
        this.buffer.append(LINE_SEPARATOR);
        ++this.currentLineNumber;
        return this;
    }

    public void indent() {
        if (++this.indentLevel <= 20) {
            this.effectiveIndentLevel = this.indentLevel;
        }
    }

    public int length() {
        return this.buffer.length();
    }

    public void outdent() {
        if (--this.indentLevel < 0) {
            this.indentLevel = 0;
        } else if (this.indentLevel < this.effectiveIndentLevel) {
            this.effectiveIndentLevel = this.indentLevel;
        }
    }

    void printIndent() {
        int n = 0;
        int n2 = this.effectiveIndentLevel;
        while (n < n2) {
            this.buffer.append(' ').append(' ');
            ++n;
        }
    }

    public String toString() {
        return String.valueOf(this.buffer);
    }

    public void trimEnd(int n, int n2) {
        int n3 = 0;
        int n4 = n2;
        block9: while (n4 > n) {
            switch (this.buffer.charAt(n4)) {
                case '\t': 
                case ' ': {
                    break;
                }
                case '\n': 
                case '\r': {
                    break;
                }
                case ';': {
                    if (n3 == 0) {
                        ++n3;
                        break;
                    }
                }
                default: {
                    if (n4 >= n2) break block9;
                    this.buffer.delete(n4 + 1, n2 + 1);
                    break block9;
                }
            }
            --n4;
        }
        n4 = n;
        block10: while (n4 < n2) {
            switch (this.buffer.charAt(n4)) {
                case '\t': 
                case ' ': {
                    break;
                }
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    if (n4 <= n) break block10;
                    this.buffer.delete(n, n4);
                    break block10;
                }
            }
            ++n4;
        }
    }

    public String getContents() {
        return String.valueOf(this.buffer);
    }

    public void setCurrentMappedLineNumber(int n) {
        this.currentMappedLineNumber = n;
    }

    public Map getLineMapping() {
        return this.lineTracker.getMapping();
    }

    static class LineTracker {
        private Map mapping = new HashMap();

        LineTracker() {
        }

        public void record(int n, int n2) {
            this.mapping.put(new Integer(n), new Integer(n2));
        }

        public Map getMapping() {
            return this.mapping;
        }
    }
}

