/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.as;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.as.ASCompilerOptions;
import org.eclipse.jdt.internal.compiler.as.ActionScriptConstructorGenerator;
import org.eclipse.jdt.internal.compiler.as.ActionScriptScribe;
import org.eclipse.jdt.internal.compiler.as.ActionScriptSourceFile;
import org.eclipse.jdt.internal.compiler.as.ActionScriptSourceGenerator;
import org.eclipse.jdt.internal.compiler.as.ActionScriptSourceGeneratorCatcher;
import org.eclipse.jdt.internal.compiler.as.FieldNamesRegistry;
import org.eclipse.jdt.internal.compiler.as.IActionScriptSourcesCollector;
import org.eclipse.jdt.internal.compiler.as.ImportRegistry;
import org.eclipse.jdt.internal.compiler.as.LocalNamesRegistry;
import org.eclipse.jdt.internal.compiler.as.ProblemReporter;
import org.eclipse.jdt.internal.compiler.as.Util;
import org.eclipse.jdt.internal.compiler.ast.AND_AND_Expression;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.AssertStatement;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.BreakStatement;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ContinueStatement;
import org.eclipse.jdt.internal.compiler.ast.DoStatement;
import org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.jdt.internal.compiler.ast.ForStatement;
import org.eclipse.jdt.internal.compiler.ast.ForeachStatement;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.LabeledStatement;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.OR_OR_Expression;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.PostfixExpression;
import org.eclipse.jdt.internal.compiler.ast.PrefixExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.ast.WhileStatement;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SignatureWrapper;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

class ActionScriptSourceGenerator
extends ActionScriptSourceGeneratorCatcher {
    private Stack actionScriptSourceFiles = new Stack();
    ActionScriptSourceFile actionScriptSourceFile = null;
    IActionScriptSourcesCollector actionScriptSourceFilesCollector;
    protected ActionScriptScribe scriptOutput = null;
    LocalNamesRegistry localNamesRegistry;
    LocalNamesRegistry compilationUnitLocalNamesRegistry;
    private Stack localNamesRegistries = new Stack();
    protected ImportRegistry importRegistry;
    private ImportReference currentPackage;
    private FieldNamesRegistry fieldNamesRegistry;
    int[] lineSeparators = null;
    int lineNumberStart;
    int lineNumberEnd;
    protected Statement unIndentedStatement;
    static final double DOUBLE_MIN_VALUE = 9.9E-324;
    static final double DOUBLE_MAX_VALUE = 1.79769313486231E308;
    static final long LONG_MIN_VALUE = -9007199254740992L;
    static final long LONG_MAX_VALUE = 0x20000000000000L;
    int localDeclarationForStatus = -1;
    static final int NOT_IN_FOR = -1;
    static final int FIRST_IN_FOR = 0;
    static final int NTH_IN_FOR = 1;
    private static final char[] ARG0 = "arg0".toCharArray();
    private static final char[] ARG1 = "arg1".toCharArray();
    private static final char[] TAB = "tab".toCharArray();
    private static final char[] TAB2 = "tab2".toCharArray();
    private static final String INTERFACE_FIELDS = "$$fields";
    boolean generatingConstructor;
    ActionScriptConstructorGenerator constructorGenerator;
    Stack constructorGenerators = new Stack();
    Statement lastStatement;
    boolean generatingInterfaceFields = false;

    public ActionScriptSourceGenerator(IActionScriptSourcesCollector iActionScriptSourcesCollector, FieldNamesRegistry fieldNamesRegistry) {
        this.actionScriptSourceFilesCollector = iActionScriptSourcesCollector;
        this.fieldNamesRegistry = fieldNamesRegistry;
    }

    private void appendMethod(AbstractMethodDeclaration abstractMethodDeclaration, ClassScope classScope) {
        int n;
        int n2;
        int n3;
        int n4;
        this.printIndent();
        if (abstractMethodDeclaration.selector == TypeConstants.CLINIT) {
            this.scriptOutput.append("static private function __clinit(): void");
            return;
        }
        MethodBinding methodBinding = abstractMethodDeclaration.binding;
        boolean bl = methodBinding.declaringClass.isInterface();
        int n5 = Util.checkIntrinsic(methodBinding);
        if (n5 == 2) {
            this.reportError((Scope)classScope, "conflicting intrinsic/non intrinsic declarations for method " + new String(methodBinding.readableName()) + " in superinterfaces", (ASTNode)abstractMethodDeclaration);
        }
        String string = null;
        if (bl) {
            if (methodBinding.isOverriding() || methodBinding.isImplementing()) {
                this.scriptOutput.append("// skip overriding ");
                this.scriptOutput.append(abstractMethodDeclaration.selector);
                this.scriptOutput.appendNewLine();
                return;
            }
        } else {
            if (methodBinding.isPublic() || n5 != 0 && methodBinding.isProtected() || methodBinding.isConstructor() && methodBinding.declaringClass.isNestedType()) {
                this.scriptOutput.append("public ");
            } else if (methodBinding.isProtected()) {
                this.scriptOutput.append("protected ");
            } else if (!this.generatingConstructor) {
                if (methodBinding.isPrivate()) {
                    this.scriptOutput.append("private ");
                } else {
                    this.scriptOutput.append("public ");
                }
            }
            if (methodBinding.isNative()) {
                CompilationUnitDeclaration compilationUnitDeclaration = classScope.referenceCompilationUnit();
                n4 = abstractMethodDeclaration.declarationSourceStart;
                n3 = abstractMethodDeclaration.declarationSourceEnd;
                int n6 = 0;
                n2 = compilationUnitDeclaration.comments.length;
                while (n6 < n2) {
                    int n7;
                    n = -compilationUnitDeclaration.comments[n6][1];
                    if (n >= 0 && (n7 = compilationUnitDeclaration.comments[n6][0]) > n4 && n <= n3) {
                        char[] cArray = compilationUnitDeclaration.compilationResult.compilationUnit.getContents();
                        if (n - n7 < 7 || cArray[n7] != '/' || cArray[n7 + 1] != '*') break;
                        if (cArray[n7 + 2] == '{') {
                            if (cArray[n - 1] != '/' || cArray[n - 2] != '*' || cArray[n - 3] != '}') break;
                            string = String.copyValueOf(cArray, n7 + 3, n - n7 - 6);
                            break;
                        }
                        if (cArray[n7 + 2] != '-' || cArray[n7 + 3] != '{' || cArray[n - 1] != '/' || cArray[n - 2] != '*' || cArray[n - 3] != '-' || cArray[n - 4] != '}') break;
                        string = String.copyValueOf(cArray, n7 + 4, n - n7 - 8);
                        break;
                    }
                    ++n6;
                }
            }
            if (methodBinding.isStatic()) {
                this.scriptOutput.append("static ");
            } else if (Util.isOverriding(methodBinding)) {
                this.scriptOutput.append("override ");
            }
        }
        this.scriptOutput.append("function ");
        switch (Util.checkIntrinsic(methodBinding)) {
            case 0: {
                Util.appendMethodName(this.scriptOutput, methodBinding, true, this.generatingConstructor);
                break;
            }
            case 1: {
                Util.appendMethodName(this.scriptOutput, methodBinding, false, this.generatingConstructor);
            }
        }
        this.scriptOutput.append("(");
        boolean bl2 = false;
        if (methodBinding.isConstructor()) {
            if (methodBinding.declaringClass.isNestedType()) {
                NestedTypeBinding nestedTypeBinding = (NestedTypeBinding)methodBinding.declaringClass;
                SyntheticArgumentBinding[] syntheticArgumentBindingArray = nestedTypeBinding.syntheticEnclosingInstances();
                int n8 = n2 = syntheticArgumentBindingArray == null ? 0 : syntheticArgumentBindingArray.length;
                if (n2 > 0) {
                    n = 0;
                    while (n < n2) {
                        SyntheticArgumentBinding syntheticArgumentBinding = syntheticArgumentBindingArray[n];
                        this.expandMethodArgument(syntheticArgumentBinding.name, syntheticArgumentBinding.type, n > 0);
                        ++n;
                    }
                    bl2 = true;
                }
                int n9 = n2 = (syntheticArgumentBindingArray = nestedTypeBinding.syntheticOuterLocalVariables()) == null ? 0 : syntheticArgumentBindingArray.length;
                if (n2 > 0) {
                    n = 0;
                    while (n < n2) {
                        SyntheticArgumentBinding syntheticArgumentBinding = syntheticArgumentBindingArray[n];
                        this.expandMethodArgument(syntheticArgumentBinding.name, syntheticArgumentBinding.type, bl2 || n > 0);
                        ++n;
                    }
                    bl2 = true;
                }
            }
            if (methodBinding.declaringClass.isEnum()) {
                this.localNamesRegistry.addTargetName(ARG0);
                this.expandMethodArgument(ARG0, (TypeBinding)classScope.getJavaLangString(), bl2);
                bl2 = true;
                this.localNamesRegistry.addTargetName(ARG1);
                this.expandMethodArgument(ARG1, (TypeBinding)TypeBinding.INT, bl2);
                bl2 = true;
            }
        }
        n4 = abstractMethodDeclaration.arguments == null ? 0 : abstractMethodDeclaration.arguments.length;
        n3 = 0;
        while (n3 < n4) {
            Argument argument = abstractMethodDeclaration.arguments[n3];
            this.expandMethodArgument(this.localNamesRegistry.targetName(argument.binding).toCharArray(), argument.binding.type, bl2 || n3 > 0);
            ++n3;
        }
        if (methodBinding.isConstructor()) {
            if (Util.checkIntrinsic(methodBinding) != 1) {
                this.reportError((Scope)classScope, "non IS_NOT_INTRINSIC constructor", (ASTNode)abstractMethodDeclaration);
                return;
            }
            this.scriptOutput.append(')');
            if (!this.generatingConstructor) {
                this.scriptOutput.append(": ").append(TypeConstants.OBJECT);
            }
        } else {
            this.scriptOutput.append("): ");
            MethodBinding methodBinding2 = null;
            if (methodBinding.parameters.length == 0 && (methodBinding.isOverriding() || methodBinding.isImplementing())) {
                methodBinding2 = methodBinding.getHighestOverridenMethod(classScope.environment()).original();
            }
            MethodBinding methodBinding3 = methodBinding.original();
            if (methodBinding2 != null && methodBinding2 != methodBinding3 && methodBinding2.returnType != methodBinding3.returnType) {
                Util.appendTypeName(this.scriptOutput, methodBinding2.returnType, this.importRegistry.isAmbiguous(methodBinding2.returnType), true);
            } else {
                Util.appendTypeName(this.scriptOutput, methodBinding.returnType, this.importRegistry.isAmbiguous(methodBinding.returnType), true);
            }
        }
        if (methodBinding.isNative()) {
            if (string != null) {
                this.scriptOutput.append(' ');
                this.scriptOutput.append('{');
                this.scriptOutput.appendNewLine();
                String string2 = this.convertInlinedJavaCalls(string, (Scope)classScope);
                this.appendNativeMethodBody(string2);
                this.scriptOutput.appendNewLine();
                this.scriptOutput.printIndent();
                this.scriptOutput.append('}');
                this.scriptOutput.appendNewLine();
            } else {
                this.scriptOutput.append(" { // native").appendNewLine();
                this.indent();
                this.printIndent();
                switch (methodBinding.returnType.id) {
                    case 5: {
                        this.scriptOutput.append("return false;").appendNewLine();
                        break;
                    }
                    case 8: 
                    case 9: {
                        this.scriptOutput.append("return 0.0;").appendNewLine();
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 10: {
                        this.scriptOutput.append("return 0;").appendNewLine();
                        break;
                    }
                    case 6: {
                        this.scriptOutput.append("return;").appendNewLine();
                        break;
                    }
                    default: {
                        this.scriptOutput.append("return null;").appendNewLine();
                    }
                }
                this.outdent();
                this.printIndent();
                this.scriptOutput.append('}').appendNewLine();
            }
        } else if (abstractMethodDeclaration.isAbstract() || (abstractMethodDeclaration.modifiers & 0x1000000) != 0) {
            if (bl) {
                this.scriptOutput.append(';').appendNewLine();
            } else if (methodBinding.returnType.id == 6) {
                this.scriptOutput.append(" { } // abstract").appendNewLine();
            } else {
                this.scriptOutput.append(" { // abstract").appendNewLine();
                this.indent();
                this.printIndent();
                switch (methodBinding.returnType.id) {
                    case 5: {
                        this.scriptOutput.append("return false;").appendNewLine();
                        break;
                    }
                    case 8: 
                    case 9: {
                        this.scriptOutput.append("return 0.0;").appendNewLine();
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 10: {
                        this.scriptOutput.append("return 0;").appendNewLine();
                        break;
                    }
                    default: {
                        this.scriptOutput.append("return null;").appendNewLine();
                    }
                }
                this.outdent();
                this.printIndent();
                this.scriptOutput.append('}').appendNewLine();
            }
        }
    }

    private void appendNativeMethodBody(String string) {
        block16: {
            LineNumberReader lineNumberReader = null;
            this.scriptOutput.indent();
            try {
                try {
                    lineNumberReader = new LineNumberReader(new StringReader(string.trim()));
                    String string2 = null;
                    int n = 0;
                    while ((string2 = lineNumberReader.readLine()) != null) {
                        if (n > 0) {
                            this.scriptOutput.appendNewLine();
                        }
                        this.scriptOutput.printIndent();
                        this.scriptOutput.append(string2.trim());
                        ++n;
                    }
                }
                catch (IOException iOException) {
                    this.scriptOutput.outdent();
                    if (lineNumberReader != null) {
                        try {
                            lineNumberReader.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                this.scriptOutput.outdent();
                if (lineNumberReader != null) {
                    try {
                        lineNumberReader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            this.scriptOutput.outdent();
            if (lineNumberReader != null) {
                try {
                    lineNumberReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    void appendMethod(MethodBinding methodBinding, ClassScope classScope) {
        this.printIndent();
        this.scriptOutput.append("public ");
        if (Util.isOverriding(methodBinding)) {
            this.scriptOutput.append("override ");
        }
        this.scriptOutput.append("function ");
        switch (Util.checkIntrinsic(methodBinding)) {
            case 0: {
                Util.appendMethodName(this.scriptOutput, methodBinding, true, this.generatingConstructor);
                break;
            }
            case 1: {
                Util.appendMethodName(this.scriptOutput, methodBinding, false, this.generatingConstructor);
                break;
            }
            case 2: {
                this.reportError((Scope)classScope, "conflicting intrinsic/non intrinsic declarations for method " + new String(methodBinding.readableName()) + " in superinterfaces", (ASTNode)classScope.referenceContext);
            }
        }
        int n = methodBinding.parameters == null ? 0 : methodBinding.parameters.length;
        this.scriptOutput.append("(");
        int n2 = 0;
        while (n2 < n) {
            TypeBinding typeBinding = methodBinding.parameters[n2];
            if (n2 > 0) {
                this.scriptOutput.append(", ");
            }
            this.scriptOutput.append("arg");
            this.scriptOutput.append(n2);
            this.scriptOutput.append(": ");
            Util.appendTypeName(this.scriptOutput, typeBinding, this.importRegistry.isAmbiguous(typeBinding), true);
            ++n2;
        }
        this.scriptOutput.append("): ");
        Util.appendTypeName(this.scriptOutput, methodBinding.returnType, this.importRegistry.isAmbiguous(methodBinding.returnType), true);
        if (methodBinding.returnType.id == 6) {
            this.scriptOutput.append(" { } // abstract").appendNewLine();
        } else {
            this.scriptOutput.append(" { // abstract").appendNewLine();
            this.indent();
            this.printIndent();
            switch (methodBinding.returnType.id) {
                case 5: {
                    this.scriptOutput.append("return false;").appendNewLine();
                    break;
                }
                case 8: 
                case 9: {
                    this.scriptOutput.append("return 0.0;").appendNewLine();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 10: {
                    this.scriptOutput.append("return 0;").appendNewLine();
                    break;
                }
                default: {
                    this.scriptOutput.append("return null;").appendNewLine();
                }
            }
            this.outdent();
            this.printIndent();
            this.scriptOutput.append('}').appendNewLine();
        }
    }

    private String convertInlinedJavaCalls(String string, Scope scope) {
        int n;
        while ((n = string.indexOf(64)) != -1) {
            String string2;
            Object object;
            int n2;
            int n3 = string.indexOf("::", n + 1);
            if (n3 == -1) {
                return string;
            }
            String string3 = string.substring(n + 1, n3).replace('$', '.');
            Binding binding = scope.getTypeOrPackage(CharOperation.splitOn((char)'.', (char[])string3.toCharArray()));
            if (!binding.isValidBinding() || !(binding instanceof ReferenceBinding)) {
                return string;
            }
            ReferenceBinding referenceBinding = (ReferenceBinding)binding;
            String string4 = Util.typeName((TypeBinding)referenceBinding, true);
            int n4 = string.length();
            int n5 = n2 = n3 + 2;
            while (n5 < n4 && Character.isJavaIdentifierPart(string.charAt(n5))) {
                ++n5;
            }
            int n6 = string.indexOf(40, n2);
            boolean bl = n6 == -1 || n6 > n5;
            StringBuffer stringBuffer = new StringBuffer(n4);
            stringBuffer.append(string.substring(0, n));
            if (bl) {
                String string5 = string.substring(n2, n5);
                object = referenceBinding.getField(string5.toCharArray(), true);
                if (object == null || !object.isValidBinding()) {
                    return string;
                }
                string2 = this.fieldNamesRegistry.targetName((FieldBinding)object);
                if (object.isStatic()) {
                    stringBuffer.append(string4);
                    stringBuffer.append('.');
                }
                stringBuffer.append(string2);
                stringBuffer.append(string.substring(n5, n4));
            } else {
                MethodBinding methodBinding;
                int n7 = string.indexOf(41, n2);
                if (n7 == -1) {
                    return string;
                }
                object = string.substring(n2, n6).toCharArray();
                string2 = string.substring(n6, n7 + 1);
                TypeBinding[] typeBindingArray = this.convertSignatureToParameters(string2, scope);
                boolean bl2 = CharOperation.equals((char[])object, (char[])"new".toCharArray());
                MethodBinding methodBinding2 = methodBinding = bl2 ? referenceBinding.getExactConstructor(typeBindingArray) : referenceBinding.getExactMethod((char[])object, typeBindingArray, null);
                if (methodBinding == null && bl2 && referenceBinding.isNestedType()) {
                    TypeBinding[] typeBindingArray2 = new TypeBinding[typeBindingArray.length - 1];
                    System.arraycopy(typeBindingArray, 1, typeBindingArray2, 0, typeBindingArray2.length);
                    methodBinding = referenceBinding.getExactConstructor(typeBindingArray2);
                }
                if (methodBinding == null) {
                    methodBinding = Util.findExactMethod(referenceBinding, (char[])object, typeBindingArray);
                }
                if (methodBinding == null || !methodBinding.isValidBinding()) {
                    return string;
                }
                if (methodBinding.isStatic() || string.charAt(n7 + 1) != '(') {
                    stringBuffer.append(string4);
                    stringBuffer.append('.');
                }
                if (methodBinding.isConstructor()) {
                    stringBuffer.append("new ");
                    stringBuffer.append(string4);
                } else {
                    Util.appendMethodName(stringBuffer, methodBinding, false, false);
                }
                stringBuffer.append(string.substring(n7 + 1, n4));
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private TypeBinding[] convertSignatureToParameters(String string, Scope scope) {
        if (string.length() <= 2) {
            return new TypeBinding[0];
        }
        SignatureWrapper signatureWrapper = new SignatureWrapper(string.toCharArray());
        TypeBinding[] typeBindingArray = new TypeBinding[]{};
        if (signatureWrapper.signature[signatureWrapper.start] == '(') {
            ++signatureWrapper.start;
            if (signatureWrapper.signature[signatureWrapper.start] == ')') {
                ++signatureWrapper.start;
            } else {
                ArrayList<TypeBinding> arrayList = new ArrayList<TypeBinding>(2);
                LookupEnvironment lookupEnvironment = scope.environment();
                while (signatureWrapper.signature[signatureWrapper.start] != ')') {
                    TypeBinding typeBinding = lookupEnvironment.getTypeFromTypeSignature(signatureWrapper, null, null, null);
                    typeBinding = BinaryTypeBinding.resolveType((TypeBinding)typeBinding, (LookupEnvironment)lookupEnvironment, (boolean)true);
                    arrayList.add(typeBinding);
                }
                ++signatureWrapper.start;
                int n = arrayList.size();
                typeBindingArray = new TypeBinding[n];
                arrayList.toArray(typeBindingArray);
            }
        }
        return typeBindingArray;
    }

    private void expandMethodArgument(char[] cArray, TypeBinding typeBinding, boolean bl) {
        if (bl) {
            this.scriptOutput.append(", ");
        }
        this.scriptOutput.append(cArray);
        this.scriptOutput.append(": ");
        Util.appendTypeName(this.scriptOutput, typeBinding, this.importRegistry.isAmbiguous(typeBinding), true);
    }

    void flushImports(CompilationUnitScope compilationUnitScope) {
        Object object;
        ImportReference importReference;
        boolean bl;
        char[] cArray;
        block19: {
            CompilationUnitDeclaration compilationUnitDeclaration = compilationUnitScope.referenceCompilationUnit();
            ImportReference[] importReferenceArray = compilationUnitDeclaration.imports;
            char[][] cArrayArray = new char[][]{"java".toCharArray(), "lang".toCharArray(), "System".toCharArray()};
            cArray = "java.lang.System".toCharArray();
            bl = this.importRegistry.importJavaLangSystem;
            this.compilationUnitLocalNamesRegistry = new LocalNamesRegistry();
            if (this.currentPackage != null) {
                this.compilationUnitLocalNamesRegistry.checkPackage(this.currentPackage.tokens, this.currentPackage.tokens.length);
            }
            if (this.localNamesRegistry != null) {
                this.localNamesRegistries.push(this.localNamesRegistry);
            }
            this.localNamesRegistry = this.compilationUnitLocalNamesRegistry;
            if (importReferenceArray == null) break block19;
            int n = 0;
            int n2 = importReferenceArray.length;
            while (n < n2) {
                block20: {
                    Binding binding;
                    ReferenceBinding referenceBinding;
                    int n3;
                    int n4;
                    block21: {
                        importReference = importReferenceArray[n];
                        if (importReference == this.currentPackage || importReference.isStatic()) break block20;
                        object = importReference.tokens;
                        n4 = ((PackageBinding)object).length;
                        n3 = 0;
                        if (!CharOperation.equals((char[])Util.INTRINSIC, (char[])object[0])) break block21;
                        switch (n4) {
                            case 1: {
                                break block20;
                            }
                            case 2: {
                                if ((importReference.bits & 0x20000) == 0) break block20;
                            }
                            default: {
                                n3 = 1;
                            }
                        }
                    }
                    ReferenceBinding referenceBinding2 = referenceBinding = (binding = compilationUnitScope.getTypeOrPackage((char[][])object)) instanceof ReferenceBinding ? (ReferenceBinding)binding : null;
                    if (referenceBinding == null) {
                        this.scriptOutput.append("import ");
                        int n5 = n3;
                        while (n5 < n4) {
                            this.scriptOutput.append((char[])object[n5]);
                            this.scriptOutput.append('.');
                            ++n5;
                        }
                        this.scriptOutput.append('*');
                        this.compilationUnitLocalNamesRegistry.checkPackage((char[][])object, n4);
                        this.scriptOutput.append(';').appendNewLine();
                    } else if (!referenceBinding.isAnnotationType() && referenceBinding.isValidBinding()) {
                        this.scriptOutput.append("import ");
                        Util.appendTypeName(this.scriptOutput, (TypeBinding)referenceBinding, true);
                        this.compilationUnitLocalNamesRegistry.checkPackage((char[][])object, n4 - 1);
                        this.scriptOutput.append(';').appendNewLine();
                    }
                    if (CharOperation.equals((char[][])cArrayArray, (char[][])object)) {
                        bl = false;
                    }
                }
                ++n;
            }
        }
        Iterator iterator = this.importRegistry.getUnimportedTypes();
        PackageBinding packageBinding = compilationUnitScope.fPackage;
        while (iterator.hasNext()) {
            char[][] cArray2;
            importReference = (TypeBinding)iterator.next();
            object = importReference.getPackage();
            if (object == null || object == packageBinding || importReference.isAnnotationType() || (cArray2 = object.compoundName).length == 1 && CharOperation.equals((char[])Util.INTRINSIC, (char[])cArray2[0])) continue;
            this.compilationUnitLocalNamesRegistry.checkPackage(cArray2, cArray2.length - 1);
            this.scriptOutput.append("import ");
            Util.appendTypeName(this.scriptOutput, (TypeBinding)importReference, true);
            this.scriptOutput.append(';').appendNewLine();
            if (!CharOperation.equals((char[])cArray, (char[])importReference.readableName())) continue;
            bl = false;
        }
        if (this.importRegistry.importJavaLangArguments) {
            this.scriptOutput.append("import java.lang.Arguments;").appendNewLine();
        }
        if (this.importRegistry.importJavaLangClass) {
            this.scriptOutput.append("import java.lang.Class__;").appendNewLine();
        }
        if (this.importRegistry.importJavaLangEnum) {
            this.scriptOutput.append("import java.lang.Enum;").appendNewLine();
        }
        if (this.importRegistry.importJavaLangJavaArray) {
            this.scriptOutput.append("import java.lang.JavaArray;").appendNewLine();
        }
        if (bl) {
            this.scriptOutput.append("import java.lang.System;").appendNewLine();
        }
        if (!this.localNamesRegistries.empty()) {
            this.localNamesRegistry = (LocalNamesRegistry)this.localNamesRegistries.pop();
        }
    }

    private void generateOuterAccess(Object[] objectArray, TypeBinding typeBinding) {
        if (objectArray != null) {
            if (objectArray == BlockScope.EmulationPathToImplicitThis) {
                if (typeBinding != null) {
                    Util.appendTypeName(this.scriptOutput, typeBinding, false);
                    this.scriptOutput.append('(');
                }
                this.scriptOutput.append("this");
                if (typeBinding != null) {
                    this.scriptOutput.append(')');
                }
            } else {
                this.generateOuterAccess(objectArray, 0, objectArray.length - 1);
            }
        }
    }

    private void generateOuterAccess(Object[] objectArray) {
        this.generateOuterAccess(objectArray, null);
    }

    private void generateOuterAccess(Object[] objectArray, int n, int n2) {
        if (n2 >= n) {
            if (objectArray[n2] instanceof MethodBinding) {
                MethodBinding methodBinding = (MethodBinding)objectArray[n2];
                Util.appendTypeName(this.scriptOutput, (TypeBinding)methodBinding.declaringClass, this.importRegistry.isAmbiguous((TypeBinding)methodBinding.declaringClass));
                this.scriptOutput.append('.');
                this.scriptOutput.append(methodBinding.selector);
                this.scriptOutput.append('(');
                this.generateOuterAccess(objectArray, n, n2 - 1);
                this.scriptOutput.append(')');
            } else if (objectArray[n2] instanceof FieldBinding) {
                this.generateOuterAccess(objectArray, n, n2 - 1);
                this.scriptOutput.append(this.fieldNamesRegistry.targetName((FieldBinding)objectArray[n2]));
            } else {
                this.scriptOutput.append(this.localNamesRegistry.targetName((LocalVariableBinding)objectArray[n2]));
            }
        }
    }

    public void indent() {
        this.scriptOutput.indent();
    }

    public void outdent() {
        this.scriptOutput.outdent();
    }

    public void printIndent() {
        this.scriptOutput.printIndent();
    }

    protected void reportError(Scope scope, String string, ASTNode aSTNode) {
        String[] stringArray = new String[]{"ActionScript3.0: " + string};
        org.eclipse.jdt.internal.compiler.problem.ProblemReporter problemReporter = scope.problemReporter();
        problemReporter.handle(0, stringArray, 0, stringArray, 129, aSTNode == null ? 0 : aSTNode.sourceStart, aSTNode == null ? 0 : aSTNode.sourceEnd, problemReporter.referenceContext, problemReporter.referenceContext == null ? null : problemReporter.referenceContext.compilationResult());
    }

    protected void reportWarning(Scope scope, String string, ASTNode aSTNode) {
        String[] stringArray = new String[]{"ActionScript3.0: " + string};
        ProblemReporter problemReporter = (ProblemReporter)scope.problemReporter();
        if (((ASCompilerOptions)problemReporter.options).disableWarnings) {
            return;
        }
        problemReporter.handle(0, stringArray, 0, stringArray, 0, aSTNode == null ? 0 : aSTNode.sourceStart, aSTNode == null ? 0 : aSTNode.sourceEnd, problemReporter.referenceContext, problemReporter.referenceContext == null ? null : problemReporter.referenceContext.compilationResult());
    }

    public String toString() {
        return String.valueOf(this.scriptOutput.toString()) + "[END]";
    }

    String toString(char[][] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            if (n != 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(cArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean visit(AllocationExpression allocationExpression, BlockScope blockScope) {
        FieldDeclaration fieldDeclaration;
        int n;
        SyntheticArgumentBinding[] syntheticArgumentBindingArray;
        int n2;
        ReferenceBinding referenceBinding = allocationExpression.binding.declaringClass;
        boolean bl = false;
        boolean bl2 = false;
        if (referenceBinding.id == 11) {
            if (allocationExpression.arguments != null && allocationExpression.arguments.length > 0) {
                this.scriptOutput.append("Object(String).");
                Util.appendMethodName(this.scriptOutput, allocationExpression.binding, false, false);
                this.scriptOutput.append('(');
            } else {
                this.scriptOutput.append("new String(");
            }
        } else if (Util.isSingleConstructor(allocationExpression.binding) || allocationExpression.binding.declaringClass.id == 1 || Util.isIntrinsic((TypeBinding)referenceBinding)) {
            this.scriptOutput.append("new ");
            Util.appendTypeName(this.scriptOutput, (TypeBinding)referenceBinding, this.importRegistry.isAmbiguous((TypeBinding)referenceBinding));
            this.scriptOutput.append('(');
        } else {
            this.scriptOutput.append("new ");
            Util.appendTypeName(this.scriptOutput, (TypeBinding)referenceBinding, this.importRegistry.isAmbiguous((TypeBinding)referenceBinding));
            this.scriptOutput.append("(new Arguments(");
            Util.dumpConstructorFieldReference(this.scriptOutput, allocationExpression.binding);
            this.scriptOutput.append(", [");
            bl2 = true;
        }
        ReferenceBinding[] referenceBindingArray = referenceBinding.syntheticEnclosingInstanceTypes();
        if (referenceBindingArray != null) {
            bl = true;
            int n3 = 0;
            n2 = referenceBindingArray.length;
            while (n3 < n2) {
                this.generateOuterAccess(blockScope.getEmulationPath(referenceBindingArray[n3], false, false), (TypeBinding)(blockScope instanceof MethodScope && ((MethodScope)blockScope).isInsideInitializer() ? referenceBindingArray[n3] : null));
                ++n3;
            }
        }
        if ((syntheticArgumentBindingArray = referenceBinding.syntheticOuterLocalVariables()) != null) {
            if (bl) {
                this.scriptOutput.append(", ");
            } else {
                bl = true;
            }
            this.generateOuterAccess(blockScope.getEmulationPath(syntheticArgumentBindingArray[0].actualOuterLocalVariable));
            n2 = 1;
            n = syntheticArgumentBindingArray.length;
            while (n2 < n) {
                this.scriptOutput.append(", ");
                this.generateOuterAccess(blockScope.getEmulationPath(syntheticArgumentBindingArray[n2].actualOuterLocalVariable));
                ++n2;
            }
        }
        if ((fieldDeclaration = allocationExpression.enumConstant) != null) {
            this.scriptOutput.append('\"');
            this.scriptOutput.append(fieldDeclaration.name);
            this.scriptOutput.append("\", ");
            this.scriptOutput.append(Util.getOrdinalValue(fieldDeclaration));
            bl = true;
        }
        if (allocationExpression.arguments != null) {
            if (bl) {
                this.scriptOutput.append(", ");
            }
            allocationExpression.arguments[0].traverse((ASTVisitor)this, blockScope);
            n = 1;
            int n4 = allocationExpression.arguments.length;
            while (n < n4) {
                this.scriptOutput.append(", ");
                allocationExpression.arguments[n].traverse((ASTVisitor)this, blockScope);
                ++n;
            }
        }
        if (bl2) {
            this.scriptOutput.append("]))");
        } else {
            this.scriptOutput.append(')');
        }
        return false;
    }

    public boolean visit(AND_AND_Expression aND_AND_Expression, BlockScope blockScope) {
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)aND_AND_Expression, blockScope);
        aND_AND_Expression.left.traverse((ASTVisitor)this, blockScope);
        this.scriptOutput.append(' ').append(aND_AND_Expression.operatorToString()).append(' ');
        aND_AND_Expression.right.traverse((ASTVisitor)this, blockScope);
        Util.appendClosingParenthesis(this.scriptOutput, (Expression)aND_AND_Expression, blockScope);
        return false;
    }

    public boolean visit(ArrayAllocationExpression arrayAllocationExpression, BlockScope blockScope) {
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)arrayAllocationExpression, blockScope);
        ArrayInitializer arrayInitializer = arrayAllocationExpression.initializer;
        Expression[] expressionArray = arrayAllocationExpression.dimensions;
        this.scriptOutput.append("new JavaArray(\"");
        this.scriptOutput.append(arrayAllocationExpression.resolvedType.signature());
        this.scriptOutput.append("\")");
        if (arrayInitializer != null && arrayInitializer.expressions != null) {
            this.scriptOutput.append(".values(");
            int n = arrayInitializer.expressions.length - 1;
            int n2 = 0;
            while (n2 < n) {
                arrayInitializer.expressions[n2].traverse((ASTVisitor)this, blockScope);
                this.scriptOutput.append(", ");
                ++n2;
            }
            arrayInitializer.expressions[n].traverse((ASTVisitor)this, blockScope);
            this.scriptOutput.append(")");
        } else if (expressionArray != null) {
            this.scriptOutput.append(".lengths(");
            int n = 0;
            while (n < expressionArray.length) {
                if (expressionArray[n] == null) break;
                if (n != 0) {
                    this.scriptOutput.append(", ");
                }
                expressionArray[n].traverse((ASTVisitor)this, blockScope);
                ++n;
            }
            this.scriptOutput.append(")");
        }
        Util.appendClosingParenthesis(this.scriptOutput, (Expression)arrayAllocationExpression, blockScope);
        return false;
    }

    public boolean visit(ArrayInitializer arrayInitializer, BlockScope blockScope) {
        this.scriptOutput.append("new JavaArray(\"");
        this.scriptOutput.append(arrayInitializer.resolvedType.signature());
        this.scriptOutput.append("\")");
        if (arrayInitializer.expressions != null) {
            this.scriptOutput.append(".values(");
            int n = arrayInitializer.expressions.length - 1;
            int n2 = 0;
            while (n2 < n) {
                arrayInitializer.expressions[n2].traverse((ASTVisitor)this, blockScope);
                this.scriptOutput.append(", ");
                ++n2;
            }
            arrayInitializer.expressions[n].traverse((ASTVisitor)this, blockScope);
            this.scriptOutput.append(")");
        }
        return false;
    }

    public boolean visit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, BlockScope blockScope) {
        Util.appendTypeName(this.scriptOutput, arrayQualifiedTypeReference.resolvedType, this.importRegistry.isAmbiguous(arrayQualifiedTypeReference.resolvedType));
        return false;
    }

    public boolean visit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, ClassScope classScope) {
        Util.appendTypeName(this.scriptOutput, arrayQualifiedTypeReference.resolvedType, this.importRegistry.isAmbiguous(arrayQualifiedTypeReference.resolvedType));
        return false;
    }

    public boolean visit(ArrayReference arrayReference, BlockScope blockScope) {
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)arrayReference, blockScope);
        arrayReference.receiver.traverse((ASTVisitor)this, blockScope);
        this.scriptOutput.append('[');
        arrayReference.position.traverse((ASTVisitor)this, blockScope);
        this.scriptOutput.append(']');
        Util.appendClosingParenthesis(this.scriptOutput, (Expression)arrayReference, blockScope);
        return false;
    }

    public boolean visit(ArrayTypeReference arrayTypeReference, BlockScope blockScope) {
        Util.appendTypeName(this.scriptOutput, arrayTypeReference.resolvedType, this.importRegistry.isAmbiguous(arrayTypeReference.resolvedType));
        return false;
    }

    public boolean visit(ArrayTypeReference arrayTypeReference, ClassScope classScope) {
        Util.appendTypeName(this.scriptOutput, arrayTypeReference.resolvedType, this.importRegistry.isAmbiguous(arrayTypeReference.resolvedType));
        return false;
    }

    public boolean visit(AssertStatement assertStatement, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)assertStatement);
        blockScope.environment().getType(TypeConstants.JAVA_LANG_ASSERTIONERROR);
        this.printIndent();
        this.scriptOutput.append("if (!(");
        this.visitAsExpression((Statement)assertStatement.assertExpression, blockScope);
        this.scriptOutput.append(")) {").appendNewLine();
        this.indent();
        Expression expression = assertStatement.exceptionArgument;
        this.printIndent();
        this.scriptOutput.append("throw ");
        if (expression == null) {
            this.scriptOutput.append("new java.lang.AssertionError(new Arguments(0, []));").appendNewLine();
        } else {
            MethodBinding methodBinding = Util.retrieveConstructor(expression.resolvedType, blockScope.getJavaLangAssertionError());
            if (methodBinding == null) {
                this.reportError((Scope)blockScope, "A constructor must be found for AssertionError", (ASTNode)assertStatement);
            }
            this.scriptOutput.append("new java.lang.AssertionError(new Arguments(");
            Util.dumpConstructorFieldReference(this.scriptOutput, methodBinding);
            this.scriptOutput.append(", [");
            if (expression != null) {
                this.visitAsExpression((Statement)expression, blockScope);
            }
            this.scriptOutput.append("]));").appendNewLine();
        }
        this.outdent();
        this.printIndent();
        this.scriptOutput.append('}');
        return false;
    }

    public boolean visit(Assignment assignment, BlockScope blockScope) {
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)assignment, blockScope);
        Expression expression = assignment.lhs;
        try {
            if (expression instanceof Reference) {
                if (expression instanceof FieldReference) {
                    FieldReference fieldReference = (FieldReference)expression;
                    MethodBinding[] methodBindingArray = fieldReference.syntheticAccessors;
                    if (methodBindingArray != null) {
                        MethodBinding methodBinding = methodBindingArray[1];
                        if (methodBinding != null) {
                            ReferenceBinding referenceBinding = methodBinding.declaringClass;
                            Util.appendTypeName(this.scriptOutput, (TypeBinding)referenceBinding, this.importRegistry.isAmbiguous((TypeBinding)referenceBinding));
                            this.scriptOutput.append('.');
                            this.scriptOutput.append(methodBinding.selector);
                            this.scriptOutput.append('(');
                            if (!fieldReference.binding.isStatic()) {
                                this.generateOuterAccess(blockScope.getEmulationPath(fieldReference.fieldBinding().original().declaringClass, false, false));
                                this.scriptOutput.append(", ");
                            }
                            assignment.expression.traverse((ASTVisitor)this, blockScope);
                            this.scriptOutput.append(')');
                        }
                        return false;
                    }
                } else if (expression instanceof QualifiedNameReference) {
                    QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)expression;
                    SyntheticMethodBinding syntheticMethodBinding = qualifiedNameReference.syntheticWriteAccessor;
                    if (syntheticMethodBinding != null) {
                        ReferenceBinding referenceBinding = syntheticMethodBinding.declaringClass;
                        boolean bl = Util.shouldFullyQualified(qualifiedNameReference);
                        Util.appendTypeName(this.scriptOutput, (TypeBinding)referenceBinding, bl);
                        this.scriptOutput.append('.');
                        this.scriptOutput.append(syntheticMethodBinding.selector);
                        this.scriptOutput.append('(');
                        switch (qualifiedNameReference.bits & 7) {
                            case 1: {
                                SyntheticMethodBinding syntheticMethodBinding2;
                                FieldBinding fieldBinding = qualifiedNameReference.fieldBinding();
                                if (fieldBinding == null || fieldBinding.isStatic()) break;
                                SyntheticMethodBinding syntheticMethodBinding3 = syntheticMethodBinding2 = qualifiedNameReference.syntheticReadAccessors == null ? null : qualifiedNameReference.syntheticReadAccessors[0];
                                if (syntheticMethodBinding2 != null) {
                                    Util.appendTypeName(this.scriptOutput, qualifiedNameReference.actualReceiverType, bl);
                                    this.scriptOutput.append('.');
                                    this.scriptOutput.append(syntheticMethodBinding2.selector);
                                    this.scriptOutput.append('(');
                                    this.generateOuterAccess(blockScope.getEmulationPath(fieldBinding.original().declaringClass, false, false));
                                    this.scriptOutput.append(')');
                                } else {
                                    if ((qualifiedNameReference.bits & 0x1FE0) != 0) {
                                        if (((FieldBinding)qualifiedNameReference.binding).isStatic()) {
                                            Util.appendTypeName(this.scriptOutput, qualifiedNameReference.actualReceiverType, true);
                                        } else {
                                            this.generateOuterAccess(blockScope.getEmulationPath(fieldBinding.original().declaringClass, false, false));
                                        }
                                        this.scriptOutput.append('.');
                                    } else if (qualifiedNameReference.indexOfFirstFieldBinding > 1) {
                                        if (qualifiedNameReference.actualReceiverType.isInterface()) {
                                            Util.appendTypeName(this.scriptOutput, qualifiedNameReference.actualReceiverType, true);
                                            this.scriptOutput.append(INTERFACE_FIELDS);
                                        } else {
                                            Util.appendTypeName(this.scriptOutput, qualifiedNameReference.actualReceiverType, bl);
                                        }
                                        this.scriptOutput.append('.');
                                    }
                                    this.scriptOutput.append(this.fieldNamesRegistry.targetName(fieldBinding));
                                }
                                this.scriptOutput.append(", ");
                                break;
                            }
                            case 2: {
                                LocalVariableBinding localVariableBinding = (LocalVariableBinding)qualifiedNameReference.binding;
                                this.scriptOutput.append(this.localNamesRegistry.targetName(localVariableBinding));
                                this.scriptOutput.append(", ");
                            }
                        }
                        assignment.expression.traverse((ASTVisitor)this, blockScope);
                        this.scriptOutput.append(')');
                        return false;
                    }
                } else if (expression instanceof SingleNameReference) {
                    SingleNameReference singleNameReference = (SingleNameReference)expression;
                    MethodBinding[] methodBindingArray = singleNameReference.syntheticAccessors;
                    if (methodBindingArray != null) {
                        MethodBinding methodBinding = methodBindingArray[1];
                        if (methodBinding != null) {
                            ReferenceBinding referenceBinding = methodBinding.declaringClass;
                            Util.appendTypeName(this.scriptOutput, (TypeBinding)referenceBinding, this.importRegistry.isAmbiguous((TypeBinding)referenceBinding));
                            this.scriptOutput.append('.');
                            this.scriptOutput.append(methodBinding.selector);
                            this.scriptOutput.append('(');
                            FieldBinding fieldBinding = singleNameReference.fieldBinding();
                            if (!fieldBinding.isStatic()) {
                                this.generateOuterAccess(blockScope.getEmulationPath(fieldBinding.original().declaringClass, false, false));
                                this.scriptOutput.append(", ");
                            }
                            assignment.expression.traverse((ASTVisitor)this, blockScope);
                            this.scriptOutput.append(')');
                        }
                        return false;
                    }
                }
            }
            expression.traverse((ASTVisitor)this, blockScope);
            this.scriptOutput.append(" = ");
            assignment.expression.traverse((ASTVisitor)this, blockScope);
        }
        finally {
            Util.appendClosingParenthesis(this.scriptOutput, (Expression)assignment, blockScope);
        }
        return false;
    }

    public boolean visit(BinaryExpression binaryExpression, BlockScope blockScope) {
        if (binaryExpression.resolvedType.id == 11) {
            return this.visitStringConcatenation(binaryExpression, blockScope);
        }
        boolean bl = false;
        switch (binaryExpression.resolvedType.id) {
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                bl = (binaryExpression.bits & 0xFC0) >> 6 == 9;
            }
        }
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)binaryExpression, blockScope);
        if (bl) {
            this.scriptOutput.append("int(");
        }
        block3 : switch (binaryExpression.resolvedType.id) {
            case 5: {
                switch ((binaryExpression.bits & 0xFC0) >> 6) {
                    case 2: {
                        this.scriptOutput.append('(');
                        binaryExpression.left.traverse((ASTVisitor)this, blockScope);
                        this.scriptOutput.append(") ? (");
                        binaryExpression.right.traverse((ASTVisitor)this, blockScope);
                        this.scriptOutput.append(") : (");
                        binaryExpression.right.traverse((ASTVisitor)this, blockScope);
                        this.scriptOutput.append(", false)");
                        break block3;
                    }
                    case 3: {
                        this.scriptOutput.append('(');
                        binaryExpression.left.traverse((ASTVisitor)this, blockScope);
                        this.scriptOutput.append(") ? (");
                        binaryExpression.right.traverse((ASTVisitor)this, blockScope);
                        this.scriptOutput.append(", true) : (");
                        binaryExpression.right.traverse((ASTVisitor)this, blockScope);
                        this.scriptOutput.append(')');
                        break block3;
                    }
                    case 8: {
                        this.scriptOutput.append('(');
                        binaryExpression.left.traverse((ASTVisitor)this, blockScope);
                        this.scriptOutput.append(") != (");
                        binaryExpression.right.traverse((ASTVisitor)this, blockScope);
                        this.scriptOutput.append(')');
                        break block3;
                    }
                }
            }
            default: {
                binaryExpression.left.traverse((ASTVisitor)this, blockScope);
                this.scriptOutput.append(' ').append(binaryExpression.operatorToString()).append(' ');
                binaryExpression.right.traverse((ASTVisitor)this, blockScope);
            }
        }
        if (bl) {
            this.scriptOutput.append(")");
        }
        Util.appendClosingParenthesis(this.scriptOutput, (Expression)binaryExpression, blockScope);
        return false;
    }

    public boolean visit(Block block, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)block);
        if (block != this.unIndentedStatement) {
            this.printIndent();
        }
        this.scriptOutput.append('{').appendNewLine();
        this.indent();
        Statement[] statementArray = block.statements;
        int n = 0;
        int n2 = statementArray == null ? 0 : statementArray.length;
        while (n < n2) {
            Statement statement = statementArray[n];
            if (Util.isUnreachable((ASTNode)statement)) break;
            this.visitAsStatement(statement, block.scope);
            this.scriptOutput.appendNewLine();
            ++n;
        }
        this.outdent();
        this.printIndent();
        this.scriptOutput.append('}');
        this.lastStatement = null;
        return false;
    }

    public boolean visit(BreakStatement breakStatement, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)breakStatement);
        if (breakStatement != this.unIndentedStatement) {
            this.printIndent();
        }
        if (breakStatement.label == null) {
            this.scriptOutput.append("break;");
        } else {
            this.scriptOutput.append("break ").append(breakStatement.label).append(';');
        }
        return false;
    }

    public boolean visit(CaseStatement caseStatement, BlockScope blockScope) {
        Expression expression;
        Util.mapLine(this, this.scriptOutput, (ASTNode)caseStatement);
        if (caseStatement != this.unIndentedStatement) {
            this.printIndent();
        }
        if ((expression = caseStatement.constantExpression) == null) {
            this.scriptOutput.append("default :");
        } else {
            this.scriptOutput.append("case ");
            if (expression.resolvedType.isEnum()) {
                this.scriptOutput.append(Util.getOrdinalValue((FieldBinding)((SingleNameReference)expression).binding));
            } else {
                expression.traverse((ASTVisitor)this, blockScope);
            }
            this.scriptOutput.append(" :");
        }
        return false;
    }

    public boolean visit(CastExpression castExpression, BlockScope blockScope) {
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)castExpression, blockScope);
        Util.appendTypeName(this.scriptOutput, castExpression.resolvedType, this.importRegistry.isAmbiguous(castExpression.resolvedType));
        this.scriptOutput.append('(');
        castExpression.expression.traverse((ASTVisitor)this, blockScope);
        this.scriptOutput.append(')');
        Util.appendClosingParenthesis(this.scriptOutput, (Expression)castExpression, blockScope);
        return false;
    }

    public boolean visit(CharLiteral charLiteral, BlockScope blockScope) {
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)charLiteral, blockScope);
        this.scriptOutput.append(charLiteral.constant.intValue());
        Util.appendClosingParenthesis(this.scriptOutput, (Expression)charLiteral, blockScope);
        return false;
    }

    public boolean visit(ClassLiteralAccess classLiteralAccess, BlockScope blockScope) {
        this.scriptOutput.append("Class__.forName__Ljava_lang_String_2(\"");
        Util.appendTypeName(this.scriptOutput, classLiteralAccess.targetType, true);
        this.scriptOutput.append("\")");
        return false;
    }

    public boolean visit(Clinit clinit, ClassScope classScope) {
        boolean bl = false;
        TypeDeclaration typeDeclaration = classScope.referenceType();
        if (typeDeclaration.fields != null) {
            int n = typeDeclaration.fields.length;
            int n2 = 0;
            while (n2 < n) {
                FieldDeclaration fieldDeclaration = typeDeclaration.fields[n2];
                if (fieldDeclaration.getKind() == 2 && fieldDeclaration.isStatic()) {
                    if (!bl) {
                        bl = true;
                        this.setLineNumberBounds((AbstractMethodDeclaration)clinit);
                        this.localNamesRegistries.push(this.localNamesRegistry);
                        this.localNamesRegistry = LocalNamesRegistry.newInstance((AbstractMethodDeclaration)clinit, this.compilationUnitLocalNamesRegistry);
                        this.appendMethod((AbstractMethodDeclaration)clinit, classScope);
                        this.scriptOutput.append(" {").appendNewLine();
                        this.indent();
                    }
                    fieldDeclaration.traverse((ASTVisitor)this, typeDeclaration.staticInitializerScope);
                }
                ++n2;
            }
        }
        if (bl) {
            this.outdent();
            this.printIndent();
            this.scriptOutput.append('}').appendNewLine();
            this.localNamesRegistry = (LocalNamesRegistry)this.localNamesRegistries.pop();
        }
        return false;
    }

    public boolean visit(CompilationUnitDeclaration compilationUnitDeclaration, CompilationUnitScope compilationUnitScope) {
        this.currentPackage = compilationUnitDeclaration.currentPackage;
        if (this.currentPackage != null && CharOperation.equals((char[])Util.INTRINSIC, (char[])this.currentPackage.tokens[0])) {
            return false;
        }
        this.importRegistry = new ImportRegistry();
        this.importRegistry.initialize(compilationUnitDeclaration);
        this.lineSeparators = compilationUnitDeclaration.compilationResult.getLineSeparatorPositions();
        return true;
    }

    public boolean visit(CompoundAssignment compoundAssignment, BlockScope blockScope) {
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)compoundAssignment, blockScope);
        compoundAssignment.lhs.traverse((ASTVisitor)this, blockScope);
        if (compoundAssignment.expression.resolvedType.id == 5) {
            this.scriptOutput.append(" = (");
            compoundAssignment.lhs.traverse((ASTVisitor)this, blockScope);
            this.scriptOutput.append(") ? (");
            compoundAssignment.expression.traverse((ASTVisitor)this, blockScope);
            switch (compoundAssignment.operator) {
                case 2: {
                    this.scriptOutput.append(") : (");
                    compoundAssignment.expression.traverse((ASTVisitor)this, blockScope);
                    this.scriptOutput.append(", false)");
                    break;
                }
                case 3: {
                    this.scriptOutput.append(", true) : (");
                    compoundAssignment.expression.traverse((ASTVisitor)this, blockScope);
                    this.scriptOutput.append(')');
                }
            }
        } else {
            this.scriptOutput.append(' ').append(compoundAssignment.operatorToString()).append(' ');
            compoundAssignment.expression.traverse((ASTVisitor)this, blockScope);
        }
        Util.appendClosingParenthesis(this.scriptOutput, (Expression)compoundAssignment, blockScope);
        return false;
    }

    public boolean visit(ConditionalExpression conditionalExpression, BlockScope blockScope) {
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)conditionalExpression, blockScope);
        conditionalExpression.condition.traverse((ASTVisitor)this, blockScope);
        this.scriptOutput.append(" ? ");
        conditionalExpression.valueIfTrue.traverse((ASTVisitor)this, blockScope);
        this.scriptOutput.append(" : ");
        conditionalExpression.valueIfFalse.traverse((ASTVisitor)this, blockScope);
        Util.appendClosingParenthesis(this.scriptOutput, (Expression)conditionalExpression, blockScope);
        return false;
    }

    public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope classScope) {
        if (constructorDeclaration.ignoreFurtherInvestigation) {
            return false;
        }
        if (constructorDeclaration.binding == null) {
            return false;
        }
        this.setLineNumberBounds((AbstractMethodDeclaration)constructorDeclaration);
        MethodBinding methodBinding = constructorDeclaration.binding;
        FieldBinding[] fieldBindingArray = null;
        ReferenceBinding referenceBinding = methodBinding.declaringClass;
        if (referenceBinding.isNestedType() || referenceBinding.isEnum()) {
            fieldBindingArray = ((SourceTypeBinding)referenceBinding).syntheticFields();
        }
        TypeDeclaration typeDeclaration = classScope.referenceType();
        boolean bl = Util.hasFieldInitializers(typeDeclaration);
        Argument[] argumentArray = constructorDeclaration.arguments;
        if (!(!constructorDeclaration.isDefaultConstructor() || referenceBinding.isEnum() || fieldBindingArray != null || argumentArray != null && argumentArray.length != 0 || bl)) {
            Util.registerDefaultConstructor(constructorDeclaration.binding);
            return false;
        }
        if (!this.generatingConstructor && Util.isSingleConstructor(constructorDeclaration.binding)) {
            this.generatingConstructor = true;
            this.visit(constructorDeclaration, classScope);
            this.generatingConstructor = false;
            return false;
        }
        this.localNamesRegistries.push(this.localNamesRegistry);
        this.localNamesRegistry = LocalNamesRegistry.newInstance((AbstractMethodDeclaration)constructorDeclaration, this.compilationUnitLocalNamesRegistry);
        this.constructorGenerator.add(constructorDeclaration);
        this.appendMethod((AbstractMethodDeclaration)constructorDeclaration, classScope);
        if (!methodBinding.isNative()) {
            Statement[] statementArray;
            FieldBinding fieldBinding;
            int n;
            int n2;
            this.scriptOutput.append(" {").appendNewLine();
            this.indent();
            if (referenceBinding.isEnum()) {
                this.printIndent();
                if (referenceBinding.superclass().original() == classScope.getJavaLangEnum()) {
                    this.scriptOutput.append("super(arg0, arg1);").appendNewLine();
                } else {
                    this.scriptOutput.append("super(arg0, arg1");
                    if (argumentArray != null) {
                        n2 = 0;
                        n = argumentArray.length;
                        while (n2 < n) {
                            this.scriptOutput.append(", ");
                            this.scriptOutput.append(this.localNamesRegistry.targetName(argumentArray[n2].binding).toCharArray());
                            ++n2;
                        }
                    }
                    this.scriptOutput.append(");").appendNewLine();
                }
            } else {
                if (referenceBinding.isNestedType() && fieldBindingArray != null) {
                    n2 = 0;
                    n = fieldBindingArray.length;
                    while (n2 < n) {
                        fieldBinding = fieldBindingArray[n2];
                        if (!Util.isExcluded(fieldBinding)) {
                            this.printIndent();
                            this.scriptOutput.append("this.");
                            this.scriptOutput.append(fieldBinding.name);
                            this.scriptOutput.append(" = ");
                            this.scriptOutput.append(fieldBinding.name);
                            this.scriptOutput.append(';').appendNewLine();
                        }
                        ++n2;
                    }
                }
                if (this.generatingConstructor && constructorDeclaration.constructorCall != null && (constructorDeclaration.constructorCall.binding.parameters.length > 0 || constructorDeclaration.constructorCall.binding.declaringClass.isNestedType())) {
                    constructorDeclaration.constructorCall.traverse((ASTVisitor)this, (BlockScope)constructorDeclaration.scope);
                    this.scriptOutput.append(';').appendNewLine();
                }
            }
            if (bl) {
                n2 = typeDeclaration.fields.length;
                n = 0;
                while (n < n2) {
                    fieldBinding = typeDeclaration.fields[n];
                    if (!fieldBinding.isStatic()) {
                        if (fieldBinding.getKind() != 2) {
                            if (fieldBinding.initialization != null && Util.containsThisReference((FieldDeclaration)fieldBinding, typeDeclaration.initializerScope)) {
                                this.printIndent();
                                this.scriptOutput.append(this.fieldNamesRegistry.targetName(fieldBinding.binding));
                                this.scriptOutput.append(" = ");
                                fieldBinding.initialization.traverse((ASTVisitor)this, (BlockScope)typeDeclaration.initializerScope);
                                this.scriptOutput.append(';').appendNewLine();
                            }
                        } else {
                            fieldBinding.traverse((ASTVisitor)this, typeDeclaration.initializerScope);
                        }
                    }
                    ++n;
                }
            }
            if ((statementArray = constructorDeclaration.statements) != null) {
                n = statementArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Statement statement = statementArray[n3];
                    if (Util.isUnreachable((ASTNode)statement)) break;
                    this.visitAsStatement(statement, (BlockScope)constructorDeclaration.scope);
                    if (!(statement instanceof TypeDeclaration)) {
                        this.scriptOutput.appendNewLine();
                    }
                    ++n3;
                }
            }
        }
        if ((constructorDeclaration.bits & 0x40) != 0 || !(this.lastStatement instanceof ReturnStatement)) {
            this.printIndent();
            if (this.generatingConstructor) {
                this.scriptOutput.append("return;").appendNewLine();
            } else {
                this.scriptOutput.append("return this;").appendNewLine();
            }
        }
        this.outdent();
        this.printIndent();
        this.scriptOutput.append('}').appendNewLine();
        this.localNamesRegistry = (LocalNamesRegistry)this.localNamesRegistries.pop();
        return false;
    }

    public boolean visit(ContinueStatement continueStatement, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)continueStatement);
        if (continueStatement != this.unIndentedStatement) {
            this.printIndent();
        }
        if (continueStatement.label == null) {
            this.scriptOutput.append("continue;");
        } else {
            this.scriptOutput.append("continue ").append(continueStatement.label).append(';');
        }
        return false;
    }

    public boolean visit(DoStatement doStatement, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)doStatement);
        if (doStatement != this.unIndentedStatement) {
            this.printIndent();
        }
        this.scriptOutput.append("do");
        Statement statement = doStatement.action;
        boolean bl = statement instanceof Block;
        if (bl) {
            this.scriptOutput.append(' ');
            this.unIndentedStatement = statement;
            this.visitAsExpression(statement, blockScope);
            this.scriptOutput.append(' ');
        } else {
            this.scriptOutput.appendNewLine();
            this.indent();
            this.visitAsStatement(statement, blockScope);
            this.outdent();
            this.scriptOutput.appendNewLine();
            this.printIndent();
        }
        this.scriptOutput.append("while (");
        Expression expression = doStatement.condition;
        expression.traverse((ASTVisitor)this, blockScope);
        this.scriptOutput.append(");");
        return false;
    }

    public boolean visit(DoubleLiteral doubleLiteral, BlockScope blockScope) {
        double d = doubleLiteral.constant.doubleValue();
        if (d > 0.0) {
            if (d < 9.9E-324) {
                this.reportWarning((Scope)blockScope, "double literal underflow", (ASTNode)doubleLiteral);
            } else if (d > 1.79769313486231E308) {
                this.reportWarning((Scope)blockScope, "double literal overflow", (ASTNode)doubleLiteral);
            }
        } else if (d < 0.0) {
            if (d > -9.9E-324) {
                this.reportWarning((Scope)blockScope, "double literal underflow", (ASTNode)doubleLiteral);
            } else if (d < -1.79769313486231E308) {
                this.reportWarning((Scope)blockScope, "double literal overflow", (ASTNode)doubleLiteral);
            }
        }
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)doubleLiteral, blockScope);
        this.scriptOutput.append(d);
        Util.appendClosingParenthesis(this.scriptOutput, (Expression)doubleLiteral, blockScope);
        return false;
    }

    public boolean visit(EmptyStatement emptyStatement, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)emptyStatement);
        if (emptyStatement != this.unIndentedStatement) {
            this.printIndent();
        }
        this.scriptOutput.append(';');
        return false;
    }

    public boolean visit(EqualExpression equalExpression, BlockScope blockScope) {
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)equalExpression, blockScope);
        equalExpression.left.traverse((ASTVisitor)this, blockScope);
        if (equalExpression.left.resolvedType.isBaseType()) {
            this.scriptOutput.append(' ').append(equalExpression.operatorToString()).append(' ');
        } else {
            this.scriptOutput.append(' ').append(Util.operatorToString((OperatorExpression)equalExpression)).append(' ');
        }
        equalExpression.right.traverse((ASTVisitor)this, blockScope);
        Util.appendClosingParenthesis(this.scriptOutput, (Expression)equalExpression, blockScope);
        return false;
    }

    public boolean visit(ExplicitConstructorCall explicitConstructorCall, BlockScope blockScope) {
        int n;
        SyntheticArgumentBinding[] syntheticArgumentBindingArray;
        int n2;
        ReferenceBinding[] referenceBindingArray;
        boolean bl;
        if (Util.isIntrinsic((TypeBinding)explicitConstructorCall.binding.declaringClass) && !Util.isSingleConstructor(explicitConstructorCall.binding)) {
            return false;
        }
        if (!explicitConstructorCall.isSuperAccess()) {
            return false;
        }
        Util.mapLine(this, this.scriptOutput, (ASTNode)explicitConstructorCall);
        this.printIndent();
        this.scriptOutput.append("super(");
        boolean bl2 = bl = !Util.isSingleConstructor(explicitConstructorCall.binding) && explicitConstructorCall.binding.declaringClass.id != 1 && !Util.isIntrinsic((TypeBinding)explicitConstructorCall.binding.declaringClass);
        if (bl) {
            this.scriptOutput.append("new Arguments(");
            Util.dumpConstructorFieldReference(this.scriptOutput, explicitConstructorCall.binding);
            this.scriptOutput.append(", [");
        }
        boolean bl3 = false;
        ReferenceBinding referenceBinding = explicitConstructorCall.binding.declaringClass;
        if (referenceBinding != null && (referenceBindingArray = referenceBinding.syntheticEnclosingInstanceTypes()) != null) {
            bl3 = true;
            int n3 = 0;
            n2 = referenceBindingArray.length;
            while (n3 < n2) {
                this.generateOuterAccess(blockScope.getEmulationPath(referenceBindingArray[n3], false, false));
                ++n3;
            }
        }
        if (referenceBinding != null && (syntheticArgumentBindingArray = referenceBinding.syntheticOuterLocalVariables()) != null) {
            bl3 = true;
            this.generateOuterAccess(blockScope.getEmulationPath(syntheticArgumentBindingArray[0].actualOuterLocalVariable));
            n2 = 1;
            n = syntheticArgumentBindingArray.length;
            while (n2 < n) {
                this.scriptOutput.append(", ");
                this.generateOuterAccess(blockScope.getEmulationPath(syntheticArgumentBindingArray[n2].actualOuterLocalVariable));
                ++n2;
            }
        }
        if (explicitConstructorCall.arguments != null) {
            if (bl3) {
                this.scriptOutput.append(", ");
            }
            explicitConstructorCall.arguments[0].traverse((ASTVisitor)this, blockScope);
            n2 = explicitConstructorCall.arguments.length;
            n = 1;
            while (n < n2) {
                this.scriptOutput.append(", ");
                explicitConstructorCall.arguments[n].traverse((ASTVisitor)this, blockScope);
                ++n;
            }
        }
        if (bl) {
            this.scriptOutput.append("])");
        }
        this.scriptOutput.append(')');
        return false;
    }

    public boolean visit(ExtendedStringLiteral extendedStringLiteral, BlockScope blockScope) {
        return this.visit(new StringLiteral(extendedStringLiteral.constant.stringValue().toCharArray(), extendedStringLiteral.sourceStart, extendedStringLiteral.sourceEnd, 1), blockScope);
    }

    public boolean visit(FalseLiteral falseLiteral, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)falseLiteral);
        this.scriptOutput.append("false");
        return false;
    }

    public boolean visit(FieldDeclaration fieldDeclaration, MethodScope methodScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)fieldDeclaration, 1, this.lineSeparators == null ? 1 : this.lineSeparators.length);
        if ((fieldDeclaration.binding.modifiers & 0x4000) != 0) {
            this.printIndent();
            this.scriptOutput.append("private static var ");
            char[] cArray = Util.getSyntheticFieldName(fieldDeclaration);
            this.scriptOutput.append(cArray);
            this.scriptOutput.append(" : ");
            char[] cArray2 = Util.getTypeName((TypeBinding)fieldDeclaration.binding.declaringClass, this.importRegistry.isAmbiguous((TypeBinding)fieldDeclaration.binding.declaringClass), true);
            this.scriptOutput.append(cArray2);
            this.scriptOutput.append(';').appendNewLine();
            this.printIndent();
            this.scriptOutput.append("public static function get ");
            this.scriptOutput.append(this.fieldNamesRegistry.targetName(fieldDeclaration.binding));
            this.scriptOutput.append("() : ");
            this.scriptOutput.append(cArray2);
            this.scriptOutput.append(" {").appendNewLine();
            this.indent();
            this.printIndent();
            this.scriptOutput.append("if (");
            this.scriptOutput.append(cArray);
            this.scriptOutput.append("=== null) {").appendNewLine();
            this.indent();
            this.printIndent();
            this.scriptOutput.append(cArray);
            this.scriptOutput.append(" = ");
            fieldDeclaration.initialization.traverse((ASTVisitor)this, (BlockScope)methodScope);
            this.scriptOutput.append(';').appendNewLine();
            this.outdent();
            this.printIndent();
            this.scriptOutput.append('}').appendNewLine();
            this.printIndent();
            this.scriptOutput.append("return ");
            this.scriptOutput.append(cArray);
            this.scriptOutput.append(';').appendNewLine();
            this.outdent();
            this.printIndent();
            this.scriptOutput.append('}').appendNewLine();
            return false;
        }
        this.printIndent();
        if (fieldDeclaration.binding.declaringClass.isInterface() && !this.generatingInterfaceFields) {
            this.scriptOutput.append("// ");
        }
        if (fieldDeclaration.binding.isPublic() || fieldDeclaration.binding.isProtected() || fieldDeclaration.binding.declaringClass.isNestedType() || fieldDeclaration.isStatic()) {
            this.scriptOutput.append("public ");
        } else if (fieldDeclaration.binding.isPrivate()) {
            this.scriptOutput.append("private ");
        } else {
            this.scriptOutput.append("internal ");
        }
        if (fieldDeclaration.binding.isStatic()) {
            this.scriptOutput.append("static ");
        }
        if (fieldDeclaration.binding.isFinal()) {
            if (fieldDeclaration.binding.constant() == Constant.NotAConstant) {
                if (!this.generatingInterfaceFields) {
                    this.reportWarning((Scope)methodScope, "final field should be initialized to a constant value to be generated as a const", (ASTNode)fieldDeclaration);
                }
                this.scriptOutput.append("var ");
            } else {
                this.scriptOutput.append("const ");
            }
        } else {
            this.scriptOutput.append("var ");
        }
        this.scriptOutput.append(this.fieldNamesRegistry.targetName(fieldDeclaration.binding));
        this.scriptOutput.append(": ");
        Util.appendTypeName(this.scriptOutput, fieldDeclaration.type.resolvedType, this.importRegistry.isAmbiguous(fieldDeclaration.type.resolvedType), true);
        if (fieldDeclaration.initialization == null) {
            switch (fieldDeclaration.binding.type.id) {
                case 7: 
                case 8: 
                case 9: {
                    this.scriptOutput.append(" = 0");
                }
            }
        } else if (!Util.containsThisReference(fieldDeclaration, methodScope)) {
            this.scriptOutput.append(" = ");
            fieldDeclaration.initialization.traverse((ASTVisitor)this, (BlockScope)methodScope);
        }
        this.scriptOutput.append(';').appendNewLine();
        return false;
    }

    public boolean visit(FieldReference fieldReference, BlockScope blockScope) {
        MethodBinding methodBinding;
        Util.mapLine(this, this.scriptOutput, (ASTNode)fieldReference);
        Expression expression = fieldReference.receiver;
        MethodBinding methodBinding2 = methodBinding = fieldReference.syntheticAccessors == null ? null : fieldReference.syntheticAccessors[0];
        if (fieldReference.fieldBinding().isStatic()) {
            if (!(this.generatingConstructor || expression == null || expression.isImplicitThis() || expression.isTypeReference())) {
                this.reportError((Scope)blockScope, "cannot handle receiver for static field access, should be eliminated", (ASTNode)fieldReference.receiver);
            }
            Util.appendTypeName(this.scriptOutput, (TypeBinding)fieldReference.binding.declaringClass, this.importRegistry.isAmbiguous((TypeBinding)fieldReference.binding.declaringClass));
            this.scriptOutput.append('.');
        } else if (methodBinding != null) {
            Util.appendTypeName(this.scriptOutput, (TypeBinding)fieldReference.binding.declaringClass, this.importRegistry.isAmbiguous((TypeBinding)fieldReference.binding.declaringClass));
            this.scriptOutput.append('.');
            this.scriptOutput.append(methodBinding.selector);
            this.scriptOutput.append('(');
            fieldReference.receiver.traverse((ASTVisitor)this, blockScope);
            this.scriptOutput.append(')');
        } else if (expression != null) {
            fieldReference.receiver.traverse((ASTVisitor)this, blockScope);
            this.scriptOutput.append('.');
        }
        if (methodBinding == null) {
            this.scriptOutput.append(this.fieldNamesRegistry.targetName(fieldReference.fieldBinding()));
        }
        return false;
    }

    public boolean visit(FloatLiteral floatLiteral, BlockScope blockScope) {
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)floatLiteral, blockScope);
        this.scriptOutput.append(floatLiteral.constant.doubleValue());
        Util.appendClosingParenthesis(this.scriptOutput, (Expression)floatLiteral, blockScope);
        return false;
    }

    public boolean visit(ForeachStatement foreachStatement, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)foreachStatement);
        if (foreachStatement != this.unIndentedStatement) {
            this.printIndent();
        }
        this.scriptOutput.append("for (");
        Expression expression = foreachStatement.collection;
        boolean bl = expression.resolvedType.isArrayType();
        if (bl) {
            this.scriptOutput.append("var ");
            this.scriptOutput.append(this.localNamesRegistry.targetName(foreachStatement.indexVariable));
            this.scriptOutput.append(": ");
            Util.appendTypeName(this.scriptOutput, foreachStatement.indexVariable.type, this.importRegistry.isAmbiguous(foreachStatement.indexVariable.type));
            this.scriptOutput.append(" = 0, ");
            this.scriptOutput.append(this.localNamesRegistry.targetName(foreachStatement.maxVariable));
            this.scriptOutput.append(": ");
            Util.appendTypeName(this.scriptOutput, foreachStatement.maxVariable.type, this.importRegistry.isAmbiguous(foreachStatement.maxVariable.type));
            this.scriptOutput.append(" = ");
            this.visitAsExpression((Statement)expression, blockScope);
            this.scriptOutput.append(".length");
            this.scriptOutput.append("; ");
            this.scriptOutput.append(this.localNamesRegistry.targetName(foreachStatement.indexVariable));
            this.scriptOutput.append(" < ");
            this.scriptOutput.append(this.localNamesRegistry.targetName(foreachStatement.maxVariable));
            this.scriptOutput.append("; ");
            this.scriptOutput.append(this.localNamesRegistry.targetName(foreachStatement.indexVariable));
            this.scriptOutput.append("++)");
        } else {
            blockScope.environment().getType(TypeConstants.JAVA_UTIL_ITERATOR);
            this.scriptOutput.append("var ");
            this.scriptOutput.append(this.localNamesRegistry.targetName(foreachStatement.indexVariable));
            this.scriptOutput.append(": ");
            Util.appendTypeName(this.scriptOutput, foreachStatement.indexVariable.type, this.importRegistry.isAmbiguous(foreachStatement.indexVariable.type));
            this.scriptOutput.append(" = ");
            this.visitAsExpression((Statement)expression, blockScope);
            this.scriptOutput.append(".iterator__(); ");
            this.scriptOutput.append(this.localNamesRegistry.targetName(foreachStatement.indexVariable));
            this.scriptOutput.append(".hasNext__(); )");
        }
        Statement statement = foreachStatement.action;
        boolean bl2 = statement instanceof Block;
        this.scriptOutput.append(" {").appendNewLine();
        this.indent();
        this.printIndent();
        this.visitAsExpression((Statement)foreachStatement.elementVariable, blockScope);
        this.scriptOutput.append('=');
        if (bl) {
            this.visitAsExpression((Statement)expression, blockScope);
            this.scriptOutput.append('[');
            this.scriptOutput.append(this.localNamesRegistry.targetName(foreachStatement.indexVariable));
            this.scriptOutput.append("];").appendNewLine();
        } else {
            Util.appendTypeName(this.scriptOutput, foreachStatement.elementVariable.type.resolvedType, this.importRegistry.isAmbiguous(foreachStatement.elementVariable.type.resolvedType));
            this.scriptOutput.append('(');
            this.scriptOutput.append(this.localNamesRegistry.targetName(foreachStatement.indexVariable));
            this.scriptOutput.append(".next__());").appendNewLine();
        }
        if (bl2) {
            Statement[] statementArray = ((Block)statement).statements;
            int n = 0;
            int n2 = statementArray == null ? 0 : statementArray.length;
            while (n < n2) {
                this.visitAsStatement(statementArray[n], blockScope);
                this.scriptOutput.appendNewLine();
                ++n;
            }
        } else {
            this.visitAsStatement(statement, blockScope);
            this.scriptOutput.appendNewLine();
        }
        this.outdent();
        this.printIndent();
        this.scriptOutput.append('}');
        return false;
    }

    public boolean visit(ForStatement forStatement, BlockScope blockScope) {
        int n;
        Util.mapLine(this, this.scriptOutput, (ASTNode)forStatement);
        if (forStatement != this.unIndentedStatement) {
            this.printIndent();
        }
        this.scriptOutput.append("for (");
        Statement[] statementArray = forStatement.initializations;
        if (statementArray != null) {
            this.localDeclarationForStatus = 0;
            int n2 = 0;
            int n3 = statementArray.length;
            while (n2 < n3) {
                if (n2 > 0) {
                    this.scriptOutput.append(", ");
                }
                this.visitAsExpression(statementArray[n2], blockScope);
                this.localDeclarationForStatus = 1;
                ++n2;
            }
            this.localDeclarationForStatus = -1;
        }
        this.scriptOutput.append(';');
        Expression expression = forStatement.condition;
        if (expression != null) {
            this.scriptOutput.append(' ');
            expression.traverse((ASTVisitor)this, blockScope);
        }
        this.scriptOutput.append(';');
        Statement[] statementArray2 = forStatement.increments;
        if (statementArray2 != null) {
            this.scriptOutput.append(' ');
            int n4 = 0;
            n = statementArray2.length;
            while (n4 < n) {
                if (n4 > 0) {
                    this.scriptOutput.append(", ");
                }
                this.visitAsExpression(statementArray2[n4], blockScope);
                ++n4;
            }
        }
        this.scriptOutput.append(')');
        Statement statement = forStatement.action;
        n = statement instanceof Block;
        if (n != 0) {
            this.scriptOutput.append(' ');
            this.unIndentedStatement = statement;
            this.visitAsStatement(statement, blockScope);
        } else {
            this.scriptOutput.appendNewLine();
            this.indent();
            this.visitAsStatement(statement, blockScope);
            this.outdent();
        }
        return false;
    }

    public boolean visit(IfStatement ifStatement, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)ifStatement);
        Statement statement = ifStatement.thenStatement;
        boolean bl = statement instanceof Block;
        Statement statement2 = ifStatement.elseStatement;
        if (ifStatement.condition.constant != Constant.NotAConstant) {
            if (Util.isUnreachable((ASTNode)statement)) {
                if (statement2 != null && !Util.isUnreachable((ASTNode)statement2)) {
                    if (statement2 instanceof IfStatement || statement2 instanceof Block) {
                        if (ifStatement != this.unIndentedStatement) {
                            this.printIndent();
                        }
                        this.unIndentedStatement = statement2;
                        this.visitAsStatement(statement2, blockScope);
                    } else {
                        this.visitAsStatement(statement2, blockScope);
                    }
                }
            } else if (bl) {
                if (ifStatement != this.unIndentedStatement) {
                    this.printIndent();
                }
                this.unIndentedStatement = statement;
                this.visitAsStatement(statement, blockScope);
            } else {
                this.visitAsStatement(statement, blockScope);
            }
            return false;
        }
        if (ifStatement != this.unIndentedStatement) {
            this.printIndent();
        }
        this.scriptOutput.append("if (");
        ifStatement.condition.traverse((ASTVisitor)this, blockScope);
        this.scriptOutput.append(")");
        if (bl) {
            this.scriptOutput.append(' ');
            this.visitAsExpression(statement, blockScope);
        } else {
            this.scriptOutput.appendNewLine();
            this.indent();
            this.visitAsStatement(statement, blockScope);
            this.outdent();
        }
        if (statement2 != null) {
            if (bl) {
                this.scriptOutput.append(' ');
            } else {
                this.scriptOutput.appendNewLine();
                this.printIndent();
            }
            this.scriptOutput.append("else");
            if (statement2 instanceof IfStatement || statement2 instanceof Block) {
                this.scriptOutput.append(' ');
                this.unIndentedStatement = statement2;
                this.visitAsStatement(statement2, blockScope);
            } else {
                this.scriptOutput.appendNewLine();
                this.indent();
                this.visitAsStatement(statement2, blockScope);
                this.outdent();
            }
        }
        return false;
    }

    public boolean visit(ImportReference importReference, CompilationUnitScope compilationUnitScope) {
        return false;
    }

    public boolean visit(Initializer initializer, MethodScope methodScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)initializer);
        initializer.block.traverse((ASTVisitor)this, (BlockScope)methodScope);
        this.scriptOutput.appendNewLine();
        return false;
    }

    public boolean visit(InstanceOfExpression instanceOfExpression, BlockScope blockScope) {
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)instanceOfExpression, blockScope);
        instanceOfExpression.expression.traverse((ASTVisitor)this, blockScope);
        this.scriptOutput.append(" is ");
        TypeBinding typeBinding = instanceOfExpression.type.resolvedType;
        Util.appendTypeName(this.scriptOutput, typeBinding, this.importRegistry.isAmbiguous(typeBinding));
        Util.appendClosingParenthesis(this.scriptOutput, (Expression)instanceOfExpression, blockScope);
        return false;
    }

    public boolean visit(IntLiteral intLiteral, BlockScope blockScope) {
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)intLiteral, blockScope);
        this.scriptOutput.append(intLiteral.source());
        Util.appendClosingParenthesis(this.scriptOutput, (Expression)intLiteral, blockScope);
        return false;
    }

    public boolean visit(LabeledStatement labeledStatement, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)labeledStatement);
        if (labeledStatement != this.unIndentedStatement) {
            this.printIndent();
        }
        this.scriptOutput.append(labeledStatement.label).append(':');
        Statement statement = labeledStatement.statement;
        if (statement instanceof Block || statement instanceof WhileStatement || statement instanceof ForStatement || statement instanceof SwitchStatement || statement instanceof DoStatement) {
            this.scriptOutput.append(' ');
            this.unIndentedStatement = statement;
            this.visitAsStatement(statement, blockScope);
        } else {
            this.scriptOutput.appendNewLine();
            this.indent();
            this.visitAsStatement(statement, blockScope);
            this.outdent();
        }
        return false;
    }

    public boolean visit(LocalDeclaration localDeclaration, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)localDeclaration);
        if (this.localDeclarationForStatus != 1) {
            this.scriptOutput.append("var ");
        }
        this.scriptOutput.append(this.localNamesRegistry.targetName(localDeclaration.binding));
        this.scriptOutput.append(": ");
        Util.appendTypeName(this.scriptOutput, localDeclaration.type.resolvedType, this.importRegistry.isAmbiguous(localDeclaration.type.resolvedType));
        if (localDeclaration.initialization == null) {
            switch (localDeclaration.binding.type.id) {
                case 7: 
                case 8: 
                case 9: {
                    this.scriptOutput.append(" = 0");
                }
            }
        } else {
            this.scriptOutput.append(" = ");
            localDeclaration.initialization.traverse((ASTVisitor)this, blockScope);
        }
        return false;
    }

    public boolean visit(LongLiteral longLiteral, BlockScope blockScope) {
        long l = longLiteral.constant.longValue();
        if (l < -9007199254740992L) {
            this.reportWarning((Scope)blockScope, "long literal underflow", (ASTNode)longLiteral);
        } else if (l > 0x20000000000000L) {
            this.reportWarning((Scope)blockScope, "long literal overflow", (ASTNode)longLiteral);
        }
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)longLiteral, blockScope);
        this.scriptOutput.append(l);
        Util.appendClosingParenthesis(this.scriptOutput, (Expression)longLiteral, blockScope);
        return false;
    }

    public boolean visit(MessageSend messageSend, BlockScope blockScope) {
        Object object;
        boolean bl;
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)messageSend, blockScope);
        Expression expression = messageSend.receiver;
        MethodBinding methodBinding = messageSend.binding;
        ReferenceBinding referenceBinding = methodBinding.declaringClass;
        boolean bl2 = referenceBinding.id == 11 || referenceBinding.id == 1 || referenceBinding.isInterface() && blockScope.getJavaLangObject().getExactMethod(methodBinding.selector, methodBinding.parameters, null) != null;
        boolean bl3 = bl = methodBinding instanceof ParameterizedMethodBinding && messageSend.resolvedType.id != 6 && !methodBinding.original().returnType.isBaseType() && (methodBinding.original().returnType.isTypeVariable() || methodBinding.getHighestOverridenMethod((LookupEnvironment)blockScope.environment()).original().returnType != methodBinding.original().returnType);
        if (bl) {
            object = null;
            object = Util.getTypeName(messageSend.resolvedType, this.importRegistry.isAmbiguous(messageSend.resolvedType), false);
            if (CharOperation.equals((char[])object, (char[])TypeConstants.OBJECT)) {
                bl = false;
            } else {
                this.scriptOutput.append((char[])object);
                this.scriptOutput.append('(');
            }
        }
        if (bl2) {
            this.scriptOutput.append("Object(");
        }
        if (messageSend.syntheticAccessor != null) {
            if (expression.isSuper()) {
                expression.traverse((ASTVisitor)this, blockScope);
            } else {
                Util.appendTypeName(this.scriptOutput, (TypeBinding)referenceBinding, this.importRegistry.isAmbiguous((TypeBinding)referenceBinding));
            }
            this.scriptOutput.append('.');
        } else if (expression.isSuper()) {
            if (referenceBinding.id == 1) {
                this.scriptOutput.append("Object.prototype");
            } else {
                this.scriptOutput.append("super");
            }
            if (bl2) {
                this.scriptOutput.append(")");
            }
            this.scriptOutput.append('.');
        } else if (methodBinding.isStatic()) {
            if (expression != null && !expression.isImplicitThis() && !expression.isTypeReference()) {
                this.reportError((Scope)blockScope, "cannot handle receiver for static method invocation, should be eliminated", (ASTNode)expression);
            }
            if ((object = (Object)blockScope.classScope().referenceContext.binding) != referenceBinding || !blockScope.methodScope().isStatic) {
                Util.appendTypeName(this.scriptOutput, (TypeBinding)referenceBinding, this.importRegistry.isAmbiguous((TypeBinding)referenceBinding));
                if (bl2) {
                    this.scriptOutput.append(")");
                }
                this.scriptOutput.append('.');
            }
        } else {
            if (expression.isThis() && expression.resolvedType.enclosingType() != null && referenceBinding != expression.resolvedType) {
                this.generateOuterAccess(blockScope.getEmulationPath(referenceBinding, false, false));
            } else {
                expression.traverse((ASTVisitor)this, blockScope);
            }
            if (bl2) {
                this.scriptOutput.append(")");
            }
            this.scriptOutput.append('.');
        }
        if (messageSend.syntheticAccessor != null) {
            this.scriptOutput.append(messageSend.syntheticAccessor.selector);
        } else {
            switch (Util.checkIntrinsic(methodBinding)) {
                case 0: {
                    Util.appendMethodName(this.scriptOutput, methodBinding, true, this.generatingConstructor);
                    break;
                }
                case 1: {
                    if (methodBinding instanceof SyntheticMethodBinding) {
                        this.scriptOutput.append(methodBinding.selector);
                        break;
                    }
                    Util.appendMethodName(this.scriptOutput, methodBinding, false, this.generatingConstructor);
                    break;
                }
                case 2: {
                    this.reportError((Scope)blockScope, "conflicting intrinsic/non intrinsic declarations for method " + new String(methodBinding.readableName()) + " in superinterfaces", (ASTNode)messageSend);
                }
            }
        }
        if (expression.isSuper() && referenceBinding.id == 1) {
            this.scriptOutput.append(".call(this");
            if (messageSend.arguments != null && messageSend.arguments.length > 0) {
                this.scriptOutput.append(", ");
            }
        } else {
            this.scriptOutput.append('(');
        }
        boolean bl4 = false;
        if (messageSend.syntheticAccessor != null && !methodBinding.isStatic() && !expression.isSuper()) {
            if (expression.isThis() && expression.resolvedType.enclosingType() != null && referenceBinding != expression.resolvedType) {
                this.generateOuterAccess(blockScope.getEmulationPath(referenceBinding, false, false));
            } else {
                expression.traverse((ASTVisitor)this, blockScope);
            }
            bl4 = true;
        }
        if (messageSend.arguments != null) {
            if (bl4) {
                this.scriptOutput.append(", ");
            }
            messageSend.arguments[0].traverse((ASTVisitor)this, blockScope);
            int n = 1;
            int n2 = messageSend.arguments.length;
            while (n < n2) {
                this.scriptOutput.append(", ");
                messageSend.arguments[n].traverse((ASTVisitor)this, blockScope);
                ++n;
            }
        }
        this.scriptOutput.append(')');
        if (bl) {
            this.scriptOutput.append(')');
        }
        Util.appendClosingParenthesis(this.scriptOutput, (Expression)messageSend, blockScope);
        return false;
    }

    public boolean visit(MethodDeclaration methodDeclaration, ClassScope classScope) {
        if (methodDeclaration.ignoreFurtherInvestigation) {
            return false;
        }
        if (methodDeclaration.binding == null) {
            return false;
        }
        if (this.generatingInterfaceFields) {
            return false;
        }
        this.setLineNumberBounds((AbstractMethodDeclaration)methodDeclaration);
        this.localNamesRegistries.push(this.localNamesRegistry);
        this.localNamesRegistry = LocalNamesRegistry.newInstance((AbstractMethodDeclaration)methodDeclaration, this.compilationUnitLocalNamesRegistry);
        this.appendMethod((AbstractMethodDeclaration)methodDeclaration, classScope);
        MethodBinding methodBinding = methodDeclaration.binding;
        if (!methodBinding.isNative() && !methodBinding.isAbstract() && (methodDeclaration.modifiers & 0x1000000) == 0) {
            this.scriptOutput.append(" {").appendNewLine();
            this.indent();
            if (methodDeclaration.statements != null) {
                int n = methodDeclaration.statements.length;
                int n2 = 0;
                while (n2 < n) {
                    Statement statement = methodDeclaration.statements[n2];
                    if (Util.isUnreachable((ASTNode)statement)) break;
                    this.visitAsStatement(statement, (BlockScope)methodDeclaration.scope);
                    if (!(statement instanceof TypeDeclaration)) {
                        this.scriptOutput.appendNewLine();
                    }
                    ++n2;
                }
                if (!(this.lastStatement instanceof ReturnStatement)) {
                    this.printIndent();
                    this.scriptOutput.append("return");
                    switch (methodDeclaration.binding.returnType.id) {
                        case 6: {
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: {
                            this.scriptOutput.append(" 0");
                            break;
                        }
                        case 5: {
                            this.scriptOutput.append(" false");
                            break;
                        }
                        default: {
                            this.scriptOutput.append(" null");
                        }
                    }
                    this.scriptOutput.append(';').appendNewLine();
                }
            }
            this.outdent();
            this.printIndent();
            this.scriptOutput.append('}').appendNewLine();
        }
        this.localNamesRegistry = (LocalNamesRegistry)this.localNamesRegistries.pop();
        return false;
    }

    private void setLineNumberBounds(AbstractMethodDeclaration abstractMethodDeclaration) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)abstractMethodDeclaration, 1, this.lineSeparators == null ? 1 : this.lineSeparators.length);
        if (this.lineSeparators != null) {
            int n = this.lineSeparators.length;
            int n2 = n - 1;
            if (abstractMethodDeclaration.isClinit() || abstractMethodDeclaration.isConstructor()) {
                this.lineNumberStart = 1;
                this.lineNumberEnd = n == 0 ? 1 : n;
            } else {
                int n3;
                this.lineNumberStart = n3 = org.eclipse.jdt.internal.compiler.util.Util.getLineNumber((int)abstractMethodDeclaration.bodyStart, (int[])this.lineSeparators, (int)0, (int)n2);
                if (n3 > n2) {
                    this.lineNumberEnd = n3;
                } else {
                    int n4 = org.eclipse.jdt.internal.compiler.util.Util.getLineNumber((int)abstractMethodDeclaration.bodyEnd, (int[])this.lineSeparators, (int)(n3 - 1), (int)n2);
                    if (n4 >= n2) {
                        n4 = n;
                    }
                    this.lineNumberEnd = n4 == 0 ? 1 : n4;
                }
            }
        }
    }

    public boolean visit(NullLiteral nullLiteral, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)nullLiteral);
        this.scriptOutput.append("null");
        return false;
    }

    public boolean visit(OR_OR_Expression oR_OR_Expression, BlockScope blockScope) {
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)oR_OR_Expression, blockScope);
        oR_OR_Expression.left.traverse((ASTVisitor)this, blockScope);
        this.scriptOutput.append(' ').append(oR_OR_Expression.operatorToString()).append(' ');
        oR_OR_Expression.right.traverse((ASTVisitor)this, blockScope);
        Util.appendClosingParenthesis(this.scriptOutput, (Expression)oR_OR_Expression, blockScope);
        return false;
    }

    public boolean visit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, BlockScope blockScope) {
        Util.appendTypeName(this.scriptOutput, parameterizedQualifiedTypeReference.resolvedType, this.importRegistry.isAmbiguous(parameterizedQualifiedTypeReference.resolvedType));
        return false;
    }

    public boolean visit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, ClassScope classScope) {
        Util.appendTypeName(this.scriptOutput, parameterizedQualifiedTypeReference.resolvedType, this.importRegistry.isAmbiguous(parameterizedQualifiedTypeReference.resolvedType));
        return false;
    }

    public boolean visit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, BlockScope blockScope) {
        Util.appendTypeName(this.scriptOutput, parameterizedSingleTypeReference.resolvedType, this.importRegistry.isAmbiguous(parameterizedSingleTypeReference.resolvedType));
        return false;
    }

    public boolean visit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, ClassScope classScope) {
        Util.appendTypeName(this.scriptOutput, parameterizedSingleTypeReference.resolvedType, this.importRegistry.isAmbiguous(parameterizedSingleTypeReference.resolvedType));
        return false;
    }

    public boolean visit(PostfixExpression postfixExpression, BlockScope blockScope) {
        if (Util.isUnBoxing((Expression)postfixExpression) || Util.isUnBoxing(postfixExpression.lhs)) {
            int n = (postfixExpression.bits & 0x1FE00000) >> 21;
            int n2 = 0;
            while (n2 < n) {
                this.scriptOutput.append('(');
                ++n2;
            }
            TypeBinding typeBinding = blockScope.environment().computeBoxingType(postfixExpression.resolvedType);
            MethodBinding methodBinding = Util.retrieveConstructor(typeBinding, (ReferenceBinding)postfixExpression.resolvedType);
            if (methodBinding == null) {
                return false;
            }
            Util.dumpWrapperType(this.scriptOutput, postfixExpression.resolvedType, methodBinding);
            postfixExpression.lhs.traverse((ASTVisitor)this, blockScope);
            switch (postfixExpression.operator) {
                case 14: {
                    this.scriptOutput.append('+');
                    break;
                }
                case 13: {
                    this.scriptOutput.append('-');
                }
            }
            this.scriptOutput.append('1');
            this.scriptOutput.append("]))");
            Util.appendClosingParenthesis(this.scriptOutput, (Expression)postfixExpression, blockScope);
        } else {
            Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)postfixExpression, blockScope);
            postfixExpression.lhs.traverse((ASTVisitor)this, blockScope);
            this.scriptOutput.append(postfixExpression.operatorToString());
            Util.appendClosingParenthesis(this.scriptOutput, (Expression)postfixExpression, blockScope);
        }
        return false;
    }

    public boolean visit(PrefixExpression prefixExpression, BlockScope blockScope) {
        if (Util.isUnBoxing((Expression)prefixExpression)) {
            TypeBinding typeBinding = blockScope.environment().computeBoxingType(prefixExpression.resolvedType);
            MethodBinding methodBinding = Util.retrieveConstructor(typeBinding, (ReferenceBinding)prefixExpression.resolvedType);
            if (methodBinding == null) {
                return false;
            }
            Util.dumpWrapperType(this.scriptOutput, prefixExpression.resolvedType, methodBinding);
            prefixExpression.lhs.traverse((ASTVisitor)this, blockScope);
            switch (prefixExpression.operator) {
                case 14: {
                    this.scriptOutput.append('+');
                    break;
                }
                case 13: {
                    this.scriptOutput.append('-');
                }
            }
            this.scriptOutput.append('1');
            this.scriptOutput.append("]))");
            Util.appendClosingParenthesis(this.scriptOutput, (Expression)prefixExpression, blockScope);
        } else {
            Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)prefixExpression, blockScope);
            this.scriptOutput.append(prefixExpression.operatorToString());
            prefixExpression.lhs.traverse((ASTVisitor)this, blockScope);
            Util.appendClosingParenthesis(this.scriptOutput, (Expression)prefixExpression, blockScope);
        }
        return false;
    }

    public boolean visit(QualifiedAllocationExpression qualifiedAllocationExpression, BlockScope blockScope) {
        int n;
        if (qualifiedAllocationExpression.anonymousType != null) {
            this.visit(qualifiedAllocationExpression.anonymousType, blockScope.compilationUnitScope());
        }
        if (qualifiedAllocationExpression.enclosingInstance == null || qualifiedAllocationExpression.enclosingInstance.isThis()) {
            return this.visit((AllocationExpression)qualifiedAllocationExpression, blockScope);
        }
        ReferenceBinding referenceBinding = qualifiedAllocationExpression.binding.declaringClass;
        boolean bl = false;
        boolean bl2 = false;
        this.scriptOutput.append("new ");
        Util.appendTypeName(this.scriptOutput, (TypeBinding)referenceBinding, this.importRegistry.isAmbiguous((TypeBinding)referenceBinding));
        this.scriptOutput.append('(');
        qualifiedAllocationExpression.enclosingInstance.traverse((ASTVisitor)this, blockScope);
        SyntheticArgumentBinding[] syntheticArgumentBindingArray = referenceBinding.syntheticOuterLocalVariables();
        if (syntheticArgumentBindingArray != null) {
            Object[] objectArray = blockScope.getEmulationPath(syntheticArgumentBindingArray[0].actualOuterLocalVariable);
            if (objectArray.length > 0) {
                this.generateOuterAccess(objectArray);
                bl = true;
            }
            n = 1;
            int n2 = syntheticArgumentBindingArray.length;
            while (n < n2) {
                if (bl) {
                    this.scriptOutput.append(", ");
                } else {
                    bl = true;
                }
                this.generateOuterAccess(blockScope.getEmulationPath(syntheticArgumentBindingArray[n].actualOuterLocalVariable));
                ++n;
            }
        }
        if (qualifiedAllocationExpression.arguments != null) {
            int n3 = 0;
            n = qualifiedAllocationExpression.arguments.length;
            while (n3 < n) {
                if (bl) {
                    this.scriptOutput.append(", ");
                } else {
                    bl = true;
                }
                qualifiedAllocationExpression.arguments[n3].traverse((ASTVisitor)this, blockScope);
                ++n3;
            }
        }
        this.scriptOutput.append(')');
        if (bl2) {
            this.scriptOutput.append(')');
        }
        return false;
    }

    public boolean visit(QualifiedNameReference qualifiedNameReference, BlockScope blockScope) {
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)qualifiedNameReference, blockScope);
        try {
            boolean bl;
            char[][] cArray = Util.split(qualifiedNameReference.actualReceiverType.qualifiedPackageName(), '.');
            boolean bl2 = Util.shouldFullyQualified(qualifiedNameReference);
            int n = qualifiedNameReference.binding.kind();
            boolean bl3 = bl = n == 1 || n == 2;
            if (!bl) {
                Util.appendTypeName(this.scriptOutput, qualifiedNameReference.actualReceiverType, bl2);
            }
            if (bl) {
                Constant constant = ((VariableBinding)qualifiedNameReference.binding).constant();
                if (constant != Constant.NotAConstant && !Util.isIntrinsic(cArray)) {
                    String string = Util.appendConstant(this.scriptOutput, constant);
                    if (string != null) {
                        this.reportWarning((Scope)blockScope, "SHOULD BE ERROR - " + string, (ASTNode)qualifiedNameReference);
                    }
                    return false;
                }
                if (qualifiedNameReference.binding.kind() == 2) {
                    if ((qualifiedNameReference.bits & 0x1FE0) != 0) {
                        this.generateOuterAccess(blockScope.getEmulationPath((LocalVariableBinding)qualifiedNameReference.binding));
                    } else {
                        this.scriptOutput.append(this.localNamesRegistry.targetName((LocalVariableBinding)qualifiedNameReference.binding));
                    }
                } else {
                    SyntheticMethodBinding syntheticMethodBinding;
                    SyntheticMethodBinding syntheticMethodBinding2 = syntheticMethodBinding = qualifiedNameReference.syntheticReadAccessors == null ? null : qualifiedNameReference.syntheticReadAccessors[0];
                    if (syntheticMethodBinding != null) {
                        Util.appendTypeName(this.scriptOutput, qualifiedNameReference.actualReceiverType, bl2);
                        this.scriptOutput.append('.');
                        this.scriptOutput.append(syntheticMethodBinding.selector);
                        this.scriptOutput.append('(');
                        this.generateOuterAccess(blockScope.getEmulationPath(qualifiedNameReference.fieldBinding().original().declaringClass, false, false));
                        this.scriptOutput.append(')');
                    } else {
                        if ((qualifiedNameReference.bits & 0x1FE0) != 0) {
                            if (((FieldBinding)qualifiedNameReference.binding).isStatic()) {
                                Util.appendTypeName(this.scriptOutput, qualifiedNameReference.actualReceiverType, true);
                            } else {
                                this.generateOuterAccess(blockScope.getEmulationPath(qualifiedNameReference.fieldBinding().original().declaringClass, false, false));
                            }
                            this.scriptOutput.append('.');
                        } else if (qualifiedNameReference.indexOfFirstFieldBinding > 1) {
                            if (qualifiedNameReference.actualReceiverType.isInterface()) {
                                Util.appendTypeName(this.scriptOutput, qualifiedNameReference.actualReceiverType, true);
                                this.scriptOutput.append(INTERFACE_FIELDS);
                            } else {
                                Util.appendTypeName(this.scriptOutput, qualifiedNameReference.actualReceiverType, bl2);
                            }
                            this.scriptOutput.append('.');
                        }
                        this.scriptOutput.append(this.fieldNamesRegistry.targetName((FieldBinding)qualifiedNameReference.binding));
                    }
                }
                if (qualifiedNameReference.otherBindings != null) {
                    int n2 = 0;
                    int n3 = qualifiedNameReference.otherBindings.length;
                    while (n2 < n3) {
                        this.scriptOutput.append('.');
                        this.scriptOutput.append(qualifiedNameReference.otherBindings[n2].shortReadableName());
                        ++n2;
                    }
                }
            }
        }
        finally {
            Util.appendClosingParenthesis(this.scriptOutput, (Expression)qualifiedNameReference, blockScope);
        }
        return false;
    }

    public boolean visit(QualifiedSuperReference qualifiedSuperReference, BlockScope blockScope) {
        this.generateOuterAccess(blockScope.getEmulationPath((ReferenceBinding)qualifiedSuperReference.resolvedType, false, false));
        return false;
    }

    public boolean visit(QualifiedThisReference qualifiedThisReference, BlockScope blockScope) {
        this.generateOuterAccess(blockScope.getEmulationPath((ReferenceBinding)qualifiedThisReference.resolvedType, false, false));
        return false;
    }

    public boolean visit(QualifiedTypeReference qualifiedTypeReference, BlockScope blockScope) {
        Util.appendTypeName(this.scriptOutput, qualifiedTypeReference.resolvedType, this.importRegistry.isAmbiguous(qualifiedTypeReference.resolvedType));
        return false;
    }

    public boolean visit(QualifiedTypeReference qualifiedTypeReference, ClassScope classScope) {
        Util.appendTypeName(this.scriptOutput, qualifiedTypeReference.resolvedType, this.importRegistry.isAmbiguous(qualifiedTypeReference.resolvedType));
        return false;
    }

    public boolean visit(ReturnStatement returnStatement, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)returnStatement);
        if (returnStatement != this.unIndentedStatement) {
            this.printIndent();
        }
        if (returnStatement.expression == null) {
            AbstractMethodDeclaration abstractMethodDeclaration = blockScope.methodScope().referenceMethod();
            if (abstractMethodDeclaration.isConstructor() && !this.generatingConstructor) {
                this.scriptOutput.append("return this;");
            } else {
                this.scriptOutput.append("return;");
            }
        } else {
            this.scriptOutput.append("return ");
            returnStatement.expression.traverse((ASTVisitor)this, blockScope);
            this.scriptOutput.append(';');
        }
        this.lastStatement = returnStatement;
        return false;
    }

    public boolean visit(SingleNameReference singleNameReference, BlockScope blockScope) {
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)singleNameReference, blockScope);
        try {
            if (singleNameReference.constant != Constant.NotAConstant) {
                String string = Util.appendConstant(this.scriptOutput, singleNameReference.constant);
                if (string != null) {
                    this.reportWarning((Scope)blockScope, "SHOULD BE ERROR - " + string, (ASTNode)singleNameReference);
                }
                return false;
            }
            switch (singleNameReference.binding.kind()) {
                case 1: {
                    MethodBinding methodBinding;
                    FieldBinding fieldBinding = singleNameReference.fieldBinding().original();
                    if (fieldBinding.declaringClass.isInterface()) {
                        Util.appendTypeName(this.scriptOutput, (TypeBinding)fieldBinding.declaringClass, true);
                        this.scriptOutput.append(INTERFACE_FIELDS);
                        this.scriptOutput.append('.');
                        this.scriptOutput.append(this.fieldNamesRegistry.targetName(fieldBinding));
                        return false;
                    }
                    fieldBinding = singleNameReference.fieldBinding().original();
                    if (fieldBinding.isStatic()) {
                        MethodBinding methodBinding2;
                        MethodBinding methodBinding3 = methodBinding2 = singleNameReference.syntheticAccessors == null ? null : singleNameReference.syntheticAccessors[0];
                        if (methodBinding2 == null) {
                            if ((singleNameReference.bits & 0x1FE0) != 0) {
                                Util.appendTypeName(this.scriptOutput, (TypeBinding)fieldBinding.declaringClass, true);
                                this.scriptOutput.append('.');
                            } else if (fieldBinding.declaringClass != blockScope.referenceType().binding) {
                                Util.appendTypeName(this.scriptOutput, (TypeBinding)fieldBinding.declaringClass, this.importRegistry.isAmbiguous((TypeBinding)fieldBinding.declaringClass));
                                this.scriptOutput.append('.');
                            }
                            this.scriptOutput.append(this.fieldNamesRegistry.targetName(fieldBinding));
                            break;
                        }
                        ReferenceBinding referenceBinding = methodBinding2.declaringClass;
                        Util.appendTypeName(this.scriptOutput, (TypeBinding)referenceBinding, this.importRegistry.isAmbiguous((TypeBinding)referenceBinding));
                        this.scriptOutput.append('.');
                        this.scriptOutput.append(methodBinding2.selector);
                        this.scriptOutput.append("()");
                        break;
                    }
                    MethodBinding methodBinding4 = methodBinding = singleNameReference.syntheticAccessors == null ? null : singleNameReference.syntheticAccessors[0];
                    if ((singleNameReference.bits & 0x1FE0) != 0) {
                        if (methodBinding != null) {
                            ReferenceBinding referenceBinding = methodBinding.declaringClass;
                            Util.appendTypeName(this.scriptOutput, (TypeBinding)referenceBinding, this.importRegistry.isAmbiguous((TypeBinding)referenceBinding));
                            this.scriptOutput.append('.');
                            this.scriptOutput.append(methodBinding.selector);
                            this.scriptOutput.append('(');
                        }
                        this.generateOuterAccess(blockScope.getEmulationPath(singleNameReference.fieldBinding().original().declaringClass, false, false));
                        if (methodBinding == null) {
                            this.scriptOutput.append('.');
                        } else {
                            this.scriptOutput.append(')');
                        }
                    }
                    if (methodBinding == null) {
                        this.scriptOutput.append(this.fieldNamesRegistry.targetName(fieldBinding));
                    }
                    break;
                }
                case 2: {
                    if ((singleNameReference.bits & 0x1FE0) != 0) {
                        this.generateOuterAccess(blockScope.getEmulationPath(singleNameReference.localVariableBinding()));
                        break;
                    }
                    this.scriptOutput.append(this.localNamesRegistry.targetName((LocalVariableBinding)singleNameReference.binding));
                }
            }
        }
        finally {
            Util.appendClosingParenthesis(this.scriptOutput, (Expression)singleNameReference, blockScope);
        }
        return false;
    }

    public boolean visit(SingleTypeReference singleTypeReference, BlockScope blockScope) {
        Util.appendTypeName(this.scriptOutput, singleTypeReference.resolvedType, this.importRegistry.isAmbiguous(singleTypeReference.resolvedType));
        return false;
    }

    public boolean visit(SingleTypeReference singleTypeReference, ClassScope classScope) {
        Util.appendTypeName(this.scriptOutput, singleTypeReference.resolvedType, this.importRegistry.isAmbiguous(singleTypeReference.resolvedType));
        return false;
    }

    public boolean visit(StringLiteral stringLiteral, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)stringLiteral);
        if (stringLiteral.constant == null) {
            stringLiteral.computeConstant();
        }
        Util.appendString(this.scriptOutput, stringLiteral.constant.stringValue());
        return false;
    }

    public boolean visit(SwitchStatement switchStatement, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)switchStatement);
        if (switchStatement != this.unIndentedStatement) {
            this.printIndent();
        }
        this.scriptOutput.append("switch (");
        Expression expression = switchStatement.expression;
        expression.traverse((ASTVisitor)this, blockScope);
        if (expression.resolvedType.isEnum()) {
            this.scriptOutput.append(".ordinal__()");
        }
        this.scriptOutput.append(") {").appendNewLine();
        Statement[] statementArray = switchStatement.statements;
        int n = 0;
        int n2 = switchStatement.caseCount;
        int n3 = 0;
        int n4 = statementArray == null ? 0 : statementArray.length;
        while (n3 < n4) {
            Statement statement = statementArray[n3];
            if (Util.isUnreachable((ASTNode)statement)) break;
            if (n < n2 && statement == switchStatement.cases[n] || statement == switchStatement.defaultCase) {
                ++n;
                this.indent();
                this.visitAsStatement(statement, switchStatement.scope);
                this.outdent();
            } else {
                this.indent();
                this.indent();
                this.visitAsStatement(statement, switchStatement.scope);
                this.outdent();
                this.outdent();
            }
            this.scriptOutput.appendNewLine();
            ++n3;
        }
        this.printIndent();
        this.scriptOutput.append('}');
        return false;
    }

    public boolean visit(SynchronizedStatement synchronizedStatement, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)synchronizedStatement);
        synchronizedStatement.block.traverse((ASTVisitor)this, blockScope);
        return false;
    }

    public boolean visit(ThisReference thisReference, BlockScope blockScope) {
        this.scriptOutput.append("this");
        return false;
    }

    public boolean visit(ThrowStatement throwStatement, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)throwStatement);
        if (throwStatement != this.unIndentedStatement) {
            this.printIndent();
        }
        this.scriptOutput.append("throw ");
        throwStatement.exception.traverse((ASTVisitor)this, blockScope);
        this.scriptOutput.append(';');
        return false;
    }

    public boolean visit(TrueLiteral trueLiteral, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)trueLiteral);
        this.scriptOutput.append("true");
        return false;
    }

    public boolean visit(TryStatement tryStatement, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)tryStatement);
        if (tryStatement != this.unIndentedStatement) {
            this.printIndent();
        }
        this.scriptOutput.append("try");
        Block block = tryStatement.tryBlock;
        this.scriptOutput.append(' ');
        this.unIndentedStatement = block;
        this.visitAsExpression((Statement)block, blockScope);
        if (tryStatement.catchArguments != null) {
            int n = 0;
            int n2 = tryStatement.catchArguments.length;
            while (n < n2) {
                Argument argument = tryStatement.catchArguments[n];
                Block block2 = tryStatement.catchBlocks[n];
                this.scriptOutput.append(" catch (");
                this.scriptOutput.append(this.localNamesRegistry.targetName(argument.binding));
                this.scriptOutput.append(" : ");
                Util.appendTypeName(this.scriptOutput, argument.type.resolvedType, this.importRegistry.isAmbiguous(argument.type.resolvedType));
                this.scriptOutput.append(") ");
                this.unIndentedStatement = block2;
                this.visitAsExpression((Statement)block2, blockScope);
                ++n;
            }
        }
        if (tryStatement.finallyBlock != null) {
            this.scriptOutput.append(" finally ");
            this.unIndentedStatement = tryStatement.finallyBlock;
            this.visitAsStatement((Statement)tryStatement.finallyBlock, blockScope);
        }
        return false;
    }

    public boolean visit(TypeDeclaration typeDeclaration, BlockScope blockScope) {
        return this.visit(typeDeclaration, blockScope.enclosingClassScope());
    }

    public boolean visit(TypeDeclaration typeDeclaration, ClassScope classScope) {
        return this.visit(typeDeclaration, classScope.compilationUnitScope());
    }

    public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope compilationUnitScope) {
        if (typeDeclaration.ignoreFurtherInvestigation) {
            return false;
        }
        if (typeDeclaration.binding == null) {
            return false;
        }
        switch (typeDeclaration.binding.id) {
            case 1: 
            case 11: {
                return false;
            }
        }
        int n = 1;
        int n2 = TypeDeclaration.kind((int)typeDeclaration.modifiers);
        switch (n2) {
            case 2: {
                this.generatingInterfaceFields = true;
                ++n;
            }
            case 1: {
                break;
            }
            case 4: {
                return false;
            }
        }
        if (this.actionScriptSourceFile != null) {
            this.actionScriptSourceFiles.push(this.actionScriptSourceFile);
        }
        if (this.constructorGenerator != null) {
            this.constructorGenerators.push(this.constructorGenerator);
        }
        this.constructorGenerator = new ActionScriptConstructorGenerator(this);
        while (n-- > 0) {
            int n3;
            int n4;
            this.actionScriptSourceFile = new ActionScriptSourceFile(String.valueOf(Util.typeName((TypeBinding)typeDeclaration.binding, true).replace('.', File.separatorChar)) + (this.generatingInterfaceFields ? "$$fields.as" : ".as"), (ReferenceBinding)typeDeclaration.binding);
            this.scriptOutput = this.actionScriptSourceFile.actionScriptContents;
            this.scriptOutput.append("package ");
            if (this.currentPackage != null) {
                char[][] cArray = this.currentPackage.tokens;
                this.scriptOutput.append(cArray[0]);
                n4 = 1;
                n3 = cArray.length;
                while (n4 < n3) {
                    this.scriptOutput.append('.');
                    this.scriptOutput.append(cArray[n4]);
                    ++n4;
                }
                this.scriptOutput.append(' ');
            }
            this.scriptOutput.append("{").appendNewLine();
            this.flushImports(compilationUnitScope);
            Util.mapLine(this, this.scriptOutput, (ASTNode)typeDeclaration, 1, this.lineSeparators == null ? 1 : this.lineSeparators.length);
            if (n2 == 1) {
                this.scriptOutput.append("dynamic ");
            }
            this.scriptOutput.append("public ");
            if (n2 == 2 && !this.generatingInterfaceFields) {
                this.scriptOutput.append("interface ");
            } else {
                this.scriptOutput.append("class ");
            }
            Util.appendTypeName(this.scriptOutput, (TypeBinding)typeDeclaration.binding, false);
            if (this.generatingInterfaceFields) {
                this.scriptOutput.append(INTERFACE_FIELDS);
            } else {
                if (typeDeclaration.binding.superclass.id != 1) {
                    this.scriptOutput.append(" extends ");
                    Util.appendTypeName(this.scriptOutput, (TypeBinding)typeDeclaration.binding.superclass, this.importRegistry.isAmbiguous((TypeBinding)typeDeclaration.binding.superclass));
                }
                if (typeDeclaration.binding.superInterfaces != Binding.NO_SUPERINTERFACES) {
                    if (n2 == 2) {
                        this.scriptOutput.append(" extends ");
                    } else {
                        this.scriptOutput.append(" implements ");
                    }
                    int n5 = 0;
                    n4 = typeDeclaration.binding.superInterfaces.length;
                    while (n5 < n4) {
                        if (n5 > 0) {
                            this.scriptOutput.append(", ");
                        }
                        Util.appendTypeName(this.scriptOutput, (TypeBinding)typeDeclaration.binding.superInterfaces[n5], this.importRegistry.isAmbiguous((TypeBinding)typeDeclaration.binding.superInterfaces[n5]));
                        ++n5;
                    }
                }
            }
            this.scriptOutput.append(" {").appendNewLine();
            this.indent();
            if (!this.generatingInterfaceFields && typeDeclaration.memberTypes != null) {
                int n6 = typeDeclaration.memberTypes.length;
                n4 = 0;
                while (n4 < n6) {
                    typeDeclaration.memberTypes[n4].traverse((ASTVisitor)this, typeDeclaration.scope);
                    ++n4;
                }
            }
            boolean bl = false;
            if (typeDeclaration.fields != null) {
                n4 = typeDeclaration.fields.length;
                n3 = 0;
                while (n3 < n4) {
                    FieldDeclaration fieldDeclaration = typeDeclaration.fields[n3];
                    if (fieldDeclaration.getKind() == 2) {
                        if (fieldDeclaration.isStatic()) {
                            bl = true;
                        }
                    } else if (fieldDeclaration.isStatic()) {
                        fieldDeclaration.traverse((ASTVisitor)this, typeDeclaration.staticInitializerScope);
                    } else {
                        fieldDeclaration.traverse((ASTVisitor)this, typeDeclaration.initializerScope);
                    }
                    ++n3;
                }
            }
            if (!this.generatingInterfaceFields) {
                HashMap<char[], char[]> hashMap;
                Object object;
                Object object2;
                int n7;
                int n8;
                FieldBinding[] fieldBindingArray = typeDeclaration.binding.syntheticFields();
                n3 = 0;
                int n9 = fieldBindingArray == null ? 0 : fieldBindingArray.length;
                while (n3 < n9) {
                    FieldBinding fieldBinding = fieldBindingArray[n3];
                    if (!Util.isExcluded(fieldBinding)) {
                        this.printIndent();
                        this.scriptOutput.append("private ");
                        if (fieldBinding.isStatic()) {
                            this.scriptOutput.append("static ");
                        }
                        this.scriptOutput.append("var ");
                        this.scriptOutput.append(fieldBinding.name);
                        this.scriptOutput.append(": ");
                        Util.appendTypeName(this.scriptOutput, fieldBinding.type, this.importRegistry.isAmbiguous(fieldBinding.type));
                        switch (fieldBinding.type.id) {
                            case 7: 
                            case 8: 
                            case 9: {
                                this.scriptOutput.append(" = 0");
                            }
                        }
                        this.scriptOutput.append(';').appendNewLine();
                    }
                    ++n3;
                }
                CompilationUnitDeclaration compilationUnitDeclaration = compilationUnitScope.referenceCompilationUnit();
                n9 = typeDeclaration.declarationSourceStart;
                int n10 = typeDeclaration.declarationSourceEnd;
                int n11 = 0;
                int n12 = compilationUnitDeclaration.comments.length;
                while (n11 < n12) {
                    n8 = -compilationUnitDeclaration.comments[n11][1];
                    if (n8 >= 0 && (n7 = compilationUnitDeclaration.comments[n11][0]) > n9 && n8 < n10) {
                        object2 = compilationUnitDeclaration.compilationResult.compilationUnit.getContents();
                        if (n8 - n7 < 7 || object2[n7] != '/' || object2[n7 + 1] != '*' || object2[n7 + 2] != '+' || object2[n8 - 1] != '/' || object2[n8 - 2] != '*' || object2[n8 - 3] != '+') break;
                        object = String.copyValueOf(object2, n7 + 3, n8 - n7 - 6);
                        this.scriptOutput.append((String)object);
                        this.scriptOutput.appendNewLine();
                        break;
                    }
                    ++n11;
                }
                if (typeDeclaration.binding.isAbstract() && !typeDeclaration.binding.isInterface() && typeDeclaration.superInterfaces != null && typeDeclaration.superInterfaces.length > 0) {
                    hashMap = new HashMap<char[], char[]>();
                    SourceTypeBinding sourceTypeBinding = typeDeclaration.binding;
                    while (sourceTypeBinding != null) {
                        MethodBinding[] methodBindingArray = sourceTypeBinding.methods();
                        if (methodBindingArray != null) {
                            n7 = 0;
                            while (n7 < methodBindingArray.length) {
                                object2 = Util.methodKey(methodBindingArray[n7]);
                                hashMap.put((char[])object2, (char[])object2);
                                ++n7;
                            }
                        }
                        sourceTypeBinding = sourceTypeBinding.superclass();
                    }
                } else {
                    hashMap = null;
                }
                AbstractMethodDeclaration[] abstractMethodDeclarationArray = typeDeclaration.methods;
                if (abstractMethodDeclarationArray != null) {
                    n8 = typeDeclaration.methods.length;
                    if (bl) {
                        this.scriptOutput.appendNewLine();
                        this.printIndent();
                        this.scriptOutput.append("__clinit();").appendNewLine().appendNewLine();
                    }
                    n7 = 0;
                    while (n7 < n8) {
                        abstractMethodDeclarationArray[n7].traverse((ASTVisitor)this, typeDeclaration.scope);
                        ++n7;
                    }
                }
                this.scriptOutput.setCurrentMappedLineNumber(0);
                if (hashMap != null) {
                    class AbstractMethodsGenerator {
                        ReferenceBinding abstractType;
                        final /* synthetic */ ActionScriptSourceGenerator this$0;
                        private final /* synthetic */ HashMap val$definedMethods;

                        AbstractMethodsGenerator(ActionScriptSourceGenerator actionScriptSourceGenerator, ReferenceBinding referenceBinding, HashMap hashMap) {
                            this.this$0 = actionScriptSourceGenerator;
                            this.val$definedMethods = hashMap;
                            this.abstractType = referenceBinding;
                        }

                        public boolean visit(ReferenceBinding referenceBinding, ClassScope classScope) {
                            int n;
                            int n2;
                            MethodBinding[] methodBindingArray;
                            if (referenceBinding.isInterface()) {
                                methodBindingArray = referenceBinding.availableMethods();
                                n2 = 0;
                                n = methodBindingArray == null ? 0 : methodBindingArray.length;
                                while (n2 < n) {
                                    String string = Util.methodKey(methodBindingArray[n2]);
                                    if (this.val$definedMethods.get(string) == null) {
                                        MethodBinding methodBinding = methodBindingArray[n2];
                                        methodBinding.declaringClass = this.abstractType;
                                        this.this$0.appendMethod(methodBinding, classScope);
                                        methodBinding.declaringClass = referenceBinding;
                                        this.val$definedMethods.put(string, string);
                                    }
                                    ++n2;
                                }
                            }
                            methodBindingArray = referenceBinding.superInterfaces();
                            n2 = 0;
                            n = methodBindingArray == null ? 0 : methodBindingArray.length;
                            while (n2 < n) {
                                this.visit((ReferenceBinding)methodBindingArray[n2], classScope);
                                ++n2;
                            }
                            return false;
                        }
                    }
                    new AbstractMethodsGenerator(this, (ReferenceBinding)typeDeclaration.binding, hashMap).visit((ReferenceBinding)typeDeclaration.binding, typeDeclaration.scope);
                }
                SyntheticMethodBinding[] syntheticMethodBindingArray = typeDeclaration.binding.syntheticMethods();
                n7 = 0;
                int n13 = syntheticMethodBindingArray == null ? 0 : syntheticMethodBindingArray.length;
                while (n7 < n13) {
                    object = syntheticMethodBindingArray[n7];
                    if (object.parameters.length != 0 || object.isStatic() || object.targetMethod == null || object.declaringClass != object.targetMethod.declaringClass) {
                        switch (object.purpose) {
                            case 11: {
                                break;
                            }
                            default: {
                                TypeBinding typeBinding;
                                int n14;
                                if (object.isConstructor()) break;
                                this.printIndent();
                                if (object.purpose != 7) {
                                    if (object.purpose == 8) {
                                        this.scriptOutput.append("public ");
                                        if (Util.isOverriding((MethodBinding)object)) {
                                            this.scriptOutput.append("override ");
                                        }
                                        this.scriptOutput.append("function ");
                                        Util.appendMethodName(this.scriptOutput, (MethodBinding)object, false, false);
                                    } else {
                                        this.scriptOutput.append("public static function ");
                                        this.scriptOutput.append(object.selector);
                                    }
                                    this.scriptOutput.append('(');
                                    n14 = object.parameters == null ? 0 : object.parameters.length;
                                    int n15 = 0;
                                    while (n15 < n14) {
                                        typeBinding = object.parameters[n15];
                                        if (n15 > 0) {
                                            this.scriptOutput.append(", ");
                                        }
                                        this.scriptOutput.append("arg");
                                        this.scriptOutput.append(n15);
                                        this.scriptOutput.append(": ");
                                        Util.appendTypeName(this.scriptOutput, typeBinding, this.importRegistry.isAmbiguous(typeBinding));
                                        ++n15;
                                    }
                                    this.scriptOutput.append("): ");
                                    Util.appendTypeName(this.scriptOutput, object.returnType, this.importRegistry.isAmbiguous(object.returnType));
                                    this.scriptOutput.append(" {").appendNewLine();
                                    this.indent();
                                    switch (object.purpose) {
                                        case 1: {
                                            this.printIndent();
                                            this.scriptOutput.append(n14 == 0 ? "return " : "return arg0.");
                                            this.scriptOutput.append(object.targetReadField.name);
                                            this.scriptOutput.append(';').appendNewLine();
                                            break;
                                        }
                                        case 2: {
                                            this.printIndent();
                                            FieldBinding fieldBinding = object.targetWriteField;
                                            if (fieldBinding.isStatic()) {
                                                this.scriptOutput.append(fieldBinding.name);
                                                this.scriptOutput.append(" = ");
                                                this.scriptOutput.append("arg0;").appendNewLine();
                                                break;
                                            }
                                            this.scriptOutput.append("arg0.");
                                            this.scriptOutput.append(fieldBinding.name);
                                            this.scriptOutput.append(" = ");
                                            this.scriptOutput.append("arg1;").appendNewLine();
                                            break;
                                        }
                                        case 5: 
                                        case 8: {
                                            int n16;
                                            this.printIndent();
                                            if (object.targetMethod.returnType.id != 6) {
                                                this.scriptOutput.append("return ");
                                            }
                                            if (object.targetMethod.isStatic()) {
                                                n16 = 0;
                                            } else {
                                                this.scriptOutput.append("arg0.");
                                                n16 = 1;
                                            }
                                            Util.appendMethodName(this.scriptOutput, object.targetMethod, false, false);
                                            this.scriptOutput.append('(');
                                            if (n14 > n16) {
                                                this.scriptOutput.append("arg" + n16);
                                                int n17 = n16 + 1;
                                                while (n17 < n14) {
                                                    this.scriptOutput.append(", arg");
                                                    this.scriptOutput.append(n17);
                                                    ++n17;
                                                }
                                            }
                                            this.scriptOutput.append(");").appendNewLine();
                                            break;
                                        }
                                        case 6: {
                                            break;
                                        }
                                        case 9: {
                                            FieldBinding[] fieldBindingArray2 = Util.getEnumConstants(typeDeclaration.binding);
                                            int n18 = fieldBindingArray2.length;
                                            this.printIndent();
                                            this.scriptOutput.append("if (ENUM$VALUES === null) {").appendNewLine();
                                            this.indent();
                                            this.printIndent();
                                            this.scriptOutput.append("var ");
                                            this.scriptOutput.append(TAB);
                                            this.scriptOutput.append(" : JavaArray = new JavaArray(\"[L");
                                            this.scriptOutput.append(typeDeclaration.binding.constantPoolName());
                                            this.scriptOutput.append(";\").lengths(");
                                            this.scriptOutput.append(n18);
                                            this.scriptOutput.append(");").appendNewLine();
                                            int n19 = 0;
                                            int n20 = n18;
                                            while (n19 < n20) {
                                                FieldBinding fieldBinding = fieldBindingArray2[n19];
                                                this.printIndent();
                                                this.localNamesRegistry.addTargetName(TAB);
                                                this.scriptOutput.append(TAB);
                                                this.scriptOutput.append('[');
                                                this.scriptOutput.append(n19);
                                                this.scriptOutput.append("] = ");
                                                this.scriptOutput.append(fieldBinding.name);
                                                this.scriptOutput.append(';').appendNewLine();
                                                ++n19;
                                            }
                                            this.printIndent();
                                            this.scriptOutput.append("ENUM$VALUES = ");
                                            this.scriptOutput.append(TAB);
                                            this.scriptOutput.append(';').appendNewLine();
                                            this.outdent();
                                            this.printIndent();
                                            this.scriptOutput.append('}').appendNewLine();
                                            this.printIndent();
                                            this.scriptOutput.append("var length: int = ENUM$VALUES.length;").appendNewLine();
                                            this.printIndent();
                                            this.scriptOutput.append("var ");
                                            this.scriptOutput.append(TAB2);
                                            this.scriptOutput.append(" : JavaArray = new JavaArray(\"[L");
                                            this.scriptOutput.append(typeDeclaration.binding.constantPoolName());
                                            this.scriptOutput.append(";\").lengths(");
                                            this.scriptOutput.append(n18);
                                            this.scriptOutput.append(");").appendNewLine();
                                            this.printIndent();
                                            this.scriptOutput.append("System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(ENUM$VALUES, 0, ");
                                            this.scriptOutput.append(TAB2);
                                            this.scriptOutput.append(", 0, length);").appendNewLine();
                                            this.printIndent();
                                            this.scriptOutput.append("return ");
                                            this.scriptOutput.append(TAB2);
                                            this.scriptOutput.append(';').appendNewLine();
                                            break;
                                        }
                                        case 10: {
                                            this.printIndent();
                                            this.scriptOutput.append("return ");
                                            char[] cArray = typeDeclaration.binding.constantPoolName();
                                            cArray = CharOperation.replaceOnCopy((char[])cArray, (char)'/', (char)'.');
                                            this.scriptOutput.append(cArray);
                                            this.scriptOutput.append("(Enum.valueOf__Ljava_lang_Class_2Ljava_lang_String_2(Class__.forName__Ljava_lang_String_2(\"");
                                            this.scriptOutput.append(cArray);
                                            this.scriptOutput.append("\"), arg0));").appendNewLine();
                                            break;
                                        }
                                    }
                                } else {
                                    this.scriptOutput.append("public function ");
                                    this.scriptOutput.append(object.selector);
                                    this.scriptOutput.append('(');
                                    n14 = object.parameters == null ? 0 : object.parameters.length;
                                    int n21 = 1;
                                    while (n21 < n14) {
                                        typeBinding = object.parameters[n21];
                                        if (n21 > 1) {
                                            this.scriptOutput.append(", ");
                                        }
                                        this.scriptOutput.append("arg");
                                        this.scriptOutput.append(n21);
                                        this.scriptOutput.append(": ");
                                        Util.appendTypeName(this.scriptOutput, typeBinding, this.importRegistry.isAmbiguous(typeBinding));
                                        ++n21;
                                    }
                                    this.scriptOutput.append("): ");
                                    Util.appendTypeName(this.scriptOutput, object.returnType, this.importRegistry.isAmbiguous(object.returnType));
                                    this.scriptOutput.append(" {").appendNewLine();
                                    this.indent();
                                    this.printIndent();
                                    if (object.targetMethod.returnType.id != 6) {
                                        this.scriptOutput.append("return ");
                                    }
                                    this.scriptOutput.append("super.");
                                    Util.appendMethodName(this.scriptOutput, object.targetMethod, false, false);
                                    this.scriptOutput.append('(');
                                    if (n14 > 1) {
                                        this.scriptOutput.append("arg1");
                                        n21 = 2;
                                        while (n21 < n14) {
                                            this.scriptOutput.append(", arg");
                                            this.scriptOutput.append(n21);
                                            ++n21;
                                        }
                                    }
                                    this.scriptOutput.append(");").appendNewLine();
                                }
                                this.outdent();
                                this.printIndent();
                                this.scriptOutput.append('}').appendNewLine();
                            }
                        }
                    }
                    ++n7;
                }
                this.constructorGenerator.generate();
            }
            this.outdent();
            this.scriptOutput.append('}').appendNewLine().append('}').appendNewLine();
            this.actionScriptSourceFilesCollector.accept(this.actionScriptSourceFile);
            this.generatingInterfaceFields = false;
        }
        if (!this.actionScriptSourceFiles.empty()) {
            this.actionScriptSourceFile = (ActionScriptSourceFile)((Object)this.actionScriptSourceFiles.pop());
            this.scriptOutput = this.actionScriptSourceFile.actionScriptContents;
        } else {
            this.actionScriptSourceFile = null;
        }
        this.constructorGenerator = this.constructorGenerators.empty() ? null : (ActionScriptConstructorGenerator)this.constructorGenerators.pop();
        return false;
    }

    public boolean visit(UnaryExpression unaryExpression, BlockScope blockScope) {
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)unaryExpression, blockScope);
        this.scriptOutput.append(unaryExpression.operatorToString());
        unaryExpression.expression.traverse((ASTVisitor)this, blockScope);
        Util.appendClosingParenthesis(this.scriptOutput, (Expression)unaryExpression, blockScope);
        return false;
    }

    public boolean visit(WhileStatement whileStatement, BlockScope blockScope) {
        Util.mapLine(this, this.scriptOutput, (ASTNode)whileStatement);
        if (whileStatement != this.unIndentedStatement) {
            this.printIndent();
        }
        this.scriptOutput.append("while (");
        Expression expression = whileStatement.condition;
        expression.traverse((ASTVisitor)this, blockScope);
        this.scriptOutput.append(')');
        Statement statement = whileStatement.action;
        boolean bl = statement instanceof Block;
        if (bl) {
            this.scriptOutput.append(' ');
            this.unIndentedStatement = statement;
            this.visitAsStatement(statement, blockScope);
        } else {
            this.scriptOutput.appendNewLine();
            this.indent();
            this.visitAsStatement(statement, blockScope);
            this.outdent();
        }
        return false;
    }

    protected void visitAsExpression(Statement statement, BlockScope blockScope) {
        int n = this.scriptOutput.length();
        statement.traverse((ASTVisitor)this, blockScope);
        int n2 = this.scriptOutput.length() - 1;
        this.scriptOutput.trimEnd(n, n2);
    }

    protected void visitAsStatement(Statement statement, BlockScope blockScope) {
        if (statement instanceof Expression || statement instanceof LocalDeclaration) {
            this.printIndent();
            statement.traverse((ASTVisitor)this, blockScope);
            this.scriptOutput.append(';');
        } else {
            statement.traverse((ASTVisitor)this, blockScope);
        }
    }

    private boolean visitStringConcatenation(BinaryExpression binaryExpression, BlockScope blockScope) {
        int n;
        Util.appendOpeningParenthesis(this, this.scriptOutput, (Expression)binaryExpression, blockScope);
        block0 : switch (binaryExpression.left.resolvedType.id) {
            case 2: {
                this.scriptOutput.append("String.fromCharCode(");
                binaryExpression.left.traverse((ASTVisitor)this, blockScope);
                this.scriptOutput.append(')');
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                binaryExpression.left.traverse((ASTVisitor)this, blockScope);
                break;
            }
            default: {
                int n2 = Util.isIntrinsic(binaryExpression.left.resolvedType) ? 0 : (n = binaryExpression.left.isThis() ? 1 : 2);
                if (n > 1) {
                    this.scriptOutput.append("java.lang.System.stringValueOf(");
                }
                binaryExpression.left.traverse((ASTVisitor)this, blockScope);
                switch (n) {
                    case 1: {
                        this.scriptOutput.append(".toString__()");
                        break block0;
                    }
                    case 2: {
                        this.scriptOutput.append(')');
                    }
                }
            }
        }
        this.scriptOutput.append(' ').append(binaryExpression.operatorToString()).append(' ');
        block8 : switch (binaryExpression.right.resolvedType.id) {
            case 2: {
                this.scriptOutput.append("String.fromCharCode(");
                binaryExpression.right.traverse((ASTVisitor)this, blockScope);
                this.scriptOutput.append(')');
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                binaryExpression.right.traverse((ASTVisitor)this, blockScope);
                break;
            }
            default: {
                int n3 = Util.isIntrinsic(binaryExpression.right.resolvedType) ? 0 : (n = binaryExpression.right.isThis() ? 1 : 2);
                if (n > 1) {
                    this.scriptOutput.append("java.lang.System.stringValueOf(");
                }
                binaryExpression.right.traverse((ASTVisitor)this, blockScope);
                switch (n) {
                    case 1: {
                        this.scriptOutput.append(".toString__()");
                        break block8;
                    }
                    case 2: {
                        this.scriptOutput.append(')');
                    }
                }
            }
        }
        Util.appendClosingParenthesis(this.scriptOutput, (Expression)binaryExpression, blockScope);
        return false;
    }
}

