/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.as;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.as.Util;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ImportRegistry {
    private LinkedHashMap importedTypes = new LinkedHashMap(10);
    private LinkedHashMap unimportedTypes = new LinkedHashMap(10);
    private HashMap ambiguityStatus = new HashMap(10);
    public boolean importJavaLangArguments = false;
    public boolean importJavaLangClass = false;
    public boolean importJavaLangEnum = false;
    public boolean importJavaLangJavaArray = false;
    public boolean importJavaLangSystem = false;
    PackageBinding currentPackage;
    private Hashtable blended = new Hashtable();
    private Hashtable neededTypes = new Hashtable();

    public Iterator getUnimportedTypes() {
        return this.unimportedTypes.keySet().iterator();
    }

    public void initialize(CompilationUnitDeclaration compilationUnitDeclaration) {
        if (compilationUnitDeclaration.types != null && compilationUnitDeclaration.types.length > 0) {
            TypeDeclaration typeDeclaration = compilationUnitDeclaration.types[0];
            if (typeDeclaration.ignoreFurtherInvestigation) {
                return;
            }
            this.currentPackage = typeDeclaration.binding.getPackage();
            compilationUnitDeclaration.traverse((ASTVisitor)new TypeReferenceVisitor(), compilationUnitDeclaration.scope);
            if (!this.neededTypes.isEmpty()) {
                Object object;
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                Iterator iterator = this.importedTypes.keySet().iterator();
                while (iterator.hasNext()) {
                    object = (TypeBinding)iterator.next();
                    hashtable.put(new String(object.shortReadableName()), object);
                }
                iterator = this.unimportedTypes.keySet().iterator();
                while (iterator.hasNext()) {
                    object = (TypeBinding)iterator.next();
                    hashtable.put(new String(object.shortReadableName()), object);
                }
                object = this.neededTypes.keys();
                while (object.hasMoreElements()) {
                    String string;
                    TypeBinding typeBinding;
                    TypeBinding typeBinding2 = (TypeBinding)object.nextElement();
                    if (this.importedTypes.get(typeBinding2) == null) {
                        this.unimportedTypes.put(typeBinding2, typeBinding2);
                    }
                    if ((typeBinding = (TypeBinding)hashtable.get(string = new String(typeBinding2.shortReadableName()))) != null) {
                        if (typeBinding == typeBinding2) continue;
                        this.ambiguityStatus.put(typeBinding2, Boolean.TRUE);
                        this.ambiguityStatus.put(typeBinding, Boolean.TRUE);
                        continue;
                    }
                    hashtable.put(string, typeBinding2);
                }
            }
        }
    }

    void blend(ReferenceBinding referenceBinding) {
        if (this.blended.get(referenceBinding) == null) {
            this.blended.put(referenceBinding, referenceBinding);
            ReferenceBinding[] referenceBindingArray = referenceBinding.superInterfaces();
            int n = 0;
            int n2 = referenceBindingArray == null ? 0 : referenceBindingArray.length;
            while (n < n2) {
                this.blend(referenceBindingArray[n]);
                ++n;
            }
            FieldBinding[] fieldBindingArray = referenceBinding.availableFields();
            int n3 = 0;
            int n4 = fieldBindingArray == null ? 0 : fieldBindingArray.length;
            while (n3 < n4) {
                TypeBinding typeBinding = fieldBindingArray[n3].type;
                if (!typeBinding.isBaseType()) {
                    if (typeBinding.isArrayType()) {
                        this.importJavaLangJavaArray = true;
                    } else {
                        this.neededTypes.put(typeBinding, typeBinding);
                    }
                }
                ++n3;
            }
            MethodBinding[] methodBindingArray = referenceBinding.availableMethods();
            n4 = 0;
            int n5 = methodBindingArray == null ? 0 : methodBindingArray.length;
            while (n4 < n5) {
                MethodBinding methodBinding = methodBindingArray[n4];
                TypeBinding typeBinding = methodBinding.returnType;
                if (!typeBinding.isBaseType()) {
                    if (typeBinding.isArrayType()) {
                        this.importJavaLangJavaArray = true;
                    } else {
                        this.neededTypes.put(typeBinding, typeBinding);
                    }
                }
                TypeBinding[] typeBindingArray = methodBinding.parameters;
                int n6 = 0;
                int n7 = typeBindingArray == null ? 0 : typeBindingArray.length;
                while (n6 < n7) {
                    typeBinding = typeBindingArray[n6];
                    if (!typeBinding.isBaseType()) {
                        if (typeBinding.isArrayType()) {
                            this.importJavaLangJavaArray = true;
                        } else {
                            this.neededTypes.put(typeBinding, typeBinding);
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
        }
    }

    public boolean isAmbiguous(TypeBinding typeBinding) {
        switch (typeBinding.id) {
            case 1: 
            case 11: {
                return false;
            }
        }
        Object v = this.importedTypes.get(typeBinding);
        if (v == null && (v = this.unimportedTypes.get(typeBinding)) == null) {
            this.recordReferenceType(typeBinding);
            return true;
        }
        return this.ambiguityStatus.get(v) == Boolean.TRUE;
    }

    public void recordImportedType(TypeBinding typeBinding) {
        switch (typeBinding.id) {
            case 1: 
            case 11: {
                return;
            }
        }
        String string = (String)this.importedTypes.get(typeBinding);
        if (string != null) {
            return;
        }
        string = new String(typeBinding.shortReadableName());
        this.importedTypes.put(typeBinding, string);
        Boolean bl = (Boolean)this.ambiguityStatus.get(string);
        if (bl == Boolean.FALSE) {
            this.ambiguityStatus.put(string, Boolean.TRUE);
        } else if (bl == null) {
            Binding binding = this.currentPackage.getTypeOrPackage(string.toCharArray());
            if (binding == null || binding == typeBinding || binding instanceof PackageBinding) {
                this.ambiguityStatus.put(string, Boolean.FALSE);
            } else {
                this.ambiguityStatus.put(string, Boolean.TRUE);
            }
        }
    }

    public void recordReferenceType(TypeBinding typeBinding) {
        switch (typeBinding.id) {
            case 1: 
            case 11: {
                return;
            }
        }
        if (typeBinding.isBaseType()) {
            return;
        }
        if (typeBinding.isArrayType()) {
            this.importJavaLangJavaArray = true;
            return;
        }
        String string = (String)this.importedTypes.get(typeBinding);
        if (string != null) {
            return;
        }
        string = (String)this.unimportedTypes.get(typeBinding);
        if (string != null) {
            return;
        }
        string = new String(typeBinding.shortReadableName());
        this.unimportedTypes.put(typeBinding, string);
        Boolean bl = (Boolean)this.ambiguityStatus.get(string);
        if (bl == Boolean.FALSE) {
            this.ambiguityStatus.put(string, Boolean.TRUE);
        } else if (bl == null) {
            Binding binding = this.currentPackage.getTypeOrPackage(string.toCharArray());
            if (binding == null || binding == typeBinding || binding instanceof PackageBinding) {
                this.ambiguityStatus.put(string, Boolean.FALSE);
            } else {
                this.ambiguityStatus.put(string, Boolean.TRUE);
            }
        }
    }

    class TypeReferenceVisitor
    extends ASTVisitor {
        TypeReferenceVisitor() {
        }

        public boolean visit(AllocationExpression allocationExpression, BlockScope blockScope) {
            if (allocationExpression.binding != null) {
                ReferenceBinding referenceBinding = allocationExpression.binding.declaringClass;
                ImportRegistry.this.importJavaLangArguments = ImportRegistry.this.importJavaLangArguments || referenceBinding.id != 11 && allocationExpression.binding.declaringClass.id != 1 && !Util.isIntrinsic((TypeBinding)referenceBinding) && !Util.isSingleConstructor(allocationExpression.binding);
            }
            return super.visit(allocationExpression, blockScope);
        }

        public boolean visit(ArrayAllocationExpression arrayAllocationExpression, BlockScope blockScope) {
            ImportRegistry.this.importJavaLangJavaArray = true;
            return super.visit(arrayAllocationExpression, blockScope);
        }

        public boolean visit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, BlockScope blockScope) {
            ImportRegistry.this.importJavaLangJavaArray = true;
            return super.visit(arrayQualifiedTypeReference, blockScope);
        }

        public boolean visit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, ClassScope classScope) {
            ImportRegistry.this.importJavaLangJavaArray = true;
            return super.visit(arrayQualifiedTypeReference, classScope);
        }

        public boolean visit(ArrayTypeReference arrayTypeReference, BlockScope blockScope) {
            ImportRegistry.this.importJavaLangJavaArray = true;
            return super.visit(arrayTypeReference, blockScope);
        }

        public boolean visit(ArrayTypeReference arrayTypeReference, ClassScope classScope) {
            ImportRegistry.this.importJavaLangJavaArray = true;
            return super.visit(arrayTypeReference, classScope);
        }

        public boolean visit(BinaryExpression binaryExpression, BlockScope blockScope) {
            if (binaryExpression.resolvedType.id == 11) {
                switch (binaryExpression.left.resolvedType.id) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        break;
                    }
                    default: {
                        if (Util.isIntrinsic(binaryExpression.left.resolvedType) || binaryExpression.left.isThis()) break;
                        ImportRegistry.this.importJavaLangSystem = true;
                        return super.visit(binaryExpression, blockScope);
                    }
                }
                switch (binaryExpression.right.resolvedType.id) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        break;
                    }
                    default: {
                        if (Util.isIntrinsic(binaryExpression.right.resolvedType) || binaryExpression.right.isThis()) break;
                        ImportRegistry.this.importJavaLangSystem = true;
                        return super.visit(binaryExpression, blockScope);
                    }
                }
            }
            return super.visit(binaryExpression, blockScope);
        }

        public boolean visit(CastExpression castExpression, BlockScope blockScope) {
            ImportRegistry.this.recordReferenceType(castExpression.resolvedType);
            return super.visit(castExpression, blockScope);
        }

        public boolean visit(ClassLiteralAccess classLiteralAccess, BlockScope blockScope) {
            ImportRegistry.this.importJavaLangClass = true;
            return super.visit(classLiteralAccess, blockScope);
        }

        public boolean visit(CompilationUnitDeclaration compilationUnitDeclaration, CompilationUnitScope compilationUnitScope) {
            ImportBinding[] importBindingArray = compilationUnitScope.imports;
            int n = 0;
            int n2 = importBindingArray.length;
            while (n < n2) {
                if (importBindingArray[n].resolvedImport instanceof TypeBinding) {
                    ImportRegistry.this.recordImportedType((TypeBinding)importBindingArray[n].resolvedImport);
                }
                ++n;
            }
            return super.visit(compilationUnitDeclaration, compilationUnitScope);
        }

        public boolean visit(ExplicitConstructorCall explicitConstructorCall, BlockScope blockScope) {
            ImportRegistry.this.importJavaLangArguments = ImportRegistry.this.importJavaLangArguments || explicitConstructorCall.binding.declaringClass.id != 1 && !Util.isSingleConstructor(explicitConstructorCall.binding) && !Util.isIntrinsic((TypeBinding)explicitConstructorCall.binding.declaringClass);
            return super.visit(explicitConstructorCall, blockScope);
        }

        public boolean visit(FieldReference fieldReference, BlockScope blockScope) {
            FieldBinding fieldBinding = fieldReference.fieldBinding();
            if (fieldBinding != null && fieldBinding.isStatic()) {
                ImportRegistry.this.recordReferenceType((TypeBinding)fieldReference.fieldBinding().declaringClass);
            }
            return super.visit(fieldReference, blockScope);
        }

        public boolean visit(FieldReference fieldReference, ClassScope classScope) {
            if (fieldReference.fieldBinding().isStatic()) {
                ImportRegistry.this.recordReferenceType((TypeBinding)fieldReference.fieldBinding().declaringClass);
            }
            return super.visit(fieldReference, classScope);
        }

        public boolean visit(ImportReference importReference, CompilationUnitScope compilationUnitScope) {
            return super.visit(importReference, compilationUnitScope);
        }

        public boolean visit(MessageSend messageSend, BlockScope blockScope) {
            if (messageSend.binding != null && messageSend.binding.isStatic()) {
                ImportRegistry.this.recordReferenceType((TypeBinding)messageSend.binding.declaringClass);
            }
            return super.visit(messageSend, blockScope);
        }

        public boolean visit(MethodDeclaration methodDeclaration, ClassScope classScope) {
            if (methodDeclaration.ignoreFurtherInvestigation) {
                return false;
            }
            if (methodDeclaration.binding == null) {
                return false;
            }
            return super.visit(methodDeclaration, classScope);
        }

        public boolean visit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, BlockScope blockScope) {
            if (parameterizedQualifiedTypeReference.dimensions() == 0 && parameterizedQualifiedTypeReference.resolvedType != null) {
                ImportRegistry.this.recordReferenceType(parameterizedQualifiedTypeReference.resolvedType);
            }
            return super.visit(parameterizedQualifiedTypeReference, blockScope);
        }

        public boolean visit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, ClassScope classScope) {
            if (parameterizedQualifiedTypeReference.dimensions() == 0 && parameterizedQualifiedTypeReference.resolvedType != null) {
                ImportRegistry.this.recordReferenceType(parameterizedQualifiedTypeReference.resolvedType);
            }
            return super.visit(parameterizedQualifiedTypeReference, classScope);
        }

        public boolean visit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, BlockScope blockScope) {
            if (parameterizedSingleTypeReference.dimensions() == 0 && parameterizedSingleTypeReference.resolvedType != null) {
                ImportRegistry.this.recordReferenceType(parameterizedSingleTypeReference.resolvedType);
            }
            return super.visit(parameterizedSingleTypeReference, blockScope);
        }

        public boolean visit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, ClassScope classScope) {
            if (parameterizedSingleTypeReference.dimensions() == 0 && parameterizedSingleTypeReference.resolvedType != null) {
                ImportRegistry.this.recordReferenceType(parameterizedSingleTypeReference.resolvedType);
            }
            return super.visit(parameterizedSingleTypeReference, classScope);
        }

        public boolean visit(QualifiedNameReference qualifiedNameReference, BlockScope blockScope) {
            switch (qualifiedNameReference.bits & 7) {
                case 4: {
                    if (qualifiedNameReference.resolvedType == null) break;
                    ImportRegistry.this.recordReferenceType(qualifiedNameReference.resolvedType);
                    break;
                }
                case 1: {
                    ImportRegistry.this.recordReferenceType(qualifiedNameReference.actualReceiverType);
                }
            }
            return super.visit(qualifiedNameReference, blockScope);
        }

        public boolean visit(QualifiedNameReference qualifiedNameReference, ClassScope classScope) {
            if ((qualifiedNameReference.bits & 7) == 4 && qualifiedNameReference.resolvedType != null) {
                ImportRegistry.this.recordReferenceType(qualifiedNameReference.resolvedType);
            }
            return super.visit(qualifiedNameReference, classScope);
        }

        public boolean visit(QualifiedTypeReference qualifiedTypeReference, BlockScope blockScope) {
            if (qualifiedTypeReference.resolvedType != null) {
                ImportRegistry.this.recordReferenceType(qualifiedTypeReference.resolvedType);
            }
            return super.visit(qualifiedTypeReference, blockScope);
        }

        public boolean visit(QualifiedTypeReference qualifiedTypeReference, ClassScope classScope) {
            if (qualifiedTypeReference.resolvedType != null) {
                ImportRegistry.this.recordReferenceType(qualifiedTypeReference.resolvedType);
            }
            return super.visit(qualifiedTypeReference, classScope);
        }

        public boolean visit(SingleNameReference singleNameReference, BlockScope blockScope) {
            if ((singleNameReference.bits & 7) == 4 && singleNameReference.resolvedType != null) {
                ImportRegistry.this.recordReferenceType(singleNameReference.resolvedType);
            }
            return super.visit(singleNameReference, blockScope);
        }

        public boolean visit(SingleNameReference singleNameReference, ClassScope classScope) {
            if ((singleNameReference.bits & 7) == 4 && singleNameReference.resolvedType != null) {
                ImportRegistry.this.recordReferenceType(singleNameReference.resolvedType);
            }
            return super.visit(singleNameReference, classScope);
        }

        public boolean visit(SingleTypeReference singleTypeReference, BlockScope blockScope) {
            if (singleTypeReference.resolvedType != null) {
                ImportRegistry.this.recordReferenceType(singleTypeReference.resolvedType);
            }
            return super.visit(singleTypeReference, blockScope);
        }

        public boolean visit(SingleTypeReference singleTypeReference, ClassScope classScope) {
            if (singleTypeReference.resolvedType != null) {
                ImportRegistry.this.recordReferenceType(singleTypeReference.resolvedType);
            }
            return super.visit(singleTypeReference, classScope);
        }

        public boolean visit(TypeDeclaration typeDeclaration, BlockScope blockScope) {
            return this.visit(typeDeclaration, (CompilationUnitScope)null);
        }

        public boolean visit(TypeDeclaration typeDeclaration, ClassScope classScope) {
            return this.visit(typeDeclaration, (CompilationUnitScope)null);
        }

        public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope compilationUnitScope) {
            if (typeDeclaration.ignoreFurtherInvestigation || typeDeclaration.binding == null) {
                return false;
            }
            if (TypeDeclaration.kind((int)typeDeclaration.modifiers) == 3) {
                ImportRegistry.this.importJavaLangJavaArray = true;
                ImportRegistry.this.importJavaLangEnum = true;
                ImportRegistry.this.importJavaLangSystem = true;
                ImportRegistry.this.importJavaLangClass = true;
            }
            SourceTypeBinding sourceTypeBinding = typeDeclaration.binding;
            MethodBinding[] methodBindingArray = sourceTypeBinding.methods();
            int n = 0;
            int n2 = methodBindingArray.length;
            int n3 = 0;
            while (n < n2) {
                if (methodBindingArray[n].isConstructor() && ++n3 > 1) {
                    ImportRegistry.this.importJavaLangArguments = true;
                    break;
                }
                ++n;
            }
            if (sourceTypeBinding.isAbstract() && !sourceTypeBinding.isInterface()) {
                ReferenceBinding[] referenceBindingArray = sourceTypeBinding.superInterfaces();
                n2 = 0;
                n3 = referenceBindingArray == null ? 0 : referenceBindingArray.length;
                while (n2 < n3) {
                    ImportRegistry.this.blend(referenceBindingArray[n2]);
                    ++n2;
                }
            }
            return true;
        }
    }
}

