/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.as;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.as.ActionScriptScribe;
import org.eclipse.jdt.internal.compiler.as.ActionScriptSourceGenerator;
import org.eclipse.jdt.internal.compiler.as.Util;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class Util {
    private static final char[] NUMBER = "Number".toCharArray();
    private static final char[] UINT = "uint".toCharArray();
    private static final char[] BOOLEAN = "Boolean".toCharArray();
    private static final char[] JAVA_ARRAY = "JavaArray".toCharArray();
    public static final char[] INTRINSIC = "intrinsic".toCharArray();
    static final char[] INTRINSIC_SIGNATURE_START = "Lintrinsic/".toCharArray();
    private static final HashMap defaultConstructorsRegistry = new HashMap();
    private static final char[] JAVASCRIPT_OBJECT = "JavaScriptObject".toCharArray();
    private static final char[] CLASS$0 = "class$0".toCharArray();
    public static final int IS_INTRINSIC = 0;
    public static final int IS_NOT_INTRINSIC = 1;
    public static final int ERROR = 2;
    private static final HashMap typeNamesRegistry = new HashMap();
    private static final HashMap recodedTypeNames = new HashMap();

    static {
        String[] stringArray = new String[]{"ArgumentError", "arguments", "Array", "Boolean", "Class", "Date", "DefinitionError", "Error", "EvalError", "Function", "Math", "Namespace", "Number", "QName", "RangeError", "ReferenceError", "RegExp", "SecurityError", "SyntaxError", "TypeError", "uint", "URIError", "VerifyError", "XML", "XMLList"};
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            char[] cArray = stringArray[n].toCharArray();
            char[] cArray2 = new char[cArray.length + 2];
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
            cArray2[cArray.length + 1] = 95;
            cArray2[cArray.length] = 95;
            recodedTypeNames.put(stringArray[n], cArray2);
            ++n;
        }
    }

    public static int checkIntrinsic(MethodBinding methodBinding) {
        ReferenceBinding[] referenceBindingArray;
        MethodBinding methodBinding2;
        if (Util.isIntrinsic((TypeBinding)methodBinding.declaringClass)) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        if (methodBinding.isOverriding() && (methodBinding2 = methodBinding.declaringClass.superclass().getExactMethod(methodBinding.selector, methodBinding.parameters, null)) != null) {
            switch (Util.checkIntrinsic(methodBinding2)) {
                case 0: {
                    ++n;
                    break;
                }
                case 1: {
                    ++n2;
                    break;
                }
                default: {
                    return 2;
                }
            }
        }
        if (methodBinding.isImplementing() && (referenceBindingArray = methodBinding.declaringClass.superInterfaces()) != null) {
            int n3 = referenceBindingArray.length;
            int n4 = 0;
            while (n4 < n3) {
                methodBinding2 = referenceBindingArray[n4].getExactMethod(methodBinding.selector, methodBinding.parameters, null);
                if (methodBinding2 != null && methodBinding != methodBinding2) {
                    switch (Util.checkIntrinsic(methodBinding2)) {
                        case 0: {
                            ++n;
                            break;
                        }
                        case 1: {
                            ++n2;
                            break;
                        }
                        default: {
                            return 2;
                        }
                    }
                }
                ++n4;
            }
        }
        if (n > 0) {
            if (n2 > 0) {
                return 2;
            }
            return 0;
        }
        return 1;
    }

    public static void dumpConstructorFieldReference(ActionScriptScribe actionScriptScribe, MethodBinding methodBinding) {
        Util.appendTypeName(actionScriptScribe, (TypeBinding)methodBinding.declaringClass, true);
        actionScriptScribe.append('.');
        Util.appendMethodName(actionScriptScribe, methodBinding, false, false);
    }

    public static boolean isIntrinsic(char[][] cArray) {
        return cArray.length > 0 && CharOperation.equals((char[])INTRINSIC, (char[])cArray[0]);
    }

    public static boolean isIntrinsic(TypeBinding typeBinding) {
        PackageBinding packageBinding = typeBinding.getPackage();
        if (packageBinding != null) {
            return Util.isIntrinsic(packageBinding.compoundName);
        }
        return false;
    }

    public static boolean isOverriding(MethodBinding methodBinding) {
        ReferenceBinding referenceBinding = methodBinding.declaringClass;
        if (methodBinding.isOverriding()) {
            MethodBinding methodBinding2 = null;
            ReferenceBinding referenceBinding2 = (ReferenceBinding)referenceBinding.superclass().original();
            while (methodBinding2 == null && referenceBinding2.id != 1) {
                methodBinding2 = Util.findExactMethod(referenceBinding2, methodBinding);
                referenceBinding2 = (ReferenceBinding)referenceBinding2.superclass().original();
            }
            if (methodBinding2 != null && methodBinding2.declaringClass.id != 1) {
                TypeBinding typeBinding = methodBinding2.returnType;
                TypeBinding typeBinding2 = methodBinding.returnType;
                return typeBinding == typeBinding2 || typeBinding.erasure() == typeBinding2.erasure();
            }
        } else if (methodBinding.isBridge()) {
            ReferenceBinding[] referenceBindingArray;
            MethodBinding methodBinding3 = null;
            ReferenceBinding referenceBinding3 = (ReferenceBinding)referenceBinding.superclass().original();
            while (methodBinding3 == null && referenceBinding3.id != 1) {
                methodBinding3 = Util.findExactMethod(referenceBinding3, methodBinding);
                referenceBinding3 = (ReferenceBinding)referenceBinding3.superclass().original();
            }
            if (methodBinding3 == null && (methodBinding.isImplementing() || referenceBinding.isAbstract())) {
                referenceBinding3 = referenceBinding.isInterface() ? referenceBinding : referenceBinding.superclass();
                while (methodBinding3 == null && referenceBinding3.id != 1) {
                    referenceBindingArray = Util.getAllInterfaces(referenceBinding3);
                    int n = 0;
                    int n2 = referenceBindingArray.length;
                    while (n < n2) {
                        ReferenceBinding referenceBinding4 = referenceBindingArray[n];
                        methodBinding3 = Util.findExactMethod(referenceBinding4, methodBinding);
                        if (methodBinding3 != null) break;
                        ++n;
                    }
                    referenceBinding3 = referenceBinding3.superclass();
                }
            }
            if (methodBinding3 != null && methodBinding3.declaringClass.id != 1) {
                referenceBindingArray = methodBinding3.returnType;
                TypeBinding typeBinding = methodBinding.returnType;
                return referenceBindingArray == typeBinding || referenceBindingArray.erasure() == typeBinding.erasure();
            }
        } else if (methodBinding.isImplementing() || referenceBinding.isAbstract()) {
            TypeBinding typeBinding;
            MethodBinding methodBinding4 = null;
            ReferenceBinding referenceBinding5 = referenceBinding.isInterface() ? referenceBinding : referenceBinding.superclass();
            while (methodBinding4 == null && referenceBinding5.id != 1) {
                typeBinding = Util.getAllInterfaces(referenceBinding5);
                int n = 0;
                int n3 = ((TypeBinding)typeBinding).length;
                while (n < n3) {
                    TypeBinding typeBinding3 = typeBinding[n];
                    methodBinding4 = Util.findExactMethod((ReferenceBinding)typeBinding3, methodBinding);
                    if (methodBinding4 != null) break;
                    ++n;
                }
                referenceBinding5 = referenceBinding5.superclass();
            }
            if (methodBinding4 != null && methodBinding4.declaringClass.id != 1) {
                typeBinding = methodBinding4.returnType;
                TypeBinding typeBinding4 = methodBinding.returnType;
                return typeBinding == typeBinding4 || typeBinding.erasure() == typeBinding4.erasure();
            }
        } else if (methodBinding.isConstructor() && !Util.isSingleConstructor(methodBinding)) {
            MethodBinding methodBinding5 = null;
            ReferenceBinding referenceBinding6 = (ReferenceBinding)referenceBinding.superclass().original();
            while (methodBinding5 == null && referenceBinding6.id != 1) {
                methodBinding5 = Util.findExactMethod(referenceBinding6, methodBinding);
                referenceBinding6 = (ReferenceBinding)referenceBinding6.superclass().original();
            }
            if (methodBinding5 != null && !Util.isSingleConstructor(methodBinding5)) {
                return CharOperation.equals((char[])methodBinding5.declaringClass.sourceName(), (char[])referenceBinding.sourceName());
            }
        }
        return false;
    }

    private static ReferenceBinding[] getAllInterfaces(ReferenceBinding referenceBinding) {
        HashSet hashSet = new HashSet();
        Util.collectAllInterfaces0(referenceBinding, hashSet);
        return hashSet.toArray(new ReferenceBinding[hashSet.size()]);
    }

    private static void collectAllInterfaces0(ReferenceBinding referenceBinding, Set set) {
        ReferenceBinding[] referenceBindingArray = referenceBinding.superInterfaces();
        int n = 0;
        int n2 = referenceBindingArray.length;
        while (n < n2) {
            set.add(referenceBindingArray[n]);
            Util.collectAllInterfaces0(referenceBindingArray[n], set);
            ++n;
        }
    }

    public static ActionScriptScribe appendSignature(ActionScriptScribe actionScriptScribe, char[] cArray) {
        int n = cArray.length;
        int n2 = INTRINSIC_SIGNATURE_START.length;
        int n3 = 0;
        if (n > n2 && CharOperation.indexOf((char[])INTRINSIC_SIGNATURE_START, (char[])cArray, (boolean)true, (int)0, (int)n2) != -1) {
            actionScriptScribe.append('L');
            n3 = n2;
        }
        int n4 = n3;
        while (n4 < n) {
            switch (cArray[n4]) {
                case '/': {
                    actionScriptScribe.append('_');
                    break;
                }
                case '_': {
                    actionScriptScribe.append("_1");
                    break;
                }
                case ';': {
                    actionScriptScribe.append("_2");
                    break;
                }
                case '[': {
                    actionScriptScribe.append("_3");
                    break;
                }
                default: {
                    actionScriptScribe.append(cArray[n4]);
                }
            }
            ++n4;
        }
        return actionScriptScribe;
    }

    public static StringBuffer appendSignature(StringBuffer stringBuffer, char[] cArray) {
        int n = cArray.length;
        int n2 = INTRINSIC_SIGNATURE_START.length;
        int n3 = 0;
        if (n > n2 && CharOperation.indexOf((char[])INTRINSIC_SIGNATURE_START, (char[])cArray, (boolean)true, (int)0, (int)n2) != -1) {
            stringBuffer.append('L');
            n3 = n2;
        }
        int n4 = n3;
        while (n4 < n) {
            switch (cArray[n4]) {
                case '/': {
                    stringBuffer.append('_');
                    break;
                }
                case '_': {
                    stringBuffer.append("_1");
                    break;
                }
                case ';': {
                    stringBuffer.append("_2");
                    break;
                }
                case '[': {
                    stringBuffer.append("_3");
                    break;
                }
                default: {
                    stringBuffer.append(cArray[n4]);
                }
            }
            ++n4;
        }
        return stringBuffer;
    }

    public static ActionScriptScribe appendTypeName(ActionScriptScribe actionScriptScribe, TypeBinding typeBinding, boolean bl) {
        return Util.appendTypeName(actionScriptScribe, typeBinding, bl, false);
    }

    public static ActionScriptScribe appendTypeName(ActionScriptScribe actionScriptScribe, TypeBinding typeBinding, boolean bl, boolean bl2) {
        actionScriptScribe.append(Util.getTypeName(typeBinding, bl, bl2));
        return actionScriptScribe;
    }

    /*
     * Unable to fully structure code
     */
    public static char[] getTypeName(TypeBinding var0, boolean var1_1, boolean var2_2) {
        if (!var0.isArrayType()) ** GOTO lbl4
        return Util.JAVA_ARRAY;
lbl-1000:
        // 1 sources

        {
            var0 = ((TypeVariableBinding)var0).upperBound();
lbl4:
            // 2 sources

            ** while (var0.isTypeVariable())
        }
lbl5:
        // 1 sources

        switch (var0.id) {
            case 1: 
            case 11: {
                var1_1 = false;
                break;
            }
            case 5: {
                return Util.BOOLEAN;
            }
            case 3: 
            case 4: 
            case 10: {
                return TypeConstants.INT;
            }
            case 2: {
                return Util.UINT;
            }
            case 7: 
            case 8: 
            case 9: {
                return Util.NUMBER;
            }
        }
        var3_3 = Util.shortTypeName(var0);
        if (var2_2 && CharOperation.equals((char[])Util.JAVASCRIPT_OBJECT, (char[])var3_3)) {
            return TypeConstants.OBJECT;
        }
        if (var1_1 && (var4_4 = var0.getPackage()) != null && (var5_5 = var4_4.compoundName).length > 0) {
            var6_6 = CharOperation.equals((char[])Util.INTRINSIC, (char[])var5_5[0]) != false ? 1 : 0;
            return CharOperation.concat((char[])CharOperation.concatWith((char[][])CharOperation.subarray((char[][])var5_5, (int)var6_6, (int)var5_5.length), (char)'.'), (char[])var3_3, (char)'.');
        }
        return var3_3;
    }

    public static ActionScriptScribe appendMethodName(ActionScriptScribe actionScriptScribe, MethodBinding methodBinding, boolean bl, boolean bl2) {
        if (bl) {
            actionScriptScribe.append(methodBinding.selector);
        } else {
            if (methodBinding.isConstructor()) {
                if (bl2) {
                    Util.appendTypeName(actionScriptScribe, (TypeBinding)methodBinding.declaringClass, false);
                    return actionScriptScribe;
                }
                if (methodBinding.declaringClass.id == 11) {
                    actionScriptScribe.append("__init");
                } else {
                    Util.appendTypeName(actionScriptScribe, (TypeBinding)methodBinding.declaringClass, false);
                }
            } else {
                actionScriptScribe.append(methodBinding.selector);
            }
            actionScriptScribe.append("__");
            if (methodBinding instanceof ParameterizedMethodBinding) {
                methodBinding = methodBinding.original();
            }
            int n = 0;
            int n2 = methodBinding.parameters.length;
            while (n < n2) {
                Util.appendSignature(actionScriptScribe, methodBinding.parameters[n].signature());
                ++n;
            }
        }
        return actionScriptScribe;
    }

    public static StringBuffer appendMethodName(StringBuffer stringBuffer, MethodBinding methodBinding, boolean bl, boolean bl2) {
        if (bl) {
            stringBuffer.append(methodBinding.selector);
        } else {
            if (methodBinding.isConstructor()) {
                if (bl2) {
                    stringBuffer.append(Util.getTypeName((TypeBinding)methodBinding.declaringClass, false, false));
                    return stringBuffer;
                }
                if (methodBinding.declaringClass.id == 11) {
                    stringBuffer.append("__init");
                } else {
                    stringBuffer.append(Util.getTypeName((TypeBinding)methodBinding.declaringClass, false, false));
                }
            } else {
                stringBuffer.append(methodBinding.selector);
            }
            stringBuffer.append("__");
            if (methodBinding instanceof ParameterizedMethodBinding) {
                methodBinding = methodBinding.original();
            }
            int n = 0;
            int n2 = methodBinding.parameters.length;
            while (n < n2) {
                Util.appendSignature(stringBuffer, methodBinding.parameters[n].signature());
                ++n;
            }
        }
        return stringBuffer;
    }

    public static void mapLine(ActionScriptSourceGenerator actionScriptSourceGenerator, ActionScriptScribe actionScriptScribe, ASTNode aSTNode) {
        Util.mapLine(actionScriptSourceGenerator, actionScriptScribe, aSTNode, actionScriptSourceGenerator.lineNumberStart, actionScriptSourceGenerator.lineNumberEnd);
    }

    public static void mapLine(ActionScriptSourceGenerator actionScriptSourceGenerator, ActionScriptScribe actionScriptScribe, ASTNode aSTNode, int n, int n2) {
        int n3 = n == n2 ? n : org.eclipse.jdt.internal.compiler.util.Util.getLineNumber((int)aSTNode.sourceStart(), (int[])actionScriptSourceGenerator.lineSeparators, (int)(n - 1), (int)(n2 - 1));
        if (n3 > actionScriptScribe.currentMappedLineNumber) {
            actionScriptScribe.setCurrentMappedLineNumber(n3);
        }
    }

    public static void appendOpeningParenthesis(ActionScriptSourceGenerator actionScriptSourceGenerator, ActionScriptScribe actionScriptScribe, Expression expression, BlockScope blockScope) {
        Util.mapLine(actionScriptSourceGenerator, actionScriptScribe, (ASTNode)expression);
        int n = (expression.bits & 0x1FE00000) >> 21;
        int n2 = 0;
        while (n2 < n) {
            actionScriptScribe.append('(');
            ++n2;
        }
        if (Util.isBoxing(expression)) {
            Util.boxedExpression(actionScriptScribe, expression, blockScope);
        }
    }

    public static void boxedExpression(ActionScriptScribe actionScriptScribe, Expression expression, BlockScope blockScope) {
        TypeBinding typeBinding = blockScope.environment().computeBoxingType(expression.resolvedType);
        MethodBinding methodBinding = Util.retrieveConstructor(expression.resolvedType, (ReferenceBinding)typeBinding);
        if (methodBinding == null) {
            return;
        }
        Util.dumpWrapperType(actionScriptScribe, typeBinding, methodBinding);
    }

    public static void dumpWrapperType(ActionScriptScribe actionScriptScribe, TypeBinding typeBinding, MethodBinding methodBinding) {
        actionScriptScribe.append("new ");
        char[] cArray = typeBinding.constantPoolName();
        cArray = CharOperation.replaceOnCopy((char[])cArray, (char)'/', (char)'.');
        actionScriptScribe.append(cArray);
        actionScriptScribe.append("(new java.lang.Arguments(");
        Util.dumpConstructorFieldReference(actionScriptScribe, methodBinding);
        actionScriptScribe.append(", [");
    }

    public static void appendClosingParenthesis(ActionScriptScribe actionScriptScribe, Expression expression, BlockScope blockScope) {
        if (Util.isBoxing(expression)) {
            actionScriptScribe.append("]))");
        } else if (Util.isUnBoxing(expression)) {
            Util.unboxedExpression(actionScriptScribe, expression, blockScope);
        }
        int n = (expression.bits & 0x1FE00000) >> 21;
        int n2 = 0;
        while (n2 < n) {
            actionScriptScribe.append(')');
            ++n2;
        }
    }

    public static void unboxedExpression(ActionScriptScribe actionScriptScribe, Expression expression, BlockScope blockScope) {
        TypeBinding typeBinding = blockScope.environment().computeBoxingType(expression.resolvedType);
        switch (typeBinding.id) {
            case 3: {
                actionScriptScribe.append(".byteValue__()");
                break;
            }
            case 4: {
                actionScriptScribe.append(".shortValue__()");
                break;
            }
            case 2: {
                actionScriptScribe.append(".charValue__()");
                break;
            }
            case 10: {
                actionScriptScribe.append(".intValue__()");
                break;
            }
            case 7: {
                actionScriptScribe.append(".longValue__()");
                break;
            }
            case 9: {
                actionScriptScribe.append(".floatValue__()");
                break;
            }
            case 8: {
                actionScriptScribe.append(".doubleValue__()");
                break;
            }
            case 5: {
                actionScriptScribe.append(".booleanValue__()");
            }
        }
    }

    public static String appendConstant(ActionScriptScribe actionScriptScribe, Constant constant) {
        switch (constant.typeID()) {
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                actionScriptScribe.append(constant.intValue());
                break;
            }
            case 7: {
                long l = constant.longValue();
                if (l < -9007199254740992L) {
                    actionScriptScribe.append(-1);
                    return "long literal underflow";
                }
                if (l > 0x20000000000000L) {
                    actionScriptScribe.append(-1);
                    return "long literal overflow";
                }
                actionScriptScribe.append(l);
                break;
            }
            case 5: {
                if (constant.booleanValue()) {
                    actionScriptScribe.append("true");
                    break;
                }
                actionScriptScribe.append("false");
                break;
            }
            case 8: {
                double d = constant.doubleValue();
                if (d > 0.0) {
                    if (d < 9.9E-324) {
                        actionScriptScribe.append(-1);
                        return "double constant underflow";
                    }
                    if (d > 1.79769313486231E308) {
                        actionScriptScribe.append(-1);
                        return "double constant overflow";
                    }
                } else if (d < 0.0) {
                    if (d > -9.9E-324) {
                        actionScriptScribe.append(-1);
                        return "double constant underflow";
                    }
                    if (d < -1.79769313486231E308) {
                        actionScriptScribe.append(-1);
                        return "double constant overflow";
                    }
                }
                actionScriptScribe.append(d);
                break;
            }
            case 9: {
                actionScriptScribe.append(constant.doubleValue());
                break;
            }
            case 11: {
                Util.appendString(actionScriptScribe, constant.stringValue());
                break;
            }
            case 12: {
                actionScriptScribe.append("null");
            }
        }
        return null;
    }

    public static void appendString(ActionScriptScribe actionScriptScribe, String string) {
        char[] cArray = string.toCharArray();
        actionScriptScribe.append('\"');
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            switch (c) {
                case '\b': {
                    actionScriptScribe.append("\\b");
                    break;
                }
                case '\t': {
                    actionScriptScribe.append("\\t");
                    break;
                }
                case '\n': {
                    actionScriptScribe.append("\\n");
                    break;
                }
                case '\f': {
                    actionScriptScribe.append("\\f");
                    break;
                }
                case '\r': {
                    actionScriptScribe.append("\\r");
                    break;
                }
                case '\"': {
                    actionScriptScribe.append("\\\"");
                    break;
                }
                case '\'': {
                    actionScriptScribe.append("\\'");
                    break;
                }
                case '\\': {
                    actionScriptScribe.append("\\\\");
                    break;
                }
                default: {
                    if (c <= '\u000f') {
                        actionScriptScribe.append("\\u000");
                        actionScriptScribe.append(Integer.toHexString(c));
                        break;
                    }
                    if (c < ' ') {
                        actionScriptScribe.append("\\u00");
                        actionScriptScribe.append(Integer.toHexString(c));
                        break;
                    }
                    if (c < '\u0080') {
                        actionScriptScribe.append(c);
                        break;
                    }
                    if (c < '\u0100') {
                        actionScriptScribe.append("\\u00");
                        actionScriptScribe.append(Integer.toHexString(c));
                        break;
                    }
                    if (c < '\u1000') {
                        actionScriptScribe.append("\\u0");
                        actionScriptScribe.append(Integer.toHexString(c));
                        break;
                    }
                    actionScriptScribe.append("\\u");
                    actionScriptScribe.append(Integer.toHexString(c));
                }
            }
            ++n;
        }
        actionScriptScribe.append('\"');
    }

    static boolean hasFieldInitializers(TypeDeclaration typeDeclaration) {
        int n = 0;
        int n2 = typeDeclaration.fields == null ? 0 : typeDeclaration.fields.length;
        while (n < n2) {
            FieldDeclaration fieldDeclaration = typeDeclaration.fields[n];
            if (fieldDeclaration.getKind() == 2 && !fieldDeclaration.isStatic()) {
                return true;
            }
            if (Util.containsThisReference(fieldDeclaration, typeDeclaration.initializerScope)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static boolean isDefaultConstructor(MethodBinding methodBinding) {
        Boolean bl = (Boolean)defaultConstructorsRegistry.get(methodBinding);
        if (bl != null) {
            return bl;
        }
        try {
            AbstractMethodDeclaration abstractMethodDeclaration = methodBinding.sourceMethod();
            if (abstractMethodDeclaration != null && abstractMethodDeclaration.isDefaultConstructor() && !abstractMethodDeclaration.binding.declaringClass.isNestedType()) {
                defaultConstructorsRegistry.put(methodBinding, Boolean.TRUE);
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {}
        defaultConstructorsRegistry.put(methodBinding, Boolean.FALSE);
        return false;
    }

    public static boolean isSingleConstructor(MethodBinding methodBinding) {
        if (!methodBinding.isConstructor()) {
            return false;
        }
        MethodBinding[] methodBindingArray = methodBinding.declaringClass.methods();
        int n = 0;
        int n2 = methodBindingArray.length;
        int n3 = 0;
        while (n < n2) {
            if (methodBindingArray[n].isConstructor() && ++n3 > 1) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String methodKey(MethodBinding methodBinding) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(methodBinding.selector);
        stringBuffer.append(methodBinding.signature());
        return stringBuffer.toString();
    }

    public static String operatorToString(OperatorExpression operatorExpression) {
        switch ((operatorExpression.bits & 0xFC0) >> 6) {
            case 18: {
                return "===";
            }
            case 29: {
                return "!==";
            }
        }
        return operatorExpression.operatorToString();
    }

    public static void registerDefaultConstructor(MethodBinding methodBinding) {
        defaultConstructorsRegistry.put(methodBinding, Boolean.TRUE);
    }

    public static char[] shortTypeName(TypeBinding typeBinding) {
        char[] cArray = (char[])typeNamesRegistry.get(typeBinding);
        if (cArray == null) {
            char[] cArray2;
            if (typeBinding.isTypeVariable()) {
                typeBinding = ((TypeVariableBinding)typeBinding).upperBound();
            }
            cArray = typeBinding.isNestedType() ? CharOperation.lastSegment((char[])typeBinding.constantPoolName(), (char)'/') : typeBinding.shortReadableName();
            CharOperation.replace((char[])cArray, (char)'.', (char)'$');
            if (CharOperation.indexOf((char)'<', (char[])cArray) != -1) {
                int n = cArray.length;
                int n2 = 0;
                StringBuffer stringBuffer = new StringBuffer(n);
                int n3 = 0;
                while (n3 < n) {
                    char c = cArray[n3];
                    if (c == '<') {
                        ++n2;
                    } else {
                        c = cArray[n3];
                        if (c == '>') {
                            --n2;
                        } else if (n2 == 0) {
                            stringBuffer.append(c);
                        }
                    }
                    ++n3;
                }
                cArray = stringBuffer.toString().toCharArray();
            }
            if (!Util.isIntrinsic(typeBinding) && (cArray2 = (char[])recodedTypeNames.get(new String(cArray))) != null) {
                cArray = cArray2;
            }
            typeNamesRegistry.put(typeBinding, cArray);
        }
        return cArray;
    }

    public static char[][] split(char[] cArray, char c) {
        char[] cArray2;
        int n;
        int n2 = cArray.length;
        char[][] cArrayArray = new char[n2][];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < n2) {
            if (cArray[n3] == c) {
                n = n3 - n5;
                if (n > 0) {
                    cArray2 = new char[n];
                    System.arraycopy(cArray, n5, cArray2, 0, n);
                    cArrayArray[n4++] = cArray2;
                }
                n5 = n3 + 1;
            }
            ++n3;
        }
        n = n3 - n5;
        if (n > 0) {
            cArray2 = new char[n];
            System.arraycopy(cArray, n5, cArray2, 0, n);
            cArrayArray[n4++] = cArray2;
        }
        if (n4 < n2) {
            char[][] cArrayArray2 = cArrayArray;
            cArrayArray = new char[n4][];
            System.arraycopy(cArrayArray2, 0, cArrayArray, 0, n4);
        }
        return cArrayArray;
    }

    public static int compareTo(char[] cArray, char[] cArray2) {
        return new String(cArray).compareTo(new String(cArray2));
    }

    public static MethodBinding findExactMethod(ReferenceBinding referenceBinding, char[] cArray, TypeBinding[] typeBindingArray) {
        MethodBinding[] methodBindingArray = referenceBinding.getMethods(cArray);
        switch (methodBindingArray.length) {
            case 0: {
                return null;
            }
            case 1: {
                return methodBindingArray[0];
            }
        }
        int n = typeBindingArray.length;
        int n2 = 0;
        int n3 = methodBindingArray.length;
        while (n2 < n3) {
            block8: {
                MethodBinding methodBinding = methodBindingArray[n2];
                if (methodBinding.parameters.length == n) {
                    int n4 = n;
                    while (--n4 >= 0) {
                        if (methodBinding.parameters[n4] == typeBindingArray[n4]) {
                            continue;
                        }
                        break block8;
                    }
                    return methodBinding;
                }
            }
            ++n2;
        }
        return null;
    }

    public static MethodBinding findExactMethod(ReferenceBinding referenceBinding, MethodBinding methodBinding) {
        MethodBinding[] methodBindingArray = referenceBinding.getMethods(methodBinding.selector);
        switch (methodBindingArray.length) {
            case 0: {
                return null;
            }
            case 1: {
                if (methodBinding.areParameterErasuresEqual(methodBindingArray[0])) {
                    return methodBindingArray[0];
                }
                return null;
            }
        }
        int n = 0;
        int n2 = methodBindingArray.length;
        while (n < n2) {
            MethodBinding methodBinding2 = methodBindingArray[n];
            if (methodBinding.areParameterErasuresEqual(methodBinding2)) {
                return methodBinding2;
            }
            ++n;
        }
        return null;
    }

    public static String typeName(TypeBinding typeBinding, boolean bl) {
        return new String(Util.getTypeName(typeBinding, bl, false));
    }

    public static boolean isBoxing(Expression expression) {
        return (expression.implicitConversion & 0x200) != 0;
    }

    public static boolean isUnBoxing(Expression expression) {
        return (expression.implicitConversion & 0x400) != 0;
    }

    public static MethodBinding retrieveConstructor(TypeBinding typeBinding, ReferenceBinding referenceBinding) {
        MethodBinding[] methodBindingArray = referenceBinding.methods();
        int n = 0;
        int n2 = methodBindingArray.length;
        while (n < n2) {
            MethodBinding methodBinding = methodBindingArray[n];
            if (methodBinding.isConstructor()) {
                TypeBinding typeBinding2;
                TypeBinding[] typeBindingArray = methodBinding.parameters;
                if (typeBinding == null ? typeBindingArray.length == 0 : typeBindingArray.length == 1 && ((typeBinding2 = typeBindingArray[0]).isBaseType() ? typeBinding2 == typeBinding : typeBinding != null && typeBinding2.isCompatibleWith(typeBinding))) {
                    return methodBinding;
                }
            }
            ++n;
        }
        return null;
    }

    public static int getOrdinalValue(FieldDeclaration fieldDeclaration) {
        FieldBinding fieldBinding = fieldDeclaration.binding;
        ReferenceBinding referenceBinding = fieldBinding.declaringClass;
        FieldBinding[] fieldBindingArray = referenceBinding.fields();
        int n = 0;
        int n2 = fieldBindingArray.length;
        while (n < n2) {
            FieldBinding fieldBinding2 = fieldBindingArray[n];
            if (fieldBinding2 == fieldBinding) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public static FieldBinding[] getEnumConstants(SourceTypeBinding sourceTypeBinding) {
        ArrayList<FieldBinding> arrayList = new ArrayList<FieldBinding>();
        FieldBinding[] fieldBindingArray = sourceTypeBinding.fields();
        int n = 0;
        int n2 = fieldBindingArray.length;
        while (n < n2) {
            FieldBinding fieldBinding = fieldBindingArray[n];
            if ((fieldBinding.modifiers & 0x4000) != 0) {
                arrayList.add(fieldBinding);
            }
            ++n;
        }
        FieldBinding[] fieldBindingArray2 = new FieldBinding[arrayList.size()];
        arrayList.toArray(fieldBindingArray2);
        return fieldBindingArray2;
    }

    public static int getOrdinalValue(FieldBinding fieldBinding) {
        ReferenceBinding referenceBinding = fieldBinding.declaringClass;
        FieldBinding[] fieldBindingArray = referenceBinding.fields();
        int n = 0;
        int n2 = fieldBindingArray.length;
        while (n < n2) {
            if (fieldBindingArray[n] == fieldBinding) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static boolean isExcluded(FieldBinding fieldBinding) {
        if (CharOperation.equals((char[])fieldBinding.name, (char[])CLASS$0)) {
            return true;
        }
        if (fieldBinding.declaringClass.isEnum() && !CharOperation.equals((char[])fieldBinding.name, (char[])TypeConstants.SYNTHETIC_ENUM_VALUES)) {
            return true;
        }
        if (CharOperation.indexOf((char[])TypeConstants.SYNTHETIC_SWITCH_ENUM_TABLE, (char[])fieldBinding.name, (boolean)true) != -1) {
            return true;
        }
        if (CharOperation.equals((char[])TypeConstants.SYNTHETIC_ASSERT_DISABLED, (char[])fieldBinding.name)) {
            return true;
        }
        return CharOperation.indexOf((char[])TypeConstants.SYNTHETIC_CLASS, (char[])fieldBinding.name, (boolean)true) != -1;
    }

    public static boolean containsThisReference(FieldDeclaration fieldDeclaration, MethodScope methodScope) {
        if (fieldDeclaration.initialization == null || fieldDeclaration.binding.isStatic()) {
            return false;
        }
        class ThisReferenceVisitor
        extends ASTVisitor {
            boolean found;

            ThisReferenceVisitor() {
                this.found = false;
            }

            public boolean visit(ThisReference thisReference, BlockScope blockScope) {
                this.found = true;
                return false;
            }
        }
        ThisReferenceVisitor thisReferenceVisitor = new ThisReferenceVisitor();
        fieldDeclaration.initialization.traverse((ASTVisitor)thisReferenceVisitor, (BlockScope)methodScope);
        return thisReferenceVisitor.found;
    }

    public static char[] getSyntheticFieldName(FieldDeclaration fieldDeclaration) {
        boolean bl;
        char[] cArray = CharOperation.concat((char[])new char[]{'_'}, (char[])fieldDeclaration.name);
        FieldBinding[] fieldBindingArray = fieldDeclaration.binding.declaringClass.fields();
        do {
            bl = false;
            int n = 0;
            while (n < fieldBindingArray.length) {
                FieldBinding fieldBinding = fieldBindingArray[n];
                if (CharOperation.equals((char[])cArray, (char[])fieldBinding.name)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) continue;
            cArray = CharOperation.concat((char[])new char[]{'_'}, (char[])cArray);
        } while (bl);
        return cArray;
    }

    public static void dumpMapFile(String string) {
        block15: {
            FilterInputStream filterInputStream = null;
            try {
                try {
                    filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
                    System.out.println("java source folder : " + ((DataInputStream)filterInputStream).readUTF());
                    System.out.println("java qualified name : " + ((DataInputStream)filterInputStream).readUTF());
                    int n = ((DataInputStream)filterInputStream).readInt();
                    int n2 = 0;
                    while (n2 < n) {
                        System.out.print(" as line number : ");
                        System.out.print(((DataInputStream)filterInputStream).readInt());
                        System.out.print(" java line number : ");
                        System.out.println(((DataInputStream)filterInputStream).readInt());
                        ++n2;
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if (filterInputStream != null) {
                        try {
                            filterInputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (filterInputStream != null) {
                    try {
                        filterInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean shouldFullyQualified(QualifiedNameReference qualifiedNameReference) {
        boolean bl = true;
        char[][] cArray = Util.split(qualifiedNameReference.actualReceiverType.qualifiedPackageName(), '.');
        char[][] cArray2 = Util.split(qualifiedNameReference.actualReceiverType.qualifiedSourceName(), '.');
        int n = 0;
        while (n < cArray.length) {
            if (n >= qualifiedNameReference.tokens.length || Util.compareTo(cArray[n], qualifiedNameReference.tokens[n]) != 0) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            int n2 = 0;
            while (n2 < cArray2.length) {
                if (n >= qualifiedNameReference.tokens.length || Util.compareTo(cArray2[n2], qualifiedNameReference.tokens[n]) != 0) {
                    bl = false;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    public static boolean isUnreachable(ASTNode aSTNode) {
        if (aSTNode == null) {
            return false;
        }
        if (aSTNode instanceof Block) {
            Block block = (Block)aSTNode;
            Statement[] statementArray = block.statements;
            if (statementArray == null || statementArray.length == 0) {
                return false;
            }
            return (statementArray[0].bits & Integer.MIN_VALUE) == 0;
        }
        return (aSTNode.bits & Integer.MIN_VALUE) == 0;
    }
}

