/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.animation;

import org.eclipse.nebula.animation.effects.IEffect;
import org.eclipse.swt.widgets.Display;

public class AnimationRunner {
    int delay = 20;
    IEffect effect;
    boolean running = false;

    public AnimationRunner() {
        this(50);
    }

    public AnimationRunner(int n) {
        this.delay = 1000 / n;
    }

    public void runEffect(IEffect iEffect) {
        this.cancel();
        this.effect = iEffect;
        this.startEffect();
    }

    public void cancel() {
        if (this.effect != null && !this.effect.isDone()) {
            this.effect.cancel();
            this.effect = null;
        }
    }

    private void startEffect() {
        if (this.running) {
            return;
        }
        this.running = true;
        Display.getCurrent().syncExec(new Runnable(){

            public void run() {
                if (!AnimationRunner.this.effect.isDone()) {
                    Display.getCurrent().timerExec(AnimationRunner.this.delay, (Runnable)this);
                    AnimationRunner.this.effect.doEffect();
                } else {
                    AnimationRunner.this.running = false;
                }
            }
        });
    }
}

