/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.animation;

import org.eclipse.nebula.animation.effects.MoveScrollBarEffect;
import org.eclipse.nebula.animation.movement.IMovement;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public class ScrollingSmoother {
    Scrollable component;
    ScrollBar verticalScrollBar;
    ScrollBar horizontalScrollBar;
    MoveScrollBarEffect me = null;
    IMovement movement = null;
    Listener mouseWheelListener = new Listener(){

        public void handleEvent(Event event) {
            int n;
            event.doit = false;
            ScrollBar scrollBar = ScrollingSmoother.this.getScrollbar(event);
            int n2 = n = scrollBar.getSelection();
            if (ScrollingSmoother.this.me != null) {
                n = ScrollingSmoother.this.me.getCurrent();
                n2 = ScrollingSmoother.this.me.getEnd();
            }
            if ((n2 -= event.count * scrollBar.getIncrement()) > scrollBar.getMaximum() - scrollBar.getThumb()) {
                n2 = scrollBar.getMaximum() - scrollBar.getThumb();
            }
            if (n2 < scrollBar.getMinimum()) {
                n2 = scrollBar.getMinimum();
            }
            ScrollingSmoother.this.startEffect(new MoveScrollBarEffect(scrollBar, n, n2, 2000L, ScrollingSmoother.this.movement, null, null));
        }
    };
    SelectionListener cancelEffectIfUserSelection = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.widgetSelected(selectionEvent);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (!(selectionEvent.data instanceof MoveScrollBarEffect)) {
                ScrollingSmoother.this.me = null;
            }
        }
    };

    public ScrollingSmoother(Scrollable scrollable, IMovement iMovement) {
        this.component = scrollable;
        this.verticalScrollBar = scrollable.getVerticalBar();
        this.horizontalScrollBar = scrollable.getHorizontalBar();
        this.movement = iMovement;
    }

    protected ScrollBar getScrollbar(Event event) {
        ScrollBar scrollBar = this.verticalScrollBar;
        if (scrollBar == null) {
            scrollBar = this.horizontalScrollBar;
        }
        return scrollBar;
    }

    public void smoothControl(boolean bl) {
        if (bl) {
            this.component.addListener(37, this.mouseWheelListener);
            if (this.verticalScrollBar != null) {
                this.verticalScrollBar.addSelectionListener(this.cancelEffectIfUserSelection);
            }
            if (this.horizontalScrollBar != null) {
                this.horizontalScrollBar.addSelectionListener(this.cancelEffectIfUserSelection);
            }
        } else {
            this.component.removeListener(37, this.mouseWheelListener);
            if (this.verticalScrollBar != null) {
                this.verticalScrollBar.removeSelectionListener(this.cancelEffectIfUserSelection);
            }
            if (this.horizontalScrollBar != null) {
                this.horizontalScrollBar.removeSelectionListener(this.cancelEffectIfUserSelection);
            }
        }
    }

    protected void startEffect(MoveScrollBarEffect moveScrollBarEffect) {
        MoveScrollBarEffect moveScrollBarEffect2 = this.me;
        this.me = moveScrollBarEffect;
        if (moveScrollBarEffect2 == null) {
            Display.getCurrent().syncExec(new Runnable(){

                public void run() {
                    if (ScrollingSmoother.this.me != null && !ScrollingSmoother.this.me.isDone()) {
                        ScrollingSmoother.this.me.doEffect();
                        Display.getCurrent().timerExec(10, (Runnable)this);
                    } else {
                        ScrollingSmoother.this.me = null;
                    }
                }
            });
        }
    }
}

