/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.animation.effects;

import org.eclipse.nebula.animation.effects.IEffect;
import org.eclipse.nebula.animation.movement.IMovement;

public abstract class AbstractEffect
implements IEffect {
    protected Runnable runnableOnStop = null;
    protected Runnable runnableOnCancel = null;
    protected long length = 0L;
    protected long startTime = -1L;
    protected boolean done = false;
    protected IMovement easingFunction;

    public AbstractEffect(long l, IMovement iMovement, Runnable runnable, Runnable runnable2) {
        this.length = l;
        this.easingFunction = iMovement;
        this.runnableOnCancel = runnable2;
        this.runnableOnStop = runnable;
    }

    public abstract void applyEffect(long var1);

    protected void doCancel() {
        if (this.runnableOnCancel != null) {
            this.runnableOnCancel.run();
        }
    }

    protected void doStop() {
        if (this.runnableOnStop != null) {
            this.runnableOnStop.run();
        }
    }

    public long getCurrentTime() {
        long l;
        long l2 = System.currentTimeMillis();
        if (this.startTime == -1L) {
            this.startTime = l2;
        }
        if ((l = l2 - this.startTime) > this.length) {
            l = this.length;
        }
        return l;
    }

    public void processEnd() {
        if (this.done) {
            return;
        }
        if (this.getCurrentTime() == this.length) {
            this.done = true;
            this.doStop();
        }
    }

    public void cancel() {
        this.done = true;
        this.doCancel();
    }

    public void doEffect() {
        long l = this.getCurrentTime();
        this.applyEffect(l);
        this.processEnd();
    }

    public boolean isDone() {
        return this.done;
    }
}

