/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.jface.galleryviewer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.nebula.jface.galleryviewer.FlatTreeContentProvider;
import org.eclipse.nebula.jface.galleryviewer.GalleryViewerRow;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class GalleryTreeViewer
extends AbstractTreeViewer {
    protected Gallery gallery;
    protected boolean preservingSelection;
    private GalleryViewerRow cachedRow;

    public GalleryTreeViewer(Composite composite) {
        this(composite, 2562);
    }

    public GalleryTreeViewer(Composite composite, int n) {
        this.gallery = new Gallery(composite, n);
        this.gallery.setGroupRenderer(new DefaultGalleryGroupRenderer());
        this.gallery.setItemRenderer(new DefaultGalleryItemRenderer());
        super.setAutoExpandLevel(-1);
        this.hookControl((Control)this.gallery);
    }

    public GalleryTreeViewer(Gallery gallery) {
        this.gallery = gallery;
        super.setAutoExpandLevel(-1);
        this.hookControl((Control)gallery);
    }

    protected void addTreeListener(Control control, TreeListener treeListener) {
        ((Gallery)control).addTreeListener(treeListener);
    }

    protected Item getChild(Widget widget, int n) {
        if (widget instanceof GalleryItem) {
            return ((GalleryItem)widget).getItem(n);
        }
        if (widget instanceof Gallery) {
            return ((Gallery)widget).getItem(n);
        }
        return null;
    }

    protected Item[] getChildren(Widget widget) {
        if (widget instanceof GalleryItem) {
            return ((GalleryItem)widget).getItems();
        }
        if (widget instanceof Gallery) {
            return ((Gallery)widget).getItems();
        }
        return null;
    }

    protected Widget getColumnViewerOwner(int n) {
        if (n == 0) {
            return this.getGallery();
        }
        return null;
    }

    protected boolean getExpanded(Item item) {
        return ((GalleryItem)item).isExpanded();
    }

    protected int getItemCount(Control control) {
        return ((Gallery)control).getItemCount();
    }

    protected int getItemCount(Item item) {
        return ((GalleryItem)item).getItemCount();
    }

    protected Item[] getItems(Item item) {
        return ((GalleryItem)item).getItems();
    }

    protected Item getParentItem(Item item) {
        return ((GalleryItem)item).getParentItem();
    }

    protected Item[] getSelection(Control control) {
        Item[] itemArray = ((Gallery)control).getSelection();
        if (itemArray == null) {
            return new GalleryItem[0];
        }
        ArrayList<Item> arrayList = new ArrayList<Item>(itemArray.length);
        int n = 0;
        while (n < itemArray.length) {
            if (!itemArray[n].isDisposed()) {
                arrayList.add(itemArray[n]);
            } else {
                System.out.println("GalleryItem was disposed (ignoring)");
            }
            ++n;
        }
        itemArray = arrayList.toArray(new GalleryItem[arrayList.size()]);
        return itemArray;
    }

    protected Item newItem(Widget widget, int n, int n2) {
        GalleryItem galleryItem = widget instanceof GalleryItem ? (GalleryItem)this.createNewRowPart(this.getViewerRowFromItem(widget), n, n2).getItem() : (GalleryItem)this.createNewRowPart(null, n, n2).getItem();
        return galleryItem;
    }

    protected void removeAll(Control control) {
        ((Gallery)control).removeAll();
    }

    public void setAutoExpandLevel(int n) {
        throw new UnsupportedOperationException("Gallery must be fully expanded.");
    }

    public void setContentProvider(IContentProvider iContentProvider) {
        if (iContentProvider instanceof IStructuredContentProvider && !(iContentProvider instanceof ITreeContentProvider) && !(iContentProvider instanceof ITreePathContentProvider)) {
            super.setContentProvider((IContentProvider)new FlatTreeContentProvider((IStructuredContentProvider)iContentProvider));
        } else {
            super.setContentProvider(iContentProvider);
        }
    }

    protected void setExpanded(Item item, boolean bl) {
        ((GalleryItem)item).setExpanded(bl);
    }

    protected void setSelection(List list) {
        Item[] itemArray = this.getSelection((Control)this.getGallery());
        if (this.isSameSelection(list, itemArray)) {
            return;
        }
        GalleryItem[] galleryItemArray = new GalleryItem[list.size()];
        list.toArray(galleryItemArray);
        this.getGallery().setSelection(galleryItemArray);
    }

    protected void showItem(Item item) {
        this.gallery.showItem((GalleryItem)item);
    }

    public Control getControl() {
        return this.gallery;
    }

    public Gallery getGallery() {
        return this.gallery;
    }

    protected Item getItemAt(Point point) {
        return this.gallery.getItem(point);
    }

    protected ColumnViewerEditor createViewerEditor() {
        return null;
    }

    public void setChildCount(final Object object, final int n) {
        this.preservingSelection(new Runnable(){

            public void run() {
                if (GalleryTreeViewer.this.internalIsInputOrEmptyPath(object)) {
                    GalleryTreeViewer.this.getGallery().setItemCount(n);
                    return;
                }
                Widget[] widgetArray = GalleryTreeViewer.this.internalFindItems(object);
                int n2 = 0;
                while (n2 < widgetArray.length) {
                    GalleryItem galleryItem = (GalleryItem)widgetArray[n2];
                    galleryItem.setItemCount(n);
                    ++n2;
                }
            }
        });
    }

    protected ViewerRow getViewerRowFromItem(Widget widget) {
        if (this.cachedRow == null) {
            this.cachedRow = new GalleryViewerRow((GalleryItem)widget);
        } else {
            this.cachedRow.setItem((GalleryItem)widget);
        }
        return this.cachedRow;
    }

    private ViewerRow createNewRowPart(ViewerRow viewerRow, int n, int n2) {
        if (viewerRow == null) {
            if (n2 >= 0) {
                return this.getViewerRowFromItem((Widget)new GalleryItem(this.gallery, n, n2));
            }
            return this.getViewerRowFromItem((Widget)new GalleryItem(this.gallery, n));
        }
        if (n2 >= 0) {
            return this.getViewerRowFromItem((Widget)new GalleryItem((GalleryItem)viewerRow.getItem(), 0, n2));
        }
        return this.getViewerRowFromItem((Widget)new GalleryItem((GalleryItem)viewerRow.getItem(), 0));
    }

    public void remove(final Object object, final int n) {
        final LinkedList<TreePath> linkedList = new LinkedList<TreePath>(Arrays.asList(((TreeSelection)this.getSelection()).getPaths()));
        this.preservingSelection(new Runnable(){

            public void run() {
                GalleryItem galleryItem;
                Object object2;
                Widget[] widgetArray;
                TreePath treePath = null;
                if (GalleryTreeViewer.this.internalIsInputOrEmptyPath(object)) {
                    widgetArray = (Widget[])GalleryTreeViewer.this.getControl();
                    if (n < widgetArray.getItemCount()) {
                        object2 = widgetArray.getItem(n);
                        if (object2.getData() != null) {
                            treePath = GalleryTreeViewer.this.getTreePathFromItem(object2);
                            GalleryTreeViewer.this.disassociate(object2);
                        }
                        object2.dispose();
                    }
                } else {
                    widgetArray = GalleryTreeViewer.this.internalFindItems(object);
                    int n2 = 0;
                    while (n2 < widgetArray.length) {
                        galleryItem = (GalleryItem)widgetArray[n2];
                        if (n < galleryItem.getItemCount()) {
                            GalleryItem galleryItem2 = galleryItem.getItem(n);
                            if (galleryItem2.getData() != null) {
                                treePath = GalleryTreeViewer.this.getTreePathFromItem(galleryItem2);
                                GalleryTreeViewer.this.disassociate(galleryItem2);
                            }
                            galleryItem2.dispose();
                        }
                        ++n2;
                    }
                }
                if (treePath != null) {
                    boolean bl = false;
                    object2 = linkedList.iterator();
                    while (object2.hasNext()) {
                        galleryItem = (TreePath)object2.next();
                        if (!galleryItem.startsWith(treePath, GalleryTreeViewer.this.getComparer())) continue;
                        object2.remove();
                        bl = true;
                    }
                    if (bl) {
                        GalleryTreeViewer.this.setSelection((ISelection)new TreeSelection(linkedList.toArray(new TreePath[linkedList.size()]), GalleryTreeViewer.this.getComparer()), false);
                    }
                }
            }
        });
    }

    public void editElement(Object object, int n) {
        if (object instanceof TreePath) {
            ViewerCell viewerCell;
            ViewerRow viewerRow;
            this.setSelection((ISelection)new TreeSelection((TreePath)object));
            GalleryItem[] galleryItemArray = this.gallery.getSelection();
            if (galleryItemArray.length == 1 && (viewerRow = this.getViewerRowFromItem((Widget)galleryItemArray[0])) != null && (viewerCell = viewerRow.getCell(n)) != null) {
                this.getControl().setRedraw(false);
                this.triggerEditorActivationEvent(new ColumnViewerEditorActivationEvent(viewerCell));
                this.getControl().setRedraw(true);
            }
        } else {
            super.editElement(object, n);
        }
    }
}

