/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.jface.galleryviewer;

import java.util.LinkedList;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class GalleryViewerRow
extends ViewerRow {
    protected GalleryItem item;

    public GalleryViewerRow(GalleryItem galleryItem) {
        this.item = galleryItem;
    }

    public void setItem(GalleryItem galleryItem) {
        this.item = galleryItem;
    }

    public Object clone() {
        return new GalleryViewerRow(this.item);
    }

    public Color getBackground(int n) {
        return this.item.getBackground();
    }

    public Rectangle getBounds() {
        return this.item.getBounds();
    }

    public Rectangle getBounds(int n) {
        return this.item.getBounds();
    }

    public int getColumnCount() {
        return 0;
    }

    public Control getControl() {
        return this.item.getParent();
    }

    public Object getElement() {
        return this.item.getData();
    }

    public Font getFont(int n) {
        return this.item.getFont();
    }

    public Color getForeground(int n) {
        return this.item.getForeground();
    }

    public Image getImage(int n) {
        return this.item.getImage();
    }

    public Widget getItem() {
        return this.item;
    }

    public ViewerRow getNeighbor(int n, boolean bl) {
        if (n == 1) {
            return this.getRowAbove();
        }
        if (n == 2) {
            return this.getRowBelow();
        }
        throw new IllegalArgumentException("Illegal value of direction argument.");
    }

    protected ViewerRow getRowAbove() {
        if (this.item.getParentItem() == null) {
            int n = this.item.getParent().indexOf(this.item) - 1;
            if (n >= 0) {
                return new GalleryViewerRow(this.item.getParent().getItem(n));
            }
        } else {
            GalleryItem galleryItem = this.item.getParentItem();
            int n = galleryItem.indexOf(this.item) - 1;
            if (n >= 0) {
                return new GalleryViewerRow(galleryItem.getItem(n));
            }
        }
        return null;
    }

    protected ViewerRow getRowBelow() {
        if (this.item.getParentItem() == null) {
            GalleryItem galleryItem;
            int n = this.item.getParent().indexOf(this.item) + 1;
            if (n < this.item.getParent().getItemCount() && (galleryItem = this.item.getParent().getItem(n)) != null) {
                return new GalleryViewerRow(galleryItem);
            }
        } else {
            GalleryItem galleryItem;
            GalleryItem galleryItem2 = this.item.getParentItem();
            int n = galleryItem2.indexOf(this.item) + 1;
            if (n < galleryItem2.getItemCount() && (galleryItem = galleryItem2.getItem(n)) != null) {
                return new GalleryViewerRow(galleryItem);
            }
        }
        return null;
    }

    public String getText(int n) {
        return this.item.getText();
    }

    public TreePath getTreePath() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(this.item.getData());
        GalleryItem galleryItem = this.item;
        while (galleryItem.getParentItem() != null) {
            linkedList.addFirst(galleryItem.getParentItem().getData());
            galleryItem = galleryItem.getParentItem();
        }
        return new TreePath(linkedList.toArray());
    }

    public void setBackground(int n, Color color) {
        this.item.setBackground(color);
    }

    public void setFont(int n, Font font) {
        this.item.setFont(font);
    }

    public void setForeground(int n, Color color) {
        this.item.setForeground(color);
    }

    public void setImage(int n, Image image) {
        Image image2 = this.item.getImage();
        if (image != image2) {
            this.item.setImage(image);
        }
    }

    public void setText(int n, String string) {
        this.item.setText(string == null ? "" : string);
    }
}

