/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.gallery;

import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public abstract class AbstractGalleryItemRenderer {
    public static final String OVERLAY_BOTTOM_RIGHT = "org.eclipse.nebula.widget.gallery.bottomRightOverlay";
    public static final String OVERLAY_BOTTOM_LEFT = "org.eclipse.nebula.widget.gallery.bottomLeftOverlay";
    public static final String OVERLAY_TOP_RIGHT = "org.eclipse.nebula.widget.gallery.topRightOverlay";
    public static final String OVERLAY_TOP_LEFT = "org.eclipse.nebula.widget.gallery.topLeftOverlay";
    protected static final String EMPTY_STRING = "";
    protected Gallery gallery;
    protected boolean selected;

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public abstract void draw(GC var1, GalleryItem var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void dispose();

    public void preDraw(GC gC) {
    }

    public Gallery getGallery() {
        return this.gallery;
    }

    public void setGallery(Gallery gallery) {
        this.gallery = gallery;
    }

    protected double getOverlayRatio(Point point, Point point2, Point point3, Point point4, Point point5) {
        double d = 1.0;
        if (point2.x + point3.x > point.x) {
            d = Math.min(d, (double)point.x / (double)(point2.x + point3.x));
        }
        if (point4.x + point5.x > point.x) {
            d = Math.min(d, (double)point.x / (double)(point4.x + point5.x));
        }
        if (point2.y + point4.y > point.y) {
            d = Math.min(d, (double)point.y / (double)(point2.y + point4.y));
        }
        if (point3.y + point5.y > point.y) {
            d = Math.min(d, (double)point.y / (double)(point3.y + point5.y));
        }
        return d;
    }

    protected void drawAllOverlays(GC gC, GalleryItem galleryItem, int n, int n2, Point point, int n3, int n4) {
        Image[] imageArray = this.getImageOverlay(galleryItem, OVERLAY_BOTTOM_LEFT);
        Image[] imageArray2 = this.getImageOverlay(galleryItem, OVERLAY_BOTTOM_RIGHT);
        Image[] imageArray3 = this.getImageOverlay(galleryItem, OVERLAY_TOP_LEFT);
        Image[] imageArray4 = this.getImageOverlay(galleryItem, OVERLAY_TOP_RIGHT);
        Point point2 = this.getOverlaySize(imageArray);
        Point point3 = this.getOverlaySize(imageArray2);
        Point point4 = this.getOverlaySize(imageArray3);
        Point point5 = this.getOverlaySize(imageArray4);
        double d = this.getOverlayRatio(point, point4, point5, point2, point3);
        this.drawOverlayImages(gC, n + n3, n2 + n4, d, imageArray3);
        this.drawOverlayImages(gC, (int)((double)(n + n3 + point.x) - (double)point3.x * d), n2 + n4, d, imageArray4);
        this.drawOverlayImages(gC, n + n3, (int)((double)(n2 + n4 + point.y) - (double)point3.y * d), d, imageArray);
        this.drawOverlayImages(gC, (int)((double)(n + n3 + point.x) - (double)point3.x * d), (int)((double)(n2 + n4 + point.y) - (double)point3.y * d), d, imageArray2);
    }

    protected void drawOverlayImages(GC gC, int n, int n2, double d, Image[] imageArray) {
        if (imageArray == null) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < imageArray.length) {
            Image image = imageArray[n4];
            gC.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, n + n3, n2, (int)((double)image.getBounds().width * d), (int)((double)image.getBounds().height * d));
            n3 = (int)((double)n3 + (double)image.getBounds().width * d);
            ++n4;
        }
    }

    protected Point getOverlaySize(Image[] imageArray) {
        if (imageArray == null) {
            return new Point(0, 0);
        }
        Point point = new Point(0, 0);
        int n = 0;
        while (n < imageArray.length) {
            point.x += imageArray[n].getBounds().width;
            point.y = Math.max(point.y, imageArray[n].getBounds().height);
            ++n;
        }
        return point;
    }

    protected Image[] getImageOverlay(GalleryItem galleryItem, String string) {
        Object object = galleryItem.getData(string);
        if (object == null) {
            return null;
        }
        Image[] imageArray = null;
        if (object instanceof Image) {
            imageArray = new Image[]{(Image)object};
        }
        if (object instanceof Image[]) {
            imageArray = (Image[])object;
        }
        return imageArray;
    }
}

