/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.gallery;

import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public abstract class AbstractGridGroupRenderer
extends AbstractGalleryGroupRenderer {
    static final int DEFAULT_SIZE = 96;
    protected int minMargin;
    protected int margin;
    protected boolean autoMargin;
    protected int itemWidth = 96;
    protected int itemHeight = 96;
    public static final String H_COUNT = "g.h";
    public static final String V_COUNT = "g.v";
    private static final int END = 0;
    private static final int START = 1;
    private boolean alwaysExpanded = false;

    public void draw(GC gC, GalleryItem galleryItem, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public GalleryItem getItem(GalleryItem galleryItem, Point point) {
        return null;
    }

    public Rectangle getSize(GalleryItem galleryItem) {
        return null;
    }

    public void layout(GC gC, GalleryItem galleryItem) {
    }

    public boolean isAlwaysExpanded() {
        return this.alwaysExpanded;
    }

    protected boolean isGroupExpanded(GalleryItem galleryItem) {
        if (this.alwaysExpanded) {
            return true;
        }
        if (galleryItem == null) {
            return false;
        }
        return galleryItem.isExpanded();
    }

    public void setAlwaysExpanded(boolean bl) {
        this.alwaysExpanded = bl;
    }

    public int getMinMargin() {
        return this.minMargin;
    }

    public int getItemWidth() {
        return this.itemWidth;
    }

    public void setItemWidth(int n) {
        this.itemWidth = n;
        this.updateGallery();
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public void setItemHeight(int n) {
        this.itemHeight = n;
        this.updateGallery();
    }

    private void updateGallery() {
        if (this.gallery != null) {
            this.gallery.updateStructuralValues(null, true);
            this.gallery.updateScrollBarsProperties();
            this.gallery.redraw();
        }
    }

    public void setItemSize(int n, int n2) {
        this.itemHeight = n2;
        this.itemWidth = n;
        this.updateGallery();
    }

    public void setMinMargin(int n) {
        this.minMargin = n;
        this.updateGallery();
    }

    public boolean isAutoMargin() {
        return this.autoMargin;
    }

    public void setAutoMargin(boolean bl) {
        this.autoMargin = bl;
        this.updateGallery();
    }

    protected int calculateMargins(int n, int n2, int n3) {
        int n4 = this.minMargin;
        return n4 += Math.round((float)(n - this.minMargin - n2 * (n3 + this.minMargin)) / (float)(n2 + 1));
    }

    protected Point getSize(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        if (this.gallery.isVertical()) {
            n7 = n * n3 + (n - 1) * this.margin + 2 * n5;
            n8 = n2 * n4 + (n2 + 1) * n5;
        } else {
            n7 = n * n3 + (n + 1) * n5;
            n8 = n2 * n4 + (n2 - 1) * this.margin + 2 * n5;
        }
        return new Point(n7, n8);
    }

    protected void drawItem(GC gC, int n, boolean bl, GalleryItem galleryItem, int n2) {
        if (Gallery.DEBUG) {
            System.out.println("Draw item ? " + n);
        }
        if (n < galleryItem.getItemCount()) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = (Integer)galleryItem.getData(H_COUNT);
            int n8 = (Integer)galleryItem.getData(V_COUNT);
            if (Gallery.DEBUG) {
                System.out.println("hCount :  " + n7 + " vCount : " + n8);
            }
            if (this.gallery.isVertical()) {
                n6 = n % n7;
                n5 = (n - n6) / n7;
            } else {
                n5 = n % n8;
                n6 = (n - n5) / n8;
            }
            GalleryItem galleryItem2 = galleryItem.getItem(n);
            if (galleryItem2 == null) {
                return;
            }
            GalleryItem galleryItem3 = galleryItem2;
            if (this.gallery.isVertical()) {
                n4 = n6 * (this.itemWidth + this.margin) + this.margin;
                n3 = n5 * (this.itemHeight + this.minMargin) - this.gallery.translate + this.minMargin + (galleryItem == null ? 0 : galleryItem.y + n2);
                galleryItem3.x = n4;
                galleryItem3.y = n3 + this.gallery.translate;
            } else {
                n4 = n6 * (this.itemWidth + this.minMargin) - this.gallery.translate + this.minMargin + (galleryItem == null ? 0 : galleryItem.x + n2);
                n3 = n5 * (this.itemHeight + this.margin) + this.margin;
                galleryItem3.x = n4 + this.gallery.translate;
                galleryItem3.y = n3;
            }
            galleryItem3.height = this.itemHeight;
            galleryItem3.width = this.itemWidth;
            this.gallery.sendPaintItemEvent(galleryItem2, n, gC, n4, n3, this.itemWidth, this.itemHeight);
            if (this.gallery.getItemRenderer() != null) {
                this.gallery.getItemRenderer().setSelected(bl);
                if (Gallery.DEBUG) {
                    System.out.println("itemRender.draw");
                }
                Rectangle rectangle = gC.getClipping();
                gC.setClipping(rectangle.intersection(new Rectangle(n4, n3, this.itemWidth, this.itemHeight)));
                this.gallery.getItemRenderer().draw(gC, galleryItem3, n, n4, n3, this.itemWidth, this.itemHeight);
                gC.setClipping(rectangle);
                if (Gallery.DEBUG) {
                    System.out.println("itemRender done");
                }
            }
        }
    }

    protected int[] getVisibleItems(GalleryItem galleryItem, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int[] nArray;
        if (this.gallery.isVertical()) {
            int n8;
            int n9;
            int n10 = (Integer)galleryItem.getData(H_COUNT);
            int n11 = (n4 - n2 - n7 - this.minMargin) / (this.itemHeight + this.minMargin);
            if (n11 < 0) {
                n11 = 0;
            }
            int n12 = n11 * n10;
            if (Gallery.DEBUG) {
                System.out.println("First line : " + n11);
            }
            if ((n9 = (n4 - n2 - n7 + n6 - this.minMargin) / (this.itemHeight + this.minMargin)) < n11) {
                n9 = n11;
            }
            if (Gallery.DEBUG) {
                System.out.println("Last line : " + n9);
            }
            if ((n8 = (n9 + 1) * n10) - n12 == 0) {
                return null;
            }
            nArray = new int[n8 - n12];
            int n13 = 0;
            while (n13 < n8 - n12) {
                nArray[n13] = n12 + n13;
                ++n13;
            }
        } else {
            int n14;
            int n15;
            int n16 = (Integer)galleryItem.getData(V_COUNT);
            int n17 = (n3 - n - n7 - this.minMargin) / (this.itemWidth + this.minMargin);
            if (n17 < 0) {
                n17 = 0;
            }
            int n18 = n17 * n16;
            if (Gallery.DEBUG) {
                System.out.println("First line : " + n17);
            }
            if ((n15 = (n3 - n - n7 + n5 - this.minMargin) / (this.itemWidth + this.minMargin)) < n17) {
                n15 = n17;
            }
            if (Gallery.DEBUG) {
                System.out.println("Last line : " + n15);
            }
            if ((n14 = (n15 + 1) * n16) - n18 == 0) {
                return null;
            }
            nArray = new int[n14 - n18];
            int n19 = 0;
            while (n19 < n14 - n18) {
                nArray[n19] = n18 + n19;
                ++n19;
            }
        }
        return nArray;
    }

    protected Point gridLayout(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        if (n2 == 0) {
            return new Point(n4, n5);
        }
        n4 = (n - this.minMargin) / (n3 + this.minMargin);
        if (n4 > 0) {
            n5 = (int)Math.ceil((double)n2 / (double)n4);
        } else {
            n5 = n2;
            n4 = 1;
        }
        return new Point(n4, n5);
    }

    public void dispose() {
    }

    public boolean mouseDown(GalleryItem galleryItem, MouseEvent mouseEvent, Point point) {
        return false;
    }

    public void preLayout(GC gC) {
        this.margin = this.minMargin;
        super.preLayout(gC);
    }

    protected Point getLayoutData(GalleryItem galleryItem) {
        Integer n = (Integer)galleryItem.getData(H_COUNT);
        Integer n2 = (Integer)galleryItem.getData(V_COUNT);
        if (n == null || n2 == null) {
            return null;
        }
        return new Point(n.intValue(), n2.intValue());
    }

    protected Rectangle getSize(GalleryItem galleryItem, int n) {
        GalleryItem galleryItem2 = galleryItem.getParentItem();
        if (galleryItem2 != null) {
            int n2 = galleryItem2.indexOf(galleryItem);
            Point point = this.getLayoutData(galleryItem2);
            if (point == null) {
                return null;
            }
            int n3 = point.x;
            int n4 = point.y;
            if (Gallery.DEBUG) {
                System.out.println("hCount :  " + n3 + " vCount : " + n4);
            }
            if (this.gallery.isVertical()) {
                int n5 = n2 % n3;
                int n6 = (n2 - n5) / n3;
                int n7 = n5 * (this.itemWidth + this.margin) + this.margin;
                int n8 = n6 * (this.itemHeight + this.minMargin) + this.minMargin + (galleryItem2 == null ? 0 : galleryItem2.y + n);
                return new Rectangle(n7, n8, this.itemWidth, this.itemHeight);
            }
            int n9 = n2 % n4;
            int n10 = (n2 - n9) / n4;
            int n11 = n9 * (this.itemHeight + this.margin) + this.margin;
            int n12 = n10 * (this.itemWidth + this.minMargin) + this.minMargin + (galleryItem2 == null ? 0 : galleryItem2.x + n);
            return new Rectangle(n12, n11, this.itemWidth, this.itemHeight);
        }
        return null;
    }

    protected GalleryItem getItem(GalleryItem galleryItem, Point point, int n) {
        int n2;
        if (Gallery.DEBUG) {
            System.out.println("getitem " + point.x + " " + point.y);
        }
        if (this.gallery.isVertical()) {
            Integer n3 = (Integer)galleryItem.getData(H_COUNT);
            if (n3 == null) {
                return null;
            }
            int n4 = n3;
            int n5 = (point.x - this.margin) / (this.itemWidth + this.margin);
            int n6 = (point.x - this.margin) % (this.itemWidth + this.margin);
            if (n6 > this.itemWidth || n6 < 0) {
                return null;
            }
            if (n5 >= n4) {
                return null;
            }
            if (point.y - galleryItem.y - this.minMargin < n) {
                return null;
            }
            int n7 = (point.y - galleryItem.y - n - this.minMargin) / (this.itemHeight + this.minMargin);
            if ((point.y - galleryItem.y - n - this.minMargin) % (this.itemHeight + this.minMargin) > this.itemHeight) {
                return null;
            }
            n2 = n5 + n7 * n4;
        } else {
            Integer n8 = (Integer)galleryItem.getData(V_COUNT);
            if (n8 == null) {
                return null;
            }
            int n9 = n8;
            int n10 = (point.y - this.margin) / (this.itemHeight + this.margin);
            int n11 = (point.y - this.margin) % (this.itemHeight + this.margin);
            if (n11 > this.itemHeight || n11 < 0) {
                return null;
            }
            if (n10 >= n9) {
                return null;
            }
            if (point.x - galleryItem.x - this.minMargin < n) {
                return null;
            }
            int n12 = (point.x - galleryItem.x - n - this.minMargin) / (this.itemWidth + this.minMargin);
            if ((point.x - galleryItem.x - n - this.minMargin) % (this.itemWidth + this.minMargin) > this.itemWidth) {
                return null;
            }
            n2 = n10 + n12 * n9;
        }
        if (Gallery.DEBUG) {
            System.out.println("Item found : " + n2);
        }
        if (n2 < galleryItem.getItemCount()) {
            return galleryItem.getItem(n2);
        }
        return null;
    }

    private GalleryItem goLeft(GalleryItem galleryItem, int n) {
        int n2 = n - 1;
        if (n2 < 0) {
            return this.getFirstItem(this.getPreviousGroup(galleryItem), 0);
        }
        return galleryItem.getItem(n2);
    }

    private GalleryItem goRight(GalleryItem galleryItem, int n) {
        int n2 = n + 1;
        if (n2 >= galleryItem.getItemCount()) {
            return this.getFirstItem(this.getNextGroup(galleryItem), 1);
        }
        return galleryItem.getItem(n2);
    }

    private GalleryItem goUp(GalleryItem galleryItem, int n, int n2) {
        int n3 = n % n2;
        int n4 = n - n2;
        if (n4 < 0) {
            return this.getItemAt(this.getPreviousGroup(galleryItem), n3, 0);
        }
        return galleryItem.getItem(n4);
    }

    private GalleryItem goDown(GalleryItem galleryItem, int n, int n2) {
        int n3 = n % n2;
        int n4 = n + n2;
        if (n4 >= galleryItem.getItemCount()) {
            return this.getItemAt(this.getNextGroup(galleryItem), n3, 1);
        }
        return galleryItem.getItem(n4);
    }

    public GalleryItem getNextItem(GalleryItem galleryItem, int n) {
        if (galleryItem == null) {
            GalleryItem galleryItem2;
            if (this.gallery.getItemCount() > 0 && (galleryItem2 = this.gallery.getItem(0)) != null && galleryItem2.getItemCount() > 0) {
                return galleryItem2.getItem(0);
            }
            return null;
        }
        if (galleryItem.getParentItem() == null) {
            return null;
        }
        GalleryItem galleryItem3 = galleryItem.getParentItem();
        switch (n) {
            case 0x1000007: {
                return this.getFirstItem(galleryItem3, 1);
            }
            case 0x1000008: {
                return this.getFirstItem(galleryItem3, 0);
            }
        }
        int n2 = galleryItem3.indexOf(galleryItem);
        GalleryItem galleryItem4 = null;
        if (this.gallery.isVertical()) {
            int n3 = (Integer)galleryItem3.getData(H_COUNT);
            int n4 = this.gallery.getClientArea().height / this.itemHeight;
            switch (n) {
                case 0x1000003: {
                    galleryItem4 = this.goLeft(galleryItem3, n2);
                    break;
                }
                case 0x1000004: {
                    galleryItem4 = this.goRight(galleryItem3, n2);
                    break;
                }
                case 0x1000001: {
                    galleryItem4 = this.goUp(galleryItem3, n2, n3);
                    break;
                }
                case 0x1000002: {
                    galleryItem4 = this.goDown(galleryItem3, n2, n3);
                    break;
                }
                case 0x1000005: {
                    galleryItem4 = this.goUp(galleryItem3, n2, n3 * Math.max(n4 - 1, 1));
                    break;
                }
                case 0x1000006: {
                    galleryItem4 = this.goDown(galleryItem3, n2, n3 * Math.max(n4 - 1, 1));
                }
            }
        } else {
            int n5 = (Integer)galleryItem3.getData(V_COUNT);
            int n6 = this.gallery.getClientArea().width / this.itemWidth;
            switch (n) {
                case 0x1000003: {
                    galleryItem4 = this.goUp(galleryItem3, n2, n5);
                    break;
                }
                case 0x1000004: {
                    galleryItem4 = this.goDown(galleryItem3, n2, n5);
                    break;
                }
                case 0x1000001: {
                    galleryItem4 = this.goLeft(galleryItem3, n2);
                    break;
                }
                case 0x1000002: {
                    galleryItem4 = this.goRight(galleryItem3, n2);
                    break;
                }
                case 0x1000005: {
                    galleryItem4 = this.goUp(galleryItem3, n2, n5 * Math.max(n6 - 1, 1));
                    break;
                }
                case 0x1000006: {
                    galleryItem4 = this.goDown(galleryItem3, n2, n5 * Math.max(n6 - 1, 1));
                }
            }
        }
        return galleryItem4;
    }

    private GalleryItem getPreviousGroup(GalleryItem galleryItem) {
        int n = this.gallery.indexOf(galleryItem);
        while (n > 0) {
            GalleryItem galleryItem2 = this.gallery.getItem(n - 1);
            if (this.isGroupExpanded(galleryItem2)) {
                return galleryItem2;
            }
            --n;
        }
        return null;
    }

    private GalleryItem getNextGroup(GalleryItem galleryItem) {
        int n = this.gallery.indexOf(galleryItem);
        while (n < this.gallery.getItemCount() - 1) {
            GalleryItem galleryItem2 = this.gallery.getItem(n + 1);
            if (this.isGroupExpanded(galleryItem2)) {
                return galleryItem2;
            }
            ++n;
        }
        return null;
    }

    private GalleryItem getFirstItem(GalleryItem galleryItem, int n) {
        if (galleryItem == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return galleryItem.getItem(galleryItem.getItemCount() - 1);
            }
        }
        return galleryItem.getItem(0);
    }

    private GalleryItem getItemAt(GalleryItem galleryItem, int n, int n2) {
        if (galleryItem == null) {
            return null;
        }
        int n3 = (Integer)galleryItem.getData(H_COUNT);
        int n4 = 0;
        switch (n2) {
            case 0: {
                int n5 = galleryItem.getItemCount() % n3;
                if (n5 == 0) {
                    n5 = n3 - 1;
                    --n4;
                }
                if (n < n5) {
                    int n6 = galleryItem.getItemCount() / n3 + n4;
                    return galleryItem.getItem(n6 * n3 + n);
                }
                return galleryItem.getItem((galleryItem.getItemCount() / n3 + n4) * n3 + n5 - 1);
            }
        }
        if (n >= galleryItem.getItemCount()) {
            return galleryItem.getItem(galleryItem.getItemCount() - 1);
        }
        return galleryItem.getItem(n);
    }
}

