/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.gallery;

import org.eclipse.nebula.animation.AnimationRunner;
import org.eclipse.nebula.animation.movement.IMovement;
import org.eclipse.nebula.animation.movement.LinearInOut;
import org.eclipse.nebula.widgets.gallery.AbstractGridGroupRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryGroupResizeEffect;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.RendererHelper;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;

public class DefaultGalleryGroupRenderer
extends AbstractGridGroupRenderer {
    private AnimationRunner animationRunner = new AnimationRunner();
    private static final String PARENTHESIS_OPEN = " (";
    private static final String PARENTHESIS_CLOSE = ")";
    private int fontHeight = 0;
    private int titleHeight = this.fontHeight + 5;
    private Color titleForeground;
    private Color descriptionColor;
    private Color titleBackground = null;
    private int maxImageWidth = 32;
    private int maxImageHeight = 32;
    private Point imageSize = null;
    private boolean fillIfSingleColumn = false;
    private boolean fill = false;
    boolean marginCalculated = false;
    private Font font = null;
    protected boolean animation = false;
    protected int animationLength = 500;
    protected IMovement animationOpenMovement = new LinearInOut();
    protected IMovement animationCloseMovement = new LinearInOut();
    protected static final String DATA_ANIMATION = "org.eclipse.nebula.gallery.internal.animation";

    public DefaultGalleryGroupRenderer() {
        this.titleForeground = Display.getDefault().getSystemColor(30);
        this.descriptionColor = Display.getDefault().getSystemColor(10);
    }

    protected void drawGroupBackground(GC gC, int n, int n2, int n3, int n4) {
        if (this.titleBackground != null) {
            gC.setBackground(this.titleBackground);
            gC.fillRectangle(n, n2, n3, n4);
        } else {
            gC.setBackground(this.gallery.getDisplay().getSystemColor(31));
            gC.setForeground(this.gallery.getDisplay().getSystemColor(32));
            gC.fillGradientRectangle(n, n2, n3, n4, true);
        }
    }

    protected int drawGroupToggleButton(GC gC, int n, int n2, GalleryItem galleryItem) {
        if (!this.isAlwaysExpanded()) {
            int n3 = RendererHelper.getShift(this.titleHeight, 9);
            int n4 = RendererHelper.getShift(this.titleHeight, 9);
            int n5 = n + n3;
            int n6 = n2 + n4;
            gC.setBackground(gC.getDevice().getSystemColor(25));
            gC.fillRectangle(n5, n6, 8, 8);
            gC.setForeground(gC.getDevice().getSystemColor(21));
            gC.drawLine(n5 + 2, n6 + 4, n5 + 6, n6 + 4);
            if (!this.expanded) {
                gC.drawLine(n5 + 4, n6 + 2, n5 + 4, n6 + 6);
            }
            gC.setForeground(gC.getDevice().getSystemColor(18));
            gC.drawRectangle(n5, n6, 8, 8);
        }
        return this.titleHeight + this.minMargin;
    }

    protected Rectangle getToggleButtonBounds() {
        return new Rectangle(this.minMargin + RendererHelper.getShift(this.titleHeight, 9), RendererHelper.getShift(this.titleHeight, 9), 9, 9);
    }

    protected int getGroupHeight(GalleryItem galleryItem) {
        int n = this.titleHeight;
        if (galleryItem.getImage() != null) {
            Point point = RendererHelper.getBestSize(galleryItem.getImage().getBounds().width, galleryItem.getImage().getBounds().height, this.maxImageWidth, this.maxImageHeight);
            n = Math.max(this.titleHeight, point.y + 2 * this.minMargin);
        }
        int n2 = 1;
        if (galleryItem.getText(1) != null) {
            ++n2;
        }
        if (galleryItem.getText(2) != null) {
            ++n2;
        }
        n = Math.max(n, n2 * (this.fontHeight + 2) + 2);
        return n;
    }

    protected void drawGroup(GC gC, GalleryItem galleryItem, int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.fill) {
            return;
        }
        this.imageSize = null;
        if (galleryItem.getImage() != null) {
            this.imageSize = RendererHelper.getBestSize(galleryItem.getImage().getBounds().width, galleryItem.getImage().getBounds().height, this.maxImageWidth, this.maxImageHeight);
        }
        int n7 = this.getGroupHeight(galleryItem);
        if (this.gallery.isVertical()) {
            int n8 = n + this.minMargin;
            int n9 = n2;
            if (galleryItem.getImage() != null) {
                n9 += (this.imageSize.y - this.fontHeight) / 2;
            }
            int n10 = n9 + 2;
            int n11 = 1;
            while (n11 < 3) {
                if (galleryItem.getText(n11) != null) {
                    n10 -= this.fontHeight / 2 + 1;
                }
                ++n11;
            }
            n10 = Math.max(n2 + 2, n10);
            this.drawGroupBackground(gC, n, n2, galleryItem.width, n7);
            n8 += this.drawGroupToggleButton(gC, n8, n10 - 1, galleryItem);
            n8 += this.drawGroupImage(gC, galleryItem, n8, n2, this.imageSize);
            gC.setForeground(this.titleForeground);
            gC.setFont(this.font);
            gC.drawText(this.getGroupTitle(galleryItem), n8, n10, true);
            gC.setForeground(this.descriptionColor);
            n11 = 1;
            while (n11 < 3) {
                if (galleryItem.getText(n11) != null) {
                    gC.drawText(galleryItem.getText(n11), n8, n10 + n11 * (2 + this.fontHeight), true);
                }
                ++n11;
            }
        } else {
            Transform transform = new Transform(gC.getDevice());
            transform.rotate(-90.0f);
            gC.setTransform(transform);
            int n12 = n;
            int n13 = n2 - galleryItem.height;
            if (galleryItem.getImage() != null) {
                n12 += (this.imageSize.y - this.fontHeight) / 2;
            }
            int n14 = n12 + 2;
            int n15 = 1;
            while (n15 < 3) {
                if (galleryItem.getText(n15) != null) {
                    n14 -= this.fontHeight / 2 + 1;
                }
                ++n15;
            }
            n14 = Math.max(n + 2, n14);
            this.drawGroupBackground(gC, n2 - galleryItem.height, n, galleryItem.height, n7);
            n13 += this.drawGroupToggleButton(gC, n13, n14 - 1, galleryItem);
            n13 += this.drawGroupImage(gC, galleryItem, n13, n, this.imageSize);
            gC.setForeground(this.titleForeground);
            gC.setFont(this.font);
            gC.drawText(this.getGroupTitle(galleryItem), n13, n14, true);
            gC.setForeground(this.descriptionColor);
            n15 = 1;
            while (n15 < 3) {
                if (galleryItem.getText(n15) != null) {
                    gC.drawText(galleryItem.getText(n15), n13, n14 + n15 * (2 + this.fontHeight), true);
                }
                ++n15;
            }
            gC.setTransform(null);
            transform.dispose();
        }
    }

    private int drawGroupImage(GC gC, GalleryItem galleryItem, int n, int n2, Point point) {
        if (point == null) {
            return 0;
        }
        Image image = galleryItem.getImage();
        Rectangle rectangle = image.getBounds();
        Point point2 = RendererHelper.getImageOffset(point.x, point.y, this.maxImageWidth, this.getGroupHeight(galleryItem));
        gC.drawImage(image, 0, 0, rectangle.width, rectangle.height, n + point2.x, n2 + point2.y, point.x, point.y);
        return this.maxImageWidth + 2 * this.minMargin;
    }

    protected String getGroupTitle(GalleryItem galleryItem) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(galleryItem.getText());
        stringBuffer.append(PARENTHESIS_OPEN);
        stringBuffer.append(galleryItem.getItemCount());
        stringBuffer.append(PARENTHESIS_CLOSE);
        return stringBuffer.toString();
    }

    protected int getGroupOffset(GalleryItem galleryItem) {
        return this.getGroupHeight(galleryItem) + this.minMargin;
    }

    public void draw(GC gC, GalleryItem galleryItem, int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawGroup(gC, galleryItem, n, n2, n3, n4, n5, n6);
        int n7 = this.getGroupOffset(galleryItem);
        if (this.isGroupExpanded(galleryItem)) {
            int[] nArray = this.getVisibleItems(galleryItem, n, n2, n3, n4, n5, n6, n7);
            if (this.fill) {
                nArray = new int[]{nArray[0]};
            }
            if (nArray != null && nArray.length > 0) {
                int n8 = nArray.length - 1;
                while (n8 >= 0) {
                    boolean bl = galleryItem.isSelected(galleryItem.getItem(nArray[n8]));
                    if (Gallery.DEBUG) {
                        System.out.println("Selected : " + bl + " index : " + nArray[n8] + "item : " + (Object)((Object)galleryItem.getItem(nArray[n8])));
                    }
                    this.drawItem(gC, nArray[n8], bl, galleryItem, n7);
                    --n8;
                }
            }
        }
    }

    public void layout(GC gC, GalleryItem galleryItem) {
        Object object;
        int n = galleryItem.getItemCount();
        double d = 1.0;
        if (this.animation && (object = galleryItem.getData(DATA_ANIMATION)) != null && object instanceof Double && (d = ((Double)object).doubleValue()) < 0.0) {
            d = 0.0;
        }
        if (this.gallery.isVertical()) {
            int n2 = galleryItem.width;
            galleryItem.height = this.getGroupOffset(galleryItem) + 3 * this.minMargin;
            if (this.isGroupExpanded(galleryItem)) {
                Point point = this.gridLayout(n2, n, this.itemWidth);
                int n3 = point.x;
                int n4 = point.y;
                if (this.autoMargin && n3 > 0 && !this.marginCalculated) {
                    this.margin = this.calculateMargins(n2, n3, this.itemWidth);
                    this.marginCalculated = true;
                    if (Gallery.DEBUG) {
                        System.out.println("margin " + this.margin);
                    }
                }
                Point point2 = this.getSize(n3, n4, this.itemWidth, this.itemHeight, this.minMargin, this.margin);
                galleryItem.height = (int)((double)galleryItem.height + (double)point2.y * d);
                if (Gallery.DEBUG) {
                    System.out.println("group.height " + galleryItem.height);
                }
                galleryItem.setData("g.h", new Integer(n3));
                galleryItem.setData("g.v", new Integer(n4));
                if (Gallery.DEBUG) {
                    System.out.println("Hnb" + n3 + "Vnb" + n4);
                }
                this.fill = this.fillIfSingleColumn && n3 == 1;
            }
        } else {
            int n5 = galleryItem.height;
            galleryItem.width = this.getGroupOffset(galleryItem);
            if (this.isGroupExpanded(galleryItem)) {
                Point point = this.gridLayout(n5, n, this.itemHeight);
                int n6 = point.x;
                int n7 = point.y;
                if (this.autoMargin) {
                    this.margin = this.calculateMargins(n5, n6, this.itemHeight);
                }
                Point point3 = this.getSize(n7, n6, this.itemWidth, this.itemHeight, this.minMargin, this.margin);
                galleryItem.width = (int)((double)galleryItem.width + (double)point3.x * d);
                galleryItem.setData("g.h", new Integer(n7));
                galleryItem.setData("g.v", new Integer(n6));
                this.fill = this.fillIfSingleColumn && n6 == 1;
            }
        }
    }

    public void preDraw(GC gC) {
        this.pre(gC);
    }

    public void preLayout(GC gC) {
        this.marginCalculated = false;
        this.pre(gC);
        super.preLayout(gC);
    }

    private void pre(GC gC) {
        GC gC2 = gC;
        boolean bl = false;
        if (gC2 == null) {
            gC2 = new GC((Drawable)this.gallery, 0);
            bl = true;
        }
        gC2.setFont(this.font);
        this.fontHeight = gC2.getFontMetrics().getHeight();
        this.titleHeight = this.fontHeight + 5;
        if (bl) {
            gC2.dispose();
        }
    }

    public GalleryItem getItem(GalleryItem galleryItem, Point point) {
        if (!this.isGroupExpanded(galleryItem)) {
            return null;
        }
        return super.getItem(galleryItem, point, this.getGroupOffset(galleryItem));
    }

    protected void startGroupAnimation(GalleryItem galleryItem, boolean bl) {
        if (this.animation) {
            IMovement iMovement;
            int n;
            int n2;
            if (galleryItem.getData(DATA_ANIMATION) == null) {
                galleryItem.setData(DATA_ANIMATION, new Double(!bl ? 1 : 0));
            }
            if (bl) {
                n2 = 0;
                n = 1;
                iMovement = this.animationOpenMovement;
            } else {
                n2 = 1;
                n = 0;
                iMovement = this.animationCloseMovement;
            }
            this.animationRunner.runEffect(new GalleryGroupResizeEffect(galleryItem, n2, n, this.animationLength, iMovement, null, null));
        }
    }

    public boolean mouseDown(GalleryItem galleryItem, MouseEvent mouseEvent, Point point) {
        if (this.gallery.isVertical()) {
            if (point.y - galleryItem.y <= this.getGroupHeight(galleryItem)) {
                if (!this.isAlwaysExpanded() && point.x - galleryItem.x <= this.getToggleButtonBounds().x + this.getToggleButtonBounds().width && point.x - galleryItem.x > this.getToggleButtonBounds().x) {
                    boolean bl = !galleryItem.isExpanded();
                    this.startGroupAnimation(galleryItem, bl);
                    galleryItem._setExpanded(bl, false);
                    if (!this.isGroupExpanded(galleryItem)) {
                        galleryItem.deselectAll();
                    }
                    this.gallery.notifyTreeListeners(galleryItem, this.isGroupExpanded(galleryItem));
                    if (!this.animation) {
                        this.gallery.updateStructuralValues(galleryItem, false);
                        this.gallery.updateScrollBarsProperties();
                        this.gallery.redraw();
                    }
                } else if (this.isGroupExpanded(galleryItem)) {
                    if ((mouseEvent.stateMask & SWT.MOD1) == 0) {
                        this.gallery.deselectAll();
                    }
                    galleryItem.selectAll();
                    this.gallery.notifySelectionListeners(galleryItem, this.gallery.indexOf(galleryItem), false);
                    this.gallery.redraw();
                }
                return false;
            }
        } else if (point.x - galleryItem.x <= this.getGroupHeight(galleryItem)) {
            if (!this.isAlwaysExpanded() && galleryItem.height - point.y + 5 <= this.getToggleButtonBounds().x + this.getToggleButtonBounds().width && galleryItem.height - point.y + 5 > this.getToggleButtonBounds().x) {
                boolean bl = !galleryItem.isExpanded();
                this.startGroupAnimation(galleryItem, bl);
                galleryItem._setExpanded(bl, false);
                if (!this.isGroupExpanded(galleryItem)) {
                    galleryItem.deselectAll();
                }
                this.gallery.notifyTreeListeners(galleryItem, this.isGroupExpanded(galleryItem));
                if (!this.animation) {
                    this.gallery.updateStructuralValues(null, false);
                    this.gallery.updateScrollBarsProperties();
                    this.gallery.redraw();
                }
            } else if (this.isGroupExpanded(galleryItem)) {
                if ((mouseEvent.stateMask & SWT.MOD1) == 0) {
                    this.gallery.deselectAll();
                }
                galleryItem.selectAll();
                this.gallery.notifySelectionListeners(galleryItem, this.gallery.indexOf(galleryItem), false);
                this.gallery.redraw();
            }
            return false;
        }
        return true;
    }

    public Rectangle getSize(GalleryItem galleryItem) {
        Rectangle rectangle = super.getSize(galleryItem, this.getGroupOffset(galleryItem));
        return rectangle;
    }

    public Color getTitleForeground() {
        return this.titleForeground;
    }

    public void setTitleForeground(Color color) {
        this.titleForeground = color;
    }

    public Color getTitleBackground() {
        return this.titleBackground;
    }

    public void setTitleBackground(Color color) {
        this.titleBackground = color;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (this.font != font) {
            this.font = font;
            if (this.getGallery() != null) {
                this.getGallery().redraw();
            }
        }
    }

    protected void drawItem(GC gC, int n, boolean bl, GalleryItem galleryItem, int n2) {
        if (this.fill) {
            GalleryItem galleryItem2 = galleryItem.getItem(n);
            if (galleryItem2 == null) {
                return;
            }
            GalleryItem galleryItem3 = galleryItem2;
            Rectangle rectangle = this.gallery.getClientArea();
            galleryItem3.x = rectangle.x;
            galleryItem3.y = rectangle.y + this.gallery.translate;
            galleryItem3.height = rectangle.height;
            galleryItem3.width = rectangle.width;
            this.gallery.sendPaintItemEvent(galleryItem2, n, gC, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this.gallery.getItemRenderer() != null) {
                this.gallery.getItemRenderer().setSelected(bl);
                this.gallery.getItemRenderer().draw(gC, galleryItem3, n, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            return;
        }
        super.drawItem(gC, n, bl, galleryItem, n2);
    }

    public int getScrollBarIncrement() {
        if (this.fill) {
            if (this.gallery.isVertical()) {
                return this.gallery.getClientArea().height;
            }
            return this.gallery.getClientArea().width;
        }
        return super.getScrollBarIncrement();
    }

    public boolean isFillIfSingleColumn() {
        return this.fillIfSingleColumn;
    }

    public void setFillIfSingleColumn(boolean bl) {
        this.fillIfSingleColumn = bl;
    }

    public int getMaxImageWidth() {
        return this.maxImageWidth;
    }

    public void setMaxImageWidth(int n) {
        this.maxImageWidth = n;
    }

    public int getMaxImageHeight() {
        return this.maxImageHeight;
    }

    public void setMaxImageHeight(int n) {
        this.maxImageHeight = n;
    }

    public boolean isAnimation() {
        return this.animation;
    }

    public void setAnimation(boolean bl) {
        this.animation = bl;
    }

    public int getAnimationLength() {
        return this.animationLength;
    }

    public void setAnimationLength(int n) {
        this.animationLength = n;
    }

    public IMovement getAnimationOpenMovement() {
        return this.animationOpenMovement;
    }

    public IMovement getAnimationCloseMovement() {
        return this.animationCloseMovement;
    }

    public void setAnimationOpenMovement(IMovement iMovement) {
        this.animationOpenMovement = iMovement;
    }

    public void setAnimationCloseMovement(IMovement iMovement) {
        this.animationCloseMovement = iMovement;
    }

    protected boolean isGroupExpanded(GalleryItem galleryItem) {
        if (this.animation && galleryItem.getData(DATA_ANIMATION) != null) {
            return true;
        }
        return super.isGroupExpanded(galleryItem);
    }
}

