/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.gallery;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.RendererHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class DefaultGalleryItemRenderer
extends AbstractGalleryItemRenderer {
    protected ArrayList dropShadowsColors = new ArrayList();
    boolean dropShadows = false;
    int dropShadowsSize = 0;
    int dropShadowsAlphaStep = 20;
    Color selectionForegroundColor;
    Color selectionBackgroundColor;
    Color foregroundColor = Display.getDefault().getSystemColor(24);
    Color backgroundColor = Display.getDefault().getSystemColor(25);
    boolean showLabels = true;
    boolean showRoundedSelectionCorners = true;
    int selectionRadius = 15;

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean bl) {
        this.showLabels = bl;
    }

    public DefaultGalleryItemRenderer() {
        this.selectionForegroundColor = Display.getDefault().getSystemColor(27);
        this.selectionBackgroundColor = Display.getDefault().getSystemColor(26);
        this.createColors();
    }

    public void draw(GC gC, GalleryItem galleryItem, int n, int n2, int n3, int n4, int n5) {
        int n6;
        Object object;
        Image image = galleryItem.getImage();
        Color color = galleryItem.getBackground();
        Color color2 = galleryItem.getForeground();
        gC.setFont(this.getFont(galleryItem));
        int n7 = n5;
        int n8 = 0;
        if (galleryItem.getText() != null && this.showLabels) {
            n8 = gC.getFontMetrics().getHeight();
            n7 -= n8 + 2;
        }
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        Point point = null;
        if (image != null) {
            object = image.getBounds();
            n9 = object.width;
            n10 = object.height;
            point = RendererHelper.getBestSize(n9, n10, n4 - 8 - 2 * this.dropShadowsSize, n7 - 8 - 2 * this.dropShadowsSize);
            n11 = RendererHelper.getShift(n4, point.x);
            n12 = RendererHelper.getShift(n7, point.y);
            if (this.dropShadows) {
                Color color3 = null;
                n6 = this.dropShadowsSize - 1;
                while (n6 >= 0) {
                    color3 = (Color)this.dropShadowsColors.get(n6);
                    gC.setForeground(color3);
                    gC.drawLine(n2 + n4 + n6 - n11 - 1, n3 + this.dropShadowsSize + n12, n2 + n4 + n6 - n11 - 1, n3 + n7 + n6 - n12);
                    gC.drawLine(n2 + n11 + this.dropShadowsSize, n3 + n7 + n6 - n12 - 1, n2 + n4 + n6 - n11, n3 - 1 + n7 + n6 - n12);
                    --n6;
                }
            }
        }
        if (this.selected || color != null) {
            if (this.selected) {
                gC.setBackground(this.selectionBackgroundColor);
                gC.setForeground(this.selectionBackgroundColor);
            } else if (color != null) {
                gC.setBackground(color);
            }
            if (this.showRoundedSelectionCorners) {
                gC.fillRoundRectangle(n2, n3, n4, n7, this.selectionRadius, this.selectionRadius);
            } else {
                gC.fillRectangle(n2, n3, n4, n5);
            }
            if (galleryItem.getText() != null && this.showLabels) {
                gC.fillRoundRectangle(n2, n3 + n5 - n8, n4, n8, this.selectionRadius, this.selectionRadius);
            }
        }
        if (image != null && point != null && point.x > 0 && point.y > 0) {
            gC.drawImage(image, 0, 0, n9, n10, n2 + n11, n3 + n12, point.x, point.y);
            this.drawAllOverlays(gC, galleryItem, n2, n3, point, n11, n12);
        }
        if (galleryItem.getText() != null && !"".equals(galleryItem.getText()) && this.showLabels) {
            if (this.selected) {
                gC.setForeground(this.selectionForegroundColor);
                gC.setBackground(this.selectionBackgroundColor);
            } else {
                if (color != null) {
                    gC.setBackground(color);
                } else {
                    gC.setBackground(this.backgroundColor);
                }
                if (color2 != null) {
                    gC.setForeground(color2);
                } else {
                    gC.setForeground(this.foregroundColor);
                }
            }
            object = RendererHelper.createLabel(galleryItem.getText(), gC, n4 - 10);
            int n13 = gC.textExtent((String)object).x;
            n6 = RendererHelper.getShift(n4, n13);
            gC.drawText((String)object, n2 + n6, n3 + n5 - n8, true);
        }
    }

    protected Font getFont(GalleryItem galleryItem) {
        Font font = galleryItem.getFont();
        if (font == null && galleryItem.getParentItem() != null) {
            font = galleryItem.getParentItem().getFont();
        }
        if (font == null && galleryItem.getParentItem() != null) {
            font = galleryItem.getParent().getFont();
        }
        return font;
    }

    public void setDropShadowsSize(int n) {
        this.dropShadowsSize = n;
        this.dropShadowsAlphaStep = n == 0 ? 0 : 200 / n;
        this.freeDropShadowsColors();
        this.createColors();
    }

    private void createColors() {
        if (this.dropShadowsSize > 0) {
            int n = 125 / this.dropShadowsSize;
            int n2 = this.dropShadowsSize - 1;
            while (n2 >= 0) {
                int n3 = 255 - n2 * n;
                Color color = new Color((Device)Display.getDefault(), n3, n3, n3);
                this.dropShadowsColors.add(color);
                --n2;
            }
        }
    }

    private void freeDropShadowsColors() {
        Iterator iterator = this.dropShadowsColors.iterator();
        while (iterator.hasNext()) {
            Color color = (Color)iterator.next();
            if (color == null || color.isDisposed()) continue;
            color.dispose();
        }
    }

    public boolean isDropShadows() {
        return this.dropShadows;
    }

    public void setDropShadows(boolean bl) {
        this.dropShadows = bl;
    }

    public int getDropShadowsSize() {
        return this.dropShadowsSize;
    }

    public Font getFont() {
        if (this.gallery != null) {
            return this.gallery.getFont();
        }
        return null;
    }

    public void setFont(Font font) {
        if (this.gallery != null) {
            this.gallery.setFont(font);
        }
    }

    public void dispose() {
        this.freeDropShadowsColors();
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
    }

    public Color getSelectionForegroundColor() {
        return this.selectionForegroundColor;
    }

    public void setSelectionForegroundColor(Color color) {
        this.selectionForegroundColor = color;
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color color) {
        this.selectionBackgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public boolean isShowRoundedSelectionCorners() {
        return this.showRoundedSelectionCorners;
    }

    public void setShowRoundedSelectionCorners(boolean bl) {
        this.showRoundedSelectionCorners = bl;
    }
}

