/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.gallery;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class Gallery
extends Canvas {
    private static final String BUG_PLATFORM_LINUX_GTK_174932 = "gtk";
    protected static boolean DEBUG = false;
    GalleryItem[] items = null;
    private GalleryItem[] selection = null;
    private int[] selectionIndices = null;
    boolean virtual = false;
    boolean virtualGroups = false;
    boolean virtualGroupsCompatibilityMode = false;
    int virtualGroupDefaultItemCount = 10;
    boolean vertical = true;
    boolean multi = false;
    int interpolation = 2;
    int antialias = 1;
    private int gHeight = 0;
    private int gWidth = 0;
    int lastIndexOf = 0;
    protected GalleryItem lastSingleClick = null;
    protected int translate = 0;
    boolean lowQualityOnUserAction = false;
    protected int lastTranslateValue = 0;
    protected int lastControlWidth = 0;
    protected int lastControlHeight = 0;
    protected int lastContentHeight = 0;
    protected int lastContentWidth = 0;
    protected int higherQualityDelay = 500;
    private boolean mouseClickHandled = false;
    AbstractGalleryItemRenderer itemRenderer;
    AbstractGalleryGroupRenderer groupRenderer;
    RedrawTimer redrawTimer = new RedrawTimer();

    public int getItemCount() {
        this.checkWidget();
        if (this.items == null) {
            return 0;
        }
        return this.items.length;
    }

    public void setItemCount(int n) {
        this.checkWidget();
        if (DEBUG) {
            System.out.println("setCount" + n);
        }
        if (n == 0) {
            this.items = null;
        } else {
            GalleryItem[] galleryItemArray = new GalleryItem[n];
            if (this.items != null) {
                System.arraycopy(this.items, 0, galleryItemArray, 0, Math.min(n, this.items.length));
            }
            this.items = galleryItemArray;
        }
        this.updateStructuralValues(null, false);
        this.updateScrollBarsProperties();
        this.redraw();
    }

    public AbstractGalleryItemRenderer getItemRenderer() {
        this.checkWidget();
        return this.itemRenderer;
    }

    public void setItemRenderer(AbstractGalleryItemRenderer abstractGalleryItemRenderer) {
        this.checkWidget();
        this.itemRenderer = abstractGalleryItemRenderer;
        if (this.itemRenderer != null) {
            this.itemRenderer.setGallery(this);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)selectionListener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.removeListener(13, (SWTEventListener)selectionListener);
        this.removeListener(14, (SWTEventListener)selectionListener);
    }

    public void removeTreeListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.removeListener(17, (SWTEventListener)selectionListener);
    }

    public void addTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            SWT.error((int)4);
        }
        this.addListener(17, (Listener)new TypedListener((SWTEventListener)treeListener));
    }

    protected void sendPaintItemEvent(Item item, int n, GC gC, int n2, int n3, int n4, int n5) {
        Event event = new Event();
        event.item = item;
        event.type = 42;
        event.index = n;
        event.gc = gC;
        event.x = n2;
        event.y = n3;
        event.width = n4;
        event.height = n5;
        this.notifyListeners(42, event);
    }

    public boolean isLowQualityOnUserAction() {
        return this.lowQualityOnUserAction;
    }

    public void setLowQualityOnUserAction(boolean bl) {
        this.lowQualityOnUserAction = bl;
    }

    public int getHigherQualityDelay() {
        return this.higherQualityDelay;
    }

    public void setHigherQualityDelay(int n) {
        this.higherQualityDelay = n;
    }

    public int getInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(int n) {
        this.interpolation = n;
    }

    public int getAntialias() {
        return this.antialias;
    }

    public void setAntialias(int n) {
        this.antialias = n;
    }

    protected void notifySelectionListeners(GalleryItem galleryItem, int n, boolean bl) {
        Event event = new Event();
        event.widget = this;
        event.item = galleryItem;
        if (galleryItem != null) {
            event.data = galleryItem.getData();
        }
        try {
            if (bl) {
                this.notifyListeners(14, event);
            } else {
                this.notifyListeners(13, event);
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    protected void notifyTreeListeners(GalleryItem galleryItem, boolean bl) {
        Event event = new Event();
        event.widget = this;
        event.item = galleryItem;
        if (galleryItem != null) {
            event.data = galleryItem.getData();
        }
        try {
            this.notifyListeners(17, event);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    public Gallery(Composite composite, int n) {
        super(composite, n | 0x40000 | 0x20000000);
        this.virtual = (n & 0x10000000) > 0;
        this.vertical = (n & 0x200) > 0;
        this.multi = (n & 2) > 0;
        this.setBackground(this.getDisplay().getSystemColor(25));
        this._addDisposeListeners();
        this._addResizeListeners();
        this._addPaintListeners();
        this._addScrollBarsListeners();
        this._addMouseListeners();
        this._addKeyListeners();
        this._setDefaultRenderers();
        this.updateStructuralValues(null, false);
        this.updateScrollBarsProperties();
        this.redraw();
    }

    private void _setDefaultRenderers() {
        DefaultGalleryGroupRenderer defaultGalleryGroupRenderer = new DefaultGalleryGroupRenderer();
        defaultGalleryGroupRenderer.setMinMargin(2);
        defaultGalleryGroupRenderer.setItemHeight(56);
        defaultGalleryGroupRenderer.setItemWidth(72);
        defaultGalleryGroupRenderer.setAutoMargin(true);
        defaultGalleryGroupRenderer.setGallery(this);
        this.groupRenderer = defaultGalleryGroupRenderer;
        this.itemRenderer = new DefaultGalleryItemRenderer();
        this.itemRenderer.setGallery(this);
    }

    private void _addDisposeListeners() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                Gallery.this.onDispose();
            }
        });
    }

    private void _addPaintListeners() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Gallery.this.onPaint(paintEvent.gc);
            }
        });
    }

    private void _addResizeListeners() {
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Gallery.this.updateStructuralValues(null, true);
                Gallery.this.updateScrollBarsProperties();
                Gallery.this.redraw();
            }
        });
    }

    private void _addScrollBarsListeners() {
        ScrollBar scrollBar;
        ScrollBar scrollBar2 = this.getVerticalBar();
        if (scrollBar2 != null) {
            scrollBar2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (Gallery.this.vertical) {
                        Gallery.this.scrollVertical();
                    }
                }
            });
        }
        if ((scrollBar = this.getHorizontalBar()) != null) {
            scrollBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (!Gallery.this.vertical) {
                        Gallery.this.scrollHorizontal();
                    }
                }
            });
        }
    }

    private void _addKeyListeners() {
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.keyCode) {
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000003: 
                    case 0x1000004: 
                    case 0x1000005: 
                    case 0x1000006: 
                    case 0x1000007: 
                    case 0x1000008: {
                        GalleryItem galleryItem = Gallery.this.groupRenderer.getNextItem(Gallery.this.lastSingleClick, keyEvent.keyCode);
                        if (galleryItem == null) break;
                        Gallery.this._deselectAll();
                        Gallery.this.setSelected(galleryItem, true, true);
                        Gallery.this.lastSingleClick = galleryItem;
                        Gallery.this._showItem(galleryItem);
                        Gallery.this.redraw();
                        break;
                    }
                    case 13: {
                        GalleryItem[] galleryItemArray = Gallery.this.getSelection();
                        GalleryItem galleryItem = null;
                        if (galleryItemArray != null && galleryItemArray.length > 0) {
                            galleryItem = galleryItemArray[0];
                        }
                        Gallery.this.notifySelectionListeners(galleryItem, 0, true);
                    }
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
    }

    public void showItem(GalleryItem galleryItem) {
        this.checkWidget();
        this._showItem(galleryItem);
    }

    void _showItem(GalleryItem galleryItem) {
        Rectangle rectangle = this.groupRenderer.getSize(galleryItem);
        if (rectangle == null) {
            return;
        }
        if (this.vertical) {
            int n = rectangle.y;
            int n2 = rectangle.height;
            if (n < this.translate) {
                this.translate = n;
            } else if (this.translate + this.getClientArea().height < n + n2) {
                this.translate = n + n2 - this.getClientArea().height;
            }
        } else {
            int n = rectangle.x;
            int n3 = rectangle.width;
            if (n < this.translate) {
                this.translate = n;
            } else if (this.translate + this.getClientArea().width < n + n3) {
                this.translate = n + n3 - this.getClientArea().width;
            }
        }
        this.updateScrollBarsProperties();
        this.redraw();
    }

    private void _addMouseListeners() {
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                Gallery.this.onMouseDoubleClick(mouseEvent);
            }

            public void mouseDown(MouseEvent mouseEvent) {
                Gallery.this.onMouseDown(mouseEvent);
            }

            public void mouseUp(MouseEvent mouseEvent) {
                Gallery.this.onMouseUp(mouseEvent);
            }
        });
    }

    private void select(int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            GalleryItem galleryItem = this.getItem(n3);
            this._addSelection(galleryItem);
            galleryItem._selectAll();
            ++n3;
        }
    }

    private void select(GalleryItem galleryItem, GalleryItem galleryItem2) {
        GalleryItem galleryItem3;
        GalleryItem galleryItem4 = galleryItem.getParentItem();
        if (galleryItem4 == (galleryItem3 = galleryItem2.getParentItem())) {
            if (galleryItem4 == null) {
                int n = this.indexOf(galleryItem);
                int n2 = this.indexOf(galleryItem2);
                this.select(n, n2);
            } else {
                int n = galleryItem4.indexOf(galleryItem);
                int n3 = galleryItem3.indexOf(galleryItem2);
                galleryItem4.select(n, n3);
            }
        } else {
            int n = this.indexOf(galleryItem4);
            int n4 = this.indexOf(galleryItem3);
            int n5 = galleryItem4.indexOf(galleryItem);
            int n6 = galleryItem3.indexOf(galleryItem2);
            galleryItem4.select(n5, galleryItem4.getItemCount() - 1);
            int n7 = n + 1;
            while (n7 < n4) {
                this.getItem(n7)._selectAll();
                ++n7;
            }
            galleryItem3.select(0, n6);
        }
        this.notifySelectionListeners(galleryItem2, this.indexOf(galleryItem2), false);
        this.redraw();
    }

    private boolean getOrder(GalleryItem galleryItem, GalleryItem galleryItem2) {
        if (galleryItem == null || galleryItem2 == null) {
            return true;
        }
        GalleryItem galleryItem3 = galleryItem.getParentItem();
        GalleryItem galleryItem4 = galleryItem2.getParentItem();
        int n = this.indexOf(galleryItem3);
        int n2 = this.indexOf(galleryItem4);
        if (galleryItem3 == galleryItem4) {
            int n3;
            int n4;
            if (galleryItem3 == null) {
                n4 = this.indexOf(galleryItem);
                n3 = this.indexOf(galleryItem2);
            } else {
                n4 = galleryItem3.indexOf(galleryItem);
                n3 = galleryItem3.indexOf(galleryItem2);
            }
            return n4 < n3;
        }
        return n < n2;
    }

    protected void setSelected(GalleryItem galleryItem, boolean bl, boolean bl2) {
        if (bl) {
            if (!this.isSelected(galleryItem)) {
                this._addSelection(galleryItem);
            }
        } else if (this.isSelected(galleryItem)) {
            this._removeSelection(galleryItem);
        }
        if (bl2) {
            this.notifySelectionListeners(galleryItem, this.indexOf(galleryItem), false);
        }
    }

    protected void _addSelection(GalleryItem galleryItem) {
        Object[] objectArray;
        if (galleryItem == null) {
            return;
        }
        if (this.isSelected(galleryItem)) {
            return;
        }
        if (!this.multi) {
            this._deselectAll();
        }
        if (galleryItem.getParentItem() != null) {
            galleryItem.getParentItem()._addSelection(galleryItem);
        } else {
            if (this.selectionIndices == null) {
                this.selectionIndices = new int[1];
            } else {
                objectArray = this.selectionIndices;
                this.selectionIndices = new int[objectArray.length + 1];
                System.arraycopy(objectArray, 0, this.selectionIndices, 0, objectArray.length);
            }
            this.selectionIndices[this.selectionIndices.length - 1] = this.indexOf(galleryItem);
        }
        if (this.selection == null) {
            this.selection = new GalleryItem[1];
        } else {
            objectArray = (Object[])this.selection;
            this.selection = new GalleryItem[objectArray.length + 1];
            System.arraycopy(objectArray, 0, this.selection, 0, objectArray.length);
        }
        this.selection[this.selection.length - 1] = galleryItem;
    }

    private void _removeSelection(GalleryItem galleryItem) {
        if (galleryItem.getParentItem() == null) {
            this.selectionIndices = this._arrayRemoveItem(this.selectionIndices, this._arrayIndexOf(this.selectionIndices, this._indexOf(galleryItem)));
        } else {
            this._removeSelection(galleryItem.getParentItem(), galleryItem);
        }
        int n = this._arrayIndexOf((Object[])this.selection, (Object)galleryItem);
        if (n == -1) {
            return;
        }
        this.selection = (GalleryItem[])this._arrayRemoveItem((Object[])this.selection, n);
    }

    protected void _removeSelection(GalleryItem galleryItem, GalleryItem galleryItem2) {
        galleryItem.selectionIndices = this._arrayRemoveItem(galleryItem.selectionIndices, this._arrayIndexOf(galleryItem.selectionIndices, this._indexOf(galleryItem, galleryItem2)));
    }

    protected boolean isSelected(GalleryItem galleryItem) {
        if (galleryItem == null) {
            return false;
        }
        if (galleryItem.getParentItem() != null) {
            return galleryItem.getParentItem().isSelected(galleryItem);
        }
        if (this.selectionIndices == null) {
            return false;
        }
        int n = this.indexOf(galleryItem);
        int n2 = 0;
        while (n2 < this.selectionIndices.length) {
            if (this.selectionIndices[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void deselectAll() {
        this.checkWidget();
        this._deselectAll();
        this.redraw();
    }

    protected void _deselectAll() {
        if (DEBUG) {
            System.out.println("clear");
        }
        this.selection = null;
        this.selectionIndices = null;
        if (this.items == null) {
            return;
        }
        int n = 0;
        while (n < this.items.length) {
            if (this.items[n] != null) {
                this.items[n]._deselectAll();
            }
            ++n;
        }
    }

    void onMouseDoubleClick(MouseEvent mouseEvent) {
        GalleryItem galleryItem;
        if (DEBUG) {
            System.out.println("Mouse Double Click");
        }
        if ((galleryItem = this.getItem(new Point(mouseEvent.x, mouseEvent.y))) != null) {
            this.notifySelectionListeners(galleryItem, 0, true);
        }
        this.mouseClickHandled = true;
    }

    void onMouseUp(MouseEvent mouseEvent) {
        if (DEBUG) {
            System.out.println("onMouseUp");
        }
        if (this.mouseClickHandled) {
            if (DEBUG) {
                System.out.println("onMouseUp : mouse event already handled");
            }
            return;
        }
        if (mouseEvent.button == 1) {
            GalleryItem galleryItem = this.getItem(new Point(mouseEvent.x, mouseEvent.y));
            if (galleryItem == null) {
                return;
            }
            if ((mouseEvent.stateMask & SWT.MOD1) > 0) {
                this.onMouseHandleLeftMod1(mouseEvent, galleryItem, false, true);
            } else if ((mouseEvent.stateMask & 0x20000) > 0) {
                this.onMouseHandleLeftShift(mouseEvent, galleryItem, false, true);
            } else {
                this.onMouseHandleLeft(mouseEvent, galleryItem, false, true);
            }
        }
    }

    void onDispose() {
        if (!this.virtual) {
            this.removeAll();
        }
        if (this.itemRenderer != null) {
            this.itemRenderer.dispose();
        }
        if (this.groupRenderer != null) {
            this.groupRenderer.dispose();
        }
    }

    void onMouseDown(MouseEvent mouseEvent) {
        if (DEBUG) {
            System.out.println("Mouse down ");
        }
        this.mouseClickHandled = false;
        if (!this._mouseDown(mouseEvent)) {
            this.mouseClickHandled = true;
            return;
        }
        GalleryItem galleryItem = this.getItem(new Point(mouseEvent.x, mouseEvent.y));
        if (mouseEvent.button == 1) {
            if (galleryItem == null) {
                this._deselectAll();
                this.redraw();
                this.mouseClickHandled = true;
                this.lastSingleClick = null;
            } else if ((mouseEvent.stateMask & SWT.MOD1) > 0) {
                this.onMouseHandleLeftMod1(mouseEvent, galleryItem, true, false);
            } else if ((mouseEvent.stateMask & 0x20000) > 0) {
                this.onMouseHandleLeftShift(mouseEvent, galleryItem, true, false);
            } else {
                this.onMouseHandleLeft(mouseEvent, galleryItem, true, false);
            }
        } else if (mouseEvent.button == 3) {
            this.onMouseHandleRight(mouseEvent, galleryItem, true, false);
        }
    }

    private void onMouseHandleLeftMod1(MouseEvent mouseEvent, GalleryItem galleryItem, boolean bl, boolean bl2) {
        if (bl2 && galleryItem != null) {
            if (DEBUG) {
                System.out.println("setSelected : inverse");
            }
            this.setSelected(galleryItem, !this.isSelected(galleryItem), true);
            this.lastSingleClick = galleryItem;
            this.redraw();
        }
    }

    private void onMouseHandleLeftShift(MouseEvent mouseEvent, GalleryItem galleryItem, boolean bl, boolean bl2) {
        if (bl2 && this.lastSingleClick != null) {
            this._deselectAll();
            if (this.getOrder(galleryItem, this.lastSingleClick)) {
                this.select(galleryItem, this.lastSingleClick);
            } else {
                this.select(this.lastSingleClick, galleryItem);
            }
        }
    }

    void onMouseHandleLeft(MouseEvent mouseEvent, GalleryItem galleryItem, boolean bl, boolean bl2) {
        if (bl) {
            if (!this.isSelected(galleryItem)) {
                this._deselectAll();
                if (DEBUG) {
                    System.out.println("setSelected");
                }
                this.setSelected(galleryItem, true, true);
                this.lastSingleClick = galleryItem;
                this.redraw();
                this.mouseClickHandled = true;
            }
        } else if (bl2) {
            if (galleryItem == null) {
                this._deselectAll();
            } else {
                if (DEBUG) {
                    System.out.println("setSelected");
                }
                this._deselectAll();
                this.setSelected(galleryItem, true, this.lastSingleClick != galleryItem);
                this.lastSingleClick = galleryItem;
            }
            this.redraw();
        }
    }

    void onMouseHandleRight(MouseEvent mouseEvent, GalleryItem galleryItem, boolean bl, boolean bl2) {
        if (bl) {
            if (DEBUG) {
                System.out.println("right click");
            }
            if (galleryItem != null && !this.isSelected(galleryItem)) {
                this._deselectAll();
                this.setSelected(galleryItem, true, true);
                this.redraw();
                this.mouseClickHandled = true;
            }
        }
    }

    void onPaint(GC gC) {
        if (DEBUG) {
            System.out.println("paint");
        }
        boolean bl = this.lowQualityOnUserAction && (this.translate != this.lastTranslateValue || this.lastControlWidth != this.getSize().x || this.lastControlHeight != this.getSize().y || this.lastContentHeight != this.gHeight || this.lastContentWidth != this.gWidth);
        try {
            GC gC2 = gC;
            if (!SWT.getPlatform().equals(BUG_PLATFORM_LINUX_GTK_174932)) {
                gC2.setAdvanced(true);
            }
            if (gC.getAdvanced()) {
                if (bl) {
                    gC2.setAntialias(0);
                    gC2.setInterpolation(0);
                } else {
                    gC2.setAntialias(this.antialias);
                    gC2.setInterpolation(this.interpolation);
                }
            }
            Rectangle rectangle = gC2.getClipping();
            gC2.setBackground(this.getBackground());
            gC2.fillRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            int[] nArray = this.getVisibleItems(rectangle);
            if (nArray != null && nArray.length > 0) {
                if (this.groupRenderer != null) {
                    this.groupRenderer.preDraw(gC2);
                }
                if (this.itemRenderer != null) {
                    this.itemRenderer.preDraw(gC2);
                }
                int n = nArray.length - 1;
                while (n >= 0) {
                    if (DEBUG) {
                        System.out.println("Drawing group " + nArray[n]);
                    }
                    this._drawGroup(gC2, nArray[n]);
                    --n;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.lowQualityOnUserAction) {
            this.lastTranslateValue = this.translate;
            this.lastControlWidth = this.getSize().x;
            this.lastControlHeight = this.getSize().y;
            this.lastContentHeight = this.gHeight;
            this.lastContentWidth = this.gWidth;
            if (bl) {
                Display.getCurrent().timerExec(this.higherQualityDelay, (Runnable)this.redrawTimer);
            }
        }
    }

    private int[] getVisibleItems(Rectangle rectangle) {
        if (this.items == null) {
            return null;
        }
        int n = this.vertical ? rectangle.y + this.translate : rectangle.x + this.translate;
        int n2 = this.vertical ? rectangle.y + rectangle.height + this.translate : rectangle.x + rectangle.width + this.translate;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n3 = 0;
        GalleryItem galleryItem = null;
        while (n3 < this.items.length) {
            galleryItem = this.virtualGroups ? this._getItem(n3, false) : this.getItem(n3);
            if ((this.vertical ? galleryItem.y : galleryItem.x) > n2) break;
            if ((this.vertical ? galleryItem.y + galleryItem.height : galleryItem.x + galleryItem.width) >= n) {
                arrayList.add(new Integer(n3));
            }
            ++n3;
        }
        int[] nArray = new int[arrayList.size()];
        int n4 = 0;
        while (n4 < arrayList.size()) {
            nArray[n4] = (Integer)arrayList.get(n4);
            ++n4;
        }
        return nArray;
    }

    public void refresh(int n) {
        this.checkWidget();
        this.getItemCount();
    }

    public void redraw(GalleryItem galleryItem) {
        this.checkWidget();
        Rectangle rectangle = galleryItem.getBounds();
        this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private void _drawGroup(GC gC, int n) {
        int n2;
        int n3;
        GalleryItem galleryItem = null;
        if (this.virtualGroups) {
            galleryItem = this._getItem(n, false);
            if (galleryItem.isUltraLazyDummy()) {
                n3 = !(this.vertical && galleryItem.y < this.translate || !this.vertical && galleryItem.x < this.translate) ? 0 : 1;
                n2 = galleryItem.height;
                galleryItem = this._getItem(n, true);
                if (this.virtualGroupsCompatibilityMode) {
                    int n4 = 0;
                    while (n4 < n) {
                        this._getItem(n4);
                        ++n4;
                    }
                }
                this.updateStructuralValues(galleryItem, false);
                if (DEBUG) {
                    System.out.println("old" + n2 + " new " + galleryItem.height + " translate " + this.translate);
                }
                if (n3 != 0) {
                    this.translate += galleryItem.height - n2;
                    if (DEBUG) {
                        System.out.println("updated to : " + this.translate);
                    }
                }
                this.updateScrollBarsProperties();
                this.redraw();
            }
        } else {
            galleryItem = this.getItem(n);
        }
        if (galleryItem == null) {
            return;
        }
        this.groupRenderer.setExpanded(galleryItem.isExpanded());
        n3 = this.vertical ? galleryItem.x : galleryItem.x - this.translate;
        n2 = this.vertical ? galleryItem.y - this.translate : galleryItem.y;
        Rectangle rectangle = gC.getClipping();
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        rectangle.intersect(new Rectangle(n3, n2, galleryItem.width, galleryItem.height));
        gC.setClipping(rectangle);
        this.groupRenderer.draw(gC, galleryItem, n3, n2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        gC.setClipping(rectangle2);
    }

    private void updateItem(GalleryItem galleryItem, int n, boolean bl) {
        if (this.virtual) {
            if (galleryItem == null) {
                GalleryItem galleryItem2 = this.items[n];
                if (galleryItem2 == null || this.virtualGroups && galleryItem2.isUltraLazyDummy() && bl) {
                    if (DEBUG) {
                        System.out.println("Virtual/creating item ");
                    }
                    this.items[n] = galleryItem2 = new GalleryItem(this, 0, n, false);
                    if (this.virtualGroups && !bl) {
                        galleryItem2.setItemCount(this.virtualGroupDefaultItemCount);
                        galleryItem2.setUltraLazyDummy(true);
                        galleryItem2.setExpanded(true);
                    } else {
                        this.setData(galleryItem2, n);
                    }
                }
            } else {
                GalleryItem galleryItem3 = galleryItem.items[n];
                if (galleryItem3 == null) {
                    if (DEBUG) {
                        System.out.println("Virtual/creating item ");
                    }
                    galleryItem.items[n] = galleryItem3 = new GalleryItem(galleryItem, 0, n, false);
                    this.setData(galleryItem3, n);
                }
            }
        }
    }

    protected void setData(GalleryItem galleryItem, int n) {
        GalleryItem galleryItem2 = galleryItem;
        Event event = new Event();
        event.item = galleryItem2;
        event.type = 36;
        event.index = n;
        this.notifyListeners(36, event);
    }

    protected void updateStructuralValues(boolean bl) {
        this.updateStructuralValues(null, bl);
    }

    protected void updateStructuralValues(GalleryItem galleryItem, boolean bl) {
        if (DEBUG) {
            System.out.println("Client Area : " + this.getClientArea().x + " " + this.getClientArea().y + " " + this.getClientArea().width + " " + this.getClientArea().height);
        }
        Rectangle rectangle = this.getClientArea();
        float f = 0.0f;
        if (this.vertical) {
            if (this.gHeight > 0 && bl) {
                f = (float)((double)this.translate + 0.5 * (double)rectangle.height) / (float)this.gHeight;
            }
            this.gWidth = rectangle.width;
            this.gHeight = this.calculateSize(galleryItem);
            if (bl) {
                this.translate = (int)((double)((float)this.gHeight * f) - 0.5 * (double)rectangle.height);
            }
        } else {
            if (this.gWidth > 0 && bl) {
                f = (float)((double)this.translate + 0.5 * (double)rectangle.width) / (float)this.gWidth;
            }
            this.gWidth = this.calculateSize(galleryItem);
            this.gHeight = rectangle.height;
            if (bl) {
                this.translate = (int)((double)((float)this.gWidth * f) - 0.5 * (double)rectangle.width);
            }
        }
        this.validateTranslation();
        if (DEBUG) {
            System.out.println("Content Size : " + this.gWidth + " " + this.gHeight);
        }
    }

    private int calculateSize(GalleryItem galleryItem) {
        if (this.groupRenderer == null) {
            return 0;
        }
        this.groupRenderer.preLayout(null);
        int n = 0;
        int n2 = this.getItemCount();
        int n3 = 0;
        while (n3 < n2) {
            GalleryItem galleryItem2 = null;
            galleryItem2 = this.virtualGroups ? this._getItem(n3, false) : this.getItem(n3);
            if (galleryItem != null && !((Object)((Object)galleryItem)).equals((Object)galleryItem2)) {
                if (this.vertical) {
                    galleryItem2.y = n;
                    galleryItem2.x = this.getClientArea().x;
                    n += galleryItem2.height;
                } else {
                    galleryItem2.y = this.getClientArea().y;
                    galleryItem2.x = n;
                    n += galleryItem2.width;
                }
            } else {
                this.groupRenderer.setExpanded(galleryItem2.isExpanded());
                if (this.vertical) {
                    galleryItem2.y = n;
                    galleryItem2.x = this.getClientArea().x;
                    galleryItem2.width = this.getClientArea().width;
                    galleryItem2.height = -1;
                    this.groupRenderer.layout(null, galleryItem2);
                    n += galleryItem2.height;
                } else {
                    galleryItem2.y = this.getClientArea().y;
                    galleryItem2.x = n;
                    galleryItem2.width = -1;
                    galleryItem2.height = this.getClientArea().height;
                    this.groupRenderer.layout(null, galleryItem2);
                    n += galleryItem2.width;
                }
            }
            ++n3;
        }
        this.groupRenderer.postLayout(null);
        return n;
    }

    protected void updateScrollBarsProperties() {
        if (this.vertical) {
            this.updateScrollBarProperties(this.getVerticalBar(), this.getClientArea().height, this.gHeight);
        } else {
            this.updateScrollBarProperties(this.getHorizontalBar(), this.getClientArea().width, this.gWidth);
        }
    }

    private void updateScrollBarProperties(ScrollBar scrollBar, int n, int n2) {
        if (scrollBar == null) {
            return;
        }
        scrollBar.setMinimum(0);
        scrollBar.setPageIncrement(n);
        scrollBar.setMaximum(n2);
        scrollBar.setThumb(n);
        if (this.groupRenderer != null) {
            scrollBar.setIncrement(this.groupRenderer.getScrollBarIncrement());
        }
        if (n2 > n) {
            if (DEBUG) {
                System.out.println("Enabling scrollbar");
            }
            scrollBar.setEnabled(true);
            scrollBar.setSelection(this.translate);
            this.validateTranslation();
        } else {
            if (DEBUG) {
                System.out.println("Disabling scrollbar");
            }
            scrollBar.setEnabled(false);
            scrollBar.setSelection(0);
            this.translate = 0;
        }
    }

    private void validateTranslation() {
        Rectangle rectangle = this.getClientArea();
        int n = 0;
        int n2 = 0;
        if (this.translate < 0) {
            this.translate = 0;
        }
        if (this.vertical) {
            n = this.gHeight;
            n2 = rectangle.height;
        } else {
            n = this.gWidth;
            n2 = rectangle.width;
        }
        if (n > n2) {
            if (this.translate + n2 > n) {
                this.translate = n - n2;
            }
        } else {
            this.translate = 0;
        }
    }

    protected void scrollVertical() {
        int n = this.getClientArea().height;
        if (this.gHeight > n) {
            ScrollBar scrollBar = this.getVerticalBar();
            this.scroll(0, this.translate - scrollBar.getSelection(), 0, 0, this.getClientArea().width, n, false);
            this.translate = scrollBar.getSelection();
        } else {
            this.translate = 0;
        }
    }

    protected void scrollHorizontal() {
        int n = this.getClientArea().width;
        if (this.gWidth > n) {
            ScrollBar scrollBar = this.getHorizontalBar();
            this.scroll(this.translate - scrollBar.getSelection(), 0, 0, 0, n, this.getClientArea().height, false);
            this.translate = scrollBar.getSelection();
        } else {
            this.translate = 0;
        }
    }

    protected void addItem(GalleryItem galleryItem, int n) {
        if (n != -1 && (n < 0 || n > this.getItemCount())) {
            throw new IllegalArgumentException("ERROR_INVALID_RANGE ");
        }
        this._addItem(galleryItem, n);
    }

    private void _addItem(GalleryItem galleryItem, int n) {
        this.items = (GalleryItem[])this._arrayAddItem((Object[])this.items, (Object)galleryItem, n);
        this.updateStructuralValues(null, false);
        this.updateScrollBarsProperties();
    }

    public GalleryItem getItem(int n) {
        this.checkWidget();
        return this._getItem(n);
    }

    protected GalleryItem _getItem(GalleryItem galleryItem, int n) {
        if (n < galleryItem.getItemCount()) {
            this.updateItem(galleryItem, n, true);
            return galleryItem.items[n];
        }
        return null;
    }

    protected GalleryItem _getItem(int n) {
        return this._getItem(n, true);
    }

    public GalleryItem _getItem(int n, boolean bl) {
        if (n < this.getItemCount()) {
            this.updateItem(null, n, bl);
            return this.items[n];
        }
        return null;
    }

    protected boolean _mouseDown(MouseEvent mouseEvent) {
        GalleryItem galleryItem;
        if (DEBUG) {
            System.out.println("getitem " + mouseEvent.x + " " + mouseEvent.y);
        }
        if ((galleryItem = this._getGroup(new Point(mouseEvent.x, mouseEvent.y))) != null) {
            int n = this.vertical ? mouseEvent.y + this.translate : mouseEvent.x + this.translate;
            return this.groupRenderer.mouseDown(galleryItem, mouseEvent, new Point(this.vertical ? mouseEvent.x : n, this.vertical ? n : mouseEvent.y));
        }
        return true;
    }

    public GalleryItem getItem(Point point) {
        this.checkWidget();
        if (DEBUG) {
            System.out.println("getitem " + point.x + " " + point.y);
        }
        int n = this.vertical ? point.y + this.translate : point.x + this.translate;
        GalleryItem galleryItem = this._getGroup(point);
        if (galleryItem != null) {
            return this.groupRenderer.getItem(galleryItem, new Point(this.vertical ? point.x : n, this.vertical ? n : point.y));
        }
        return null;
    }

    private GalleryItem _getGroup(Point point) {
        if (this.items == null) {
            return null;
        }
        int n = this.vertical ? point.y + this.translate : point.x + this.translate;
        int n2 = 0;
        GalleryItem galleryItem = null;
        while (n2 < this.items.length) {
            galleryItem = this.getItem(n2);
            if ((this.vertical ? galleryItem.y : galleryItem.x) > n) break;
            if ((this.vertical ? galleryItem.y + galleryItem.height : galleryItem.x + galleryItem.width) >= n) {
                return galleryItem;
            }
            ++n2;
        }
        return null;
    }

    public GalleryItem getGroup(Point point) {
        this.checkWidget();
        return this._getGroup(point);
    }

    public void clearAll(boolean bl) {
        this.checkWidget();
        if (this.items == null) {
            return;
        }
        if (this.virtual) {
            this.items = new GalleryItem[this.items.length];
        } else {
            int n = 0;
            while (n < this.items.length) {
                if (this.items[n] != null) {
                    if (bl) {
                        this.items[n].clearAll(true);
                    } else {
                        this.items[n].clear();
                    }
                }
                ++n;
            }
        }
        this._deselectAll();
        this.updateStructuralValues(null, false);
        this.updateScrollBarsProperties();
        this.redraw();
    }

    public void clearAll() {
        this.clearAll(false);
    }

    public void clear(int n) {
        this.clear(n, false);
    }

    public void clear(int n, boolean bl) {
        this.checkWidget();
        if (this.items[n] == null) {
            return;
        }
        if (this.virtual) {
            this.items[n] = null;
            this.updateStructuralValues(null, false);
            this.updateScrollBarsProperties();
        } else {
            this.items[n].clear();
            if (bl) {
                this.items[n].clearAll(true);
            }
        }
        this.redraw();
    }

    public int indexOf(GalleryItem galleryItem) {
        this.checkWidget();
        if (galleryItem == null) {
            SWT.error((int)4);
        }
        if (galleryItem.getParentItem() == null) {
            return this._indexOf(galleryItem);
        }
        return this._indexOf(galleryItem.getParentItem(), galleryItem);
    }

    protected int _indexOf(GalleryItem galleryItem) {
        int n = this.getItemCount();
        if (galleryItem == null) {
            SWT.error((int)4);
        }
        if (1 <= this.lastIndexOf && this.lastIndexOf < n - 1) {
            if (this.items[this.lastIndexOf] == galleryItem) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == galleryItem) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == galleryItem) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < n / 2) {
            int n2 = 0;
            while (n2 < n) {
                if (this.items[n2] == galleryItem) {
                    this.lastIndexOf = n2;
                    return this.lastIndexOf;
                }
                ++n2;
            }
        } else {
            int n3 = n - 1;
            while (n3 >= 0) {
                if (this.items[n3] == galleryItem) {
                    this.lastIndexOf = n3;
                    return this.lastIndexOf;
                }
                --n3;
            }
        }
        return -1;
    }

    protected int _indexOf(GalleryItem galleryItem, GalleryItem galleryItem2) {
        int n = galleryItem.getItemCount();
        if (galleryItem2 == null) {
            SWT.error((int)4);
        }
        if (1 <= galleryItem.lastIndexOf && galleryItem.lastIndexOf < n - 1) {
            if (galleryItem.items[galleryItem.lastIndexOf] == galleryItem2) {
                return galleryItem.lastIndexOf;
            }
            if (galleryItem.items[galleryItem.lastIndexOf + 1] == galleryItem2) {
                return ++galleryItem.lastIndexOf;
            }
            if (galleryItem.items[galleryItem.lastIndexOf - 1] == galleryItem2) {
                return --galleryItem.lastIndexOf;
            }
        }
        if (galleryItem.lastIndexOf < n / 2) {
            int n2 = 0;
            while (n2 < n) {
                if (galleryItem.items[n2] == galleryItem2) {
                    galleryItem.lastIndexOf = n2;
                    return galleryItem.lastIndexOf;
                }
                ++n2;
            }
        } else {
            int n3 = n - 1;
            while (n3 >= 0) {
                if (galleryItem.items[n3] == galleryItem2) {
                    galleryItem.lastIndexOf = n3;
                    return galleryItem.lastIndexOf;
                }
                --n3;
            }
        }
        return -1;
    }

    public GalleryItem[] getItems() {
        this.checkWidget();
        if (this.items == null) {
            return new GalleryItem[0];
        }
        GalleryItem[] galleryItemArray = new GalleryItem[this.items.length];
        System.arraycopy(this.items, 0, galleryItemArray, 0, this.items.length);
        return galleryItemArray;
    }

    public boolean isVertical() {
        this.checkWidget();
        return this.vertical;
    }

    public void setVertical(boolean bl) {
        this.checkWidget();
        this.vertical = bl;
        this.updateStructuralValues(null, true);
        this.redraw();
    }

    public AbstractGalleryGroupRenderer getGroupRenderer() {
        return this.groupRenderer;
    }

    public void setGroupRenderer(AbstractGalleryGroupRenderer abstractGalleryGroupRenderer) {
        this.groupRenderer = abstractGalleryGroupRenderer;
        if (this.groupRenderer != null) {
            this.groupRenderer.setGallery(this);
        }
        this.updateStructuralValues(null, true);
        this.updateScrollBarsProperties();
        this.redraw();
    }

    public GalleryItem[] getSelection() {
        if (this.selection == null) {
            return new GalleryItem[0];
        }
        return this.selection;
    }

    public int getSelectionCount() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.length;
    }

    public void selectAll() {
        this.checkWidget();
        this._selectAll();
        this.redraw();
    }

    protected void _selectAll() {
        this.select(0, this.getItemCount() - 1);
    }

    public void setSelection(GalleryItem[] galleryItemArray) {
        this.checkWidget();
        this._deselectAll();
        int n = 0;
        while (n < galleryItemArray.length) {
            this.setSelected(galleryItemArray[n], true, false);
            this._showItem(galleryItemArray[n]);
            this.lastSingleClick = galleryItemArray[n];
            ++n;
        }
        this.redraw();
    }

    public void removeAll() {
        this.checkWidget();
        if (this.items != null) {
            GalleryItem[] galleryItemArray = new GalleryItem[this.items.length];
            System.arraycopy(this.items, 0, galleryItemArray, 0, this.items.length);
            int n = 0;
            while (n < galleryItemArray.length) {
                if (galleryItemArray[n] != null) {
                    galleryItemArray[n]._dispose();
                }
                ++n;
            }
        }
    }

    public void remove(int n) {
        this.checkWidget();
        this._remove(n);
        this.updateStructuralValues(null, false);
        this.updateScrollBarsProperties();
        this.redraw();
    }

    public void remove(GalleryItem galleryItem) {
        this.remove(this.indexOf(galleryItem));
    }

    protected void _remove(int n) {
        if (this.isSelected(this.items[n])) {
            this.setSelected(this.items[n], false, false);
        }
        this.items = (GalleryItem[])this._arrayRemoveItem((Object[])this.items, n);
    }

    protected void _remove(GalleryItem galleryItem, int n) {
        if (this.isSelected(galleryItem.items[n])) {
            this.setSelected(galleryItem.items[n], false, false);
        }
        galleryItem.items = (GalleryItem[])this._arrayRemoveItem((Object[])galleryItem.items, n);
    }

    protected Object[] _arrayRemoveItem(Object[] objectArray, int n) {
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 1 && n == 0) {
            return null;
        }
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray[0].getClass(), objectArray.length - 1);
        if (n > 0) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
        }
        if (n + 1 < objectArray.length) {
            System.arraycopy(objectArray, n + 1, objectArray2, n, objectArray2.length - n);
        }
        return objectArray2;
    }

    protected Object[] _arrayAddItem(Object[] objectArray, Object object, int n) {
        int n2 = 0;
        if (objectArray != null) {
            n2 = objectArray.length;
        }
        Object[] objectArray2 = (Object[])Array.newInstance(object.getClass(), n2 + 1);
        if (objectArray != null) {
            System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        }
        if (n != -1) {
            int n3 = objectArray2.length - 2;
            while (n3 >= n) {
                if (n3 >= 0) {
                    objectArray2[n3 + 1] = objectArray2[n3];
                }
                --n3;
            }
            objectArray2[n] = object;
        } else {
            objectArray2[objectArray2.length - 1] = object;
        }
        return objectArray2;
    }

    protected int _arrayIndexOf(int[] nArray, int n) {
        if (nArray == null) {
            return -1;
        }
        int n2 = nArray.length - 1;
        while (n2 >= 0) {
            if (nArray[n2] == n) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    protected int _arrayIndexOf(Object[] objectArray, Object object) {
        if (objectArray == null) {
            return -1;
        }
        int n = objectArray.length - 1;
        while (n >= 0) {
            if (objectArray[n] == object) {
                return n;
            }
            --n;
        }
        return -1;
    }

    protected int[] _arrayRemoveItem(int[] nArray, int n) {
        if (nArray == null) {
            return null;
        }
        if (nArray.length == 1 && n == 0) {
            return null;
        }
        int[] nArray2 = new int[nArray.length - 1];
        if (n > 0) {
            System.arraycopy(nArray, 0, nArray2, 0, n);
        }
        if (n + 1 < nArray.length) {
            System.arraycopy(nArray, n + 1, nArray2, n, nArray2.length - n);
        }
        return nArray2;
    }

    public void _setGalleryItems(GalleryItem[] galleryItemArray) {
        this.items = galleryItemArray;
    }

    public boolean isVirtualGroups() {
        return this.virtualGroups;
    }

    public void setVirtualGroups(boolean bl) {
        this.virtualGroups = bl;
    }

    public int getVirtualGroupDefaultItemCount() {
        return this.virtualGroupDefaultItemCount;
    }

    public boolean isVirtualGroupsCompatibilityMode() {
        return this.virtualGroupsCompatibilityMode;
    }

    public void setVirtualGroupsCompatibilityMode(boolean bl) {
        this.virtualGroupsCompatibilityMode = bl;
    }

    public void setVirtualGroupDefaultItemCount(int n) {
        this.virtualGroupDefaultItemCount = n;
    }

    protected class RedrawTimer
    implements Runnable {
        protected RedrawTimer() {
        }

        public void run() {
            Gallery.this.redraw();
        }
    }
}

