/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.gallery;

import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class GalleryItem
extends Item {
    private static final String EMPTY_STRING = "";
    private String[] text = new String[3];
    protected GalleryItem[] items = null;
    protected int x = 0;
    protected int y = 0;
    protected int width = 0;
    protected int height = 0;
    protected int marginBottom = 0;
    protected int hCount = 0;
    protected int vCount = 0;
    protected int lastIndexOf = 0;
    private boolean virtualGallery;
    private Gallery parent;
    private GalleryItem parentItem;
    protected int[] selectionIndices = null;
    protected Font font;
    protected Color foreground;
    protected Color background;
    private boolean ultraLazyDummy = false;
    private boolean expanded;

    protected boolean isUltraLazyDummy() {
        return this.ultraLazyDummy;
    }

    protected void setUltraLazyDummy(boolean bl) {
        this.ultraLazyDummy = bl;
    }

    public Gallery getParent() {
        return this.parent;
    }

    protected void setParent(Gallery gallery) {
        this.parent = gallery;
    }

    public GalleryItem getParentItem() {
        return this.parentItem;
    }

    protected void setParentItem(GalleryItem galleryItem) {
        this.parentItem = galleryItem;
    }

    public GalleryItem(Gallery gallery, int n) {
        this(gallery, n, -1, true);
    }

    public GalleryItem(Gallery gallery, int n, int n2) {
        this(gallery, n, n2, true);
    }

    public GalleryItem(GalleryItem galleryItem, int n) {
        this(galleryItem, n, -1, true);
    }

    public GalleryItem(GalleryItem galleryItem, int n, int n2) {
        this(galleryItem, n, n2, true);
    }

    protected GalleryItem(GalleryItem galleryItem, int n, int n2, boolean bl) {
        super((Widget)galleryItem, n);
        this.parent = galleryItem.parent;
        this.parentItem = galleryItem;
        if ((galleryItem.getStyle() & 0x10000000) > 0) {
            this.virtualGallery = true;
        }
        if (bl) {
            galleryItem.addItem(this, n2);
        }
    }

    protected GalleryItem(Gallery gallery, int n, int n2, boolean bl) {
        super((Widget)gallery, n);
        this.parent = gallery;
        this.parentItem = null;
        if ((gallery.getStyle() & 0x10000000) > 0) {
            this.virtualGallery = true;
        }
        if (bl) {
            gallery.addItem(this, n2);
        }
    }

    protected void addItem(GalleryItem galleryItem, int n) {
        if (n != -1 && (n < 0 || n > this.getItemCount())) {
            throw new IllegalArgumentException("ERROR_INVALID_RANGE");
        }
        this._addItem(galleryItem, n);
    }

    private void _addItem(GalleryItem galleryItem, int n) {
        this.items = (GalleryItem[])this.parent._arrayAddItem((Object[])this.items, (Object)galleryItem, n);
        this.parent.updateStructuralValues(null, false);
        this.parent.updateScrollBarsProperties();
    }

    public int getItemCount() {
        if (this.items == null) {
            return 0;
        }
        return this.items.length;
    }

    public void setItemCount(int n) {
        if (n == 0) {
            this.items = null;
        } else {
            GalleryItem[] galleryItemArray = new GalleryItem[n];
            if (this.items != null) {
                System.arraycopy(this.items, 0, galleryItemArray, 0, Math.min(n, this.items.length));
            }
            this.items = galleryItemArray;
        }
    }

    public GalleryItem getItem(int n) {
        this.checkWidget();
        return this.parent._getItem(this, n);
    }

    public GalleryItem[] getItems() {
        this.checkWidget();
        if (this.items == null) {
            return new GalleryItem[0];
        }
        GalleryItem[] galleryItemArray = new GalleryItem[this.items.length];
        System.arraycopy(this.items, 0, galleryItemArray, 0, this.items.length);
        return galleryItemArray;
    }

    public int indexOf(GalleryItem galleryItem) {
        this.checkWidget();
        return this.parent._indexOf(this, galleryItem);
    }

    public void setImage(Image image) {
        super.setImage(image);
        this.parent.redraw(this);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        this.checkWidget();
        this._setExpanded(bl, true);
    }

    public void _setExpanded(boolean bl, boolean bl2) {
        this.expanded = bl;
        this.parent.updateStructuralValues(this, false);
        this.parent.updateScrollBarsProperties();
        if (bl2) {
            this.parent.redraw();
        }
    }

    public String getDescription() {
        return this.getText(1);
    }

    public void setDescription(String string) {
        this.setText(1, string);
    }

    public void deselectAll() {
        this.checkWidget();
        this._deselectAll();
        this.parent.redraw();
    }

    protected void _deselectAll() {
        this.selectionIndices = null;
        if (this.items == null) {
            return;
        }
        int n = 0;
        while (n < this.items.length) {
            if (this.items[n] != null) {
                this.items[n]._deselectAll();
            }
            ++n;
        }
    }

    protected void _addSelection(GalleryItem galleryItem) {
        if (!this.parent.multi) {
            this._deselectAll();
        }
        if (galleryItem.getParentItem() == this) {
            if (this.selectionIndices == null) {
                this.selectionIndices = new int[1];
            } else {
                int[] nArray = this.selectionIndices;
                this.selectionIndices = new int[nArray.length + 1];
                System.arraycopy(nArray, 0, this.selectionIndices, 0, nArray.length);
            }
            this.selectionIndices[this.selectionIndices.length - 1] = this.indexOf(galleryItem);
        }
    }

    protected boolean isSelected(GalleryItem galleryItem) {
        if (galleryItem == null) {
            return false;
        }
        if (galleryItem.getParentItem() == this) {
            if (this.selectionIndices == null) {
                return false;
            }
            int n = this.indexOf(galleryItem);
            int n2 = 0;
            while (n2 < this.selectionIndices.length) {
                if (this.selectionIndices[n2] == n) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected void select(int n, int n2) {
        if (Gallery.DEBUG) {
            System.out.println("GalleryItem.select(  " + n + "," + n2 + ")");
        }
        int n3 = n;
        while (n3 <= n2) {
            GalleryItem galleryItem = this.getItem(n3);
            this.parent._addSelection(galleryItem);
            galleryItem._selectAll();
            ++n3;
        }
    }

    public Rectangle getBounds() {
        if (this.parent.isVertical()) {
            return new Rectangle(this.x, this.y - this.parent.translate, this.width, this.height);
        }
        return new Rectangle(this.x - this.parent.translate, this.y, this.width, this.height);
    }

    public Font getFont() {
        this.checkWidget();
        return this.font;
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        this.font = font;
        this.parent.redraw(this);
    }

    public Color getForeground() {
        this.checkWidget();
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.foreground = color;
        this.parent.redraw(this);
    }

    public Color getBackground() {
        this.checkWidget();
        return this.background;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.background = color;
        this.parent.redraw(this);
    }

    public void clear() {
        this.checkWidget();
        super.setText(EMPTY_STRING);
        super.setImage(null);
        this.font = null;
        this.background = null;
        this.foreground = null;
        this.parent.redraw(this);
    }

    public void clearAll() {
        this.clearAll(false);
    }

    public void clearAll(boolean bl) {
        this.checkWidget();
        if (this.items == null) {
            return;
        }
        if (this.virtualGallery) {
            this.items = new GalleryItem[this.items.length];
        } else {
            int n = 0;
            while (n < this.items.length) {
                if (this.items[n] != null) {
                    if (bl) {
                        this.items[n].clearAll(true);
                    }
                    this.items[n].clear();
                }
                ++n;
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        this._selectAll();
        this.parent.redraw();
    }

    protected void _selectAll() {
        this.select(0, this.getItemCount() - 1);
    }

    public void remove(int n) {
        this.checkWidget();
        this.parent._remove(this, n);
        this.parent.updateStructuralValues(null, false);
        this.parent.updateScrollBarsProperties();
        this.parent.redraw();
    }

    public void remove(GalleryItem galleryItem) {
        this.remove(this.indexOf(galleryItem));
    }

    protected void _dispose() {
        this.removeFromParent();
        this._disposeChildren();
        super.dispose();
    }

    protected void _disposeChildren() {
        if (this.items != null) {
            while (this.items != null) {
                if (this.items[this.items.length - 1] == null) continue;
                this.items[this.items.length - 1]._dispose();
            }
        }
    }

    protected void removeFromParent() {
        if (this.parentItem != null) {
            int n = this.parent._indexOf(this.parentItem, this);
            this.parent._remove(this.parentItem, n);
        } else {
            int n = this.parent._indexOf(this);
            this.parent._remove(n);
        }
    }

    public void dispose() {
        this.checkWidget();
        this.removeFromParent();
        this._disposeChildren();
        super.dispose();
        this.parent.updateStructuralValues(null, false);
        this.parent.updateScrollBarsProperties();
        this.parent.redraw();
    }

    public void setText(String string) {
        this.setText(0, string);
    }

    public void setText(int n, String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        this.text[n] = string;
        this.parent.redraw(this);
    }

    public String getText() {
        return this.getText(0);
    }

    public String getText(int n) {
        this.checkWidget();
        return this.text[n];
    }
}

