/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.gallery;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.RendererHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class ListItemRenderer
extends AbstractGalleryItemRenderer {
    protected ArrayList dropShadowsColors = new ArrayList();
    boolean dropShadows = false;
    int dropShadowsSize = 5;
    int dropShadowsAlphaStep = 20;
    Color selectionBackgroundColor;
    Color selectionForegroundColor;
    Color foregroundColor = Display.getDefault().getSystemColor(24);
    Color backgroundColor = Display.getDefault().getSystemColor(25);
    Color descriptionColor;
    Font textFont = null;
    Font descriptionFont = null;
    boolean showLabels = true;
    boolean showRoundedSelectionCorners = true;
    int selectionRadius = 15;

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean bl) {
        this.showLabels = bl;
    }

    public ListItemRenderer() {
        this.selectionBackgroundColor = Display.getDefault().getSystemColor(26);
        this.selectionForegroundColor = Display.getDefault().getSystemColor(24);
        this.descriptionColor = Display.getDefault().getSystemColor(16);
    }

    public void draw(GC gC, GalleryItem galleryItem, int n, int n2, int n3, int n4, int n5) {
        Object object;
        Image image = galleryItem.getImage();
        Color color = galleryItem.getBackground();
        Color color2 = galleryItem.getForeground();
        int n6 = n5;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        Point point = null;
        if (image != null) {
            object = image.getBounds();
            n7 = object.width;
            n8 = object.height;
            point = RendererHelper.getBestSize(n7, n8, n6 - 4 - this.dropShadowsSize, n6 - 4 - this.dropShadowsSize);
            n9 = (n6 - point.x >> 1) + 2;
            n10 = n6 - point.y >> 1;
            if (this.dropShadows) {
                Color color3 = null;
                int n11 = this.dropShadowsSize - 1;
                while (n11 >= 0) {
                    color3 = (Color)this.dropShadowsColors.get(n11);
                    gC.setForeground(color3);
                    gC.drawLine(n2 + n6 + n11 - n9 - 1, n3 + this.dropShadowsSize + n10, n2 + n6 + n11 - n9 - 1, n3 + n6 + n11 - n10);
                    gC.drawLine(n2 + n9 + this.dropShadowsSize, n3 + n6 + n11 - n10 - 1, n2 + n6 + n11 - n9, n3 - 1 + n6 + n11 - n10);
                    --n11;
                }
            }
        }
        if (this.selected || color != null) {
            if (this.selected) {
                gC.setBackground(this.selectionBackgroundColor);
                gC.setForeground(this.selectionBackgroundColor);
            } else if (color != null) {
                gC.setBackground(color);
            }
            if (this.showRoundedSelectionCorners) {
                gC.fillRoundRectangle(n2, n3, n4, n6, this.selectionRadius, this.selectionRadius);
            } else {
                gC.fillRectangle(n2, n3, n4, n6);
            }
        }
        if (image != null && point != null && point.x > 0 && point.y > 0) {
            gC.drawImage(image, 0, 0, n7, n8, n2 + n9, n3 + n10, point.x, point.y);
            this.drawAllOverlays(gC, galleryItem, n2, n3, point, n9, n10);
        }
        if (galleryItem.getText() != null && !"".equals(galleryItem.getText()) && this.showLabels) {
            gC.setFont(this.textFont);
            object = RendererHelper.createLabel(galleryItem.getText(), gC, n4 - n6 - 10);
            int n12 = gC.getFontMetrics().getHeight();
            String string = null;
            int n13 = 0;
            if (galleryItem.getText(1) != null) {
                gC.setFont(this.descriptionFont);
                string = RendererHelper.createLabel(galleryItem.getText(1), gC, n4 - n6 - 10);
                n13 = gC.getFontMetrics().getHeight();
            }
            boolean bl = false;
            boolean bl2 = false;
            int n14 = n5 - 2 - n12;
            if (n14 > 0) {
                bl = true;
            }
            if ((n14 -= n13) > 0) {
                bl2 = true;
            }
            gC.setBackground(this.selected ? this.selectionBackgroundColor : this.backgroundColor);
            if (bl) {
                int n15 = n5 - n12 - 2;
                if (bl2) {
                    n15 -= n13;
                }
                n15 >>= 1;
                if (this.selected) {
                    gC.setForeground(this.selectionForegroundColor);
                } else if (color2 != null) {
                    gC.setForeground(color2);
                } else {
                    gC.setForeground(this.foregroundColor);
                }
                gC.setFont(this.textFont);
                gC.drawText((String)object, n2 + n6 + 5, n3 + n15, true);
            }
            if (string != null && bl2) {
                gC.setForeground(this.descriptionColor);
                gC.setFont(this.descriptionFont);
                gC.drawText(string, n2 + n6 + 5, n3 + (n5 - n13 - n12 - 2 >> 1) + n12 + 1, true);
            }
        }
    }

    public void setDropShadowsSize(int n) {
        this.dropShadowsSize = n;
        this.dropShadowsAlphaStep = n == 0 ? 0 : 200 / n;
        this.freeDropShadowsColors();
        this.createColors();
    }

    private void createColors() {
        if (this.dropShadowsSize > 0) {
            int n = 125 / this.dropShadowsSize;
            int n2 = this.dropShadowsSize - 1;
            while (n2 >= 0) {
                int n3 = 255 - n2 * n;
                Color color = new Color((Device)Display.getDefault(), n3, n3, n3);
                this.dropShadowsColors.add(color);
                --n2;
            }
        }
    }

    private void freeDropShadowsColors() {
        Iterator iterator = this.dropShadowsColors.iterator();
        while (iterator.hasNext()) {
            Color color = (Color)iterator.next();
            if (color == null || color.isDisposed()) continue;
            color.dispose();
        }
    }

    public boolean isDropShadows() {
        return this.dropShadows;
    }

    public void setDropShadows(boolean bl) {
        this.dropShadows = bl;
    }

    public int getDropShadowsSize() {
        return this.dropShadowsSize;
    }

    public void dispose() {
        this.freeDropShadowsColors();
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color color) {
        this.selectionBackgroundColor = color;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getDescriptionColor() {
        return this.descriptionColor;
    }

    public void setDescriptionColor(Color color) {
        this.descriptionColor = color;
    }

    public Color getSelectionForegroundColor() {
        return this.selectionForegroundColor;
    }

    public void setSelectionForegroundColor(Color color) {
        this.selectionForegroundColor = color;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
    }

    public Font getDescriptionFont() {
        return this.descriptionFont;
    }

    public void setDescriptionFont(Font font) {
        this.descriptionFont = font;
    }

    public boolean isShowRoundedSelectionCorners() {
        return this.showRoundedSelectionCorners;
    }

    public void setShowRoundedSelectionCorners(boolean bl) {
        this.showRoundedSelectionCorners = bl;
    }
}

