/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.javascript;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.e4.internal.javascript.JSBundleContext;
import org.eclipse.e4.internal.javascript.JSBundleData;
import org.eclipse.e4.internal.javascript.JSExport;
import org.eclipse.e4.internal.javascript.JSFrameworkImpl;
import org.eclipse.e4.internal.javascript.JSImport;
import org.eclipse.e4.internal.javascript.JSRequire;
import org.eclipse.e4.javascript.Constants;
import org.eclipse.e4.javascript.JSBundle;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.osgi.framework.Version;

public class JSBundleImpl
implements JSBundle {
    private static final String ACTIVATOR_STOP_METHOD = "stop";
    private static final String ACTIVATOR_START_METHOD = "start";
    private String symbolicName;
    private Version version;
    private List imports;
    private List requires;
    private List exports;
    private boolean singleton = false;
    private boolean markedStarted = false;
    private int state;
    private Scriptable scope;
    private JSFrameworkImpl framework;
    private JSBundleData bundleData;
    JSBundleContext bundleContext;
    Scriptable activator;

    public JSBundleImpl(JSFrameworkImpl jSFrameworkImpl, JSBundleData jSBundleData) {
        this.framework = jSFrameworkImpl;
        this.bundleData = jSBundleData;
        Map map = jSBundleData.getHeaders();
        String string = (String)map.get("BundleSymbolicName");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        this.symbolicName = stringTokenizer.nextToken().trim();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf("=") != -1) {
                String string3;
                int n = string2.indexOf("=");
                String string4 = string2.substring(0, n).trim();
                if (string4.length() == 0) {
                    throw new IllegalArgumentException("bad syntax: " + string2 + " in " + string);
                }
                if (!string4.equals(Constants.SINGLETON_ATTRIBUTE) || !(string3 = string2.substring(n + "=".length()).trim()).equalsIgnoreCase(Boolean.TRUE.toString())) continue;
                this.singleton = true;
                continue;
            }
            throw new IllegalArgumentException("bad syntax: " + string2 + " in " + string);
        }
        this.symbolicName = this.symbolicName.trim();
        this.version = this.parseVersion((String)map.get("BundleVersion"));
        this.imports = this.parseImports((String)map.get("Imports"));
        this.exports = this.parseExports((String)map.get("Exports"));
        this.requires = this.parseRequires((String)map.get("Requires"));
        this.state = 2;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.symbolicName == null ? 0 : this.symbolicName.hashCode());
        n = 31 * n + (this.version == null ? 0 : this.version.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JSBundleImpl jSBundleImpl = (JSBundleImpl)object;
        if (this.symbolicName == null ? jSBundleImpl.symbolicName != null : !this.symbolicName.equals(jSBundleImpl.symbolicName)) {
            return false;
        }
        return !(this.version == null ? jSBundleImpl.version != null : !this.version.equals((Object)jSBundleImpl.version));
    }

    private Version parseVersion(String string) {
        return Version.parseVersion((String)string);
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Version getVersion() {
        return this.version;
    }

    public List getImports() {
        return this.imports;
    }

    public List getRequires() {
        return this.requires;
    }

    public List getExports() {
        return this.exports;
    }

    private List parseRequires(String string) {
        if (string == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<JSRequire> arrayList = new ArrayList<JSRequire>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            JSRequire jSRequire = new JSRequire(string2);
            if (jSRequire == null) continue;
            arrayList.add(jSRequire);
        }
        return arrayList;
    }

    private List parseExports(String string) {
        if (string == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<JSExport> arrayList = new ArrayList<JSExport>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            JSExport jSExport = new JSExport(string2, this);
            if (jSExport == null) continue;
            arrayList.add(jSExport);
        }
        return arrayList;
    }

    private List parseImports(String string) {
        if (string == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<JSImport> arrayList = new ArrayList<JSImport>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            JSImport jSImport = new JSImport(string2);
            if (jSImport == null) continue;
            arrayList.add(jSImport);
        }
        return arrayList;
    }

    public int getBundleId() {
        return this.bundleData.getBundleId();
    }

    public String getLocation() {
        return this.bundleData.getLocation();
    }

    public Map getHeaders() {
        return this.bundleData.getHeaders();
    }

    public int getState() {
        return this.state;
    }

    public void uninstall() {
        this.state = 1;
    }

    protected void resolve() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.state != 2) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Object object5 = this.imports.iterator();
        while (object5.hasNext()) {
            object4 = (JSImport)object5.next();
            object3 = ((JSImport)object4).getWiredExport();
            if (hashMap.containsKey(((JSExport)object3).getName())) continue;
            hashMap.put(((JSExport)object3).getName(), object3);
        }
        object5 = this.requires.iterator();
        while (object5.hasNext()) {
            object4 = (JSRequire)object5.next();
            object3 = ((JSRequire)object4).getWiredBundle();
            object2 = ((JSBundleImpl)object3).getExports();
            object = object2.iterator();
            while (object.hasNext()) {
                JSExport jSExport = (JSExport)object.next();
                if (hashMap.containsKey(jSExport.getName())) continue;
                hashMap.put(jSExport.getName(), jSExport);
            }
        }
        object5 = new ArrayList(hashMap.keySet());
        Collections.sort(object5);
        object4 = this.framework.createScope(this.bundleData.getContextClassLoader());
        object3 = ((ArrayList)object5).iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            object = (JSExport)hashMap.get(object2);
            ((JSExport)object).addToScope((Scriptable)object4);
        }
        this.evalScript((Scriptable)object4);
        this.scope = object4;
        this.state = 4;
    }

    private void evalScript(Scriptable scriptable) {
        Context context = Context.getCurrentContext();
        String string = (String)this.bundleData.getHeaders().get("ScriptPath");
        if (string == null) {
            string = ".";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equals(".")) {
                object = (String)this.bundleData.getHeaders().get("Script");
                if (object == null) continue;
                context.evaluateString(scriptable, (String)object, "script.js", 0, null);
                continue;
            }
            object = null;
            try {
                try {
                    URL uRL = this.bundleData.getEntry(string2);
                    object = new InputStreamReader(uRL.openStream());
                    context.evaluateReader(scriptable, (Reader)object, string2, 0, null);
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Error reading script for " + this.toString() + ": " + iOException.getMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    if (object != null) {
                        ((Reader)object).close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (object == null) continue;
                ((Reader)object).close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void unresolve() {
        if (this.state != 1) {
            return;
        }
        this.scope = null;
    }

    public String toString() {
        return "JavaScriptBundle{symbolic-name=" + this.symbolicName + ", version=" + this.version.toString() + "}";
    }

    public Scriptable getScope() {
        return this.scope;
    }

    public void start() {
        this.markedStarted = true;
        if (this.state != 4) {
            return;
        }
        this.state = 8;
        this.bundleContext = this.framework.getBundleContext(this);
        this.activator = this.createActivatorInstance();
        if (this.activator != null) {
            final Callable callable = (Callable)this.activator.get(ACTIVATOR_START_METHOD, this.activator);
            Context.call((ContextAction)new ContextAction(){

                public Object run(Context context) {
                    callable.call(context, JSBundleImpl.this.activator, JSBundleImpl.this.activator, new Object[]{JSBundleImpl.this.bundleContext});
                    return null;
                }
            });
        }
        this.state = 32;
    }

    private Scriptable createActivatorInstance() {
        String string = (String)this.getHeaders().get("Activator");
        if (string == null) {
            return null;
        }
        Scriptable scriptable = this.scope;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (true) {
            String string2 = stringTokenizer.nextToken();
            Object object = scriptable.get(string2, scriptable);
            if (!stringTokenizer.hasMoreTokens()) {
                if (!(object instanceof Function)) {
                    return null;
                }
                final Function function = (Function)object;
                final Scriptable scriptable2 = scriptable;
                return (Scriptable)Context.call((ContextAction)new ContextAction(){

                    public Object run(Context context) {
                        return function.construct(context, scriptable2, null);
                    }
                });
            }
            if (!(object instanceof Scriptable)) break;
            scriptable = (Scriptable)object;
        }
        return null;
    }

    public void stop() {
        this.markedStarted = false;
        if (this.state != 32) {
            return;
        }
        this.state = 16;
        if (this.activator != null) {
            final Callable callable = (Callable)this.activator.get(ACTIVATOR_STOP_METHOD, this.activator);
            Context.call((ContextAction)new ContextAction(){

                public Object run(Context context) {
                    callable.call(Context.getCurrentContext(), JSBundleImpl.this.activator, JSBundleImpl.this.activator, new Object[]{JSBundleImpl.this.bundleContext});
                    return null;
                }
            });
        }
        this.state = 4;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public boolean isMarkedStarted() {
        return this.markedStarted;
    }

    public Object call(final ContextAction contextAction) {
        final ClassLoader classLoader = this.bundleData.getContextClassLoader();
        if (classLoader == null) {
            return Context.call((ContextAction)contextAction);
        }
        return Context.call((ContextAction)new ContextAction(){

            public Object run(Context context) {
                ClassLoader classLoader2 = context.getApplicationClassLoader();
                context.setApplicationClassLoader(classLoader);
                try {
                    Object object = contextAction.run(context);
                    return object;
                }
                finally {
                    context.setApplicationClassLoader(classLoader2);
                }
            }
        });
    }
}

