/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.javascript;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.internal.javascript.JSFrameworkImpl;
import org.eclipse.e4.javascript.JSBundle;
import org.eclipse.e4.javascript.JSBundleException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;

public class JSBundleTracker
extends BundleTracker {
    private JSFrameworkImpl framework;
    private Map jsBundleMap = new HashMap();

    public JSBundleTracker(BundleContext bundleContext, JSFrameworkImpl jSFrameworkImpl) {
        super(bundleContext, 60, null);
        this.framework = jSFrameworkImpl;
    }

    public JSBundle getJSBundle(Bundle bundle) {
        return (JSBundle)this.jsBundleMap.get(bundle);
    }

    public Object addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        String string = (String)bundle.getHeaders().get("JavaScript-Bundle");
        if (string == null) {
            return null;
        }
        URL uRL = bundle.getEntry(string.trim());
        if (uRL == null) {
            return null;
        }
        try {
            JSBundle jSBundle = this.framework.installBundle(uRL.toString(), bundle);
            this.jsBundleMap.put(bundle, jSBundle);
            this.framework.resolve();
            if (bundleEvent == null && bundle.getState() == 32) {
                jSBundle.start();
            }
            return jSBundle;
        }
        catch (JSBundleException jSBundleException) {
            jSBundleException.printStackTrace();
            return null;
        }
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Object object) {
        if (bundleEvent == null) {
            return;
        }
        JSBundle jSBundle = (JSBundle)object;
        switch (bundleEvent.getType()) {
            case 2: {
                jSBundle.start();
                break;
            }
            case 256: {
                jSBundle.stop();
            }
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, Object object) {
        JSBundle jSBundle = (JSBundle)object;
        jSBundle.uninstall();
        this.jsBundleMap.remove(bundle);
        this.framework.refresh();
    }
}

