/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.javascript;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.e4.javascript.JSBundle;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.osgi.framework.Version;

public class JSExport {
    private JSBundle exportingBundle;
    private String name;
    private Version version = Version.emptyVersion;
    private Map attributes = new HashMap();
    private Map directives = new HashMap();
    private List mandatory = new ArrayList();

    public JSExport(String string, JSBundle jSBundle) {
        if (string == null) {
            throw new IllegalArgumentException("header cannot be null");
        }
        if (jSBundle == null) {
            throw new IllegalArgumentException("exportingBundle cannot be null");
        }
        this.parseExport(string);
        this.exportingBundle = jSBundle;
    }

    public JSBundle getExportingBundle() {
        return this.exportingBundle;
    }

    private void parseExport(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        this.name = stringTokenizer.nextToken().trim();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (string2.indexOf(":=") != -1) {
                this.parseDirective(string2);
                continue;
            }
            if (string2.indexOf("=") == -1) continue;
            this.parseAttribute(string2);
        }
    }

    private void parseAttribute(String string) {
        int n = string.indexOf("=");
        String string2 = string.substring(0, n).trim();
        if (string2.length() == 0) {
            return;
        }
        String string3 = string.substring(n + "=".length()).trim();
        if (string2.equals("version")) {
            this.version = Version.parseVersion((String)string3);
        }
        this.attributes.put(string2, string3);
    }

    private void parseDirective(String string) {
        int n = string.indexOf(":=");
        String string2 = string.substring(0, n).trim();
        if (string2.length() == 0) {
            return;
        }
        String string3 = string.substring(n + ":=".length()).trim();
        if (string2.equals("mandatory")) {
            this.parseMandatory(string3);
        }
        this.directives.put(string2, string3);
    }

    private void parseMandatory(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = (String)stringTokenizer.nextElement();
            if ((string2 = string2.trim()).length() <= 0) continue;
            this.mandatory.add(string2);
        }
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getBundleSymbolicName() {
        return this.exportingBundle.getSymbolicName();
    }

    public Version getBundleVersion() {
        return this.exportingBundle.getVersion();
    }

    public int getBundleId() {
        return this.exportingBundle.getBundleId();
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Map getDirectives() {
        return this.directives;
    }

    public List getMandatory() {
        return this.mandatory;
    }

    protected void addToScope(Scriptable scriptable) {
        Scriptable scriptable2 = this.exportingBundle.getScope();
        Object object = this.getExportValue(this.name, scriptable2);
        if (Scriptable.NOT_FOUND == object) {
            throw new IllegalStateException("Resolve error: " + this.name + " for " + this.toString());
        }
        this.putExportValue(this.name, scriptable, object);
    }

    private Object getExportValue(String string, Scriptable scriptable) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (true) {
            String string2 = stringTokenizer.nextToken();
            Object object = scriptable.get(string2, scriptable);
            if (!stringTokenizer.hasMoreTokens()) {
                return object;
            }
            if (!(object instanceof Scriptable)) break;
            scriptable = (Scriptable)object;
        }
        return Scriptable.NOT_FOUND;
    }

    private void putExportValue(String string, Scriptable scriptable, Object object) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (true) {
            Scriptable scriptable2;
            String string2 = stringTokenizer.nextToken();
            Object object2 = scriptable.get(string2, scriptable);
            if (!stringTokenizer.hasMoreTokens()) {
                if (object2 == Scriptable.NOT_FOUND) {
                    if (object instanceof NativeObject) {
                        scriptable2 = Context.getCurrentContext().newObject(scriptable);
                        scriptable2.setPrototype((Scriptable)object);
                        object = scriptable2;
                    }
                    scriptable.put(string2, scriptable, object);
                    return;
                }
                throw new IllegalStateException("Resolve error: " + string + " already exists for " + this.toString());
            }
            if (object2 == Scriptable.NOT_FOUND) {
                object2 = ScriptableObject.getProperty((Scriptable)scriptable, (String)string2);
                if (object2 == Scriptable.NOT_FOUND) {
                    object2 = Context.getCurrentContext().newObject(scriptable);
                } else if (object2 instanceof NativeObject) {
                    scriptable2 = Context.getCurrentContext().newObject(scriptable);
                    scriptable2.setPrototype((Scriptable)object2);
                    object2 = scriptable2;
                } else {
                    throw new IllegalStateException("Resolve error: " + string + "-" + string2 + " already exists for " + this.toString());
                }
                scriptable.put(string2, scriptable, object2);
            }
            scriptable = (Scriptable)object2;
        }
    }
}

