/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.javascript;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.internal.javascript.JSBundleContext;
import org.eclipse.e4.internal.javascript.JSBundleData;
import org.eclipse.e4.internal.javascript.JSBundleImpl;
import org.eclipse.e4.internal.javascript.JSExport;
import org.eclipse.e4.internal.javascript.JSImport;
import org.eclipse.e4.internal.javascript.JSONUtil;
import org.eclipse.e4.internal.javascript.JSRequire;
import org.eclipse.e4.internal.javascript.RhinoClassLoader;
import org.eclipse.e4.javascript.JSBundle;
import org.eclipse.e4.javascript.JSBundleException;
import org.eclipse.e4.javascript.JSFramework;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.osgi.framework.Bundle;

public class JSFrameworkImpl
implements JSFramework {
    private static final Comparator exportsComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            JSExport jSExport = (JSExport)object;
            JSExport jSExport2 = (JSExport)object2;
            int n = jSExport2.getVersion().compareTo((Object)jSExport.getVersion());
            if (n == 0) {
                n = jSExport.getBundleId() - jSExport2.getBundleId();
            }
            return n;
        }
    };
    private static final Comparator requireBundlesComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            JSBundle jSBundle = (JSBundle)object;
            JSBundle jSBundle2 = (JSBundle)object2;
            int n = jSBundle2.getVersion().compareTo((Object)jSBundle.getVersion());
            if (n == 0) {
                n = jSBundle.getBundleId() - jSBundle2.getBundleId();
            }
            return n;
        }
    };
    private List installOrderBundles = new ArrayList();
    private List resolveOrderBundles = new ArrayList();
    private Map exports = new HashMap();
    private Map requiredBundles = new HashMap();
    private int currentBundleId = 0;
    private final Scriptable frameworkScope;
    private final Map properties = new HashMap();

    private static Map loadHeaders(String string) throws JSBundleException {
        String string2;
        Object object;
        try {
            object = new URL(string);
            string2 = JSFrameworkImpl.readContents((URL)object);
        }
        catch (IOException iOException) {
            throw new JSBundleException("error reading contents from: " + string, iOException);
        }
        try {
            object = JSONUtil.read(string2);
            if (object instanceof Map) {
                return (Map)object;
            }
            throw new JSBundleException("invalid representation - JSON Object expected from: " + string);
        }
        catch (RuntimeException runtimeException) {
            throw new JSBundleException("error parsing JSON contents from: " + string, runtimeException);
        }
    }

    private static String readContents(URL uRL) throws IOException {
        String string;
        InputStreamReader inputStreamReader = new InputStreamReader(new BufferedInputStream(uRL.openStream()));
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            char[] cArray = new char[1024];
            while (-1 != (n = inputStreamReader.read(cArray))) {
                stringBuffer.append(cArray, 0, n);
            }
            string = stringBuffer.toString();
        }
        catch (Throwable throwable) {
            try {
                ((Reader)inputStreamReader).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((Reader)inputStreamReader).close();
        }
        catch (IOException iOException) {}
        return string;
    }

    public JSFrameworkImpl() {
        this.frameworkScope = (Scriptable)Context.call((ContextAction)new ContextAction(){

            public Object run(Context context) {
                return context.initStandardObjects();
            }
        });
    }

    public JSBundle installBundle(String string) throws JSBundleException {
        Map map = JSFrameworkImpl.loadHeaders(string);
        return this.installBundle(string, map);
    }

    public JSBundle installBundle(String string, Map map) throws JSBundleException {
        return this.installBundle(string, map, new RhinoClassLoader());
    }

    public JSBundle installBundle(String string, Bundle bundle) throws JSBundleException {
        Map map = JSFrameworkImpl.loadHeaders(string);
        return this.installBundle(string, map, new RhinoClassLoader(bundle));
    }

    public JSBundle installBundle(String string, Map map, Bundle bundle) throws JSBundleException {
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle cannot be null");
        }
        return this.installBundle(string, map, new RhinoClassLoader(bundle));
    }

    public JSBundle installBundle(String string, Map map, RhinoClassLoader rhinoClassLoader) throws JSBundleException {
        JSBundleData jSBundleData;
        JSBundleImpl jSBundleImpl;
        int n;
        if (string == null) {
            throw new IllegalArgumentException("Location cannot be null");
        }
        if (rhinoClassLoader == null) {
            rhinoClassLoader = new RhinoClassLoader();
        }
        if ((n = this.installOrderBundles.indexOf(jSBundleImpl = new JSBundleImpl(this, jSBundleData = new JSBundleData(this.currentBundleId, string, map, rhinoClassLoader)))) != -1) {
            return (JSBundle)this.installOrderBundles.get(n);
        }
        ++this.currentBundleId;
        this.installOrderBundles.add(jSBundleImpl);
        return jSBundleImpl;
    }

    public JSBundle[] getBundles() {
        return this.installOrderBundles.toArray(new JSBundle[this.installOrderBundles.size()]);
    }

    public void refresh() {
        boolean bl = false;
        Iterator iterator = this.resolveOrderBundles.iterator();
        while (iterator.hasNext()) {
            JSBundleImpl jSBundleImpl = (JSBundleImpl)iterator.next();
            if (jSBundleImpl.getState() == 1) {
                bl = true;
                this.installOrderBundles.remove(jSBundleImpl);
            }
            if (!bl) continue;
            this.unresolveBundle(jSBundleImpl);
            iterator.remove();
        }
        if (bl) {
            this.resolve();
        }
    }

    public void resolve() {
        final ArrayList<JSBundle> arrayList = new ArrayList<JSBundle>();
        Iterator iterator = this.installOrderBundles.iterator();
        while (iterator.hasNext()) {
            JSBundle jSBundle = (JSBundle)iterator.next();
            if (jSBundle.getState() != 2) continue;
            arrayList.add(jSBundle);
        }
        Context.call((ContextAction)new ContextAction(){

            public Object run(Context context) {
                Object object;
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                while (!arrayList.isEmpty()) {
                    object = JSFrameworkImpl.this.stepResolver(arrayList);
                    if (object == null) break;
                    arrayList2.add(object);
                }
                object = arrayList2.iterator();
                while (object.hasNext()) {
                    JSBundleImpl jSBundleImpl = (JSBundleImpl)object.next();
                    if (!jSBundleImpl.isMarkedStarted()) continue;
                    jSBundleImpl.start();
                }
                return null;
            }
        });
    }

    JSBundleImpl stepResolver(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JSBundleImpl jSBundleImpl = (JSBundleImpl)iterator.next();
            if (!this.resolveBundle(jSBundleImpl)) continue;
            this.resolveOrderBundles.add(jSBundleImpl);
            iterator.remove();
            return jSBundleImpl;
        }
        return null;
    }

    private boolean resolveBundle(JSBundleImpl jSBundleImpl) {
        if (jSBundleImpl.isSingleton() && this.requiredBundles.containsKey(jSBundleImpl.getSymbolicName())) {
            return false;
        }
        if (this.wire(jSBundleImpl)) {
            jSBundleImpl.resolve();
            this.addExports(jSBundleImpl);
            this.addRequiredBunde(jSBundleImpl);
            return true;
        }
        this.unwire(jSBundleImpl);
        return false;
    }

    private void unresolveBundle(JSBundleImpl jSBundleImpl) {
        this.removeExports(jSBundleImpl);
        this.removeRequiredBunde(jSBundleImpl);
        jSBundleImpl.unresolve();
        this.unwire(jSBundleImpl);
    }

    private boolean wire(JSBundleImpl jSBundleImpl) {
        return this.wireRequires(jSBundleImpl) && this.wireImports(jSBundleImpl);
    }

    private boolean wireRequires(JSBundleImpl jSBundleImpl) {
        List list = jSBundleImpl.getRequires();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JSRequire jSRequire = (JSRequire)iterator.next();
            String string = jSRequire.getName();
            List list2 = (List)this.requiredBundles.get(string);
            if (list2 == null) {
                return false;
            }
            boolean bl = false;
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                JSBundleImpl jSBundleImpl2 = (JSBundleImpl)iterator2.next();
                bl = jSRequire.wire(jSBundleImpl2);
                if (bl) break;
            }
            if (bl || jSRequire.isOptional()) continue;
            return false;
        }
        return true;
    }

    private boolean wireImports(JSBundleImpl jSBundleImpl) {
        List list = jSBundleImpl.getImports();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JSImport jSImport = (JSImport)iterator.next();
            String string = jSImport.getName();
            List list2 = (List)this.exports.get(string);
            if (list2 == null) {
                return false;
            }
            boolean bl = false;
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                JSExport jSExport = (JSExport)iterator2.next();
                bl = jSImport.wire(jSExport);
                if (bl) break;
            }
            if (bl || jSImport.isOptional()) continue;
            return false;
        }
        return true;
    }

    private void addExports(JSBundleImpl jSBundleImpl) {
        Iterator iterator = jSBundleImpl.getExports().iterator();
        while (iterator.hasNext()) {
            JSExport jSExport = (JSExport)iterator.next();
            String string = jSExport.getName();
            ArrayList<JSExport> arrayList = (ArrayList<JSExport>)this.exports.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<JSExport>();
                this.exports.put(string, arrayList);
            }
            arrayList.add(jSExport);
            Collections.sort(arrayList, exportsComparator);
        }
    }

    private void addRequiredBunde(JSBundle jSBundle) {
        String string = jSBundle.getSymbolicName();
        ArrayList<JSBundle> arrayList = (ArrayList<JSBundle>)this.requiredBundles.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<JSBundle>();
            this.requiredBundles.put(string, arrayList);
        }
        arrayList.add(jSBundle);
        Collections.sort(arrayList, requireBundlesComparator);
    }

    private void unwire(JSBundleImpl jSBundleImpl) {
        this.unwireImports(jSBundleImpl);
        this.unwireRequires(jSBundleImpl);
    }

    private void unwireImports(JSBundleImpl jSBundleImpl) {
        List list = jSBundleImpl.getImports();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JSImport jSImport = (JSImport)iterator.next();
            jSImport.unwire();
        }
    }

    private void unwireRequires(JSBundleImpl jSBundleImpl) {
        List list = jSBundleImpl.getRequires();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JSRequire jSRequire = (JSRequire)iterator.next();
            jSRequire.unwire();
        }
    }

    private void removeRequiredBunde(JSBundle jSBundle) {
        String string = jSBundle.getSymbolicName();
        List list = (List)this.requiredBundles.get(string);
        if (list == null) {
            return;
        }
        list.remove(jSBundle);
        if (list.isEmpty()) {
            this.requiredBundles.remove(string);
        }
    }

    private void removeExports(JSBundleImpl jSBundleImpl) {
        Iterator iterator = jSBundleImpl.getExports().iterator();
        while (iterator.hasNext()) {
            JSExport jSExport = (JSExport)iterator.next();
            String string = jSExport.getName();
            List list = (List)this.exports.get(string);
            if (list == null) continue;
            list.remove(jSBundleImpl);
            if (!list.isEmpty()) continue;
            this.exports.remove(string);
        }
    }

    protected Scriptable createScope(ClassLoader classLoader) {
        Context context = Context.getCurrentContext();
        ClassLoader classLoader2 = context.getApplicationClassLoader();
        context.setApplicationClassLoader(classLoader);
        try {
            ScriptableObject scriptableObject = (ScriptableObject)context.newObject(this.frameworkScope);
            scriptableObject.setParentScope(this.frameworkScope);
            new LazilyLoadedCtor(scriptableObject, "Packages", "org.mozilla.javascript.NativeJavaTopPackage", false);
            scriptableObject.get("Packages", (Scriptable)scriptableObject);
            ScriptableObject scriptableObject2 = scriptableObject;
            return scriptableObject2;
        }
        finally {
            context.setApplicationClassLoader(classLoader2);
        }
    }

    public JSBundleContext getBundleContext(JSBundle jSBundle) {
        return new JSBundleContext(jSBundle, this);
    }

    public String getProperty(String string) {
        return (String)this.properties.get(string);
    }

    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public void shutdown() {
        ArrayList arrayList = new ArrayList(this.installOrderBundles);
        Collections.reverse(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            JSBundle jSBundle = (JSBundle)iterator.next();
            jSBundle.stop();
            jSBundle.uninstall();
        }
        this.refresh();
    }
}

