/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.javascript;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.e4.internal.javascript.JSExport;
import org.eclipse.e4.internal.javascript.VersionRange;

public class JSImport {
    private String name;
    private VersionRange versionRange = VersionRange.emptyRange;
    private String bundleSymbolicName;
    private VersionRange bundleVersionRange = VersionRange.emptyRange;
    private boolean optional = false;
    private Map attributes = new HashMap();
    private Map directives = new HashMap();
    private JSExport wiredExport;

    public JSImport(String string) {
        if (string == null) {
            throw new IllegalArgumentException("header cannot be null");
        }
        this.parseImport(string);
    }

    private void parseImport(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        this.name = stringTokenizer.nextToken().trim();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (string2.indexOf(":=") != -1) {
                this.parseDirective(string2);
                continue;
            }
            if (string2.indexOf("=") != -1) {
                this.parseAttribute(string2);
                continue;
            }
            throw new IllegalArgumentException("bad import syntax: " + string2 + " in " + string);
        }
    }

    private void parseAttribute(String string) {
        int n = string.indexOf("=");
        String string2 = string.substring(0, n).trim();
        if (string2.length() == 0) {
            return;
        }
        String string3 = string.substring(n + "=".length()).trim();
        if (string2.equals("version")) {
            this.versionRange = new VersionRange(string3);
        } else if (string2.equals("bundle-symbolic-name")) {
            this.bundleSymbolicName = string3;
        } else if (string2.equals("bundle-version")) {
            this.bundleVersionRange = new VersionRange(string3);
        }
        this.attributes.put(string2, string3);
    }

    private void parseDirective(String string) {
        int n = string.indexOf(":=");
        String string2 = string.substring(0, n).trim();
        if (string2.length() == 0) {
            return;
        }
        String string3 = string.substring(n + ":=".length()).trim();
        if (string2.equals("resolution")) {
            this.optional = "optional".equals(string3);
        }
        this.directives.put(string2, string3);
    }

    public String getName() {
        return this.name;
    }

    public VersionRange getVersionRange() {
        return this.versionRange;
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public VersionRange getBundleVersionRange() {
        return this.bundleVersionRange;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Map getDirectives() {
        return this.directives;
    }

    public boolean wire(JSExport jSExport) {
        Object v;
        String string;
        Map.Entry entry;
        if (!this.name.equals(jSExport.getName())) {
            return false;
        }
        Iterator iterator = this.attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string = (String)entry.getKey();
            if (string.equals("version")) {
                if (this.versionRange.isIncluded(jSExport.getVersion())) continue;
                return false;
            }
            if (string.equals("bundle-symbolic-name")) {
                if (this.bundleSymbolicName.equals(jSExport.getBundleSymbolicName())) continue;
                return false;
            }
            if (string.equals("bundle-version")) {
                if (this.bundleVersionRange.isIncluded(jSExport.getBundleVersion())) continue;
                return false;
            }
            v = entry.getValue();
            Object v2 = jSExport.getAttributes().get(string);
            if (v2 != null && v2.equals(v)) continue;
            return false;
        }
        iterator = jSExport.getMandatory().iterator();
        while (iterator.hasNext()) {
            entry = (String)((Object)iterator.next());
            string = jSExport.getAttributes().get(entry);
            v = this.attributes.get(entry);
            if (v != null && v.equals(string)) continue;
            return false;
        }
        this.wiredExport = jSExport;
        return true;
    }

    public JSExport getWiredExport() {
        return this.wiredExport;
    }

    public void unwire() {
        this.wiredExport = null;
    }
}

