/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.javascript;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.e4.internal.javascript.JSBundleImpl;
import org.eclipse.e4.internal.javascript.VersionRange;

public class JSRequire {
    private String name;
    private Map attributes = new HashMap();
    private Map directives = new HashMap();
    private boolean optional = false;
    private VersionRange bundleVersionRange = VersionRange.emptyRange;
    private JSBundleImpl wiredBundle;

    public JSRequire(String string) {
        if (string == null) {
            throw new IllegalArgumentException("header cannot be null");
        }
        this.parseRequire(string);
    }

    private void parseRequire(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        this.name = stringTokenizer.nextToken().trim();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (string2.indexOf(":=") != -1) {
                this.parseDirective(string2);
                continue;
            }
            if (string2.indexOf("=") == -1) continue;
            this.parseAttribute(string2);
        }
    }

    private void parseAttribute(String string) {
        int n = string.indexOf("=");
        String string2 = string.substring(0, n).trim();
        if (string2.length() == 0) {
            return;
        }
        String string3 = string.substring(n + "=".length()).trim();
        if (string2.equals("bundle-version")) {
            this.bundleVersionRange = new VersionRange(string3);
        }
        this.attributes.put(string2, string3);
    }

    private void parseDirective(String string) {
        int n = string.indexOf(":=");
        String string2 = string.substring(0, n).trim();
        if (string2.length() == 0) {
            return;
        }
        String string3 = string.substring(n + ":=".length()).trim();
        if (string2.equals("resolution")) {
            this.optional = "optional".equals(string3);
        }
        this.directives.put(string2, string3);
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getName() {
        return this.name;
    }

    public VersionRange getBundleVersionRange() {
        return this.bundleVersionRange;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Map getDirectives() {
        return this.directives;
    }

    public boolean wire(JSBundleImpl jSBundleImpl) {
        if (!this.name.equals(jSBundleImpl.getSymbolicName())) {
            return false;
        }
        Iterator iterator = this.attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            if (!string.equals("bundle-version") || this.bundleVersionRange.isIncluded(jSBundleImpl.getVersion())) continue;
            return false;
        }
        this.wiredBundle = jSBundleImpl;
        return true;
    }

    public JSBundleImpl getWiredBundle() {
        return this.wiredBundle;
    }

    public void unwire() {
        this.wiredBundle = null;
    }
}

