/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.content.BasicDescription;
import org.eclipse.core.internal.content.ContentDescription;
import org.eclipse.core.internal.content.ContentMessages;
import org.eclipse.core.internal.content.ContentTypeCatalog;
import org.eclipse.core.internal.content.ContentTypeHandler;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.internal.content.ContentTypeSettings;
import org.eclipse.core.internal.content.DefaultDescription;
import org.eclipse.core.internal.content.FileSpec;
import org.eclipse.core.internal.content.IContentTypeInfo;
import org.eclipse.core.internal.content.ILazySource;
import org.eclipse.core.internal.content.LowLevelIOException;
import org.eclipse.core.internal.content.Util;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeSettings;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class ContentType
implements IContentType,
IContentTypeInfo {
    static final byte ASSOCIATED_BY_EXTENSION = 2;
    static final byte ASSOCIATED_BY_NAME = 1;
    private static final String DESCRIBER_ELEMENT = "describer";
    private static ArrayList EMPTY_LIST = new ArrayList(0);
    private static final Object INHERITED_DESCRIBER = "INHERITED DESCRIBER";
    private static final Object NO_DESCRIBER = "NO DESCRIBER";
    static final byte NOT_ASSOCIATED = 0;
    public static final String PREF_DEFAULT_CHARSET = "charset";
    public static final String PREF_FILE_EXTENSIONS = "file-extensions";
    public static final String PREF_FILE_NAMES = "file-names";
    static final byte PRIORITY_HIGH = 1;
    static final byte PRIORITY_LOW = -1;
    static final byte PRIORITY_NORMAL = 0;
    static final int SPEC_PRE_DEFINED = 1;
    static final int SPEC_USER_DEFINED = 2;
    static final byte STATUS_INVALID = 2;
    static final byte STATUS_UNKNOWN = 0;
    static final byte STATUS_VALID = 1;
    private String aliasTargetId;
    private String baseTypeId;
    private boolean builtInAssociations = false;
    private ContentTypeCatalog catalog;
    private IConfigurationElement contentTypeElement;
    private DefaultDescription defaultDescription;
    private Map defaultProperties;
    private Object describer;
    private ArrayList fileSpecs = EMPTY_LIST;
    String id;
    private ContentTypeManager manager;
    private String name;
    private byte priority;
    private ContentType target;
    private String userCharset;
    private byte validation = 0;
    private ContentType baseType;
    private byte depth = (byte)-1;

    public static ContentType createContentType(ContentTypeCatalog contentTypeCatalog, String string, String string2, byte by, String[] stringArray, String[] stringArray2, String string3, String string4, Map map, IConfigurationElement iConfigurationElement) {
        ContentType contentType = new ContentType(contentTypeCatalog.getManager());
        contentType.catalog = contentTypeCatalog;
        contentType.defaultDescription = new DefaultDescription(contentType);
        contentType.id = string;
        contentType.name = string2;
        contentType.priority = by;
        if (stringArray != null && stringArray.length > 0 || stringArray2 != null && stringArray2.length > 0) {
            contentType.builtInAssociations = true;
            contentType.fileSpecs = new ArrayList(stringArray.length + stringArray2.length);
            int n = 0;
            while (n < stringArray2.length) {
                contentType.internalAddFileSpec(stringArray2[n], 5);
                ++n;
            }
            n = 0;
            while (n < stringArray.length) {
                contentType.internalAddFileSpec(stringArray[n], 9);
                ++n;
            }
        }
        contentType.defaultProperties = map;
        contentType.contentTypeElement = iConfigurationElement;
        contentType.baseTypeId = string3;
        contentType.aliasTargetId = string4;
        return contentType;
    }

    static FileSpec createFileSpec(String string, int n) {
        return new FileSpec(string, n);
    }

    static String getPreferenceKey(int n) {
        if ((n & 8) != 0) {
            return PREF_FILE_EXTENSIONS;
        }
        if ((n & 4) != 0) {
            return PREF_FILE_NAMES;
        }
        throw new IllegalArgumentException("Unknown type: " + n);
    }

    private static String getValidationString(byte by) {
        return by == 1 ? "VALID" : (by == 2 ? "INVALID" : "UNKNOWN");
    }

    public static void log(String string, Throwable throwable) {
        Status status = new Status(4, "org.eclipse.core.contenttype", 0, string, throwable instanceof CoreException ? null : throwable);
        RuntimeLog.log((IStatus)status);
    }

    public ContentType(ContentTypeManager contentTypeManager) {
        this.manager = contentTypeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileSpec(String string, int n) throws CoreException {
        Object[] objectArray;
        Assert.isLegal((n == 8 || n == 4 ? 1 : 0) != 0, (String)("Unknown type: " + n));
        ContentType contentType = this;
        synchronized (contentType) {
            if (!this.internalAddFileSpec(string, n | 2)) {
                return;
            }
            objectArray = this.getFileSpecs(n | 1);
        }
        contentType = this.manager.getPreferences().node(this.id);
        String string2 = Util.toListString(objectArray);
        Assert.isNotNull((Object)string2);
        ContentType.setPreference((Preferences)contentType, ContentType.getPreferenceKey(n), string2);
        try {
            contentType.flush();
        }
        catch (BackingStoreException backingStoreException) {
            String string3 = NLS.bind((String)ContentMessages.content_errorSavingSettings, (Object)this.id);
            Status status = new Status(4, "org.eclipse.core.contenttype", 0, string3, (Throwable)backingStoreException);
            throw new CoreException((IStatus)status);
        }
        this.manager.fireContentTypeChangeEvent(this);
    }

    int describe(IContentDescriber iContentDescriber, ILazySource iLazySource, ContentDescription contentDescription) throws IOException {
        try {
            int n = iLazySource.isText() ? ((ITextContentDescriber)iContentDescriber).describe((Reader)((Object)iLazySource), (IContentDescription)contentDescription) : iContentDescriber.describe((InputStream)((Object)iLazySource), contentDescription);
            return n;
        }
        catch (RuntimeException runtimeException) {
            this.invalidateDescriber(runtimeException);
        }
        catch (Error error) {
            this.invalidateDescriber(error);
            throw error;
        }
        catch (LowLevelIOException lowLevelIOException) {
            throw lowLevelIOException.getActualException();
        }
        catch (IOException iOException) {
            if (ContentTypeManager.DEBUGGING) {
                String string = NLS.bind((String)ContentMessages.content_errorReadingContents, (Object)this.id);
                ContentType.log(string, iOException);
            }
            return 1;
        }
        finally {
            iLazySource.rewind();
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof ContentType) {
            return this.id.equals(((ContentType)object).id);
        }
        if (object instanceof ContentTypeHandler) {
            return this.id.equals(((ContentTypeHandler)object).id);
        }
        return false;
    }

    public String getAliasTargetId() {
        return this.aliasTargetId;
    }

    public IContentType getBaseType() {
        return this.baseType;
    }

    String getBaseTypeId() {
        return this.baseTypeId;
    }

    public ContentTypeCatalog getCatalog() {
        return this.catalog;
    }

    public ContentType getContentType() {
        return this;
    }

    public String getDefaultCharset() {
        return this.getDefaultProperty(IContentDescription.CHARSET);
    }

    public IContentDescription getDefaultDescription() {
        return this.defaultDescription;
    }

    public String getDefaultProperty(QualifiedName qualifiedName) {
        String string = this.internalGetDefaultProperty(qualifiedName);
        if ("".equals(string)) {
            return null;
        }
        return string;
    }

    byte getDepth() {
        byte by = this.depth;
        if (by >= 0) {
            return by;
        }
        if (this.baseType == null) {
            this.depth = 0;
            return 0;
        }
        this.depth = (byte)(this.baseType == null ? 0 : 1 + this.baseType.getDepth());
        return this.depth;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IContentDescriber getDescriber() {
        try {
            Object object = this.describer;
            if (object != null) {
                if (INHERITED_DESCRIBER == object) {
                    return this.baseType.getDescriber();
                }
                if (NO_DESCRIBER == object) {
                    return null;
                }
                IContentDescriber iContentDescriber = (IContentDescriber)object;
                return iContentDescriber;
            }
            String string = this.contentTypeElement.getAttributeAsIs(DESCRIBER_ELEMENT);
            if (string != null || this.contentTypeElement.getChildren(DESCRIBER_ELEMENT).length > 0) {
                try {
                    if ("".equals(string)) {
                        this.describer = NO_DESCRIBER;
                        return null;
                    }
                    this.describer = object = this.contentTypeElement.createExecutableExtension(DESCRIBER_ELEMENT);
                    return (IContentDescriber)object;
                }
                catch (CoreException coreException) {
                    return this.invalidateDescriber(coreException);
                }
            }
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            this.manager.invalidate();
            return null;
        }
        if (this.baseType == null) {
            this.describer = NO_DESCRIBER;
            return null;
        }
        this.describer = INHERITED_DESCRIBER;
        return this.baseType.getDescriber();
    }

    public IContentDescription getDescriptionFor(InputStream inputStream, QualifiedName[] qualifiedNameArray) throws IOException {
        return this.internalGetDescriptionFor(ContentTypeManager.readBuffer(inputStream), qualifiedNameArray);
    }

    public IContentDescription getDescriptionFor(Reader reader, QualifiedName[] qualifiedNameArray) throws IOException {
        return this.internalGetDescriptionFor(ContentTypeManager.readBuffer(reader), qualifiedNameArray);
    }

    public String[] getFileSpecs(int n) {
        if (this.fileSpecs.isEmpty()) {
            return new String[0];
        }
        n ^= 3;
        ArrayList<String> arrayList = new ArrayList<String>(this.fileSpecs.size());
        Iterator iterator = this.fileSpecs.iterator();
        while (iterator.hasNext()) {
            FileSpec fileSpec = (FileSpec)iterator.next();
            if ((fileSpec.getType() & n) != fileSpec.getType()) continue;
            arrayList.add(fileSpec.getText());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    byte getPriority() {
        return this.priority;
    }

    public IContentTypeSettings getSettings(IScopeContext iScopeContext) {
        if (iScopeContext == null || iScopeContext.equals(this.manager.getContext())) {
            return this;
        }
        return new ContentTypeSettings(this, iScopeContext);
    }

    ContentType getAliasTarget(boolean bl) {
        return bl && this.target == null ? this : this.target;
    }

    byte getValidation() {
        return this.validation;
    }

    boolean hasBuiltInAssociations() {
        return this.builtInAssociations;
    }

    boolean hasFileSpec(IScopeContext iScopeContext, String string, int n) {
        if (iScopeContext.equals(this.manager.getContext()) || (n & 2) != 0) {
            return this.hasFileSpec(string, n, false);
        }
        String[] stringArray = ContentTypeSettings.getFileSpecs(iScopeContext, this.id, n);
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n2])) {
                return true;
            }
            ++n2;
        }
        return this.hasFileSpec(string, n | 1, false);
    }

    boolean hasFileSpec(String string, int n, boolean bl) {
        if (this.fileSpecs.isEmpty()) {
            return false;
        }
        Iterator iterator = this.fileSpecs.iterator();
        while (iterator.hasNext()) {
            FileSpec fileSpec = (FileSpec)iterator.next();
            if (!fileSpec.equals(string, n, bl)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    boolean internalAddFileSpec(String string, int n) {
        if (this.hasFileSpec(string, n, false)) {
            return false;
        }
        FileSpec fileSpec = ContentType.createFileSpec(string, n);
        if ((n & 2) == 0) {
            if (this.fileSpecs.isEmpty()) {
                this.fileSpecs = new ArrayList(3);
            }
            this.fileSpecs.add(fileSpec);
            return true;
        }
        ArrayList arrayList = (ArrayList)this.fileSpecs.clone();
        arrayList.add(fileSpec);
        this.catalog.associate(this, fileSpec.getText(), fileSpec.getType());
        this.fileSpecs = arrayList;
        return true;
    }

    String internalGetDefaultProperty(QualifiedName qualifiedName) {
        if (this.userCharset != null && qualifiedName.equals((Object)IContentDescription.CHARSET)) {
            return this.userCharset;
        }
        String string = this.basicGetDefaultProperty(qualifiedName);
        if (string != null) {
            return string;
        }
        return this.baseType == null ? null : this.baseType.internalGetDefaultProperty(qualifiedName);
    }

    String basicGetDefaultProperty(QualifiedName qualifiedName) {
        return this.defaultProperties == null ? null : (String)this.defaultProperties.get(qualifiedName);
    }

    BasicDescription internalGetDescriptionFor(ILazySource iLazySource, QualifiedName[] qualifiedNameArray) throws IOException {
        if (iLazySource == null) {
            return this.defaultDescription;
        }
        IContentDescriber iContentDescriber = this.getDescriber();
        if (iContentDescriber == null) {
            return this.defaultDescription;
        }
        if (iLazySource.isText() && !(iContentDescriber instanceof ITextContentDescriber)) {
            throw new UnsupportedOperationException();
        }
        ContentDescription contentDescription = new ContentDescription(qualifiedNameArray, this);
        if (this.describe(iContentDescriber, iLazySource, contentDescription) == 0) {
            return null;
        }
        if (!contentDescription.isSet()) {
            return this.defaultDescription;
        }
        contentDescription.markImmutable();
        return contentDescription;
    }

    byte internalIsAssociatedWith(String string, IScopeContext iScopeContext) {
        if (this.hasFileSpec(iScopeContext, string, 4)) {
            return 1;
        }
        String string2 = ContentTypeManager.getFileExtension(string);
        if (this.hasFileSpec(iScopeContext, string2, 8)) {
            return 2;
        }
        if (!this.hasBuiltInAssociations() && this.baseType != null) {
            return this.baseType.internalIsAssociatedWith(string, iScopeContext);
        }
        return 0;
    }

    boolean internalRemoveFileSpec(String string, int n) {
        if (this.fileSpecs.isEmpty()) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.fileSpecs.clone();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            FileSpec fileSpec = (FileSpec)iterator.next();
            if (fileSpec.getType() != n || !string.equals(fileSpec.getText())) continue;
            iterator.remove();
            this.catalog.dissociate(this, fileSpec.getText(), fileSpec.getType());
            this.fileSpecs = arrayList;
            return true;
        }
        return false;
    }

    private IContentDescriber invalidateDescriber(Throwable throwable) {
        String string = NLS.bind((String)ContentMessages.content_invalidContentDescriber, (Object)this.id);
        ContentType.log(string, throwable);
        this.describer = new InvalidDescriber();
        return (IContentDescriber)this.describer;
    }

    boolean isAlias() {
        return this.target != null;
    }

    public boolean isAssociatedWith(String string) {
        return this.isAssociatedWith(string, this.manager.getContext());
    }

    public boolean isAssociatedWith(String string, IScopeContext iScopeContext) {
        return this.internalIsAssociatedWith(string, iScopeContext) != 0;
    }

    public boolean isKindOf(IContentType iContentType) {
        if (iContentType == null) {
            return false;
        }
        if (this == iContentType) {
            return true;
        }
        return this.baseType != null && this.baseType.isKindOf(iContentType);
    }

    boolean isValid() {
        return this.validation == 1;
    }

    void processPreferences(Preferences preferences) {
        this.userCharset = preferences.get(PREF_DEFAULT_CHARSET, null);
        String string = preferences.get(PREF_FILE_NAMES, null);
        String[] stringArray = Util.parseItems(string);
        int n = 0;
        while (n < stringArray.length) {
            this.internalAddFileSpec(stringArray[n], 6);
            ++n;
        }
        String string2 = preferences.get(PREF_FILE_EXTENSIONS, null);
        String[] stringArray2 = Util.parseItems(string2);
        int n2 = 0;
        while (n2 < stringArray2.length) {
            this.internalAddFileSpec(stringArray2[n2], 10);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileSpec(String string, int n) throws CoreException {
        Assert.isLegal((n == 8 || n == 4 ? 1 : 0) != 0, (String)("Unknown type: " + n));
        ContentType contentType = this;
        synchronized (contentType) {
            if (!this.internalRemoveFileSpec(string, n | 2)) {
                return;
            }
        }
        contentType = this.manager.getPreferences().node(this.id);
        Object[] objectArray = this.getFileSpecs(n | 1);
        String string2 = ContentType.getPreferenceKey(n);
        String string3 = Util.toListString(objectArray);
        ContentType.setPreference((Preferences)contentType, string2, string3);
        try {
            contentType.flush();
        }
        catch (BackingStoreException backingStoreException) {
            String string4 = NLS.bind((String)ContentMessages.content_errorSavingSettings, (Object)this.id);
            Status status = new Status(4, "org.eclipse.core.contenttype", 0, string4, (Throwable)backingStoreException);
            throw new CoreException((IStatus)status);
        }
        this.manager.fireContentTypeChangeEvent(this);
    }

    void setAliasTarget(ContentType contentType) {
        this.target = contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultCharset(String string) throws CoreException {
        ContentType contentType = this;
        synchronized (contentType) {
            if (this.userCharset == null) {
                if (string == null) {
                    return;
                }
            } else if (this.userCharset.equals(string)) {
                return;
            }
            this.userCharset = string;
        }
        contentType = this.manager.getPreferences().node(this.id);
        ContentType.setPreference((Preferences)contentType, PREF_DEFAULT_CHARSET, this.userCharset);
        try {
            contentType.flush();
        }
        catch (BackingStoreException backingStoreException) {
            String string2 = NLS.bind((String)ContentMessages.content_errorSavingSettings, (Object)this.id);
            Status status = new Status(4, "org.eclipse.core.contenttype", 0, string2, (Throwable)backingStoreException);
            throw new CoreException((IStatus)status);
        }
        this.manager.fireContentTypeChangeEvent(this);
    }

    static void setPreference(Preferences preferences, String string, String string2) {
        if (string2 == null) {
            preferences.remove(string);
        } else {
            preferences.put(string, string2);
        }
    }

    void setValidation(byte by) {
        this.validation = by;
        if (ContentTypeManager.DEBUGGING) {
            ContentMessages.message("Validating " + this + ": " + ContentType.getValidationString(by));
        }
    }

    public String toString() {
        return this.id;
    }

    void setBaseType(ContentType contentType) {
        this.baseType = contentType;
    }

    private class InvalidDescriber
    implements IContentDescriber,
    ITextContentDescriber {
        private InvalidDescriber() {
        }

        public int describe(InputStream inputStream, IContentDescription iContentDescription) {
            return 0;
        }

        public int describe(Reader reader, IContentDescription iContentDescription) {
            return 0;
        }

        public QualifiedName[] getSupportedOptions() {
            return new QualifiedName[0];
        }
    }
}

