/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.internal.content.ILazySource;
import org.eclipse.core.internal.content.LowLevelIOException;

public class LazyReader
extends Reader
implements ILazySource {
    private int blockCapacity;
    char[][] blocks = new char[0][];
    private int bufferSize;
    private Reader in;
    private int mark;
    private int offset;

    public LazyReader(Reader reader, int n) {
        this.in = reader;
        this.blockCapacity = n;
    }

    public void close() {
    }

    private int computeBlockSize(int n) {
        if (n < this.blocks.length - 1) {
            return this.blockCapacity;
        }
        int n2 = this.bufferSize % this.blockCapacity;
        return n2 == 0 ? this.blockCapacity : n2;
    }

    private int copyFromBuffer(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = this.offset / this.blockCapacity;
        while (n2 - n3 > 0 && n4 < this.blocks.length) {
            int n5 = this.computeBlockSize(n4);
            int n6 = this.offset % this.blockCapacity;
            int n7 = n5 - n6;
            int n8 = Math.min(n7, n2 - n3);
            System.arraycopy(this.blocks[n4], n6, cArray, n + n3, n8);
            n3 += n8;
            ++n4;
            this.offset += n8;
        }
        return n3;
    }

    private void ensureAvailable(long l) throws IOException {
        int n = this.blockCapacity;
        while ((long)this.bufferSize < (long)this.offset + l && n == this.blockCapacity) {
            try {
                n = this.loadBlock();
            }
            catch (IOException iOException) {
                throw new LowLevelIOException(iOException);
            }
            this.bufferSize += n;
        }
    }

    protected int getBlockCount() {
        return this.blocks.length;
    }

    protected int getBufferSize() {
        return this.bufferSize;
    }

    protected int getMark() {
        return this.mark;
    }

    protected int getOffset() {
        return this.offset;
    }

    public boolean isText() {
        return true;
    }

    private int loadBlock() throws IOException {
        char[] cArray = new char[this.blockCapacity];
        int n = this.in.read(cArray);
        if (n == -1) {
            return 0;
        }
        char[][] cArrayArray = new char[this.blocks.length + 1][];
        System.arraycopy(this.blocks, 0, cArrayArray, 0, this.blocks.length);
        this.blocks = cArrayArray;
        this.blocks[this.blocks.length - 1] = cArray;
        return n;
    }

    public void mark(int n) {
        this.mark = this.offset;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        this.ensureAvailable(1L);
        if (this.bufferSize <= this.offset) {
            return -1;
        }
        char c = this.blocks[this.offset / this.blockCapacity][this.offset % this.blockCapacity];
        ++this.offset;
        return c;
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        this.ensureAvailable(n2);
        int n3 = this.copyFromBuffer(cArray, n, n2);
        return n3 == 0 ? -1 : n3;
    }

    public boolean ready() throws IOException {
        try {
            return this.bufferSize - this.offset > 0 || this.in.ready();
        }
        catch (IOException iOException) {
            throw new LowLevelIOException(iOException);
        }
    }

    public void reset() {
        this.offset = this.mark;
    }

    public void rewind() {
        this.mark = 0;
        this.offset = 0;
    }

    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        this.ensureAvailable(l);
        long l2 = Math.min(l, (long)(this.bufferSize - this.offset));
        this.offset = (int)((long)this.offset + l2);
        return l2;
    }
}

