/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.internal.content.Util;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;

public class TextContentDescriber
implements ITextContentDescriber {
    private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.BYTE_ORDER_MARK};

    public int describe(Reader reader, IContentDescription iContentDescription) throws IOException {
        return 1;
    }

    public int describe(InputStream inputStream, IContentDescription iContentDescription) throws IOException {
        if (iContentDescription == null || !iContentDescription.isRequested(IContentDescription.BYTE_ORDER_MARK)) {
            return 1;
        }
        byte[] byArray = Util.getByteOrderMark(inputStream);
        if (byArray != null) {
            iContentDescription.setProperty(IContentDescription.BYTE_ORDER_MARK, byArray);
        }
        return 1;
    }

    public QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }
}

