/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.content;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.internal.content.TextContentDescriber;
import org.eclipse.core.internal.content.Util;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;

public class XMLContentDescriber
extends TextContentDescriber
implements ITextContentDescriber {
    private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
    private static final String ENCODING = "encoding=";
    private static final String XML_PREFIX = "<?xml ";
    private static final String XML_DECL_END = "?>";

    public int describe(InputStream inputStream, IContentDescription iContentDescription) throws IOException {
        byte[] byArray = Util.getByteOrderMark(inputStream);
        String string = "UTF-8";
        inputStream.reset();
        if (byArray != null) {
            if (byArray == IContentDescription.BOM_UTF_16BE) {
                string = "UTF-16BE";
            } else if (byArray == IContentDescription.BOM_UTF_16LE) {
                string = "UTF-16LE";
            }
            inputStream.skip(byArray.length);
            if (iContentDescription != null && iContentDescription.isRequested(IContentDescription.BYTE_ORDER_MARK)) {
                iContentDescription.setProperty(IContentDescription.BYTE_ORDER_MARK, byArray);
            }
        }
        return this.internalDescribe(this.readXMLDecl(inputStream, string), iContentDescription);
    }

    public int describe(Reader reader, IContentDescription iContentDescription) throws IOException {
        return this.internalDescribe(this.readXMLDecl(reader), iContentDescription);
    }

    private int internalDescribe(String string, IContentDescription iContentDescription) throws IOException {
        if (string == null) {
            return 1;
        }
        if (!string.startsWith(XML_PREFIX)) {
            return 1;
        }
        if (iContentDescription == null) {
            return 2;
        }
        if (iContentDescription.isRequested(IContentDescription.CHARSET)) {
            String string2 = this.getCharset(string);
            if (string2 != null && !this.isCharsetValid(string2)) {
                return 0;
            }
            if (string2 != null && !string2.equalsIgnoreCase("utf8") && !string2.equalsIgnoreCase("utf-8")) {
                iContentDescription.setProperty(IContentDescription.CHARSET, string2);
            }
        }
        return 2;
    }

    private boolean isFullXMLDecl(String string) {
        return string.endsWith(XML_DECL_END);
    }

    private String readXMLDecl(InputStream inputStream, String string) throws IOException {
        byte[] byArray = XML_DECL_END.getBytes(string);
        int n = 100 * byArray.length / 2;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < byArray2.length && (n2 = inputStream.read()) != -1) {
            n4 = n2 == byArray[n4] ? ++n4 : 0;
            byArray2[n3++] = (byte)n2;
            if (n4 == byArray.length) break;
        }
        return new String(byArray2, 0, n3, string);
    }

    private String readXMLDecl(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = new String();
        String string2 = null;
        while (string.length() < 100 && (string2 = bufferedReader.readLine()) != null) {
            string = String.valueOf(string) + string2;
            if (string2.indexOf(XML_DECL_END) == -1) continue;
            return string.substring(0, string.indexOf(XML_DECL_END) + XML_DECL_END.length());
        }
        return string;
    }

    private String getCharset(String string) {
        int n = string.indexOf(ENCODING);
        if (n == -1) {
            return null;
        }
        int n2 = 34;
        int n3 = string.indexOf(n2, n);
        if (n3 == -1) {
            n2 = 39;
            n3 = string.indexOf(n2, n);
        }
        if (n3 == -1 || string.length() == n3 - 1) {
            return null;
        }
        int n4 = string.indexOf(n2, n3 + 1);
        if (n4 == -1) {
            return this.isFullXMLDecl(string) ? string.substring(n3 + 1, string.lastIndexOf(XML_DECL_END)).trim() : null;
        }
        return string.substring(n3 + 1, n4);
    }

    private boolean isCharsetValid(String string) {
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            c = string.charAt(n);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.')) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }
}

