/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.services.IContributionFactory;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.model.application.ApplicationFactory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MContributedPart;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MSashForm;
import org.eclipse.e4.ui.model.application.MStack;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.tests.Activator;
import org.eclipse.e4.workbench.ui.internal.ReflectionContributionFactory;
import org.eclipse.e4.workbench.ui.internal.Workbench;
import org.eclipse.e4.workbench.ui.renderers.PartFactory;
import org.eclipse.e4.workbench.ui.renderers.PartRenderer;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MWindowTest
extends TestCase {
    private IEclipseContext appContext;
    private IContributionFactory contributionFactory;
    private Widget topWidget;
    private Display display;

    private IEclipseContext getAppContext() {
        if (this.appContext == null) {
            IEclipseContext iEclipseContext = EclipseContextFactory.createServiceContext((BundleContext)Activator.getDefault().getBundle().getBundleContext());
            this.appContext = EclipseContextFactory.create((IEclipseContext)iEclipseContext, null);
            this.appContext.set("DEBUG_STRING", (Object)"application");
            MApplication mApplication = ApplicationFactory.eINSTANCE.createMApplication();
            this.appContext.set(MApplication.class.getName(), (Object)mApplication);
        }
        return this.appContext;
    }

    private IContributionFactory getCFactory() {
        if (this.contributionFactory == null) {
            this.contributionFactory = new ReflectionContributionFactory(RegistryFactory.getRegistry());
        }
        return this.contributionFactory;
    }

    private Display getDisplay() {
        this.display = Display.getCurrent();
        if (this.display == null) {
            this.display = new Display();
        }
        return this.display;
    }

    protected void processEventLoop() {
        if (this.display != null) {
            while (this.display.readAndDispatch()) {
            }
        }
    }

    protected void tearDown() throws Exception {
        if (this.topWidget != null) {
            this.topWidget.dispose();
            this.topWidget = null;
        }
    }

    public void testCreateWindow() {
        final MWindow mWindow = ApplicationFactory.eINSTANCE.createMWindow();
        mWindow.setHeight(300);
        mWindow.setWidth(400);
        mWindow.setName("MyWindow");
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)this.getDisplay()), (Runnable)new Runnable(){

            public void run() {
                IEclipseContext iEclipseContext = MWindowTest.this.getAppContext();
                PartRenderer partRenderer = new PartRenderer(MWindowTest.this.getCFactory(), iEclipseContext);
                Workbench.initializeRenderer((IExtensionRegistry)RegistryFactory.getRegistry(), (PartRenderer)partRenderer, (IEclipseContext)MWindowTest.this.appContext, (IContributionFactory)MWindowTest.this.getCFactory());
                Object object = partRenderer.createGui((MPart)mWindow);
                MWindowTest.assertNotNull((Object)object);
                MWindowTest.this.topWidget = (Widget)object;
                MWindowTest.assertTrue((boolean)(MWindowTest.this.topWidget instanceof Shell));
                MWindowTest.assertEquals((String)"MyWindow", (String)((Shell)MWindowTest.this.topWidget).getText());
            }
        });
    }

    public void testCreateView() {
        final MWindow<MPart<?>> mWindow = this.createWindowWithOneView();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)this.getDisplay()), (Runnable)new Runnable(){

            public void run() {
                IEclipseContext iEclipseContext = MWindowTest.this.getAppContext();
                PartRenderer partRenderer = new PartRenderer(MWindowTest.this.getCFactory(), iEclipseContext);
                Workbench.initializeRenderer((IExtensionRegistry)RegistryFactory.getRegistry(), (PartRenderer)partRenderer, (IEclipseContext)MWindowTest.this.appContext, (IContributionFactory)MWindowTest.this.getCFactory());
                Object object = partRenderer.createGui((MPart)mWindow);
                MWindowTest.assertNotNull((Object)object);
                MWindowTest.this.topWidget = (Widget)object;
                MWindowTest.assertTrue((boolean)(MWindowTest.this.topWidget instanceof Shell));
                Shell shell = (Shell)MWindowTest.this.topWidget;
                MWindowTest.assertEquals((String)"MyWindow", (String)shell.getText());
                Control[] controlArray = shell.getChildren();
                MWindowTest.assertEquals((int)1, (int)controlArray.length);
                SashForm sashForm = (SashForm)controlArray[0];
                Control[] controlArray2 = sashForm.getChildren();
                MWindowTest.assertEquals((int)1, (int)controlArray2.length);
                CTabFolder cTabFolder = (CTabFolder)controlArray2[0];
                MWindowTest.assertEquals((int)1, (int)cTabFolder.getItemCount());
                Control control = cTabFolder.getItem(0).getControl();
                MWindowTest.assertTrue((boolean)(control instanceof Composite));
                Control[] controlArray3 = ((Composite)control).getChildren();
                MWindowTest.assertEquals((int)1, (int)controlArray3.length);
                MWindowTest.assertTrue((boolean)(controlArray3[0] instanceof Tree));
            }
        });
    }

    public void testContextChildren() {
        final MWindow<MPart<?>> mWindow = this.createWindowWithOneView();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)this.getDisplay()), (Runnable)new Runnable(){

            public void run() {
                IEclipseContext iEclipseContext = MWindowTest.this.getAppContext();
                PartRenderer partRenderer = new PartRenderer(MWindowTest.this.getCFactory(), iEclipseContext);
                Workbench.initializeRenderer((IExtensionRegistry)RegistryFactory.getRegistry(), (PartRenderer)partRenderer, (IEclipseContext)MWindowTest.this.appContext, (IContributionFactory)MWindowTest.this.getCFactory());
                Object object = partRenderer.createGui((MPart)mWindow);
                MWindowTest.assertNotNull((Object)object);
                MWindowTest.this.topWidget = (Widget)object;
                MWindowTest.assertTrue((boolean)(MWindowTest.this.topWidget instanceof Shell));
                Shell shell = (Shell)MWindowTest.this.topWidget;
                MWindowTest.assertEquals((String)"MyWindow", (String)shell.getText());
                IEclipseContext iEclipseContext2 = (IEclipseContext)MWindowTest.this.appContext.get("activeChild");
                MWindowTest.assertNotNull((Object)iEclipseContext2);
                MWindowTest.assertEquals((Object)mWindow.getContext(), (Object)iEclipseContext2);
                MContributedPart mContributedPart = MWindowTest.this.getContributedPart(mWindow);
                MWindowTest.assertNotNull((Object)mContributedPart);
                MWindowTest.assertEquals((Object)mWindow, (Object)mContributedPart.getParent().getParent().getParent());
                PartFactory partFactory = (PartFactory)mContributedPart.getOwner();
                partFactory.activate((MPart)mContributedPart);
                IEclipseContext iEclipseContext3 = (IEclipseContext)iEclipseContext2.get("activeChild");
                while (iEclipseContext3 != iEclipseContext2) {
                    iEclipseContext2 = iEclipseContext3;
                    iEclipseContext3 = (IEclipseContext)iEclipseContext2.get("activeChild");
                }
                MWindowTest.assertFalse((mWindow.getContext() == iEclipseContext2 ? 1 : 0) != 0);
                MContributedPart mContributedPart2 = (MContributedPart)iEclipseContext2.get(MContributedPart.class.getName());
                MWindowTest.assertNotNull((Object)mContributedPart2);
                MWindowTest.assertEquals((Object)mWindow, (Object)mContributedPart2.getParent().getParent().getParent());
            }
        });
    }

    private MContributedPart<MPart<?>> getContributedPart(MWindow<MPart<?>> mWindow) {
        MPart mPart = (MPart)((MPart)((MPart)mWindow.getChildren().get(0)).getChildren().get(0)).getChildren().get(0);
        MWindowTest.assertTrue((String)("part is incorrect type " + mPart), (boolean)(mPart instanceof MContributedPart));
        return (MContributedPart)mPart;
    }

    private MWindow<MPart<?>> createWindowWithOneView() {
        MWindow mWindow = ApplicationFactory.eINSTANCE.createMWindow();
        mWindow.setHeight(300);
        mWindow.setWidth(400);
        mWindow.setName("MyWindow");
        MSashForm mSashForm = ApplicationFactory.eINSTANCE.createMSashForm();
        mWindow.getChildren().add((Object)mSashForm);
        MStack mStack = ApplicationFactory.eINSTANCE.createMStack();
        mSashForm.getChildren().add((Object)mStack);
        MContributedPart mContributedPart = ApplicationFactory.eINSTANCE.createMContributedPart();
        mStack.getChildren().add((Object)mContributedPart);
        mContributedPart.setName("Sample View");
        mContributedPart.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        return mWindow;
    }
}

