/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.tools.actionscript;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.http.jetty.JettyConfigurator;
import org.eclipse.equinox.http.jetty.JettyConstants;
import org.eclipse.swt.tools.actionscript.build.ActionScriptCompilerManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;

/**
 * The activator class controls the plug-in life cycle
 */
public class ActionScriptCorePlugin extends Plugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.eclipse.swt.tools.actionscript.core";

	//Preference store ids
	public static final String PREF_ENABLE_DEBUG_CHECK = PLUGIN_ID + ".enabledebug"; //$NON-NLS-1$
	public static final String PREF_SHOW_ACTIONSCRIPT_ERRORS = PLUGIN_ID + ".showaserrors"; //$NON-NLS-1$
	public static final String PREF_SWC_PATH = PLUGIN_ID + ".swcpath"; //$NON-NLS-1$
	
	// The shared instance
	private static ActionScriptCorePlugin plugin;
	
	public static final int PORT = 7777;
	public static final String LAUNCH_URL = "http://localhost:" + PORT + "/actionscript?path=";
	public static boolean DEPLOY = false;
	public static String DEPLOY_URL = "";
	public static boolean CROSS_DOMAIN = false;
	public static String CROSS_DOMAIN_URL = "";
	public static boolean THEME = false;
	public static String THEME_URL = ""; 
	
	ActionScriptCompilerManager manager;
	
	/**
	 * The constructor
	 */
	public ActionScriptCorePlugin() {
	}

	public ActionScriptCompilerManager getManager () {
		return manager;
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
		manager = new ActionScriptCompilerManager();
		startJCL();
		startJetty();
	}
	
	void startJetty () throws Exception {
		Hashtable settings = new Hashtable();
		settings.put(JettyConstants.HTTP_PORT, new Integer(PORT)); 
		settings.put(JettyConstants.HTTP_ENABLED, new Boolean(true));
		// suppress Jetty INFO/DEBUG messages to stderr
		Logger.getLogger("org.mortbay").setLevel(Level.WARNING); //$NON-NLS-1$	
		JettyConfigurator.startServer(PLUGIN_ID, settings);
		checkBundle();
	}
	
	void startJCL() {
		File jcl = getJCLLocation().toFile();
		System.err.println("startJCL: " + jcl);
		if (!jcl.exists()) {
			System.err.println("finished extraction: " 
					+ extract(jcl.getAbsolutePath(), "jre/actionscriptJCL.jar"));
		}
	}
	
	static boolean extract (String fileName, String mappedName) {
		System.err.println("extract: " + fileName + ", " + mappedName);
		FileOutputStream os = null;
		InputStream is = null;
		File file = new File(fileName);
		try {
			if (!file.exists ()) {
				System.err.println("extract: does not exist");
				is = ActionScriptCorePlugin.class.getResourceAsStream ("/" + mappedName); //$NON-NLS-1$
				System.err.println("extract: is == " + is);
				if (is != null) {
					int read;
					byte [] buffer = new byte [4096];
					os = new FileOutputStream (fileName);
					while ((read = is.read (buffer)) != -1) {
						os.write(buffer, 0, read);
					}
					os.close ();
					is.close ();
				}
			}
			return true;
		} catch (Throwable e) {
			ActionScriptCorePlugin.getDefault().getLog().log(
					new Status(IStatus.ERROR, ActionScriptCorePlugin.PLUGIN_ID,
							"Failed to copy out JCL jar", e));
			try {
				if (os != null)
					os.close();
			} catch (IOException e1) {
			}
			try {
				if (is != null)
					is.close();
			} catch (IOException e1) {
			}
		}
		return false;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
		JettyConfigurator.stopServer(PLUGIN_ID);
		manager.stop();
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static ActionScriptCorePlugin getDefault() {
		return plugin;
	}
	
	public IPath getJCLLocation() {
		IPath stateLocation = ActionScriptCorePlugin.getDefault().getStateLocation();
		return stateLocation.append("actionscriptJCL.jar");
	}

	/*
	 * Ensures that the bundle with the specified name and the highest available
	 * version is started and reads the port number
	 */
	private static void checkBundle() throws InvalidSyntaxException, BundleException {
		Bundle bundle = Platform.getBundle("org.eclipse.equinox.http.registry"); //$NON-NLS-1$if (bundle != null) {
		if (bundle.getState() == Bundle.RESOLVED) {
			bundle.start(Bundle.START_TRANSIENT);
		}
	}
}
