package org.eclipse.swt.tools.actionscript.build;

import java.io.File;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.osgi.service.environment.Constants;
import org.eclipse.swt.tools.actionscript.ActionScriptCorePlugin;

public class ActionScriptVMInstallType extends AbstractVMInstallType {

	protected IVMInstall doCreateVMInstall(String id) {
		return new ActionScriptVMInstall(this, id);
	}

	public File detectInstallLocation() {
		return null;
	}

	public LibraryLocation[] getDefaultLibraryLocations(File installLocation) {
		File jcl = ActionScriptCorePlugin.getDefault().getJCLLocation().toFile();
		return new LibraryLocation[]{new LibraryLocation(new Path(jcl.getAbsolutePath()), Path.EMPTY, Path.EMPTY, null)};
	}

	public String getName() {
		return "ActionScript VM";
	}

	public IStatus validateInstallLocation(File installLocation) {
		IStatus status = null;
		
		if (Platform.getOS().equals(Constants.OS_WIN32)) {
			File browser = findBrowserExecutable(installLocation);
			if (browser == null) {
				status = new Status(IStatus.ERROR, ActionScriptCorePlugin.PLUGIN_ID, 0, "Could not find browser", null); 			
			} else {
				status = new Status(IStatus.OK, ActionScriptCorePlugin.PLUGIN_ID, 0, "Browser found", null); 			
			}
		} else {
			//TODO: e4 add support
			status = new Status(IStatus.ERROR, ActionScriptCorePlugin.PLUGIN_ID, 0, "Not suppported on this OS yet", null); 
		}
		return status;	
	}

	private File findBrowserExecutable(File installLocation) {
		String[] browsers = {"iexplore.exe", "firefox.exe"};
		if (installLocation.isDirectory()) {
			File[] files = installLocation.listFiles();
			for (int i = 0; i < files.length; i++) {
				File file = findBrowserExecutable(files[i]);
				if (file != null) return file;
			}
		}
		
		for (int i = 0; i < browsers.length; i++) {
			if (installLocation.getName().equals(browsers[i])) 
				return installLocation; 
		}
		return null;
	}
	
	public String getExecutable(File file) {
		return findBrowserExecutable(file).getAbsolutePath();
	}
}
