/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.tools.actionscript.debug;

import java.io.File;
import java.io.IOException;

import flash.tools.debugger.IDebuggerCallbacks;

public class ActionScriptDebuggerCallbacks implements IDebuggerCallbacks {
	String httpExe;
	String name; 
	
	public ActionScriptDebuggerCallbacks(String name, String httpExe) {
		this.name = name;
		this.httpExe = httpExe;
	}
	
	public File getHttpExe() {
		return new File(httpExe);
	}

	public String getHttpExeName() {
		return name;
	}

	public File getPlayerExe() {
		return null;
	}

	public String getPlayerExeName() {
		return null;
	}

	public Process launchDebugTarget(String[] cmd) throws IOException {
		return Runtime.getRuntime().exec(cmd);
	}

	public String queryWindowsRegistry(String key, String value)
			throws IOException {
		return null;
	}

	public void recomputeExeLocations() {

	}

}
