package org.eclipse.swt.tools.actionscript.ui;


import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.DebugTypeSelectionDialog;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodSearchEngine;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class DeployMainPage extends WizardPage {
	Text fProjText, fMainText;
	IJavaProject project;
	IType[] types = null;
	private String projectName = null;
	private String mainTypeName = null;
	
	public DeployMainPage(String pageName, String title, ImageDescriptor titleImage) {
		super(pageName, title, titleImage);
	}
	
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.horizontalSpan = 1;
		layout.verticalSpacing=0;
    	composite.setLayoutData(gd);
		createProjectEditor(composite);
		createMainTypeEditor(composite, Messages.DeployMainPage_0);
		setMessage(Messages.DeployMainPage_1);
		setPageComplete(isComplete());
		setControl(composite);		
	}

	protected void createProjectEditor(Composite parent) {
		Font font= parent.getFont();
		Group group= new Group(parent, SWT.NONE);
		group.setText(Messages.DeployMainPage_2); 
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		group.setLayoutData(gd);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		group.setLayout(layout);
		group.setFont(font);
		fProjText = new Text(group, SWT.SINGLE | SWT.BORDER);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		fProjText.setLayoutData(gd);
		fProjText.setFont(font);
		fProjText.addListener(SWT.Modify, new Listener() {
			public void handleEvent(Event event) {
				setPageComplete(isComplete());
			}
		});
		if (projectName != null) fProjText.setText(projectName);
		Button fProjButton = new Button(group, SWT.PUSH);
		fProjButton.setText(Messages.DeployMainPage_3);
		fProjButton.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				project = chooseJavaProject();
				if (project == null) {
					return;
				}
				fProjText.setText(project.getElementName());	
			}
		});
	}	
	
	protected void createMainTypeEditor(Composite parent, String text) {
		Group mainGroup = new Group(parent, SWT.NONE);
		mainGroup.setLayout(new GridLayout(2, false));
		mainGroup.setText(text);
		mainGroup.setFont(parent.getFont());
    	GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 1;
		mainGroup.setLayoutData(gd);
    	fMainText = new Text(mainGroup, SWT.SINGLE | SWT.BORDER);
    	fMainText.setFont(parent.getFont());
    	gd = new GridData(GridData.FILL_HORIZONTAL);
    	gd.horizontalSpan = 1;
    	fMainText.setLayoutData(gd);
    	if (mainTypeName != null) fMainText.setText(mainTypeName);
    	fMainText.addListener(SWT.Modify, new Listener() {
			public void handleEvent(Event event) {
				setPageComplete(isComplete());
			}
		});
		Button fSearchButton = new Button(mainGroup, SWT.PUSH);
		fSearchButton.setText(Messages.DeployMainPage_4);
		fSearchButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				IJavaProject project = getJavaProject();
				IJavaElement[] elements = null;
				if ((project == null) || !project.exists()) {
					IJavaModel model = JavaCore.create(ResourcesPlugin.getWorkspace().getRoot());
					if (model != null) {
						try {
							elements = model.getJavaProjects();
						}
						catch (JavaModelException e1) {JDIDebugUIPlugin.log(e1);}
					}
				}
				else {
					elements = new IJavaElement[]{project};
				}
				if (elements == null) {
					elements = new IJavaElement[]{};
				}
				int constraints = IJavaSearchScope.SOURCES;
				constraints |= IJavaSearchScope.APPLICATION_LIBRARIES;
				final IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope(elements, constraints);
				final MainMethodSearchEngine engine = new MainMethodSearchEngine();
				types = engine.searchMainMethods(new NullProgressMonitor()/*getLaunchConfigurationDialog()*/, searchScope, false);
				DebugTypeSelectionDialog mmsd = new DebugTypeSelectionDialog(getShell(), types, Messages.DeployMainPage_10); 
				if (mmsd.open() == Window.CANCEL) {
					return;
				}
				Object[] results = mmsd.getResult();	
				IType type = (IType)results[0];
				if (type != null) {
					fMainText.setText(type.getFullyQualifiedName());
					fProjText.setText(type.getJavaProject().getElementName());
				}
			}
		});
	}
	
	private IJavaProject chooseJavaProject() {
		ILabelProvider labelProvider= new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
		ElementListSelectionDialog dialog= new ElementListSelectionDialog(getShell(), labelProvider);
		dialog.setTitle(Messages.DeployMainPage_5); 
		dialog.setMessage(Messages.DeployMainPage_6); 
		try {
			dialog.setElements(JavaCore.create(getWorkspaceRoot()).getJavaProjects());
		}
		catch (JavaModelException jme) {JDIDebugUIPlugin.log(jme);}
		IJavaProject javaProject= getJavaProject();
		if (javaProject != null) {
			dialog.setInitialSelections(new Object[] { javaProject });
		}
		if (dialog.open() == Window.OK) {			
			return (IJavaProject) dialog.getFirstResult();
		}		
		return null;		
	}
	
	protected IJavaProject getJavaProject() {
		String projectName = fProjText.getText().trim();
		if (projectName.length() < 1) {
			return null;
		}
		return getJavaModel().getJavaProject(projectName);		
	}
	/**
	 * Convenience method to get access to the java model.
	 */
	private IJavaModel getJavaModel() {
		return JavaCore.create(getWorkspaceRoot());
	}
	
	private IWorkspaceRoot getWorkspaceRoot() {
		return ResourcesPlugin.getWorkspace().getRoot();
	}

	public void setTypes(IType[] types) {
		if (types.length > 1) {
			//See if you can at least extract a project name
			String name = null;
			IJavaProject tempProject = null;
			for (int i = 0; i < types.length; i++) {
				tempProject = types[i].getJavaProject();
				String tempProjName = tempProject.getElementName();
				if (name == null) {
					name = tempProjName; 
				} else if (name != tempProjName) {
					break;
				}
			}
			projectName = name;
			project = tempProject; 
		} else if (types.length == 1){
			project = types[0].getJavaProject();
			projectName = project.getElementName();
			mainTypeName = types[0].getFullyQualifiedName();
		}
	}
	
	boolean isComplete () {
		if (fProjText == null || fMainText == null) return false;
		String path = fProjText.getText().trim ();
		if(path.equals ("")) {
			setErrorMessage (Messages.DeployMainPage_8);
			return false;
		}
		path = fMainText.getText().trim();
		if(path.equals ("")) {
			setErrorMessage (Messages.DeployMainPage_10);
			return false;
		}
		setErrorMessage(null);
		setMessage(Messages.DeployMainPage_1);
		return true;
	}
	

}
