#include "FirebirdUtils.hpp"

// Implmentation FbException
FbException::FbException()
{
	raison = "Exception Firebird, raison inconnue";
}

FbException::FbException(const string& s)
{
	raison = "Exception Firebird: " + s;
}

FbException::FbException(ISC_STATUS_ARRAY err)
{
	// dangereux, mais c'est comme a :-(
	char msg[512];
	long *perror;
	perror = err;
	ostringstream os;
	os << "Exception Firebird" << endl;
	while(isc_interprete(msg, &perror))
	{
		os << msg << endl;
	}
	raison = os.str();
}

void FbException::print() const
{
	cout << raison << endl;
}

///////////////////////////////////////////////////////////
// Implmentation FbDpb
FbDpb::FbDpb(const string& user, const string& password) : dpb(0)
{
	if(user.length()>31 || password.length()>9)
		throw FbException("Nom d'user ou mot de passe trop long");

	size_t ln = 0;
	ln += 1;	//isc_dpb_version1
	ln += 2;	//isc_dpb_user_name	+ valeur
	ln += user.length() + 1;
	ln += 2;	// isc_dpb_password + valeur
	ln += password.length() + 1; 

	length = static_cast<short>(ln);
	dpb = new char[length];	
	char* old = dpb;
	*dpb++ = isc_dpb_version1;
	*dpb++ = isc_dpb_user_name;
	*dpb++ = static_cast<char>(user.length() + 1);
	strcpy(dpb, user.c_str());
	dpb += user.length() + 1;
	*dpb++ = isc_dpb_password;
	*dpb++ = static_cast<char>(password.length() + 1);
	strcpy(dpb, password.c_str());
	dpb = old;
}

FbDpb::~FbDpb()
{
	delete[] dpb;
}

const char* FbDpb::getDpb() const
{
	return dpb;
}

const short FbDpb::getLength() const
{
	return length;
}

////////////////////////////////////////////////
// Implmentation FbConnection
FbConnection::FbConnection(const string &database,
	const string &user,
	const string password,
	bool create) : handle(0), dpb(new FbDpb(user, password))
{
	if(!create)
		connect(database);
	else
		createdb(database, user, password);
}

FbConnection::~FbConnection()
{
	if(handle)
		isc_detach_database(status, &handle);
}

void FbConnection::connect(const string& database)
{
	result = isc_attach_database(status,
		static_cast<short>(database.length()),
		const_cast<char*>(database.c_str()),
		&handle,
		dpb->getLength(),
		const_cast<char*>(dpb->getDpb()));

	if(result)
		throw FbException(status);
}
void FbConnection::createdb(const string& database,
	const string& user, const string& password)
{
	isc_tr_handle trans = 0;

	ostringstream os;
	os << "CREATE DATABASE ";
	os << "'" << database << "'";
	os << " " << "USER" << " " << "'" << user << "'";
	os << " " << "PASSWORD" << " " << "'" << password << "'";


	result =isc_dsql_execute_immediate(
		status, &handle, &trans, 0,
		const_cast<char*>(os.str().c_str()),
		3, NULL);

	if(result)
		throw FbException(status);
}

const isc_db_handle* FbConnection::getHandle_pointer() const
{
	return &handle;
}

//////////////////////////////////////////////////
// Implmentation FbTransacation

FbTransaction::FbTransaction(const FbConnection& connection)
	: handle(0), ok(false), // handle = 0 est important!
	okquery(false), cn(connection) 
{

	result = isc_start_transaction(status,
		&handle, 1,
		cn.getHandle_pointer(),
		0, NULL);

	if(result)
		throw FbException(status);
	
	ok = true;
}

FbTransaction::~FbTransaction()
{
	if(ok)
		isc_commit_transaction(status, &handle);
	else
		isc_rollback_transaction(status, &handle);
}

void FbTransaction::executeSQL(const string &requete)
{
	ok = false;

	result = isc_dsql_execute_immediate(status,
		const_cast<isc_db_handle*>(cn.getHandle_pointer()),
		&handle,
		0,
		const_cast<char*>(requete.c_str()),
		3,
		NULL);

	if(result)
		throw FbException(status);
	
	ok = true;
}

void FbTransaction::executeSQLQuery(const string &query)
{
	ok = false;
	okquery = false;
	
	fb_statement.reset(new FbStatement(cn));
	fb_xsqlda.reset(new FbXSQLDA(1));
	result = isc_dsql_prepare(status, &handle,
		const_cast<isc_stmt_handle*>
			(fb_statement->getHandle_pointer()),
		0,
		const_cast<char*>(query.c_str()),
		3, NULL);
	if(result)
		throw FbException(status);

	result = isc_dsql_describe(status,
		const_cast<isc_stmt_handle*>
				(fb_statement->getHandle_pointer()),
			3,
			fb_xsqlda->get());
	if(result)
		throw FbException(status);

	if(fb_xsqlda->get()->sqld > fb_xsqlda->get()->sqln)
	{
		size_t new_size = fb_xsqlda->get()->sqld;
		fb_xsqlda.reset(new FbXSQLDA(new_size));
		
		result = isc_dsql_describe(status,
			const_cast<isc_stmt_handle*>
				(fb_statement->getHandle_pointer()),
			3,
			fb_xsqlda->get());
		if(result)
			throw FbException(status);
	}
	fb_xsqlda->fullInit();
	result = isc_dsql_execute(status,
		&handle,
		const_cast<isc_stmt_handle*>
			(fb_statement->getHandle_pointer()),
		3,
		fb_xsqlda->get());
	if(result)
		throw FbException(status);
	
	ok = true;
	okquery = true;
}

const bool FbTransaction::isOkQuery() const
{
	return (ok && okquery);
}

auto_ptr<vector<string> > FbTransaction::getResultQuery()
{
	if(!okquery)
		throw FbException("Pas de resultats disponibles");

	okquery = false; // On ne lit XSQLDA qu'une fois
	return fb_xsqlda->toStrings(fb_statement->getHandle_pointer());
}

//////////////////////////////////////
// Implementation FbStatement
FbStatement::FbStatement(const FbConnection& cn)
	: handle(0)	// handle = 0 est important !
{
	result = isc_dsql_allocate_statement(status,
		const_cast<isc_db_handle*>(cn.getHandle_pointer()),
		&handle);

	if(result)
		throw FbException(status);
	
}

FbStatement::~FbStatement()
{
	if(handle)
		isc_dsql_free_statement(status, &handle, DSQL_drop);
}

const isc_stmt_handle* FbStatement::getHandle_pointer() const
{
	return &handle;
}

//////////////////////////////////////
// Implementation FbXSQLDA
FbXSQLDA::FbXSQLDA(size_t size)
	: n_colonnes(size), mem_(new char[XSQLDA_LENGTH(size)])
{
	XSQLDA* xsqlda = get();
	xsqlda->version = SQLDA_VERSION1;
	xsqlda->sqln = static_cast<short>(size);
	for(size_t i=0; i<n_colonnes; ++i)
	{
		xsqlda->sqlvar[i].sqldata = 0;	
		xsqlda->sqlvar[i].sqlind = 0;
	}
}

FbXSQLDA::~FbXSQLDA()
{
	
	XSQLDA* xsqlda = get();

	if (!xsqlda)
        return;
    for (size_t i = 0; i < n_colonnes; ++i) {
        delete xsqlda->sqlvar[i].sqlind;
        delete[] xsqlda->sqlvar[i].sqldata;
    }
	
	delete[] mem_;
}

XSQLDA* FbXSQLDA::get()
{
	return reinterpret_cast<XSQLDA*>(mem_);
}

void FbXSQLDA::fullInit()
{
	XSQLDA* xsqlda = get();

	for (int i = 0; i < xsqlda->sqld; ++i)
	{
        switch (xsqlda->sqlvar[i].sqltype & ~1)
		{
			// Pour SQL_TEXT et SQL_VARYING, on ajoute 1  la longueur
			// du tampon afin de pouvoir ajouter un zro de fin de chane
			// lors de la rcupration du rsultat.
        case SQL_TEXT:
			xsqlda->sqlvar[i].sqldata =
				new char[xsqlda->sqlvar[i].sqllen+1]; 
			break;
		case SQL_VARYING:
			// coercition en SQL_TEXT
			if (xsqlda->sqlvar[i].sqltype & 1)
				xsqlda->sqlvar[i].sqltype = SQL_TEXT+1;
			else
				xsqlda->sqlvar[i].sqltype = SQL_TEXT;
			xsqlda->sqlvar[i].sqldata = new char[xsqlda->sqlvar[i].sqllen+1];
			break;
		case SQL_LONG:
        case SQL_FLOAT:
		case SQL_DOUBLE:
			xsqlda->sqlvar[i].sqldata = new char[xsqlda->sqlvar[i].sqllen];
			break;
        case SQL_BLOB:
		case SQL_ARRAY:
		case SQL_SHORT:
		case SQL_INT64:
		case SQL_TIMESTAMP:
		case SQL_TYPE_TIME:
		case SQL_TYPE_DATE:
        default:
            xsqlda->sqlvar[i].sqldata = 0;
			throw FbException("Type SQL Firebird non supporte par ce pilote");
			break;
        }
		// Si possibilit de valeur SQL NULL
        if (xsqlda->sqlvar[i].sqltype & 1)
		{
            xsqlda->sqlvar[i].sqlind = new short;
            *(xsqlda->sqlvar[i].sqlind) = 0;
        }
		else
		{
           xsqlda->sqlvar[i].sqlind = 0;
        }
    }
}

auto_ptr<vector<string> > FbXSQLDA::toStrings(const isc_stmt_handle* stmt)
{
	ostringstream os;
	XSQLDA* xsqlda = get();
	ISC_STATUS fetch_stat;

	auto_ptr<vector<string> > v(new vector<string>);

	v->push_back("\nTable: " + string(xsqlda->sqlvar[0].relname));
	os.str("");
	os << "Colonnes: ";
	for(int i=0; i<xsqlda->sqld; ++i)
		os << xsqlda->sqlvar[i].sqlname << " ";
	os << "\n";
	v->push_back(os.str());
	os.str("");

	while ((fetch_stat = isc_dsql_fetch(status,
			const_cast<isc_stmt_handle*>(stmt), 1, xsqlda)) == 0)
    {
		for(int i=0; i<xsqlda->sqld; ++i)
		{
			if((xsqlda->sqlvar[i].sqltype & 1) 
				&& *xsqlda->sqlvar[i].sqlind)
				os << "NULL" << " ";
			else
				switch(xsqlda->sqlvar[i].sqltype)
				{
				case SQL_TEXT:
				case SQL_TEXT+1:
					xsqlda->sqlvar[i].sqldata[xsqlda->sqlvar[i].sqllen]= '\0';
					os << xsqlda->sqlvar[i].sqldata << " ";
					break;
				case SQL_LONG:
				case SQL_LONG+1:
					os << long(*(reinterpret_cast<long*>
						(xsqlda->sqlvar[i].sqldata))) << " ";
					break;
				case SQL_FLOAT:
				case SQL_FLOAT+1:
					os << float(*(reinterpret_cast<float*>
						(xsqlda->sqlvar[i].sqldata))) << " ";
					break;
				case SQL_DOUBLE:
				case SQL_DOUBLE+1:
					os << double(*(reinterpret_cast<double*>
						(xsqlda->sqlvar[i].sqldata))) << " ";
					break;	
				default:
					os << " ";
					break;
				}
		}
		v->push_back(os.str());
		os.str("");
    }
	// Si tout s'est bien termin
	// fetch_stat vaut 100....
	if (fetch_stat != 100L)
		throw FbException(status);
	
	return v;
}