#ifndef FIREBIRD_UTILS_CPP
#define FIREBIRD_UTILS_CPP

#include <string>
#include <iostream>
#include <sstream>
#include <memory>
#include <vector>

using namespace std;

#include <ibase.h>

class FbException
{
public:
	FbException();
	explicit FbException(const string&);
	explicit FbException(ISC_STATUS_ARRAY);
	void print() const;
private:
	string raison;
};

class FbConnection;
class FbTransaction;

class FbDpb
{
public:
	~FbDpb();
	friend class FbConnection;
private:
	FbDpb(const string& user, const string& password);

	const char* getDpb() const;
	const short getLength() const;
	// Ci-dessous: non implmentes
	// Copie et affectation interdites
	FbDpb(const FbDpb&);
	FbDpb& operator=(const FbDpb&);
	char* dpb;
	short length;
};

class FbConnection
{
public:
	FbConnection(const string& database,
		const string& user,
		const string password,
		bool create=false);	
	~FbConnection();
	const isc_db_handle* getHandle_pointer() const;

private:
	void connect(const string&);
	void createdb(const string&,
		const string&, 
		const string&);
	// Ci-dessous: non implmentes.
	// Copie et affectation interdites
	FbConnection(const FbConnection&);
	FbConnection& operator=(const FbConnection&);

	isc_db_handle handle;
	ISC_STATUS_ARRAY status;
	ISC_STATUS result;
	const auto_ptr<FbDpb> dpb;
};

class FbStatement
{
public:
	~FbStatement();
	friend class FbTransaction;
private:
	explicit FbStatement(const FbConnection&);
	const isc_stmt_handle* getHandle_pointer() const;
	// Ci-dessous: non implmentes.
	// Copie et affectation interdites
	FbStatement(const FbStatement&);
	FbStatement& operator=(FbStatement&);
	isc_stmt_handle handle;
	ISC_STATUS_ARRAY status;
	ISC_STATUS result;
};

class FbXSQLDA
{
public:
	~FbXSQLDA();
	friend class FbTransaction;
private:
	explicit FbXSQLDA(size_t);
	XSQLDA* get();
	void fullInit();
	auto_ptr<vector<string> > toStrings(const isc_stmt_handle*);
	// Ci-dessous: non implmentes.
	// Copie et affectation interdites
	FbXSQLDA(const FbXSQLDA&);
	FbXSQLDA& operator=(FbXSQLDA&);
	
	char* mem_;
	const size_t n_colonnes;
	ISC_STATUS_ARRAY status;
};

class FbTransaction
{
public:
	explicit FbTransaction(const FbConnection&);
	~FbTransaction();
	void executeSQL(const string&);
	void executeSQLQuery(const string&);
	const bool isOkQuery() const;
	auto_ptr<vector<string> > getResultQuery();
private:
	// Ci-dessous: non implmentes.
	// Copie et affectation interdites
	FbTransaction(const FbTransaction&);
	FbTransaction& operator=(FbTransaction&);

	bool ok, okquery;
	isc_tr_handle handle;
	const FbConnection& cn;
	auto_ptr<FbStatement> fb_statement;
	auto_ptr<FbXSQLDA> fb_xsqlda;
	ISC_STATUS_ARRAY status;
	ISC_STATUS result;
};

#endif