package fr.app.firstwidget;

import java.text.SimpleDateFormat;
import java.util.Date;

import android.app.Service;
import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProvider;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.widget.RemoteViews;

/**
 * Hello World Widget.
 * 
 * @author Sylvain Saurel - sylvain.saurel@gmail.com
 *
 */
public class HelloWorldWidget extends AppWidgetProvider {

	/** Date formatter. */
	private static SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("HH:mm:ss dd/MM/yyyy");
	
	@Override
	public void onUpdate(Context context, AppWidgetManager appWidgetManager, int[] appWidgetIds) {
		context.startService(new Intent(context, UpdateService.class));
	}

	public static class UpdateService extends Service {

		@Override
		public IBinder onBind(Intent intent) {
			return null;
		}

		@Override
		public void onStart(Intent intent, int startId) {
			RemoteViews updateViews = buildUpdate(this);
			ComponentName thisWidget = new ComponentName(this, HelloWorldWidget.class);
			AppWidgetManager manager = AppWidgetManager.getInstance(this);
			manager.updateAppWidget(thisWidget, updateViews);
		}

		public RemoteViews buildUpdate(Context context) {
			RemoteViews updateViews = new RemoteViews(context.getPackageName(), R.layout.widget_layout);
			updateViews.setTextViewText(R.id.lastUpdate, DATE_FORMATTER.format(new Date()));
			return updateViews;
		}

	}

}
