<?php 
class module_livres extends abstract_module{
	
	public function before(){
		$this->oLayout=new _layout('template1');
		
		//$this->oLayout->addModule('menu','menu::index');
	}
	
	
	public function _index(){
	    //on considere que la page par defaut est la page de listage
	    $this->_list();
	}
	
	public function _list(){
		
		$tLivres=model_livres::getInstance()->findAll();
		
		$oView=new _view('livres::list');
		$oView->tLivres=$tLivres;
		
				$oView->tJoinmodel_auteur=model_auteur::getInstance()->getSelect();

		$this->oLayout->add('main',$oView);
	}
	
	
	public function _new(){
		$tMessage=$this->processSave();
	
		$oLivres=new row_livres;
		
		$oView=new _view('livres::new');
		$oView->oLivres=$oLivres;
		
				$oView->tJoinmodel_auteur=model_auteur::getInstance()->getSelect();
		
		$oPluginXsrf=new plugin_xsrf();
		$oView->token=$oPluginXsrf->getToken();
		$oView->tMessage=$tMessage;
		
		$this->oLayout->add('main',$oView);
	}

	
	
	public function _edit(){
		$tMessage=$this->processSave();
		
		$oLivres=model_livres::getInstance()->findById( _root::getParam('id') );
		
		$oView=new _view('livres::edit');
		$oView->oLivres=$oLivres;
		$oView->tId=model_livres::getInstance()->getIdTab();
		
				$oView->tJoinmodel_auteur=model_auteur::getInstance()->getSelect();
		
		$oPluginXsrf=new plugin_xsrf();
		$oView->token=$oPluginXsrf->getToken();
		$oView->tMessage=$tMessage;
		
		$this->oLayout->add('main',$oView);
	}

	
	
	public function _show(){
		$oLivres=model_livres::getInstance()->findById( _root::getParam('id') );
		
		$oView=new _view('livres::show');
		$oView->oLivres=$oLivres;
		
				$oView->tJoinmodel_auteur=model_auteur::getInstance()->getSelect();
		$this->oLayout->add('main',$oView);
	}

	
	
	public function _delete(){
		$tMessage=$this->processDelete();

		$oLivres=model_livres::getInstance()->findById( _root::getParam('id') );
		
		$oView=new _view('livres::delete');
		$oView->oLivres=$oLivres;
		
				$oView->tJoinmodel_auteur=model_auteur::getInstance()->getSelect();

		$oPluginXsrf=new plugin_xsrf();
		$oView->token=$oPluginXsrf->getToken();
		$oView->tMessage=$tMessage;
		
		$this->oLayout->add('main',$oView);
	}

	

	public function processSave(){
		if(!_root::getRequest()->isPost() ){ //si ce n'est pas une requete POST on ne soumet pas
			return null;
		}
		
		$oPluginXsrf=new plugin_xsrf();
		if(!$oPluginXsrf->checkToken( _root::getParam('token') ) ){ //on verifie que le token est valide
			return array('token'=>$oPluginXsrf->getMessage() );
		}
	
		$iId=_root::getParam('id',null);
		if($iId==null){
			$oLivres=new row_livres;	
		}else{
			$oLivres=model_livres::getInstance()->findById( _root::getParam('id',null) );
		}
		
		$tId=model_livres::getInstance()->getIdTab();
		$tColumn=model_livres::getInstance()->getListColumn();
		foreach($tColumn as $sColumn){
			 $oPluginUpload=new plugin_upload($sColumn);
			if($oPluginUpload->isValid()){
				$sNewFileName=_root::getConfigVar('path.upload').$sColumn.'_'.date('Ymdhis');

				$oPluginUpload->saveAs($sNewFileName);
				$oLivres->$sColumn=$oPluginUpload->getPath();
				continue;	
			}else  if( _root::getParam($sColumn,null) === null ){ 
				continue;
			}else if( in_array($sColumn,$tId)){
				 continue;
			}
			
			$oLivres->$sColumn=_root::getParam($sColumn,null) ;
		}
		
		if($oLivres->save()){
			//une fois enregistre on redirige (vers la page liste)
			_root::redirect('livres::list');
		}else{
			return $oLivres->getListError();
		}
		
	}
	
	
	public function processDelete(){
		if(!_root::getRequest()->isPost() ){ //si ce n'est pas une requete POST on ne soumet pas
			return null;
		}
		
		$oPluginXsrf=new plugin_xsrf();
		if(!$oPluginXsrf->checkToken( _root::getParam('token') ) ){ //on verifie que le token est valide
			return array('token'=>$oPluginXsrf->getMessage() );
		}
	
		$oLivres=model_livres::getInstance()->findById( _root::getParam('id',null) );
				
		$oLivres->delete();
		//une fois enregistre on redirige (vers la page liste)
		_root::redirect('livres::list');
		
	}


	
	public function after(){
		$this->oLayout->show();
	}
	
	
}

/*variables
#select		$oView->tJoinlivres=livres::getInstance()->getSelect();#fin_select
#uploadsave $oPluginUpload=new plugin_upload($sColumn);
			if($oPluginUpload->isValid()){
				$sNewFileName=_root::getConfigVar('path.upload').$sColumn.'_'.date('Ymdhis');

				$oPluginUpload->saveAs($sNewFileName);
				$oLivres->$sColumn=$oPluginUpload->getPath();
				continue;	
			}else #fin_uploadsave
			
#methodNew
	public function _new(){
		$tMessage=$this->processSave();
	
		$oLivres=new row_livres;
		
		$oView=new _view('livres::new');
		$oView->oLivres=$oLivres;
		
				$oView->tJoinmodel_auteur=model_auteur::getInstance()->getSelect();
		
		$oPluginXsrf=new plugin_xsrf();
		$oView->token=$oPluginXsrf->getToken();
		$oView->tMessage=$tMessage;
		
		$this->oLayout->add('main',$oView);
	}
methodNew#
	
#methodEdit
	public function _edit(){
		$tMessage=$this->processSave();
		
		$oLivres=model_livres::getInstance()->findById( _root::getParam('id') );
		
		$oView=new _view('livres::edit');
		$oView->oLivres=$oLivres;
		$oView->tId=model_livres::getInstance()->getIdTab();
		
				$oView->tJoinmodel_auteur=model_auteur::getInstance()->getSelect();
		
		$oPluginXsrf=new plugin_xsrf();
		$oView->token=$oPluginXsrf->getToken();
		$oView->tMessage=$tMessage;
		
		$this->oLayout->add('main',$oView);
	}
methodEdit#

#methodShow
	public function _show(){
		$oLivres=model_livres::getInstance()->findById( _root::getParam('id') );
		
		$oView=new _view('livres::show');
		$oView->oLivres=$oLivres;
		
				$oView->tJoinmodel_auteur=model_auteur::getInstance()->getSelect();
		$this->oLayout->add('main',$oView);
	}
methodShow#
	
#methodDelete
	public function _delete(){
		$tMessage=$this->processDelete();

		$oLivres=model_livres::getInstance()->findById( _root::getParam('id') );
		
		$oView=new _view('livres::delete');
		$oView->oLivres=$oLivres;
		
				$oView->tJoinmodel_auteur=model_auteur::getInstance()->getSelect();

		$oPluginXsrf=new plugin_xsrf();
		$oView->token=$oPluginXsrf->getToken();
		$oView->tMessage=$tMessage;
		
		$this->oLayout->add('main',$oView);
	}
methodDelete#	

#methodProcessDelete
	public function processDelete(){
		if(!_root::getRequest()->isPost() ){ //si ce n'est pas une requete POST on ne soumet pas
			return null;
		}
		
		$oPluginXsrf=new plugin_xsrf();
		if(!$oPluginXsrf->checkToken( _root::getParam('token') ) ){ //on verifie que le token est valide
			return array('token'=>$oPluginXsrf->getMessage() );
		}
	
		$oLivres=model_livres::getInstance()->findById( _root::getParam('id',null) );
				
		$oLivres->delete();
		//une fois enregistre on redirige (vers la page liste)
		_root::redirect('livres::list');
		
	}
methodProcessDelete#	
			
variables*/

