﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using Microsoft.Surface.Presentation;
using Microsoft.Surface.Presentation.Manipulations;

namespace MonProjet
{
    /// <summary>
    /// CustomControl embarquant une gestuelle
    /// </summary>
    public partial class MonControle : ContentControl
    {
        #region Propriétés de dépendances

        /// <summary>
        /// Propriétée de dépendance pour définir la commande éxécutée si les condutions de gestuelles sont remplies
        /// </summary>
        public static readonly DependencyProperty CommandProperty = DependencyProperty.Register("Command", typeof(ICommand), typeof(MonControle), new PropertyMetadata(null));

        #endregion

        #region Fonctions d'accessions des propriétés de dépendance

        /// <summary>
        /// Obtient ou définit la valeur de la propriété de dépenance Command
        /// </summary>
        public ICommand Command
        {
            get
            {
                return ((ICommand)this.GetValue(MonControle.CommandProperty));
            }
            set
            {
                this.SetValue(MonControle.CommandProperty, value);
            }
        }

        #endregion

        #region Variables d'instances

        private Affine2DManipulationProcessor _processor;

        #endregion

        #region Constructeurs

        /// <summary>
        /// Constructeur statique
        /// </summary>
        static MonControle()
        {
            MonControle.DefaultStyleKeyProperty.OverrideMetadata(typeof(MonControle), new FrameworkPropertyMetadata(typeof(MonControle)));
        }

        #endregion

        #region Fonctions publiques

        /// <summary>
        /// Se produit sur l'instanciation du template
        /// </summary>
        public override void OnApplyTemplate()
        {
            base.OnApplyTemplate();

            // On crée le mécanisme de gestuelle

            this._processor = new Affine2DManipulationProcessor(Affine2DManipulations.TranslateX | Affine2DManipulations.TranslateY, this);
            this._processor.Affine2DManipulationDelta += new EventHandler<Affine2DOperationDeltaEventArgs>(this.Affine2DManipulationDelta);

            Contacts.AddContactDownHandler(this, this.ContactEventHandler);
        }

        #endregion

        #region Fonctions privées

        /// <summary>
        /// Se produit sur un changement de l'état des contacts en scrutations
        /// </summary>
        /// <param name="sender">Source de l'appel</param>
        /// <param name="e">Argument de l'appel</param>
        private void Affine2DManipulationDelta(object sender, Affine2DOperationDeltaEventArgs e)
        {
            if (Math.Abs(e.CumulativeTranslation.Length) > 110)
            {
                if (this.Command != null)
                    this.Command.Execute(null);

                this._processor.CompleteManipulation();
            }
        }

        /// <summary>
        /// Se produit sur la création d'un contact sur le contrôle
        /// </summary>
        /// <param name="sender">Source de l'appel</param>
        /// <param name="e">Argument de l'apel</param>
        private void ContactEventHandler(object sender, ContactEventArgs e)
        {
            this._processor.BeginTrack(e.Contact);
        }

        #endregion
    }
}
