package fr.jna.article.sample1;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;

/**
 * Interface définissant les fonctions natives
 * que l'on souhaite utiliser et qui s'occupe
 * de charger la bibliothèque native
 *
 * @author Sylvain Saurel
 *
 */
public interface ICLibrary extends Library {

	/** Bibliothèque à utiliser pour un système Windows */
	public static final String winCLib = "msvcrt";
	/** Bibliothèque a utiliser pour les autres  systèmes (Unix/Linux notamment) */
	public static final String otherCLib = "c";

	/** déclaration de l'instance de notre bibliothèque */
	public ICLibrary instance = (ICLibrary) Native.loadLibrary(Platform
			.isWindows() ? winCLib : otherCLib, ICLibrary.class);

	/** déclaration des fonctions natives à utiliser */
	public int printf(String format, Object... args);

	public int toupper(int c);

	public int tolower(int c);

	public double sqrt(double x);

	public int atoi(String s);
}
