package fr.jna.article.sample2;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;

/**
 * Interface définissant les fonctions natives
 * que l'on souhaite utiliser et qui s'occupe
 * de charger la bibliothèque native
 *
 * @author Sylvain Saurel
 *
 */
public interface ILibraryIO extends Library{

	/** Bibliothèque à utiliser pour un système Windows */
	public static final String winCLib = "msvcrt";
	/** Bibliothèque à utiliser pour les autres  systemes (Unix/Linux notamment) */
	public static final String otherCLib = "c";

	/** déclaration de l'instance de notre bibliothèque */
	public ILibraryIO instance = (ILibraryIO) Native.loadLibrary(Platform.isWindows() ? winCLib : otherCLib, ILibraryIO.class);

	/** déclaration des fonctions natives à utiliser */
	public void printf(String format, Object... args);

	public FILE fopen(String filename, String mode);

	public int fread(Pointer p, int size, int nbObj, FILE stream);

	public int feof(FILE stream);

	public int fclose(FILE stream);

}
