package fr.jna.article.sample2;

import com.sun.jna.Memory;

/**
 * Classe exemple qui montre comment
 * lire le contenu d'un fichier de
 * données en utilisant des fonctions
 * natives via JNA
 *
 * @author Sylvain Saurel
 *
 */
public class SecondExample{

	public static void main(String[] args) {

		ILibraryIO iLibraryIO = ILibraryIO.instance;
		// ouverture du fichier en lecture
		FILE file = iLibraryIO.fopen("resources/test.txt", "r");
		// création d'un objet mémoire JNA
		Memory m = new Memory(100);

		// on parcourt le fichier tant qu'on a pas atteint la fin
		while(iLibraryIO.feof(file) == 0){
			// on essaie de lire 100 bytes que l'on va placer dans l'objet m
			int read = iLibraryIO.fread(m, 1, 100, file);
			// on recupère le contenu de m dans un objet String
			String buf = m.getString(0).substring(0,read);
			// on l'affiche
			System.out.println(buf);
		}

		// fermeture du fichier
		iLibraryIO.fclose(file);
	}
}