﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace Landscape
{
    public partial class Page : UserControl
    {
        protected Point _lastMousePosition;
        protected Point _lastDragViewportOrigin;
        protected bool _isDragging = false;

        private void MultiScaleImage_MouseMove(object sender, MouseEventArgs e)
        {
            if (_isDragging)
            {
                Point newViewport = _lastDragViewportOrigin;
                Point currentMousePosition = e.GetPosition(msi);
                newViewport.X += (_lastMousePosition.X - currentMousePosition.X) / this.msi.ActualWidth * this.msi.ViewportWidth;
                newViewport.Y += (_lastMousePosition.Y - currentMousePosition.Y) / this.msi.ActualWidth * this.msi.ViewportWidth;
                msi.ViewportOrigin = newViewport;
                _lastDragViewportOrigin = newViewport;
            }
            _lastMousePosition = e.GetPosition(msi);
        }

        public Page()
        {
            InitializeComponent();
            new MouseWheelHelper(msi).Moved += new EventHandler<MouseWheelEventArgs>(Page_Moved);
        }

        void Page_Moved(object sender, MouseWheelEventArgs e)
        {
            if (e.Delta > 0)
            {
                Zoom(1.3f, _lastMousePosition);
            }
            else
            {
                Zoom(1 / 1.3f, _lastMousePosition);
            }
        }

        private void Zoom(float zoomRation, Point elementPoint)
        {
            Point p = msi.ElementToLogicalPoint(elementPoint);
            msi.ZoomAboutLogicalPoint(zoomRation, p.X, p.Y);
        }

        private void MultiScaleImage_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            if (!_isDragging)
            {
                this._lastDragViewportOrigin = msi.ViewportOrigin;
                this._lastMousePosition = e.GetPosition(msi);
                this._isDragging = true;
            }
        }

        private void MultiScaleImage_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            this._isDragging = false;
        }
    }
}
