﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;
using Windows.Devices.Geolocation;
using Bing.Maps;
using Windows.UI.Core;

// The Blank Page item template is documented at http://go.microsoft.com/fwlink/?LinkId=234238

namespace MonApplicationBingMaps
{
    /// <summary>
    /// An empty page that can be used on its own or navigated to within a Frame.
    /// </summary>
    public sealed partial class MainPage : Page
    {
        Geolocator geolocator;
        Pushpin GpsPushpin;


        public MainPage()
        {
            this.InitializeComponent();

            //Création d'une punaise pour indiquer la position GPS et ajout à la carte 
            GpsPushpin = new Pushpin()
            {
                Visibility = Windows.UI.Xaml.Visibility.Collapsed
            };
            MyMap.Children.Add(GpsPushpin);
        }

        /// <summary>
        /// Invoked when this page is about to be displayed in a Frame.
        /// </summary>
        /// <param name="e">Event data that describes how this page was reached.  The Parameter
        /// property is typically used to configure the page.</param>
        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
        }

        private void geolocator_PositionChanged(Geolocator sender, PositionChangedEventArgs args)
        {

            // Need to get back onto UI thread before updating location information

            this.Dispatcher.RunAsync(CoreDispatcherPriority.Normal, new DispatchedHandler(

            () =>
            {

                //Get the current location

                Location location = new Location(args.Position.Coordinate.Latitude, args.Position.Coordinate.Longitude);



                //Update the position of the GPS pushpin

                MapLayer.SetPosition(GpsPushpin, location);



                //Make GPS pushpin visible

                GpsPushpin.Visibility = Windows.UI.Xaml.Visibility.Visible;



                //Update the map view to the current GPS location

                MyMap.SetView(location, 17);

            }));

        }


        private void GPS_Checked(object sender, RoutedEventArgs e)
        {

            CheckBox cb = sender as CheckBox;



            if (cb.IsChecked.HasValue && cb.IsChecked.Value)
            {

                if (geolocator == null)
                {

                    //Create an instance of the GeoLocator class.

                    geolocator = new Geolocator();

                }



                //Add the position changed event

                geolocator.PositionChanged += geolocator_PositionChanged;

            }

            else
            {

                if (geolocator != null)
                {

                    //Remove the position changed event

                    geolocator.PositionChanged -= geolocator_PositionChanged;

                }



                //Hide the GPS pushpin

                GpsPushpin.Visibility = Windows.UI.Xaml.Visibility.Collapsed;

            }

        }

    }
}
