﻿using System.ComponentModel;
using System.Data.Linq.Mapping;

namespace Programmez.StockEchange.Services
{
    /// <summary>
    /// Classe représentant un indice financier
    /// </summary>
    [Table(Name="Quote")]
    public class Quote : INotifyPropertyChanging
    {
        public event PropertyChangingEventHandler PropertyChanging;        

        string _symbol;
        /// <summary>
        /// Obtient ou définit le symbole de l'indice
        /// </summary>        
        [Column(IsPrimaryKey = true, IsDbGenerated=false)]
        public string Symbol
        {
            get { return _symbol; }
            set {
                if (_symbol == value) return;
                RaiseNotifyPropertyChanging("Symbol");
                _symbol = value;                
            }
        }

        string _name;
        /// <summary>
        /// Obtient ou définit le nom de l'indice
        /// </summary>      
        [Column(Name = "Name")]
        public string Name
        {
            get { return _name; }
            set
            {
                if (_name == value) return;
                RaiseNotifyPropertyChanging("Name");
                _name = value;
            }
        }

        double? _lastTradePriceOnly;
        /// <summary>
        /// Obtient ou définit le cours de l'indice
        /// </summary>
        [Column(Name="LastTradePriceOnly")]
        public double? LastTradePriceOnly
        {
            get { return _lastTradePriceOnly; }
            set
            {
                if (_lastTradePriceOnly == value) return;
                RaiseNotifyPropertyChanging("LastTradePriceOnly");
                _lastTradePriceOnly = value;                
            }
        }

        double? _previousClose;
        /// <summary>
        /// Obtient ou définit le cours de l'indice
        /// </summary>
        [Column(Name="PreviousClose")]
        public double? PreviousClose
        {
            get { return _previousClose; }
            set
            {
                if (_previousClose == value) return;
                RaiseNotifyPropertyChanging("PreviousClose");
                _previousClose = value;                
            }
        }

        double? _volume;
        /// <summary>
        /// Obtient ou définit le volume d'échange
        /// </summary>
        [Column(Name = "Volume")]
        public double? Volume
        {
            get { return _volume; }
            set
            {
                if (_volume == value) return;
                RaiseNotifyPropertyChanging("Volume");
                _volume = value;                
            }
        }

        double? _changeRealtime;
        /// <summary>
        /// Obtient ou définit la variation de l'indice
        /// </summary>
        [Column(Name = "ChangeRealtime")]
        public double? ChangeRealtime
        {
            get { return _changeRealtime; }
            set
            {
                if (_changeRealtime == value) return;
                RaiseNotifyPropertyChanging("ChangeRealtime");
                _changeRealtime = value;
            }
        }

        double? _percentChange;
        /// <summary>
        /// Obtient ou définit la variation de l'indice en %
        /// </summary>
        [Column(Name = "percentChange")]
        public double? PercentChange
        {
            get { return _percentChange; }
            set
            {
                if (_percentChange == value) return;
                RaiseNotifyPropertyChanging("PercentChange");
                _percentChange = value;
            }
        }

        double? _yearHigh;
        /// <summary>
        /// Obtient ou définit le cours le plus haut annuel
        /// </summary>
        [Column(Name = "YearHigh")]
        public double? YearHigh
        {
            get { return _yearHigh; }
            set
            {
                if (_yearHigh == value) return;
                RaiseNotifyPropertyChanging("YearHigh");
                _yearHigh = value;
            }
        }

        double? _yearLow;
        /// <summary>
        /// Obtient ou définit le cours le plus bas annuel
        /// </summary>
        [Column(Name = "YearLow")]
        public double? YearLow
        {
            get { return _yearLow; }
            set
            {
                if (_yearLow == value) return;
                RaiseNotifyPropertyChanging("YearLow");
                _yearLow = value;
            }
        }

        /// <summary>
        /// Lève l'événement PropertyChanging
        /// </summary>
        /// <param name="propertyName">Nom de la propriété.</param>
        private void RaiseNotifyPropertyChanging(string propertyName)
        {
            if (PropertyChanging != null)
            {
                PropertyChanging(this, new PropertyChangingEventArgs(propertyName));
            }
        }
    }
}