﻿using System;
using System.Windows.Data;

namespace Programmez.StockExchange.UI.Converters
{
    /// <summary>
    /// Convertisseur pour l'affichage des valeurs numériques signées +/-
    /// </summary>
    public class DoubleToSignedFormatConverter : IValueConverter
    {

        /// <summary>
        /// Convertit la donnée d'une source en une valeur interprétée par le contrôle lié
        /// </summary>
        /// <param name="value">La donnée de la source.</param>
        /// <param name="targetType">Le type <see cref="T:System.Type"/> de donnée attendue par le contrôle.</param>
        /// <param name="parameter">Le paramètre optionel de conversion.</param>
        /// <param name="culture">La culture à utiliser.</param>
        /// <returns>
        /// La valeur convertie passée au contrôle
        /// </returns>
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            // Détermination du signe et conversion en chaine
            string result = "";
            double? typedValue = value as double?;
            if (typedValue.HasValue) {
                if (typedValue.Value > 0) {
                    result += "+"; 
                }
                result += Math.Round(typedValue.Value, 2).ToString();
            }
            return result;
        }

        /// <summary>
        /// Convertit la valeur du contrôle lié en donnée pour la source
        /// </summary>
        /// <param name="value">La valeur de propriété du contrôle lié.</param>
        /// <param name="targetType">Le type <see cref="T:System.Type"/>attendue par la source.</param>
        /// <param name="parameter">Le paramètre optionel de conversion.</param>
        /// <param name="culture">La culture à utiliser.</param>
        /// <returns>
        /// La valeur convertie passée à la source
        /// </returns>
        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            // Non implémenté (pas de two-way binding)
            throw new NotImplementedException();
        }
    }
}
