﻿using System;
using System.Collections.Generic;
using Programmez.StockEchange.Services;

namespace Programmez.StockExchange.UI.Design
{
    /// <summary>
    /// Classe de génération de données fictives pour le design
    /// </summary>
    public class SampleGenerator
    {
        List<Quote> _quotes;

        /// <summary>
        /// Obtient une collection d'indices pour le design
        /// </summary>
        /// <value>The quotes.</value>
        public List<Quote> Quotes
        {
            get { return _quotes; }            
        }


        Quote _quote;

        /// <summary>
        /// Obtient ou définit un indice fictif pour le design
        /// </summary>
        /// <value>The quote.</value>
        public Quote Quote
        {
            get { return _quote; }
            set { _quote = value; }
        }

        /// <summary>
        /// Contructeur
        /// </summary>
        public SampleGenerator() {
            _quotes = new List<Quote>();
            Random rand = new Random();

            // Génération de la collection exemple
            for (var i = 0; i < 10; i++) {
                _quotes.Add(new Quote() {
                    Symbol = "IND" + i.ToString(),
                    Name = "Company " + i.ToString(),
                    LastTradePriceOnly = Math.Round(rand.NextDouble() * 1000, 2),
                    ChangeRealtime = Math.Round(rand.NextDouble(), 2),
                    PercentChange = Math.Round(rand.NextDouble() * 10, 2),
                    PreviousClose = Math.Round(rand.NextDouble() * 1000, 2),
                    YearLow = Math.Round(rand.NextDouble() * 1000, 2),
                    YearHigh = Math.Round(rand.NextDouble() * 1000, 2),
                    Volume = rand.Next(10000,100000)
                });  
            }

            // Instanciation d'un indice exmple
            this.Quote = new Quote() { 
                Symbol = "IND" + 1,
                Name = "Company " + 1,
                LastTradePriceOnly = Math.Round(rand.NextDouble() * 1000, 2),
                ChangeRealtime = Math.Round(rand.NextDouble(), 2),
                PercentChange = Math.Round(rand.NextDouble() * 10, 2),
                PreviousClose = Math.Round(rand.NextDouble() * 1000, 2),
                YearLow = Math.Round(rand.NextDouble() * 1000, 2),
                YearHigh = Math.Round(rand.NextDouble() * 1000, 2),
                Volume = rand.Next(10000, 100000)
            };
        }
    }
}
