﻿using System;
using System.Linq;
using System.Windows;
using System.Windows.Controls;
using Microsoft.Phone.Controls;
using Programmez.StockEchange.Services;


namespace Programmez.StockExchange.UI
{
    /// <summary>
    /// Classe de la page d'accueil
    /// </summary>
    public partial class MainPage : PhoneApplicationPage
    {
        /// <summary>
        /// Constructeur
        /// </summary>
        public MainPage()
        {
            InitializeComponent();
            this.Loaded += new RoutedEventHandler(MainPage_Loaded);           
        }

        /// <summary>
        /// Gère l'événement Loaded de la page
        /// </summary>
        /// <param name="sender">La source de l'événement.</param>
        /// <param name="e">L'instance <see cref="System.Windows.RoutedEventArgs"/> contenant les données d'événements.</param>
        void MainPage_Loaded(object sender, RoutedEventArgs e)
        {
            // Liaison de la liste d'indices
            this.BindQuotesList();
        }

        /// <summary>
        /// Lie la liste des indices à la collection des instances d'indice stockés en local
        /// </summary>
        void BindQuotesList() {
            this.QuoteList.ItemsSource = QuoteController.Instance.GetAllQuotes().OrderBy(q => q.Name);            
        }

        /// <summary>
        /// Gère l'événement Click du bouton d'ajout d'indice
        /// </summary>
        /// <param name="sender">La source de l'événement.</param>
        /// <param name="e">L'instance <see cref="System.Windows.RoutedEventArgs"/> contenant les données d'événements.</param>
        private void OkButton_Click(object sender, RoutedEventArgs e)
        {
            // Vérification de la valeur obligatoire
            string symbol = this.NewQuoteSymbol.Text.ToUpper();            
            if (this.NewQuoteSymbol.Text == String.Empty) {
                MessageBox.Show("Un code indice est obligatoire");
                return;
            }

            // Appel de la méthode de création d'indice
            QuoteController.Instance.CreateNewQuoteAcync(symbol, CreateNewQuoteAcyncCompleted);                       
        }

        /// <summary>
        /// Méthode de rappel de la création d'un indice
        /// </summary>
        /// <param name="quote">The quote.</param>
        private void CreateNewQuoteAcyncCompleted(Quote quote)
        {
            if (quote != null)
            {
                // L'indice existe => On rafraichit l'indice
                this.NewQuoteSymbol.Text = String.Empty;
                this.BindQuotesList();
            }
            else {
                // Affichage d'un message d'erreur
                MessageBox.Show("Le code indice n'est pas reconnu");
            }            
        }

        /// <summary>
        /// Gère l'événement Click du bouton associé à chaque élément de la liste d'indices
        /// </summary>
        /// <param name="sender">La source de l'événement.</param>
        /// <param name="e">L'instance <see cref="System.Windows.RoutedEventArgs"/> contenant les données d'événements.</param>
        private void QuoteButton_Click(object sender, RoutedEventArgs e)
        {
            // Récupération de l'indice et redirection vers la page de détail
            Button button = sender as Button;
            Quote quote = button.DataContext as Quote;
            if (quote != null) {
                this.NavigationService.Navigate(new Uri("/QuoteDetails.xaml?s=" + quote.Symbol.ToString(), UriKind.Relative));
            }
        }

        /// <summary>
        /// Gère l'événement Click du bouton d'actualisation
        /// </summary>
        /// <param name="sender">La source de l'événement.</param>
        /// <param name="e">L'instance <see cref="System.EventArgs"/> contenant les données d'événements.</param>
        private void ApplicationBarIconButtonRefresh_Click(object sender, EventArgs e)
        {
            QuoteController.Instance.RefreshQuotesAsync(() => this.BindQuotesList());
        }

        
    }
}