package com.programmez.android.speechbot;

import java.util.Locale;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceManager;
import android.preference.Preference.OnPreferenceClickListener;

import com.programmez.android.speechbot.tts.Tts;
import com.programmez.android.speechbot.tts.TtsNotInitializedException;

public class Settings extends PreferenceActivity implements
    OnPreferenceClickListener {
  public static float getSpeechRatePref(final Context context) {
    return Float.parseFloat(getUserPreferences(context).getString(
        Constants.PREF_KEY_SPEECH_RATE, "100")) / 100f;
  }

  public static SharedPreferences getUserPreferences(final Context context) {
    return PreferenceManager.getDefaultSharedPreferences(context);
  }

  public static String getUserPrefLanguage(final Context context) {
    return getUserPreferences(context).getString(Constants.PREF_KEY_LANGUAGE,
        null);
  }

  private Tts tts;

  public boolean onPreferenceClick(final Preference pref) {
    final String key = pref.getKey();
    if (Constants.PREF_KEY_CHECK_TTS.equals(key)) {
      tts = Tts.getInstance(this, true);
      tts.checkTtsData(this, Constants.TTS_CHECK_REQUEST_CODE);
      return true;
    } else if (Constants.PREF_KEY_RESET.equals(key)) {
      Settings.getUserPreferences(this).edit().clear().commit();
      App.showMessage(this, getString(R.string.reset_done));
      finish();
      return true;
    }
    return false;
  }

  private void buildAvailableLanguages() throws TtsNotInitializedException {
    final Locale[] availableLocales = tts.obtainAvailableLocales();
    final String[] entries = new String[availableLocales.length + 1];
    final String[] entryValues = new String[entries.length];
    final String userLanguage = getUserPrefLanguage(getApplicationContext());
    { // Language by default
      entryValues[0] = "";
      entries[0] = getString(R.string.default_language);
    }
    int selectedLanguageIndex = 0;
    for (int i = 1; i <= availableLocales.length; i++) {
      final Locale availableLocale = availableLocales[i - 1];
      final String localeDisplayName = availableLocale.getDisplayName();
      entryValues[i] = availableLocale.toString();
      entries[i] = localeDisplayName.substring(0, 1).toUpperCase()
          + localeDisplayName.substring(1);
      if (selectedLanguageIndex == 0 && entryValues[i].equals(userLanguage)) {
        selectedLanguageIndex = i;
      }
    }
    final ListPreference prefAvailableLanguages = (ListPreference) findPreference(Constants.PREF_KEY_LANGUAGE);
    prefAvailableLanguages.setEntries(entries);
    prefAvailableLanguages.setEntryValues(entryValues);
    prefAvailableLanguages.setValueIndex(selectedLanguageIndex);
  }

  @Override
  protected void onActivityResult(final int requestCode, final int resultCode,
      final Intent data) {
    if (requestCode == Constants.TTS_CHECK_REQUEST_CODE) {
      if (tts.onCheckTtsDataResult(this, resultCode)) {
        App.showMessage(this, getString(R.string.tts_service_ok));
        return;
      }
    }
  }

  @Override
  protected void onCreate(final Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    tts = Tts.getInstance(this, false);
    addPreferencesFromResource(R.xml.settings);
    try {
      buildAvailableLanguages();
    } catch (final TtsNotInitializedException e) {
      App.showMessage(getApplicationContext(),
          getString(R.string.tts_not_available));
    }
    findPreference(Constants.PREF_KEY_CHECK_TTS).setOnPreferenceClickListener(
        this);
    findPreference(Constants.PREF_KEY_RESET).setOnPreferenceClickListener(this);
  }
}
