/*
 * Decompiled with CFR 0.152.
 */
package com.google.tts;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceManager;
import android.view.Menu;
import android.view.MenuItem;
import com.google.tts.TTS;
import java.util.HashMap;

public class PrefsActivity
extends PreferenceActivity {
    private static final int TTS_VOICE_DATA_CHECK_CODE = 42;
    private static final int TTS_VOICE_DATA_INSTALL_CODE = 43;
    private TTS myTts;
    private HashMap<String, Integer> hellos;
    private TTS.InitListener ttsInitListener = new TTS.InitListener(){

        @Override
        public void onInit(int version) {
            PrefsActivity.this.addPreferencesFromResource(2130968576);
            PrefsActivity.this.loadEngines();
            PrefsActivity.this.loadHellos();
            Preference previewPref = PrefsActivity.this.findPreference("preview");
            previewPref.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener(){

                public boolean onPreferenceClick(Preference preference) {
                    PrefsActivity.this.sayHello();
                    return true;
                }
            });
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setVolumeControlStream(3);
        this.myTts = new TTS((Context)this, this.ttsInitListener, true);
    }

    private void loadEngines() {
        ListPreference enginesPref = (ListPreference)this.findPreference("engine_pref");
        Intent intent = new Intent("android.intent.action.START_TTS_ENGINE");
        ResolveInfo[] enginesArray = new ResolveInfo[]{};
        PackageManager pm = this.getPackageManager();
        enginesArray = pm.queryIntentActivities(intent, 0).toArray(enginesArray);
        CharSequence[] entries = new CharSequence[enginesArray.length];
        CharSequence[] values = new CharSequence[enginesArray.length];
        int i = 0;
        while (i < enginesArray.length) {
            entries[i] = enginesArray[i].loadLabel(pm);
            ActivityInfo aInfo = enginesArray[i].activityInfo;
            String soFilename = String.valueOf(aInfo.name.replace(String.valueOf(aInfo.packageName) + ".", "")) + ".so";
            soFilename = soFilename.toLowerCase();
            values[i] = "/data/data/" + aInfo.packageName + "/lib/libtts" + soFilename;
            ++i;
        }
        enginesPref.setEntries(entries);
        enginesPref.setEntryValues(values);
        enginesPref.setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener(){

            public boolean onPreferenceChange(Preference preference, Object newValue) {
                String chosenEngine = newValue.toString();
                if (chosenEngine.equals("/data/data/com.svox.pico/lib/libttspico.so")) {
                    Intent intent = new Intent();
                    intent.setAction("android.speech.tts.engine.CHECK_TTS_DATA");
                    intent.setClassName("com.svox.pico", "com.svox.pico.CheckVoiceData");
                    PrefsActivity.this.startActivityForResult(intent, 42);
                }
                return true;
            }
        });
    }

    private void loadHellos() {
        this.hellos = new HashMap();
        this.hellos.put("afr", 2131165187);
        this.hellos.put("bos", 2131165188);
        this.hellos.put("yue", 2131165189);
        this.hellos.put("cmn", 2131165190);
        this.hellos.put("hrv", 0x7F070007);
        this.hellos.put("ces", 2131165192);
        this.hellos.put("nld", 2131165193);
        this.hellos.put("eng-USA", 2131165194);
        this.hellos.put("eng-GBR", 2131165195);
        this.hellos.put("epo", 2131165196);
        this.hellos.put("fin", 2131165197);
        this.hellos.put("fra", 2131165198);
        this.hellos.put("deu", 0x7F07000F);
        this.hellos.put("ell", 2131165200);
        this.hellos.put("hin", 2131165201);
        this.hellos.put("hun", 2131165202);
        this.hellos.put("isl", 2131165203);
        this.hellos.put("ind", 2131165204);
        this.hellos.put("ita", 2131165205);
        this.hellos.put("kur", 2131165206);
        this.hellos.put("lat", 2131165207);
        this.hellos.put("mkd", 2131165208);
        this.hellos.put("nor", 2131165209);
        this.hellos.put("pol", 2131165210);
        this.hellos.put("por", 2131165211);
        this.hellos.put("ron", 2131165212);
        this.hellos.put("rus", 2131165213);
        this.hellos.put("srp", 2131165214);
        this.hellos.put("slk", 2131165215);
        this.hellos.put("spa", 2131165216);
        this.hellos.put("spa-MEX", 2131165217);
        this.hellos.put("swe", 2131165218);
        this.hellos.put("swe", 2131165219);
        this.hellos.put("tam", 2131165220);
        this.hellos.put("tur", 2131165221);
        this.hellos.put("vie", 2131165222);
        this.hellos.put("cym", 2131165223);
    }

    private void sayHello() {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        String DEFAULT_TTS_BINARY = "/data/data/com.google.tts/lib/libttspico.so";
        String engine = prefs.getString("engine_pref", DEFAULT_TTS_BINARY);
        this.myTts.setEngine(engine);
        String languageCode = prefs.getString("lang_pref", "eng-USA");
        int rate = Integer.parseInt(prefs.getString("rate_pref", "140"));
        this.myTts.setLanguage(languageCode);
        this.myTts.setSpeechRate(rate);
        if (!this.hellos.containsKey(languageCode)) {
            languageCode = "eng-USA";
        }
        String hello = this.getString(this.hellos.get(languageCode));
        this.myTts.speak(hello, 0, null);
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        menu.add(0, 2131165185, 0, 2131165185).setIcon(17301583);
        menu.add(0, 2131165186, 0, 2131165186).setIcon(17301569);
        return super.onCreateOptionsMenu(menu);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        Intent i = new Intent();
        ComponentName comp = new ComponentName("com.android.browser", "com.android.browser.BrowserActivity");
        i.setComponent(comp);
        i.setAction("android.intent.action.VIEW");
        i.addCategory("android.intent.category.BROWSABLE");
        switch (item.getItemId()) {
            case 2131165185: {
                Uri uri = Uri.parse((String)"http://eyes-free.googlecode.com/svn/trunk/documentation/tts_apps.html");
                i.setData(uri);
                this.startActivity(i);
                break;
            }
            case 2131165186: {
                Uri uri = Uri.parse((String)"http://eyes-free.googlecode.com/");
                i.setData(uri);
                this.startActivity(i);
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 42 && resultCode != 1) {
            Intent intent = new Intent();
            intent.setAction("android.speech.tts.engine.INSTALL_TTS_DATA");
            intent.setClassName("com.svox.pico", "com.svox.pico.DownloadVoiceData");
            this.startActivityForResult(intent, 43);
        }
    }

    protected void onDestroy() {
        if (this.myTts != null) {
            this.myTts.shutdown();
        }
        super.onDestroy();
    }
}

