package com.programmez.android.speechbot;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.EditText;
import android.widget.Toast;

import com.programmez.android.speechbot.tts.Tts;
import com.programmez.android.speechbot.tts.TtsNotInitializedException;

public class App extends Activity {
  public static void log(final String msg) {
    Log.v(Constants.LOG_TAG, msg);
  }

  public static void showMessage(final Context context, final String msg) {
    log(msg);
    Toast.makeText(context, msg, Toast.LENGTH_SHORT).show();
  }

  private Tts tts;
  private EditText editText;

  /** Called when the activity is first created. */
  @Override
  public void onCreate(final Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    tts = Tts.getInstance(this, false);
    setContentView(R.layout.main);
    buildEditText();
    buildSpeechButton();
  }

  @Override
  public boolean onCreateOptionsMenu(final Menu menu) {
    final MenuInflater inflater = getMenuInflater();
    inflater.inflate(R.menu.options_menu, menu);
    return true;
  }

  @Override
  public boolean onMenuItemSelected(final int featureId, final MenuItem item) {
    switch (item.getItemId()) {
    case R.id.options_menu_settings:
      final Intent settingsIntent = new Intent(this, Settings.class);
      startActivityForResult(settingsIntent,
          Constants.MENU_SETTINGS_REQUEST_CODE);
      return true;
    case R.id.options_menu_quit:
      finish();
      return true;
    }
    return super.onOptionsItemSelected(item);
  }

  private void buildEditText() {
    editText = (EditText) findViewById(R.id.TtsText);
    refreshEditText();
    editText.addTextChangedListener(new TextWatcher() {
      @Override
      public void afterTextChanged(final Editable s) {
        // DO nothing
      }

      @Override
      public void beforeTextChanged(final CharSequence s, final int start,
          final int count, final int after) {
        // DO nothing
      }

      @Override
      public void onTextChanged(final CharSequence s, final int start,
          final int before, final int count) {
        Settings.getUserPreferences(App.this).edit().putString(
            Constants.PREF_KEY_EDIT_TEXT, s.toString()).commit();
      }
    });
  }

  private void buildSpeechButton() {
    findViewById(R.id.TtsButton).setOnClickListener(new OnClickListener() {
      public void onClick(final View v) {
        speek();
      }
    });
  }

  private void refreshEditText() {
    editText.setText(Settings.getUserPreferences(App.this).getString(
        Constants.PREF_KEY_EDIT_TEXT, getString(R.string.hello)));
  }

  private void speek() {
    final EditText editText = (EditText) findViewById(R.id.TtsText);
    try {
      tts.setLanguage(Settings.getUserPrefLanguage(getApplicationContext()));
      tts.setSpeechRate(Settings.getSpeechRatePref(getApplicationContext()));
      tts.speak(editText.getText().toString(), Constants.TTS_QUEUE_ADD);
    } catch (final TtsNotInitializedException e) {
      showMessage(getApplicationContext(),
          getString(R.string.tts_not_available));
    }
  }

  @Override
  protected void onActivityResult(final int requestCode, final int resultCode,
      final Intent data) {
    refreshEditText();
    super.onActivityResult(requestCode, resultCode, data);
  }

  @Override
  protected void onDestroy() {
    if (tts != null) {
      tts.shutdown();
    }
    super.onDestroy();
  }
}