package com.programmez.android.speechbot.tts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

import android.app.Activity;
import android.content.Context;

import com.google.tts.TTS;
import com.google.tts.TTS.InitListener;
import com.programmez.android.speechbot.App;

@SuppressWarnings("deprecation")
public class TtsCupcake extends Tts {
  private TTS ttsImpl;

  protected TtsCupcake(final Context context) {
    super(context);
  }

  @Override
  public void checkTtsData(final Activity activity, final int requestCode) {
    // Do nothing
  }

  @Override
  public boolean onCheckTtsDataResult(final Activity activity,
      final int resultCode) {
    return true;
  }

  @Override
  public void setSpeechRate(final float speechRate) {
    ttsImpl.setSpeechRate((int) (speechRate * 100));
  }

  @Override
  protected Object getTtsImpl() {
    return ttsImpl;
  }

  @Override
  protected void initTtsImpl() {
    ttsImpl = new TTS(context, new InitListener() {
      @Override
      public void onInit(final int version) {
        App.log("tts initialized with version=" + version);
        initialized = true;
      }
    }, true);
  }

  @Override
  protected Map<String, Set<Locale>> obtainAllTtsSupportedLocales() {
    final Locale[] systemLocales = Locale.getAvailableLocales();
    final Map<String, Set<Locale>> result = new HashMap<String, Set<Locale>>();
    for (int i = 0; i < systemLocales.length; i++) {
      final Locale systemLocale = systemLocales[i];
      Set<Locale> set = result.get(systemLocale.getLanguage());
      if (set == null) {
        set = new HashSet<Locale>();
        result.put(systemLocale.getLanguage(), set);
      }
      set.add(systemLocale);
    }
    return result;
  }

  @Override
  protected void setLanguageImpl(final Locale locale) {
    String language = locale.getLanguage();
    final int index = language.indexOf("_");
    if (index != -1) {
      language = language.substring(0, index);
    }
    ttsImpl.setLanguage(language);
  }

  @Override
  protected void shutdownTtsImpl() {
    ttsImpl.shutdown();
  }

  @Override
  protected void speakImpl(final String text, final int queueMode) {
    ttsImpl.speak(text, queueMode, null);
  }
}
