package com.programmez.android.speechbot.tts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.speech.tts.TextToSpeech;

import com.programmez.android.speechbot.App;
import com.programmez.android.speechbot.Constants;

public class TtsDonut extends Tts {
  private TextToSpeech ttsImpl;

  protected TtsDonut(final Context context) {
    super(context);
  }

  @Override
  public void checkTtsData(final Activity activity, final int requestCode) {
    final Intent checkIntent = new Intent();
    checkIntent.setAction(TextToSpeech.Engine.ACTION_CHECK_TTS_DATA);
    activity.startActivityForResult(checkIntent, requestCode);
  }

  @Override
  public boolean onCheckTtsDataResult(final Activity activity,
      final int resultCode) {
    if (resultCode == TextToSpeech.Engine.CHECK_VOICE_DATA_PASS)
      return true;
    else {
      final Intent installIntent = new Intent();
      installIntent.setAction(TextToSpeech.Engine.ACTION_INSTALL_TTS_DATA);
      activity.startActivity(installIntent);
      return false;
    }
  }

  @Override
  public void setSpeechRate(final float speechRate) {
    ttsImpl.setSpeechRate(speechRate);
  }

  @Override
  public void shutdownTtsImpl() {
    ttsImpl.shutdown();
  }

  @Override
  protected Object getTtsImpl() {
    return ttsImpl;
  }

  @Override
  protected void initTtsImpl() {
    ttsImpl = new TextToSpeech(context, new TextToSpeech.OnInitListener() {
      public void onInit(final int status) {
        App.log("tts initialized with status=" + status);
        initialized = true;
      }
    });
  }

  @Override
  protected Map<String, Set<Locale>> obtainAllTtsSupportedLocales() {
    final Locale[] systemLocales = Locale.getAvailableLocales();
    final Map<String, Set<Locale>> result = new HashMap<String, Set<Locale>>();
    for (int i = 0; i < systemLocales.length; i++) {
      final Locale systemLocale = systemLocales[i];
      final int languageAvailable = ttsImpl.isLanguageAvailable(systemLocale);
      final Locale locale;
      switch (languageAvailable) {
      case TextToSpeech.LANG_MISSING_DATA:
      case TextToSpeech.LANG_NOT_SUPPORTED:
        continue;
      case TextToSpeech.LANG_COUNTRY_VAR_AVAILABLE:
        locale = systemLocale;
        break;
      case TextToSpeech.LANG_COUNTRY_AVAILABLE:
        locale = new Locale(systemLocale.getLanguage(), systemLocale
            .getCountry());
        break;
      case TextToSpeech.LANG_AVAILABLE:
        locale = new Locale(systemLocale.getLanguage());
        break;
      default:
        locale = null;
      }
      if (locale != null) {
        Set<Locale> set = result.get(locale.getLanguage());
        if (set == null) {
          set = new HashSet<Locale>();
          result.put(locale.getLanguage(), set);
        }
        set.add(locale);
      }
    }
    return result;
  }

  @Override
  protected void setLanguageImpl(final Locale locale) {
    ttsImpl.setLanguage(locale);
  }

  @Override
  protected void speakImpl(final String text, final int queueMode) {
    ttsImpl.speak(text,
        queueMode == Constants.TTS_QUEUE_ADD ? TextToSpeech.QUEUE_ADD
            : TextToSpeech.QUEUE_FLUSH, null);
  }
}
